/*
 * Decompiled with CFR 0.152.
 */
package sbt;

import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Properties;
import jline.TerminalFactory;
import sbt.BuildPaths$;
import sbt.Command$;
import sbt.Exec;
import sbt.MainLoop;
import sbt.MainLoop$ExitCode$;
import sbt.RebootCurrent;
import sbt.StandardMain$;
import sbt.State;
import sbt.State$;
import sbt.internal.langserver.ErrorCodes$;
import sbt.internal.util.AttributeMap;
import sbt.internal.util.ErrorHandling$;
import sbt.internal.util.GlobalLogBacking;
import sbt.internal.util.GlobalLogging;
import sbt.internal.util.ManagedLogger;
import sbt.io.FileFilter;
import sbt.io.FileFilter$;
import sbt.io.IO$;
import sbt.io.PathFinder;
import sbt.io.RichFile$;
import sbt.io.Using;
import sbt.io.Using$;
import sbt.io.syntax$;
import sbt.protocol.EventMessage;
import sbt.protocol.ExecStatusEvent;
import sbt.protocol.ExecStatusEvent$;
import sbt.protocol.codec.JsonProtocol$;
import sbt.util.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;
import xsbti.AppConfiguration;
import xsbti.AppProvider;
import xsbti.ApplicationID;
import xsbti.Continue;
import xsbti.Exit;
import xsbti.FullReload;
import xsbti.MainResult;
import xsbti.Reboot;

public final class MainLoop$ {
    public static MainLoop$ MODULE$;

    static {
        new MainLoop$();
    }

    public MainResult runLogged(State state) {
        MainResult mainResult;
        Thread shutdownHook = new Thread(() -> TerminalFactory.get().restore());
        try {
            Runtime.getRuntime().addShutdownHook(shutdownHook);
            mainResult = this.runLoggedLoop(state, state.globalLogging().backing());
        }
        finally {
            Runtime.getRuntime().removeShutdownHook(shutdownHook);
        }
        return mainResult;
    }

    public MainResult runLoggedLoop(State state, GlobalLogBacking logBacking) {
        MainLoop.RunNext runNext;
        block2: {
            while (true) {
                if ((runNext = this.runAndClearLast(state, logBacking)) instanceof MainLoop.Return) break block2;
                if (runNext instanceof MainLoop.ClearGlobalLog) {
                    MainLoop.ClearGlobalLog clearGlobalLog = (MainLoop.ClearGlobalLog)runNext;
                    this.deleteLastLog(logBacking);
                    logBacking = logBacking.shiftNew();
                    state = clearGlobalLog.state();
                    continue;
                }
                if (!(runNext instanceof MainLoop.KeepGlobalLog)) break;
                MainLoop.KeepGlobalLog keepGlobalLog = (MainLoop.KeepGlobalLog)runNext;
                logBacking.file().delete();
                logBacking = logBacking.unshift();
                state = keepGlobalLog.state();
            }
            throw new MatchError((Object)runNext);
        }
        MainLoop.Return return_ = (MainLoop.Return)runNext;
        logBacking.file().delete();
        this.deleteLastLog(logBacking);
        MainResult mainResult = return_.result();
        return mainResult;
    }

    public MainLoop.RunNext runAndClearLast(State state, GlobalLogBacking logBacking) {
        MainLoop.RunNext runNext;
        try {
            runNext = this.runWithNewLog(state, logBacking);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof FullReload) {
                FullReload fullReload = (FullReload)throwable2;
                this.deleteLastLog(logBacking);
                throw fullReload;
            }
            if (throwable2 instanceof RebootCurrent) {
                RebootCurrent rebootCurrent = (RebootCurrent)throwable2;
                this.deleteLastLog(logBacking);
                this.deleteCurrentArtifacts(state);
                throw new FullReload((String[])rebootCurrent.arguments().toArray(ClassTag$.MODULE$.apply(String.class)), false);
            }
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                System.err.println(new StringBuilder(76).append("sbt appears to be exiting abnormally.\n  The log file for this session is at ").append(logBacking.file()).toString());
                this.deleteLastLog(logBacking);
                throw e;
            }
            throw throwable;
        }
        return runNext;
    }

    public void deleteLastLog(GlobalLogBacking logBacking) {
        logBacking.last().foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.delete()));
    }

    public void deleteCurrentArtifacts(State state) {
        None$ none$;
        AppProvider provider = state.configuration().provider();
        ApplicationID appId = provider.id();
        File defaultBoot = RichFile$.MODULE$.$div$extension(syntax$.MODULE$.fileToRichFile(BuildPaths$.MODULE$.defaultGlobalBase()), "boot");
        File buildProps = RichFile$.MODULE$.$div$extension(syntax$.MODULE$.fileToRichFile(RichFile$.MODULE$.$div$extension(syntax$.MODULE$.fileToRichFile(State$.MODULE$.stateOps(state).baseDir()), "project")), "build.properties");
        if (buildProps.exists()) {
            Properties buildProperties = new Properties();
            IO$.MODULE$.load(buildProperties, buildProps);
            none$ = Option$.MODULE$.apply((Object)buildProperties.getProperty("sbt.version"));
        } else {
            none$ = None$.MODULE$;
        }
        None$ sbtVersionOpt = none$;
        String sbtVersion = (String)sbtVersionOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> appId.version());
        PathFinder currentArtDirs = syntax$.MODULE$.singleFileFinder(defaultBoot).$times((FileFilter)FileFilter$.MODULE$.globFilter("*")).$div(appId.groupID()).$div(appId.name()).$div(sbtVersion);
        currentArtDirs.get().foreach((Function1 & Serializable & scala.Serializable)dir -> {
            MainLoop$.$anonfun$deleteCurrentArtifacts$2(state, dir);
            return BoxedUnit.UNIT;
        });
    }

    public MainLoop.RunNext runWithNewLog(State state, GlobalLogBacking logBacking) {
        boolean x$4 = true;
        Charset x$5 = Using$.MODULE$.fileWriter$default$1();
        return (MainLoop.RunNext)((Using)Using$.MODULE$.fileWriter(x$5, x$4)).apply((Object)logBacking.file(), (Function1 & Serializable & scala.Serializable)writer -> {
            MainLoop.RunNext runNext;
            GlobalLogging newLogging;
            PrintWriter out = new PrintWriter((Writer)writer);
            ManagedLogger full = state.globalLogging().full();
            GlobalLogging x$6 = newLogging = (GlobalLogging)state.globalLogging().newAppender().apply((Object)full, (Object)out, (Object)logBacking);
            AppConfiguration x$7 = state.copy$default$1();
            Seq x$8 = state.copy$default$2();
            Set x$9 = state.copy$default$3();
            Option x$10 = state.copy$default$4();
            List x$11 = state.copy$default$5();
            State.History x$12 = state.copy$default$6();
            AttributeMap x$13 = state.copy$default$7();
            Option x$14 = state.copy$default$9();
            State.Next x$15 = state.copy$default$10();
            State loggedState = state.copy(x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$6, x$14, x$15);
            try {
                runNext = MODULE$.run(loggedState);
            }
            finally {
                out.close();
            }
            return runNext;
        });
    }

    public MainLoop.RunNext run(State state) {
        MainLoop.RunNext runNext;
        State.Next next;
        while (State.Continue$.MODULE$.equals(next = state.next())) {
            state = this.next(state);
        }
        if (State.ClearGlobalLog$.MODULE$.equals(next)) {
            runNext = new MainLoop.ClearGlobalLog(State$.MODULE$.stateOps(state).continue());
        } else if (State.KeepLastLog$.MODULE$.equals(next)) {
            runNext = new MainLoop.KeepGlobalLog(State$.MODULE$.stateOps(state).continue());
        } else if (next instanceof State.Return) {
            State.Return return_ = (State.Return)next;
            runNext = new MainLoop.Return(return_.result());
        } else {
            throw new MatchError((Object)next);
        }
        return runNext;
    }

    public State next(State state) {
        State state2;
        boolean bl = false;
        Left left = null;
        Either either = ErrorHandling$.MODULE$.wideConvert((Function0 & Serializable & scala.Serializable)() -> State$.MODULE$.stateOps(state).process((Function2 & Serializable & scala.Serializable)(exec, state) -> MODULE$.processCommand((Exec)exec, (State)state)));
        if (either instanceof Right) {
            State s;
            Right right = (Right)either;
            state2 = s = (State)right.value();
        } else {
            Throwable t;
            if (either instanceof Left) {
                bl = true;
                left = (Left)either;
                Throwable t2 = (Throwable)left.value();
                if (t2 instanceof FullReload) {
                    FullReload fullReload = (FullReload)t2;
                    throw fullReload;
                }
            }
            if (bl && (t = (Throwable)left.value()) instanceof RebootCurrent) {
                RebootCurrent rebootCurrent = (RebootCurrent)t;
                throw rebootCurrent;
            }
            if (bl) {
                Throwable t3 = (Throwable)left.value();
                state2 = State$.MODULE$.stateOps(state).handleError(t3);
            } else {
                throw new MatchError((Object)either);
            }
        }
        return state2;
    }

    public State processCommand(Exec exec, State state) {
        Option channelName = exec.source().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.channelName());
        StandardMain$.MODULE$.exchange().publishEventMessage((EventMessage)ExecStatusEvent$.MODULE$.apply("Processing", channelName, exec.execId(), (Vector)package$.MODULE$.Vector().apply((Seq)Nil$.MODULE$)));
        State newState = Command$.MODULE$.process(exec.commandLine(), state);
        ExecStatusEvent doneEvent = ExecStatusEvent$.MODULE$.apply("Done", channelName, exec.execId(), (Vector)newState.remainingCommands().toVector().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.commandLine(), Vector$.MODULE$.canBuildFrom()), this.exitCode(newState, state));
        if (doneEvent.execId().isDefined()) {
            StandardMain$.MODULE$.exchange().publishEvent(doneEvent, JsonProtocol$.MODULE$.ExecStatusEventFormat());
        } else {
            StandardMain$.MODULE$.exchange().publishEventMessage((EventMessage)doneEvent);
        }
        return newState;
    }

    public void logFullException(Throwable e, Logger log) {
        State$.MODULE$.logFullException(e, log);
    }

    private Option<Object> exitCode(State state, State prevState) {
        Option<Object> option = this.exitCodeFromStateNext(state);
        Option<Object> option2 = MainLoop$ExitCode$.MODULE$.Success();
        Option<Object> option3 = option;
        Option<Object> option4 = !(option2 != null ? !option2.equals(option3) : option3 != null) ? this.exitCodeFromStateOnFailure(state, prevState) : option;
        return option4;
    }

    private Option<Object> exitCodeFromStateNext(State state) {
        Option<Object> option;
        State.Next next = state.next();
        if (State.Continue$.MODULE$.equals(next)) {
            option = MainLoop$ExitCode$.MODULE$.Success();
        } else if (State.ClearGlobalLog$.MODULE$.equals(next)) {
            option = MainLoop$ExitCode$.MODULE$.Success();
        } else if (State.KeepLastLog$.MODULE$.equals(next)) {
            option = MainLoop$ExitCode$.MODULE$.Success();
        } else if (next instanceof State.Return) {
            Option<Object> option2;
            State.Return return_ = (State.Return)next;
            MainResult mainResult = return_.result();
            if (mainResult instanceof Exit) {
                Exit exit = (Exit)mainResult;
                option2 = MainLoop$ExitCode$.MODULE$.apply(exit.code());
            } else if (mainResult instanceof Continue) {
                option2 = MainLoop$ExitCode$.MODULE$.Success();
            } else if (mainResult instanceof Reboot) {
                option2 = MainLoop$ExitCode$.MODULE$.Success();
            } else {
                String clazz = mainResult == null ? "" : new StringBuilder(10).append(" (class: ").append(mainResult.getClass()).append(")").toString();
                State$.MODULE$.stateOps(state).log().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Unknown main result: ").append(mainResult).append(clazz).toString());
                option2 = MainLoop$ExitCode$.MODULE$.Unknown();
            }
            option = option2;
        } else {
            throw new MatchError((Object)next);
        }
        return option;
    }

    private Option<Object> exitCodeFromStateOnFailure(State state, State prevState) {
        return prevState.onFailure().isDefined() && state.onFailure().isEmpty() ? MainLoop$ExitCode$.MODULE$.apply(ErrorCodes$.MODULE$.UnknownError()) : MainLoop$ExitCode$.MODULE$.Success();
    }

    public static final /* synthetic */ void $anonfun$deleteCurrentArtifacts$2(State state$2, File dir) {
        State$.MODULE$.stateOps(state$2).log().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(9).append("Deleting ").append(dir).toString());
        IO$.MODULE$.delete(dir);
    }

    private MainLoop$() {
        MODULE$ = this;
    }
}

