/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.impl.schema;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.xml.XmlTagImpl;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.intellij.util.containers.hash.HashMap;
import com.intellij.util.containers.hash.HashSet;
import com.intellij.xml.index.SchemaTypeInfo;
import com.intellij.xml.index.SchemaTypeInheritanceIndex;
import com.intellij.xml.index.XmlNamespaceIndex;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;

public class SchemaDefinitionsSearch
implements QueryExecutor<PsiElement, PsiElement> {
    public boolean execute(@NotNull PsiElement queryParameters, final @NotNull Processor<? super PsiElement> consumer) {
        Collection infos;
        XmlTagImpl xml;
        if (queryParameters == null) {
            SchemaDefinitionsSearch.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            SchemaDefinitionsSearch.$$$reportNull$$$0(1);
        }
        if (queryParameters instanceof XmlTagImpl && ((Boolean)ReadAction.compute(() -> SchemaDefinitionsSearch.lambda$execute$0(xml = (XmlTagImpl)queryParameters))).booleanValue() && (infos = (Collection)ReadAction.compute(() -> this.gatherInheritors(xml))) != null && !infos.isEmpty()) {
            XmlFile file2 = XmlUtil.getContainingFile(xml);
            Project project = file2.getProject();
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)queryParameters);
            VirtualFile vf = file2.getVirtualFile();
            String thisNs = (String)ReadAction.compute(() -> XmlNamespaceIndex.getNamespace(vf, project, (PsiFile)file2));
            String string = thisNs = thisNs == null ? this.getDefaultNs(file2) : thisNs;
            if (thisNs == null) {
                return false;
            }
            ArrayList infosLst = new ArrayList(infos);
            Collections.sort(infosLst);
            HashMap nsMap = new HashMap();
            for (final SchemaTypeInfo info : infosLst) {
                Set targetFiles = (Set)nsMap.get(info.getNamespaceUri());
                if (targetFiles == null) {
                    Collection files2;
                    targetFiles = new HashSet();
                    if (Comparing.equal((String)info.getNamespaceUri(), (String)thisNs)) {
                        targetFiles.add(file2);
                    }
                    if ((files2 = (Collection)ReadAction.compute(() -> XmlUtil.findNSFilesByURI(info.getNamespaceUri(), project, module))) != null) {
                        targetFiles.addAll(files2);
                    }
                    nsMap.put(info.getNamespaceUri(), targetFiles);
                }
                if (targetFiles.isEmpty()) continue;
                for (XmlFile targetFile : targetFiles) {
                    ApplicationManager.getApplication().runReadAction(() -> {
                        final String prefixByURI = XmlUtil.findNamespacePrefixByURI(targetFile, info.getNamespaceUri());
                        if (prefixByURI == null) {
                            return;
                        }
                        PsiElementProcessor processor2 = new PsiElementProcessor(){

                            public boolean execute(@NotNull PsiElement element) {
                                if (element == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                if (element instanceof XmlTagImpl && (SchemaDefinitionsSearch.this.isCertainTypeElement((XmlTagImpl)element, info.getTagName(), prefixByURI) || SchemaDefinitionsSearch.isElementWithEmbeddedType((XmlTagImpl)element, info.getTagName(), prefixByURI))) {
                                    consumer.process((Object)element);
                                    return false;
                                }
                                return true;
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/xml/impl/schema/SchemaDefinitionsSearch$1", "execute"));
                            }
                        };
                        XmlUtil.processXmlElements((XmlElement)targetFile, processor2, true);
                    });
                }
            }
        }
        return true;
    }

    public static boolean isElementWithSomeEmbeddedType(XmlTagImpl xml) {
        XmlTag[] tags;
        String localName = xml.getLocalName();
        if (!"http://www.w3.org/2001/XMLSchema".equals(xml.getNamespace()) || !"element".equals(localName)) {
            return false;
        }
        for (XmlTag tag : tags = xml.getSubTags()) {
            if (!SchemaDefinitionsSearch.isTypeElement((XmlTagImpl)tag)) continue;
            return true;
        }
        return false;
    }

    public static boolean isElementWithEmbeddedType(XmlTagImpl xml, String typeName, String typeNsPrefix) {
        XmlTag[] tags;
        String localName = xml.getLocalName();
        if (!"http://www.w3.org/2001/XMLSchema".equals(xml.getNamespace()) || !"element".equals(localName)) {
            return false;
        }
        XmlAttribute nameAttr = SchemaDefinitionsSearch.getNameAttr(xml);
        if (nameAttr == null || nameAttr.getValue() == null) {
            return false;
        }
        String localTypeName = XmlUtil.findLocalNameByQualifiedName(nameAttr.getValue());
        String prefix = XmlUtil.findPrefixByQualifiedName(nameAttr.getValue());
        if (!typeName.equals(localTypeName) || !typeNsPrefix.equals(prefix)) {
            return false;
        }
        for (XmlTag tag : tags = xml.getSubTags()) {
            if (!SchemaDefinitionsSearch.isTypeElement((XmlTagImpl)tag)) continue;
            return true;
        }
        return false;
    }

    private boolean isCertainTypeElement(XmlTagImpl xml, String typeName, String nsPrefix) {
        if (!SchemaDefinitionsSearch.isTypeElement(xml)) {
            return false;
        }
        XmlAttribute name = SchemaDefinitionsSearch.getNameAttr(xml);
        if (name == null) {
            return false;
        }
        String value = name.getValue();
        if (value == null) {
            return false;
        }
        String localName = XmlUtil.findLocalNameByQualifiedName(value);
        return typeName.equals(localName) && nsPrefix.equals(XmlUtil.findPrefixByQualifiedName(value));
    }

    public static boolean isTypeElement(XmlTagImpl xml) {
        String localName = xml.getLocalName();
        return "http://www.w3.org/2001/XMLSchema".equals(xml.getNamespace()) && ("complexType".equals(localName) || "simpleType".equals(localName));
    }

    private Collection<SchemaTypeInfo> gatherInheritors(XmlTagImpl xml) {
        XmlAttribute name = SchemaDefinitionsSearch.getNameAttr(xml);
        if (name == null || StringUtil.isEmptyOrSpaces((String)name.getValue())) {
            return null;
        }
        String localName = name.getValue();
        boolean hasPrefix = localName.contains(":");
        localName = hasPrefix ? localName.substring(localName.indexOf(58) + 1) : localName;
        String nsPrefix = hasPrefix ? name.getValue().substring(0, name.getValue().indexOf(58)) : null;
        XmlFile file2 = XmlUtil.getContainingFile(xml);
        if (file2 == null) {
            return null;
        }
        Project project = file2.getProject();
        if (project == null) {
            return null;
        }
        HashSet result2 = new HashSet();
        ArrayDeque<SchemaTypeInfo> queue2 = new ArrayDeque<SchemaTypeInfo>();
        String nsUri = !hasPrefix ? this.getDefaultNs(file2) : XmlUtil.findNamespaceByPrefix(nsPrefix, file2.getRootTag());
        if (nsUri == null) {
            return null;
        }
        queue2.add(new SchemaTypeInfo(localName, true, nsUri));
        BiFunction<String, String, List<Set<SchemaTypeInfo>>> worker = SchemaTypeInheritanceIndex.getWorker(project, file2.getContainingFile().getVirtualFile());
        while (!queue2.isEmpty()) {
            SchemaTypeInfo info = (SchemaTypeInfo)queue2.removeFirst();
            List<Set<SchemaTypeInfo>> childrenOfType = worker.apply(info.getNamespaceUri(), info.getTagName());
            for (Set<SchemaTypeInfo> infos : childrenOfType) {
                for (SchemaTypeInfo typeInfo : infos) {
                    if (typeInfo.isIsTypeName()) {
                        queue2.add(typeInfo);
                    }
                    result2.add(typeInfo);
                }
            }
        }
        return result2;
    }

    public static XmlAttribute getNameAttr(XmlTagImpl xml) {
        XmlAttribute name = xml.getAttribute("name", "http://www.w3.org/2001/XMLSchema");
        name = name == null ? xml.getAttribute("name") : name;
        return name;
    }

    private String getDefaultNs(XmlFile file2) {
        return (String)ReadAction.compute(() -> {
            XmlTag tag = file2.getDocument().getRootTag();
            XmlAttribute xmlns = tag.getAttribute("xmlns", "http://www.w3.org/2001/XMLSchema");
            xmlns = xmlns == null ? tag.getAttribute("xmlns") : xmlns;
            String nsUri = xmlns == null ? null : xmlns.getValue();
            return nsUri;
        });
    }

    private static /* synthetic */ Boolean lambda$execute$0(XmlTagImpl xml) throws RuntimeException {
        return SchemaDefinitionsSearch.isTypeElement(xml);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "queryParameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "consumer";
                break;
            }
        }
        objectArray[1] = "com/intellij/xml/impl/schema/SchemaDefinitionsSearch";
        objectArray[2] = "execute";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

