/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findInProject;

import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindSettings;
import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.find.replaceInProject.ReplaceInProjectManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.content.Content;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindInProjectManager {
    private final Project myProject;
    private volatile boolean myIsFindInProgress;

    public static FindInProjectManager getInstance(Project project) {
        return (FindInProjectManager)ServiceManager.getService((Project)project, FindInProjectManager.class);
    }

    public FindInProjectManager(Project project) {
        this.myProject = project;
    }

    public void findInProject(@NotNull DataContext dataContext, @Nullable FindModel model) {
        FindModel findModel;
        boolean isOpenInNewTabEnabled;
        boolean toOpenInNewTab;
        Content selectedContent;
        if (dataContext == null) {
            FindInProjectManager.$$$reportNull$$$0(0);
        }
        if ((selectedContent = com.intellij.usageView.UsageViewManager.getInstance((Project)this.myProject).getSelectedContent(true)) != null && selectedContent.isPinned()) {
            toOpenInNewTab = true;
            isOpenInNewTabEnabled = false;
        } else {
            toOpenInNewTab = FindSettings.getInstance().isShowResultsInSeparateView();
            isOpenInNewTabEnabled = com.intellij.usageView.UsageViewManager.getInstance((Project)this.myProject).getReusableContentsCount() > 0;
        }
        FindManager findManager = FindManager.getInstance((Project)this.myProject);
        if (model != null) {
            findModel = model.clone();
            findModel.setOpenInNewTabEnabled(isOpenInNewTabEnabled);
        } else {
            findModel = findManager.getFindInProjectModel().clone();
            findModel.setReplaceState(false);
            findModel.setOpenInNewTabEnabled(isOpenInNewTabEnabled);
            findModel.setOpenInNewTab(toOpenInNewTab);
            this.initModel(findModel, dataContext);
        }
        findManager.showFindDialog(findModel, () -> {
            if (findModel.isReplaceState()) {
                ReplaceInProjectManager.getInstance(this.myProject).replaceInPath(findModel);
            } else {
                this.findInPath(findModel);
            }
        });
    }

    public void findInPath(@NotNull FindModel findModel) {
        if (findModel == null) {
            FindInProjectManager.$$$reportNull$$$0(1);
        }
        if (findModel.isOpenInNewTabEnabled()) {
            FindSettings.getInstance().setShowResultsInSeparateView(findModel.isOpenInNewTab());
        }
        this.startFindInProject(findModel);
    }

    protected void initModel(@NotNull FindModel findModel, @NotNull DataContext dataContext) {
        if (findModel == null) {
            FindInProjectManager.$$$reportNull$$$0(2);
        }
        if (dataContext == null) {
            FindInProjectManager.$$$reportNull$$$0(3);
        }
        FindInProjectUtil.setDirectoryName(findModel, dataContext);
        String text = (String)PlatformDataKeys.PREDEFINED_TEXT.getData(dataContext);
        if (text != null) {
            FindModel.initStringToFindNoMultiline((FindModel)findModel, (String)text);
        } else {
            FindInProjectUtil.initStringToFindFromDataContext(findModel, dataContext);
        }
    }

    public void startFindInProject(@NotNull FindModel findModel) {
        if (findModel == null) {
            FindInProjectManager.$$$reportNull$$$0(4);
        }
        if (findModel.getDirectoryName() != null && FindInProjectUtil.getDirectory(findModel) == null) {
            return;
        }
        UsageViewManager manager = UsageViewManager.getInstance((Project)this.myProject);
        if (manager == null) {
            return;
        }
        FindManager findManager = FindManager.getInstance((Project)this.myProject);
        findManager.getFindInProjectModel().copyFrom(findModel);
        FindModel findModelCopy = findModel.clone();
        UsageViewPresentation presentation = FindInProjectUtil.setupViewPresentation(FindSettings.getInstance().isShowResultsInSeparateView(), findModelCopy);
        boolean showPanelIfOnlyOneUsage = !FindSettings.getInstance().isSkipResultsWithOneUsage();
        FindUsagesProcessPresentation processPresentation = FindInProjectUtil.setupProcessPresentation(this.myProject, showPanelIfOnlyOneUsage, presentation);
        FindInProjectUtil.StringUsageTarget usageTarget = new FindInProjectUtil.StringUsageTarget(this.myProject, findModel);
        ((FindManagerImpl)FindManager.getInstance((Project)this.myProject)).getFindUsagesManager().addToHistory(usageTarget);
        manager.searchAndShowUsages(new UsageTarget[]{usageTarget}, () -> processor2 -> {
            this.myIsFindInProgress = true;
            try {
                Processor consumer = info -> {
                    Usage usage = (Usage)UsageInfo2UsageAdapter.CONVERTER.fun(info);
                    usage.getPresentation().getIcon();
                    return processor2.process((Object)usage);
                };
                FindInProjectUtil.findUsages(findModelCopy, this.myProject, (Processor<? super UsageInfo>)consumer, processPresentation);
            }
            finally {
                this.myIsFindInProgress = false;
            }
        }, processPresentation, presentation, null);
    }

    public boolean isWorkInProgress() {
        return this.myIsFindInProgress;
    }

    public boolean isEnabled() {
        return !this.myIsFindInProgress && !ReplaceInProjectManager.getInstance(this.myProject).isWorkInProgress();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "findModel";
                break;
            }
        }
        objectArray2[1] = "com/intellij/find/findInProject/FindInProjectManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findInProject";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findInPath";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "initModel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "startFindInProject";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

