/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.resolve;

import com.google.common.collect.Lists;
import com.intellij.openapi.fileTypes.ExtensionFileNameMatcher;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.codeInsight.typing.PyStubPackages;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.FutureFeature;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExceptPart;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.PyReferenceExpressionImpl;
import com.jetbrains.python.psi.impl.PyResolveResultRater;
import com.jetbrains.python.psi.impl.ResolveResultList;
import com.jetbrains.python.psi.resolve.PointInImport;
import com.jetbrains.python.psi.resolve.PyQualifiedNameResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveImportUtil;
import com.jetbrains.python.psi.resolve.PythonModulePathCache;
import com.jetbrains.python.psi.resolve.PythonPathCache;
import com.jetbrains.python.psi.resolve.PythonSdkPathCache;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyModuleType;
import com.jetbrains.python.psi.types.PyType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResolveImportUtil {
    private static final ThreadLocal<Set<String>> ourBeingImported = ThreadLocal.withInitial(() -> new HashSet());

    private ResolveImportUtil() {
    }

    public static boolean isAbsoluteImportEnabledFor(PsiElement foothold) {
        PsiFile file;
        if (foothold != null && (file = foothold.getContainingFile()) instanceof PyFile) {
            PyFile pyFile = (PyFile)file;
            if (pyFile.getLanguageLevel().isPy3K()) {
                return true;
            }
            return pyFile.hasImportFromFuture(FutureFeature.ABSOLUTE_IMPORT);
        }
        return false;
    }

    @Nullable
    public static PsiDirectory stepBackFrom(PsiFile base, int depth) {
        if (depth == 0) {
            return base.getContainingDirectory();
        }
        if (base != null) {
            base = base.getOriginalFile();
            PsiDirectory result = base.getContainingDirectory();
            int count = 1;
            while (result != null && PyUtil.isPackage(result, (PsiElement)base)) {
                if (count >= depth) {
                    return result;
                }
                result = result.getParentDirectory();
                ++count;
            }
        }
        return null;
    }

    @Deprecated
    @Nullable
    public static PsiElement resolveImportElement(PyImportElement importElement, @NotNull QualifiedName qName) {
        List<RatedResolveResult> resultList;
        if (qName == null) {
            ResolveImportUtil.$$$reportNull$$$0(0);
        }
        return (resultList = RatedResolveResult.sorted(ResolveImportUtil.multiResolveImportElement(importElement, qName))).size() > 0 ? resultList.get(0).getElement() : null;
    }

    @NotNull
    public static List<RatedResolveResult> multiResolveImportElement(PyImportElement importElement, @NotNull QualifiedName qName) {
        if (qName == null) {
            ResolveImportUtil.$$$reportNull$$$0(1);
        }
        PyUtil.verboseOnly(() -> PyPsiUtils.assertValid((PsiElement)importElement));
        PyStatement importStatement = importElement.getContainingImportStatement();
        if (importStatement instanceof PyFromImportStatement) {
            List<RatedResolveResult> list = ResolveImportUtil.resolveNameInFromImport((PyFromImportStatement)importStatement, qName);
            if (list == null) {
                ResolveImportUtil.$$$reportNull$$$0(2);
            }
            return list;
        }
        List<RatedResolveResult> list = ResolveImportUtil.resolveNameInImportStatement(importElement, qName);
        if (list == null) {
            ResolveImportUtil.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public static List<RatedResolveResult> resolveNameInImportStatement(PyImportElement importElement, @NotNull QualifiedName qName) {
        if (qName == null) {
            ResolveImportUtil.$$$reportNull$$$0(4);
        }
        PsiFile file = importElement.getContainingFile().getOriginalFile();
        boolean absoluteImportEnabled = ResolveImportUtil.isAbsoluteImportEnabledFor((PsiElement)importElement);
        List<PsiElement> modules = ResolveImportUtil.resolveModule(qName, file, absoluteImportEnabled, 0);
        ResolveResultList resolveResultList = ResolveImportUtil.rateResults(modules);
        if (resolveResultList == null) {
            ResolveImportUtil.$$$reportNull$$$0(5);
        }
        return resolveResultList;
    }

    @NotNull
    public static List<RatedResolveResult> resolveNameInFromImport(PyFromImportStatement importStatement, @NotNull QualifiedName qName) {
        if (qName == null) {
            ResolveImportUtil.$$$reportNull$$$0(6);
        }
        PsiFile file = importStatement.getContainingFile().getOriginalFile();
        String name = (String)qName.getComponents().get(0);
        ArrayList<RatedResolveResult> results = new ArrayList<RatedResolveResult>();
        List<PsiElement> candidates = importStatement.resolveImportSourceCandidates();
        for (PsiElement candidate : candidates) {
            if (!candidate.isValid()) {
                throw new PsiInvalidElementAccessException(candidate, "Got an invalid candidate from resolveImportSourceCandidates(): " + candidate.getClass());
            }
            if (candidate instanceof PsiDirectory) {
                candidate = PyUtil.getPackageElement((PsiDirectory)candidate, (PsiElement)importStatement);
            }
            results.addAll(ResolveImportUtil.resolveChildren(candidate, name, file, false, true, false, false));
        }
        List<RatedResolveResult> list = ResolveImportUtil.updateRatedResults(PyStubPackages.removeRuntimeModulesForWhomStubModulesFound(results));
        if (list == null) {
            ResolveImportUtil.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    public static List<PsiElement> resolveFromImportStatementSource(@NotNull PyFromImportStatement fromImportStatement, @Nullable QualifiedName qName) {
        if (fromImportStatement == null) {
            ResolveImportUtil.$$$reportNull$$$0(8);
        }
        boolean absoluteImportEnabled = ResolveImportUtil.isAbsoluteImportEnabledFor((PsiElement)fromImportStatement);
        PsiFile file = fromImportStatement.getContainingFile();
        List<PsiElement> list = ResolveImportUtil.resolveModule(qName, file, absoluteImportEnabled, fromImportStatement.getRelativeLevel());
        if (list == null) {
            ResolveImportUtil.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    public static List<PsiElement> resolveModule(@Nullable QualifiedName qualifiedName, @Nullable PsiFile sourceFile, boolean importIsAbsolute, int relativeLevel) {
        if (qualifiedName == null || sourceFile == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                ResolveImportUtil.$$$reportNull$$$0(10);
            }
            return list;
        }
        ResolveModuleParams params = new ResolveModuleParams(qualifiedName, sourceFile, importIsAbsolute, relativeLevel);
        List list = (List)PyUtil.getParameterizedCachedValue((PsiElement)sourceFile, params, ResolveImportUtil::calculateResolveModule);
        if (list == null) {
            ResolveImportUtil.$$$reportNull$$$0(11);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static List<PsiElement> calculateResolveModule(@NotNull ResolveModuleParams params) {
        if (params == null) {
            ResolveImportUtil.$$$reportNull$$$0(12);
        }
        QualifiedName qualifiedName = params.getName();
        int relativeLevel = params.getLevel();
        PsiFile sourceFile = params.getFile();
        boolean importIsAbsolute = params.isAbsolute();
        String marker = qualifiedName + "#" + relativeLevel;
        Set<String> beingImported = ourBeingImported.get();
        if (beingImported.contains(marker)) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                ResolveImportUtil.$$$reportNull$$$0(13);
            }
            return list;
        }
        beingImported.add(marker);
        PyQualifiedNameResolveContext initialContext = PyResolveImportUtil.fromFoothold((PsiElement)sourceFile);
        PyQualifiedNameResolveContext context = relativeLevel > 0 ? initialContext.copyWithRelative(relativeLevel).copyWithoutRoots() : (importIsAbsolute ? initialContext : initialContext.copyWithRelative(0));
        List<PsiElement> list = PyResolveImportUtil.resolveQualifiedName(qualifiedName, context);
        List<PsiElement> list2 = list;
        if (list2 == null) {
            ResolveImportUtil.$$$reportNull$$$0(14);
        }
        return list2;
        finally {
            beingImported.remove(marker);
        }
    }

    @NotNull
    public static List<PsiElement> multiResolveModuleInRoots(@NotNull QualifiedName moduleQualifiedName, @Nullable PsiElement foothold) {
        if (moduleQualifiedName == null) {
            ResolveImportUtil.$$$reportNull$$$0(15);
        }
        if (foothold == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                ResolveImportUtil.$$$reportNull$$$0(16);
            }
            return list;
        }
        List<PsiElement> list = PyResolveImportUtil.resolveQualifiedName(moduleQualifiedName, PyResolveImportUtil.fromFoothold(foothold));
        if (list == null) {
            ResolveImportUtil.$$$reportNull$$$0(17);
        }
        return list;
    }

    @Deprecated
    @Nullable
    public static PsiElement resolveModuleInRoots(@NotNull QualifiedName moduleQualifiedName, @Nullable PsiElement foothold) {
        if (moduleQualifiedName == null) {
            ResolveImportUtil.$$$reportNull$$$0(18);
        }
        List<PsiElement> results = ResolveImportUtil.multiResolveModuleInRoots(moduleQualifiedName, foothold);
        return (PsiElement)ContainerUtil.getFirstItem(results);
    }

    @Nullable
    static PythonPathCache getPathCache(PsiElement foothold) {
        PythonPathCache cache2 = null;
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)foothold);
        if (module2 != null) {
            cache2 = PythonModulePathCache.getInstance(module2);
        } else {
            Sdk sdk = PyBuiltinCache.findSdkForFile((PsiFileSystemItem)foothold.getContainingFile());
            if (sdk != null) {
                cache2 = PythonSdkPathCache.getInstance(foothold.getProject(), sdk);
            }
        }
        return cache2;
    }

    @Deprecated
    @Nullable
    public static PsiElement resolveChild(@Nullable PsiElement parent, @NotNull String referencedName, @Nullable PsiFile containingFile, boolean fileOnly, boolean checkForPackage, boolean withoutStubs) {
        List<RatedResolveResult> results;
        if (referencedName == null) {
            ResolveImportUtil.$$$reportNull$$$0(19);
        }
        return (results = ResolveImportUtil.resolveChildren(parent, referencedName, containingFile, fileOnly, checkForPackage, withoutStubs, false)).isEmpty() ? null : RatedResolveResult.sorted(results).get(0).getElement();
    }

    @NotNull
    public static List<RatedResolveResult> resolveChildren(@Nullable PsiElement parent, @NotNull String referencedName, @Nullable PsiFile containingFile, boolean fileOnly, boolean checkForPackage, boolean withoutStubs, boolean withoutForeign) {
        if (referencedName == null) {
            ResolveImportUtil.$$$reportNull$$$0(20);
        }
        if (parent == null) {
            List<RatedResolveResult> list = Collections.emptyList();
            if (list == null) {
                ResolveImportUtil.$$$reportNull$$$0(21);
            }
            return list;
        }
        if (parent instanceof PyFile) {
            List<RatedResolveResult> list = ResolveImportUtil.resolveInPackageModule((PyFile)parent, referencedName, containingFile, fileOnly, checkForPackage, withoutStubs, withoutForeign);
            if (list == null) {
                ResolveImportUtil.$$$reportNull$$$0(22);
            }
            return list;
        }
        if (parent instanceof PsiDirectory) {
            List<RatedResolveResult> list = ResolveImportUtil.resolveInPackageDirectory(parent, referencedName, containingFile, fileOnly, checkForPackage, withoutStubs, withoutForeign);
            if (list == null) {
                ResolveImportUtil.$$$reportNull$$$0(23);
            }
            return list;
        }
        List<RatedResolveResult> list = ResolveImportUtil.resolveMemberFromReferenceTypeProviders(parent, referencedName);
        if (list == null) {
            ResolveImportUtil.$$$reportNull$$$0(24);
        }
        return list;
    }

    @NotNull
    private static List<RatedResolveResult> resolveInPackageModule(@NotNull PyFile parent, @NotNull String referencedName, @Nullable PsiFile containingFile, boolean fileOnly, boolean checkForPackage, boolean withoutStubs, boolean withoutForeign) {
        if (parent == null) {
            ResolveImportUtil.$$$reportNull$$$0(25);
        }
        if (referencedName == null) {
            ResolveImportUtil.$$$reportNull$$$0(26);
        }
        List<RatedResolveResult> moduleMembers = ResolveImportUtil.resolveModuleMember(parent, referencedName);
        ArrayList resolvedInModule = Lists.newArrayList();
        ArrayList results = Lists.newArrayList();
        for (RatedResolveResult member : moduleMembers) {
            PsiElement moduleMember = member.getElement();
            if (fileOnly && !PsiTreeUtil.instanceOf((Object)moduleMember, (Class[])new Class[]{PsiFile.class, PsiDirectory.class})) continue;
            results.add(member);
            if (moduleMember == null || ResolveImportUtil.preferResolveInDirectoryOverModule(moduleMember)) continue;
            resolvedInModule.add(member);
        }
        if (!resolvedInModule.isEmpty()) {
            ArrayList arrayList = resolvedInModule;
            if (arrayList == null) {
                ResolveImportUtil.$$$reportNull$$$0(27);
            }
            return arrayList;
        }
        List<RatedResolveResult> resolvedInDirectory = ResolveImportUtil.resolveInPackageDirectory((PsiElement)parent, referencedName, containingFile, fileOnly, checkForPackage, withoutStubs, withoutForeign);
        if (!resolvedInDirectory.isEmpty()) {
            List<RatedResolveResult> list = resolvedInDirectory;
            if (list == null) {
                ResolveImportUtil.$$$reportNull$$$0(28);
            }
            return list;
        }
        ArrayList arrayList = results;
        if (arrayList == null) {
            ResolveImportUtil.$$$reportNull$$$0(29);
        }
        return arrayList;
    }

    private static boolean preferResolveInDirectoryOverModule(@NotNull PsiElement resolved) {
        if (resolved == null) {
            ResolveImportUtil.$$$reportNull$$$0(30);
        }
        return PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)resolved, PyExceptPart.class) != null || PsiTreeUtil.instanceOf((Object)resolved, (Class[])new Class[]{PsiFile.class, PsiDirectory.class}) || ResolveImportUtil.isDunderAll(resolved);
    }

    @NotNull
    private static List<RatedResolveResult> resolveModuleMember(@NotNull PyFile file, @NotNull String referencedName) {
        PyResolveContext resolveContext;
        PyModuleType moduleType;
        List<? extends RatedResolveResult> results;
        if (file == null) {
            ResolveImportUtil.$$$reportNull$$$0(31);
        }
        if (referencedName == null) {
            ResolveImportUtil.$$$reportNull$$$0(32);
        }
        if ((results = (moduleType = new PyModuleType(file)).resolveMember(referencedName, null, AccessDirection.READ, resolveContext = PyResolveContext.defaultContext())) == null) {
            List<RatedResolveResult> list = Collections.emptyList();
            if (list == null) {
                ResolveImportUtil.$$$reportNull$$$0(33);
            }
            return list;
        }
        ArrayList arrayList = Lists.newArrayList(results);
        if (arrayList == null) {
            ResolveImportUtil.$$$reportNull$$$0(34);
        }
        return arrayList;
    }

    @NotNull
    private static List<RatedResolveResult> resolveInPackageDirectory(@Nullable PsiElement parent, @NotNull String referencedName, @Nullable PsiFile containingFile, boolean fileOnly, boolean checkForPackage, boolean withoutStubs, boolean withoutForeign) {
        PsiElement parentDir;
        if (referencedName == null) {
            ResolveImportUtil.$$$reportNull$$$0(35);
        }
        if ((parentDir = PyUtil.turnInitIntoDir(parent)) instanceof PsiDirectory) {
            PsiElement foreign;
            List<RatedResolveResult> resolved = ResolveImportUtil.resolveInDirectory(referencedName, containingFile, (PsiDirectory)parentDir, fileOnly, checkForPackage, withoutStubs);
            if (!resolved.isEmpty()) {
                for (RatedResolveResult result : resolved) {
                    if (result.getRate() <= -1000) continue;
                    List<RatedResolveResult> list = resolved;
                    if (list == null) {
                        ResolveImportUtil.$$$reportNull$$$0(36);
                    }
                    return list;
                }
            }
            if (!withoutForeign && parent instanceof PsiFile && (foreign = ResolveImportUtil.resolveForeignImports((PsiFile)parent, referencedName)) != null) {
                ResolveResultList results = new ResolveResultList();
                results.addAll(resolved);
                results.poke(foreign, 0);
                ResolveResultList resolveResultList = results;
                if (resolveResultList == null) {
                    ResolveImportUtil.$$$reportNull$$$0(37);
                }
                return resolveResultList;
            }
            List<RatedResolveResult> list = resolved;
            if (list == null) {
                ResolveImportUtil.$$$reportNull$$$0(38);
            }
            return list;
        }
        List<RatedResolveResult> list = Collections.emptyList();
        if (list == null) {
            ResolveImportUtil.$$$reportNull$$$0(39);
        }
        return list;
    }

    @Nullable
    private static PsiElement resolveForeignImports(@NotNull PsiFile foothold, @NotNull String referencedName) {
        if (foothold == null) {
            ResolveImportUtil.$$$reportNull$$$0(40);
        }
        if (referencedName == null) {
            ResolveImportUtil.$$$reportNull$$$0(41);
        }
        PyQualifiedNameResolveContext context = PyResolveImportUtil.fromFoothold((PsiElement)foothold).copyWithoutRoots();
        List<PsiElement> results = PyResolveImportUtil.resolveQualifiedName(QualifiedName.fromDottedString((String)referencedName), context);
        return !results.isEmpty() ? results.get(0) : null;
    }

    @NotNull
    private static List<RatedResolveResult> resolveMemberFromReferenceTypeProviders(@NotNull PsiElement parent, @NotNull String referencedName) {
        List<? extends RatedResolveResult> result;
        PyResolveContext resolveContext;
        Ref<PyType> refType;
        if (parent == null) {
            ResolveImportUtil.$$$reportNull$$$0(42);
        }
        if (referencedName == null) {
            ResolveImportUtil.$$$reportNull$$$0(43);
        }
        if ((refType = PyReferenceExpressionImpl.getReferenceTypeFromProviders(parent, (resolveContext = PyResolveContext.defaultContext()).getTypeEvalContext(), null)) != null && !refType.isNull() && (result = ((PyType)refType.get()).resolveMember(referencedName, null, AccessDirection.READ, resolveContext)) != null) {
            ArrayList arrayList = Lists.newArrayList(result);
            if (arrayList == null) {
                ResolveImportUtil.$$$reportNull$$$0(44);
            }
            return arrayList;
        }
        List<RatedResolveResult> list = Collections.emptyList();
        if (list == null) {
            ResolveImportUtil.$$$reportNull$$$0(45);
        }
        return list;
    }

    private static boolean isDunderAll(@NotNull PsiElement element) {
        if (element == null) {
            ResolveImportUtil.$$$reportNull$$$0(46);
        }
        return element instanceof PyElement && "__all__".equals(((PyElement)element).getName());
    }

    @NotNull
    private static List<RatedResolveResult> resolveInDirectory(@NotNull String referencedName, @Nullable PsiFile containingFile, PsiDirectory dir, boolean isFileOnly, boolean checkForPackage, boolean withoutStubs) {
        PsiElement packageElement;
        PsiFile module2;
        PsiDirectory stubPackage;
        if (referencedName == null) {
            ResolveImportUtil.$$$reportNull$$$0(47);
        }
        ResolveResultList result = new ResolveResultList();
        PsiDirectory subdir = dir.findSubdirectory(referencedName);
        if (subdir != null && subdir.getName().equals(referencedName) && (!checkForPackage || PyUtil.isPackage(subdir, (PsiElement)containingFile))) {
            stubPackage = PyStubPackages.findStubPackage(dir, referencedName, checkForPackage, withoutStubs);
            if (stubPackage == null || PyStubPackages.stubPackageIsPartial(stubPackage)) {
                result.add(new RatedResolveResult(0, (PsiElement)PyStubPackages.transferStubPackageMarker(dir, subdir)));
            }
            if (stubPackage != null) {
                result.add(new RatedResolveResult(0, (PsiElement)stubPackage));
            }
        }
        if (subdir == null && (stubPackage = PyStubPackages.findStubPackage(dir, referencedName, checkForPackage, withoutStubs)) != null) {
            result.add(new RatedResolveResult(0, (PsiElement)stubPackage));
        }
        if ((module2 = ResolveImportUtil.findPyFileInDir(dir, referencedName, withoutStubs)) != null) {
            result.add(new RatedResolveResult(0, (PsiElement)PyStubPackages.transferStubPackageMarker(dir, module2)));
        }
        if (!isFileOnly && (packageElement = PyUtil.getPackageElement(dir, (PsiElement)containingFile)) != containingFile && packageElement instanceof PyFile) {
            result.addAll(((PyFile)packageElement).multiResolveName(referencedName));
        }
        ResolveResultList resolveResultList = result;
        if (resolveResultList == null) {
            ResolveImportUtil.$$$reportNull$$$0(48);
        }
        return resolveResultList;
    }

    @Nullable
    private static PsiFile findPyFileInDir(PsiDirectory dir, String referencedName, boolean withoutStubs) {
        PsiFile file = null;
        if (!withoutStubs) {
            file = dir.findFile(referencedName + ".pyi");
        }
        if (file == null) {
            file = dir.findFile(referencedName + ".py");
        }
        if (file == null) {
            FileNameMatcher association;
            List associations = FileTypeManager.getInstance().getAssociations((FileType)PythonFileType.INSTANCE);
            Iterator iterator = associations.iterator();
            while (iterator.hasNext() && (!((association = (FileNameMatcher)iterator.next()) instanceof ExtensionFileNameMatcher) || (file = dir.findFile(referencedName + "." + ((ExtensionFileNameMatcher)association).getExtension())) == null)) {
            }
        }
        if (file != null && FileUtil.getNameWithoutExtension((String)file.getName()).equals(referencedName)) {
            return file;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static ResolveResultList rateResults(List<? extends PsiElement> targets) {
        ResolveResultList ret = new ResolveResultList();
        for (PsiElement psiElement : targets) {
            void var3_3;
            if (psiElement instanceof PsiDirectory) {
                PsiElement psiElement2 = PyUtil.getPackageElement((PsiDirectory)psiElement, null);
            }
            if (var3_3 == null) continue;
            int rate = 1000;
            if (var3_3 instanceof PyFile) {
                for (PyResolveResultRater rater : PyResolveResultRater.EP_NAME.getExtensionList()) {
                    rate += rater.getImportElementRate((PsiElement)var3_3);
                }
            } else if (ResolveImportUtil.isDunderAll((PsiElement)var3_3)) {
                rate = 0;
            }
            ret.poke((PsiElement)var3_3, rate);
        }
        return ret;
    }

    @NotNull
    private static List<RatedResolveResult> updateRatedResults(@NotNull List<? extends RatedResolveResult> results) {
        if (results == null) {
            ResolveImportUtil.$$$reportNull$$$0(49);
        }
        if (results.isEmpty()) {
            List<RatedResolveResult> list = Collections.emptyList();
            if (list == null) {
                ResolveImportUtil.$$$reportNull$$$0(50);
            }
            return list;
        }
        ResolveResultList result = new ResolveResultList();
        for (RatedResolveResult ratedResolveResult : results) {
            PsiElement element = ratedResolveResult.getElement();
            if (element instanceof PsiDirectory) {
                element = PyUtil.getPackageElement((PsiDirectory)element, element);
            }
            if (element == null) continue;
            int delta = 0;
            for (PyResolveResultRater rater : PyResolveResultRater.EP_NAME.getExtensionList()) {
                delta += rater.getImportElementRate(element);
            }
            result.poke(element, ratedResolveResult.getRate() + delta);
        }
        ResolveResultList resolveResultList = result;
        if (resolveResultList == null) {
            ResolveImportUtil.$$$reportNull$$$0(51);
        }
        return resolveResultList;
    }

    @NotNull
    public static PointInImport getPointInImport(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            ResolveImportUtil.$$$reportNull$$$0(52);
        }
        if ((parent = PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{PyImportElement.class, PyFromImportStatement.class})) instanceof PyFromImportStatement) {
            PointInImport pointInImport = PointInImport.AS_MODULE;
            if (pointInImport == null) {
                ResolveImportUtil.$$$reportNull$$$0(53);
            }
            return pointInImport;
        }
        if (parent instanceof PyImportElement) {
            PsiElement statement = parent.getParent();
            if (statement instanceof PyImportStatement) {
                PointInImport pointInImport = PointInImport.AS_MODULE;
                if (pointInImport == null) {
                    ResolveImportUtil.$$$reportNull$$$0(54);
                }
                return pointInImport;
            }
            if (statement instanceof PyFromImportStatement) {
                PointInImport pointInImport = PointInImport.AS_NAME;
                if (pointInImport == null) {
                    ResolveImportUtil.$$$reportNull$$$0(55);
                }
                return pointInImport;
            }
        }
        PointInImport pointInImport = PointInImport.NONE;
        if (pointInImport == null) {
            ResolveImportUtil.$$$reportNull$$$0(56);
        }
        return pointInImport;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 44: 
            case 45: 
            case 48: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 44: 
            case 45: 
            case 48: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 44: 
            case 45: 
            case 48: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/resolve/ResolveImportUtil";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromImportStatement";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleQualifiedName";
                break;
            }
            case 19: 
            case 20: 
            case 26: 
            case 32: 
            case 35: 
            case 41: 
            case 43: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referencedName";
                break;
            }
            case 25: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolved";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foothold";
                break;
            }
            case 46: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/resolve/ResolveImportUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolveImportElement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveNameInImportStatement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveNameInFromImport";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveFromImportStatementSource";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveModule";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateResolveModule";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolveModuleInRoots";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveChildren";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveInPackageModule";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveModuleMember";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveInPackageDirectory";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveMemberFromReferenceTypeProviders";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveInDirectory";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "updateRatedResults";
                break;
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getPointInImport";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveImportElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "multiResolveImportElement";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 44: 
            case 45: 
            case 48: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resolveNameInImportStatement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolveNameInFromImport";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "resolveFromImportStatementSource";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "calculateResolveModule";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "multiResolveModuleInRoots";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "resolveModuleInRoots";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "resolveChild";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "resolveChildren";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "resolveInPackageModule";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "preferResolveInDirectoryOverModule";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "resolveModuleMember";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "resolveInPackageDirectory";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "resolveForeignImports";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "resolveMemberFromReferenceTypeProviders";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "isDunderAll";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "resolveInDirectory";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "updateRatedResults";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getPointInImport";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 44: 
            case 45: 
            case 48: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ResolveModuleParams {
        @NotNull
        private final QualifiedName myName;
        @NotNull
        private final PsiFile myFile;
        private final boolean myAbsolute;
        private final int myLevel;

        ResolveModuleParams(@NotNull QualifiedName qualifiedName, @NotNull PsiFile file, boolean importIsAbsolute, int relativeLevel) {
            if (qualifiedName == null) {
                ResolveModuleParams.$$$reportNull$$$0(0);
            }
            if (file == null) {
                ResolveModuleParams.$$$reportNull$$$0(1);
            }
            this.myName = qualifiedName;
            this.myFile = file;
            this.myAbsolute = importIsAbsolute;
            this.myLevel = relativeLevel;
        }

        @NotNull
        public QualifiedName getName() {
            QualifiedName qualifiedName = this.myName;
            if (qualifiedName == null) {
                ResolveModuleParams.$$$reportNull$$$0(2);
            }
            return qualifiedName;
        }

        public boolean isAbsolute() {
            return this.myAbsolute;
        }

        public int getLevel() {
            return this.myLevel;
        }

        @NotNull
        public PsiFile getFile() {
            PsiFile psiFile = this.myFile;
            if (psiFile == null) {
                ResolveModuleParams.$$$reportNull$$$0(3);
            }
            return psiFile;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResolveModuleParams params = (ResolveModuleParams)o;
            if (this.myAbsolute != params.myAbsolute) {
                return false;
            }
            if (this.myLevel != params.myLevel) {
                return false;
            }
            if (!this.myName.equals((Object)params.myName)) {
                return false;
            }
            return this.myFile.equals(params.myFile);
        }

        public int hashCode() {
            int result = this.myName.hashCode();
            result = 31 * result + this.myFile.hashCode();
            result = 31 * result + (this.myAbsolute ? 1 : 0);
            result = 31 * result + this.myLevel;
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifiedName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/psi/resolve/ResolveImportUtil$ResolveModuleParams";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/psi/resolve/ResolveImportUtil$ResolveModuleParams";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

