/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.offroad.actions;

import java.awt.event.ActionEvent;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.swing.JFileChooser;
import net.osmand.data.FavouritePoint;
import net.osmand.data.LatLon;
import net.osmand.plus.FavouritesDbHelper;
import net.osmand.plus.GPXUtilities;
import net.osmand.plus.helpers.Kml2Gpx;
import net.sourceforge.offroad.OsmWindow;
import net.sourceforge.offroad.actions.OffRoadAction;
import net.sourceforge.offroad.ui.AsyncTask;
import net.sourceforge.offroad.ui.ProgressDialog;

public class GpxImportAction
extends OffRoadAction {
    public static final String KML_SUFFIX = ".kml";
    public static final String GPX_SUFFIX = ".gpx";

    public GpxImportAction(OsmWindow pContext) {
        super(pContext);
    }

    @Override
    public void actionPerformed(ActionEvent pE) {
        JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(true);
        int result = chooser.showOpenDialog(this.mContext.getWindow());
        if (result == 1) {
            return;
        }
        File[] fileList = chooser.getSelectedFiles();
        for (int i = 0; i < fileList.length; ++i) {
            boolean saveFile;
            File file;
            File intentUri = file = fileList[i];
            String fileName = file.getName();
            boolean isFileIntent = true;
            boolean isOsmandSubdir = this.isSubDirectory(this.mContext.getAppPath("tracks/"), new File(intentUri.getPath()));
            boolean bl = saveFile = !isOsmandSubdir;
            if (file != null && fileName.endsWith(KML_SUFFIX)) {
                this.handleKmlImport(intentUri, fileName, saveFile);
                continue;
            }
            this.handleFavouritesImport(intentUri, fileName, saveFile);
        }
    }

    private void handleFavouritesImport(final File pIntentUri, final String fileName, final boolean save) {
        new AsyncTask<Void, Void, GPXUtilities.GPXFile>(){
            ProgressDialog progress = null;

            @Override
            protected void onPreExecute() {
                this.progress = ProgressDialog.show(GpxImportAction.this.mContext.getString(1312, ""), GpxImportAction.this.mContext.getString(794));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected GPXUtilities.GPXFile doInBackground(Void ... nothing) {
                FileInputStream is = null;
                try {
                    is = new FileInputStream(pIntentUri);
                    GPXUtilities.GPXFile gPXFile = GPXUtilities.loadGPXFile(GpxImportAction.this.mContext, is);
                    return gPXFile;
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                finally {
                    if (is != null) {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                return null;
            }

            @Override
            protected void onPostExecute(GPXUtilities.GPXFile result) {
                this.progress.dismiss();
                GpxImportAction.this.importFavourites(result, fileName, save);
            }
        }.execute();
    }

    private void importFavoritesImpl(final GPXUtilities.GPXFile gpxFile) {
        new AsyncTask<Void, Void, GPXUtilities.GPXFile>(){
            ProgressDialog progress = null;

            @Override
            protected void onPreExecute() {
                this.progress = ProgressDialog.show(GpxImportAction.this.mContext.getString(1312, ""), GpxImportAction.this.mContext.getString(794));
            }

            protected GPXUtilities.GPXFile doInBackground(Void ... nothing) {
                List favourites = GpxImportAction.this.asFavourites(gpxFile.points);
                FavouritesDbHelper favoritesHelper = GpxImportAction.this.mContext.getFavorites();
                for (FavouritePoint favourite : favourites) {
                    favoritesHelper.deleteFavourite(favourite, false);
                    favoritesHelper.addFavourite(favourite, false);
                }
                favoritesHelper.sortAll();
                favoritesHelper.saveCurrentPointsIntoFile();
                return null;
            }

            @Override
            protected void onPostExecute(GPXUtilities.GPXFile result) {
                this.progress.dismiss();
            }
        }.execute();
    }

    private void handleKmlImport(final File pIntentUri, final String name, final boolean save) {
        new AsyncTask<Void, Void, GPXUtilities.GPXFile>(){
            ProgressDialog progress = null;

            @Override
            protected void onPreExecute() {
                this.progress = ProgressDialog.show(GpxImportAction.this.mContext.getString(1312, ""), GpxImportAction.this.mContext.getString(794));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            protected GPXUtilities.GPXFile doInBackground(Void ... nothing) {
                block18: {
                    FileInputStream is = null;
                    try {
                        is = new FileInputStream(pIntentUri);
                        String result = Kml2Gpx.toGpx(is);
                        if (result == null) break block18;
                        try {
                            GPXUtilities.GPXFile gPXFile = GPXUtilities.loadGPXFile(GpxImportAction.this.mContext, new ByteArrayInputStream(result.getBytes("UTF-8")));
                            return gPXFile;
                        }
                        catch (UnsupportedEncodingException e) {
                            GPXUtilities.GPXFile gPXFile;
                            block19: {
                                gPXFile = null;
                                if (is == null) break block19;
                                try {
                                    ((InputStream)is).close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            return gPXFile;
                            catch (FileNotFoundException fileNotFoundException) {
                                break block18;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                    finally {
                        if (is != null) {
                            try {
                                ((InputStream)is).close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
                return null;
            }

            @Override
            protected void onPostExecute(GPXUtilities.GPXFile result) {
                this.progress.dismiss();
                GpxImportAction.this.handleResult(result, name, save);
            }
        }.execute();
    }

    private void handleResult(GPXUtilities.GPXFile result, String name, boolean save) {
        if (result != null && result.warning == null) {
            if (save) {
                new SaveAsyncTask(result, name).execute();
            } else {
                this.showGpxOnMap(result);
            }
        }
    }

    private String saveImport(GPXUtilities.GPXFile gpxFile, String fileName) {
        String warning;
        if (gpxFile.isEmpty() || fileName == null) {
            warning = this.mContext.getString(620);
        } else {
            File importDir = this.mContext.getAppPath("tracks/import/");
            importDir.mkdirs();
            if (importDir.exists() && importDir.isDirectory() && importDir.canWrite()) {
                GPXUtilities.WptPt pt = gpxFile.findPointToShow();
                File toWrite = this.getFileToSave(fileName, importDir, pt);
                warning = GPXUtilities.writeGpxFile(toWrite, gpxFile, this.mContext);
                if (warning == null) {
                    gpxFile.path = toWrite.getAbsolutePath();
                }
            } else {
                warning = this.mContext.getString(752);
            }
        }
        return warning;
    }

    private File getFileToSave(String fileName, File importDir, GPXUtilities.WptPt pt) {
        StringBuilder builder = new StringBuilder(fileName);
        if ("".equals(fileName)) {
            builder.append("import_").append(new SimpleDateFormat("HH-mm_EEE", Locale.US).format(new Date(pt.time))).append(GPX_SUFFIX);
        }
        if (fileName.endsWith(KML_SUFFIX)) {
            builder.replace(builder.length() - KML_SUFFIX.length(), builder.length(), GPX_SUFFIX);
        } else if (!fileName.endsWith(GPX_SUFFIX)) {
            builder.append(GPX_SUFFIX);
        }
        return new File(importDir, builder.toString());
    }

    private void showGpxOnMap(GPXUtilities.GPXFile result) {
        this.mContext.getSelectedGpxHelper().setGpxFileToDisplay(result);
        GPXUtilities.WptPt moveTo = result.findPointToShow();
        if (moveTo != null) {
            this.mContext.move(new LatLon(moveTo.getLatitude(), moveTo.getLongitude()), null);
        }
        this.mContext.getDrawPanel().drawLater();
    }

    private void importFavourites(GPXUtilities.GPXFile gpxFile, String fileName, boolean save) {
        this.handleResult(gpxFile, fileName, save);
    }

    private List<FavouritePoint> asFavourites(List<GPXUtilities.WptPt> wptPts) {
        ArrayList<FavouritePoint> favourites = new ArrayList<FavouritePoint>();
        for (GPXUtilities.WptPt p : wptPts) {
            if (p.category != null) {
                FavouritePoint fp = new FavouritePoint(p.lat, p.lon, p.name, p.category);
                if (p.desc != null) {
                    fp.setDescription(p.desc);
                }
                favourites.add(fp);
                continue;
            }
            if (p.name == null) continue;
            favourites.add(new FavouritePoint(p.lat, p.lon, p.name, ""));
        }
        return favourites;
    }

    public boolean isSubDirectory(File parent, File child) {
        try {
            parent = parent.getCanonicalFile();
            for (File dir = child = child.getCanonicalFile(); dir != null; dir = dir.getParentFile()) {
                if (!parent.equals(dir)) continue;
                return true;
            }
        }
        catch (IOException e) {
            return false;
        }
        return false;
    }

    private class SaveAsyncTask
    extends AsyncTask<Void, Void, String> {
        private final GPXUtilities.GPXFile result;
        private final String name;

        private SaveAsyncTask(GPXUtilities.GPXFile result, String name) {
            this.result = result;
            this.name = name;
        }

        protected String doInBackground(Void ... nothing) {
            return GpxImportAction.this.saveImport(this.result, this.name);
        }

        @Override
        protected void onPostExecute(String warning) {
            String msg = warning == null ? MessageFormat.format(GpxImportAction.this.mContext.getString(1524), this.result.path) : warning;
            GpxImportAction.this.showGpxOnMap(this.result);
        }
    }
}

