# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.hyper_tree_cursor import HyperTreeCursor


class HyperTreeGridCursor(HyperTreeCursor):
    """
    HyperTreeGridCursor - Objects for depth-first traversal
    hyper_tree_grids.
    
    Superclass: HyperTreeCursor
    
    Objects that can perform depth-first traversal of hyper tree grids,
    take into account more parameters (related to the grid structure)
    than
     the compact hyper tree cursor implemented in HyperTree can. This
    is an abstract class. Cursors are created by the hyper_tree_grid
    implementation.
    
    @sa
    HyperTreeCursor HyperTree HyperTreeGrid
    
    @par Thanks: This class was written by Guénolé Harel and
    Jacques-Bernard Lekien, 2014 This class was re-written by Philippe
    Pebay, 2016 This work was supported by Commissariat a l'Energie
    Atomique (CEA/DIF)
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkHyperTreeGridCursor, obj, update, **traits)
    
    def _get_grid(self):
        return wrap_vtk(self._vtk_obj.GetGrid())
    def _set_grid(self, arg):
        old_val = self._get_grid()
        self._wrap_call(self._vtk_obj.SetGrid,
                        deref_vtk(arg))
        self.trait_property_changed('grid', old_val, arg)
    grid = traits.Property(_get_grid, _set_grid, desc=\
        """
        Set the hyper tree grid to which the cursor is pointing.
        """
    )

    def _get_tree(self):
        return wrap_vtk(self._vtk_obj.GetTree())
    def _set_tree(self, arg):
        old_val = self._get_tree()
        self._wrap_call(self._vtk_obj.SetTree,
                        deref_vtk(arg))
        self.trait_property_changed('tree', old_val, arg)
    tree = traits.Property(_get_tree, _set_tree, desc=\
        """
        Set the hyper tree to which the cursor is pointing.
        """
    )

    def get_bounds(self, *args):
        """
        V.get_bounds([float, float, float, float, float, float])
        C++: virtual void GetBounds(double pt[6])
        Compute the bounds of the cursor. NB: The basic hyper tree grid
        cursor does not have bounds.
        """
        ret = self._wrap_call(self._vtk_obj.GetBounds, *args)
        return ret

    def get_corner_cursors(self, *args):
        """
        V.get_corner_cursors(int, int, IdList) -> bool
        C++: virtual bool GetCornerCursors(unsigned int, unsigned int,
            IdList *)
        Return the list of cursors pointing to the leaves touching a
        given corner of the cell. Return whether the considered cell is
        the owner of said corner. NB: Only the Moore super cursor
        implements this functionality.
        """
        my_args = deref_array(args, [('int', 'int', 'vtkIdList')])
        ret = self._wrap_call(self._vtk_obj.GetCornerCursors, *my_args)
        return ret

    def get_cursor(self, *args):
        """
        V.get_cursor(int) -> HyperTreeGridCursor
        C++: virtual HyperTreeGridCursor *GetCursor(unsigned int)
        Return the cursor pointing into i-th neighbor. The neighborhood
        definition depends on the type of cursor. NB: Only super cursors
        keep track of neighborhoods.
        """
        ret = self._wrap_call(self._vtk_obj.GetCursor, *args)
        return wrap_vtk(ret)

    def _get_global_node_index(self):
        return self._vtk_obj.GetGlobalNodeIndex()
    global_node_index = traits.Property(_get_global_node_index, desc=\
        """
        Return the global index (relative to the grid) of the current
        vertex in the tree.
        """
    )

    def _get_number_of_cursors(self):
        return self._vtk_obj.GetNumberOfCursors()
    number_of_cursors = traits.Property(_get_number_of_cursors, desc=\
        """
        Return the number of neighborhood cursors The neighborhood
        definition depends on the type of cursor. NB: Only super cursors
        keep track of neighborhoods.
        """
    )

    def _get_origin(self):
        return self._vtk_obj.GetOrigin()
    origin = traits.Property(_get_origin, desc=\
        """
        Compute the origin of the cursor. NB: The basic hyper tree grid
        cursor does not have an origin.
        """
    )

    def get_point(self, *args):
        """
        V.get_point([float, float, float])
        C++: virtual void GetPoint(double pt[3])
        Compute the center coordinates of the cursor. NB: The basic hyper
        tree grid cursor is always centered at 0.
        """
        ret = self._wrap_call(self._vtk_obj.GetPoint, *args)
        return ret

    def _get_size(self):
        return self._vtk_obj.GetSize()
    size = traits.Property(_get_size, desc=\
        """
        Compute the size of the cursor. NB: The basic hyper tree grid
        cursor does not have a size.
        """
    )

    def initialize(self, *args):
        """
        V.initialize(HyperTreeGrid, int)
        C++: virtual void Initialize(HyperTreeGrid *, IdType)
        Initialize cursor at root of given tree index in grid.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Initialize, *my_args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(HyperTreeGridCursor, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit HyperTreeGridCursor properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit HyperTreeGridCursor properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit HyperTreeGridCursor properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

