/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.objectweb.asm.commons;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jruby.org.objectweb.asm.ClassVisitor;
import org.jruby.org.objectweb.asm.Handle;
import org.jruby.org.objectweb.asm.Label;
import org.jruby.org.objectweb.asm.MethodVisitor;
import org.jruby.org.objectweb.asm.Type;
import org.jruby.org.objectweb.asm.commons.LocalVariablesSorter;
import org.jruby.org.objectweb.asm.commons.Method;
import org.jruby.org.objectweb.asm.commons.TableSwitchGenerator;

public class GeneratorAdapter
extends LocalVariablesSorter {
    private static final String CLASS_DESCRIPTOR = "Ljava/lang/Class;";
    private static final Type BYTE_TYPE = Type.getObjectType("java/lang/Byte");
    private static final Type BOOLEAN_TYPE = Type.getObjectType("java/lang/Boolean");
    private static final Type SHORT_TYPE = Type.getObjectType("java/lang/Short");
    private static final Type CHARACTER_TYPE = Type.getObjectType("java/lang/Character");
    private static final Type INTEGER_TYPE = Type.getObjectType("java/lang/Integer");
    private static final Type FLOAT_TYPE = Type.getObjectType("java/lang/Float");
    private static final Type LONG_TYPE = Type.getObjectType("java/lang/Long");
    private static final Type DOUBLE_TYPE = Type.getObjectType("java/lang/Double");
    private static final Type NUMBER_TYPE = Type.getObjectType("java/lang/Number");
    private static final Type OBJECT_TYPE = Type.getObjectType("java/lang/Object");
    private static final Method BOOLEAN_VALUE = Method.getMethod("boolean booleanValue()");
    private static final Method CHAR_VALUE = Method.getMethod("char charValue()");
    private static final Method INT_VALUE = Method.getMethod("int intValue()");
    private static final Method FLOAT_VALUE = Method.getMethod("float floatValue()");
    private static final Method LONG_VALUE = Method.getMethod("long longValue()");
    private static final Method DOUBLE_VALUE = Method.getMethod("double doubleValue()");
    public static final int ADD = 96;
    public static final int SUB = 100;
    public static final int MUL = 104;
    public static final int DIV = 108;
    public static final int REM = 112;
    public static final int NEG = 116;
    public static final int SHL = 120;
    public static final int SHR = 122;
    public static final int USHR = 124;
    public static final int AND = 126;
    public static final int OR = 128;
    public static final int XOR = 130;
    public static final int EQ = 153;
    public static final int NE = 154;
    public static final int LT = 155;
    public static final int GE = 156;
    public static final int GT = 157;
    public static final int LE = 158;
    private final int access;
    private final String name;
    private final Type returnType;
    private final Type[] argumentTypes;
    private final List<Type> localTypes = new ArrayList<Type>();

    public GeneratorAdapter(MethodVisitor methodVisitor, int access, String name2, String descriptor) {
        this(393216, methodVisitor, access, name2, descriptor);
        if (this.getClass() != GeneratorAdapter.class) {
            throw new IllegalStateException();
        }
    }

    protected GeneratorAdapter(int api, MethodVisitor methodVisitor, int access, String name2, String descriptor) {
        super(api, access, descriptor, methodVisitor);
        this.access = access;
        this.name = name2;
        this.returnType = Type.getReturnType(descriptor);
        this.argumentTypes = Type.getArgumentTypes(descriptor);
    }

    public GeneratorAdapter(int access, Method method2, MethodVisitor methodVisitor) {
        this(methodVisitor, access, method2.getName(), method2.getDescriptor());
    }

    public GeneratorAdapter(int access, Method method2, String signature, Type[] exceptions, ClassVisitor classVisitor) {
        this(access, method2, classVisitor.visitMethod(access, method2.getName(), method2.getDescriptor(), signature, GeneratorAdapter.getInternalNames(exceptions)));
    }

    private static String[] getInternalNames(Type[] types) {
        if (types == null) {
            return null;
        }
        String[] names2 = new String[types.length];
        for (int i2 = 0; i2 < names2.length; ++i2) {
            names2[i2] = types[i2].getInternalName();
        }
        return names2;
    }

    public int getAccess() {
        return this.access;
    }

    public String getName() {
        return this.name;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public Type[] getArgumentTypes() {
        return (Type[])this.argumentTypes.clone();
    }

    public void push(boolean value2) {
        this.push(value2 ? 1 : 0);
    }

    public void push(int value2) {
        if (value2 >= -1 && value2 <= 5) {
            this.mv.visitInsn(3 + value2);
        } else if (value2 >= -128 && value2 <= 127) {
            this.mv.visitIntInsn(16, value2);
        } else if (value2 >= Short.MIN_VALUE && value2 <= Short.MAX_VALUE) {
            this.mv.visitIntInsn(17, value2);
        } else {
            this.mv.visitLdcInsn(value2);
        }
    }

    public void push(long value2) {
        if (value2 == 0L || value2 == 1L) {
            this.mv.visitInsn(9 + (int)value2);
        } else {
            this.mv.visitLdcInsn(value2);
        }
    }

    public void push(float value2) {
        int bits = Float.floatToIntBits(value2);
        if ((long)bits == 0L || bits == 1065353216 || bits == 0x40000000) {
            this.mv.visitInsn(11 + (int)value2);
        } else {
            this.mv.visitLdcInsn(Float.valueOf(value2));
        }
    }

    public void push(double value2) {
        long bits = Double.doubleToLongBits(value2);
        if (bits == 0L || bits == 0x3FF0000000000000L) {
            this.mv.visitInsn(14 + (int)value2);
        } else {
            this.mv.visitLdcInsn(value2);
        }
    }

    public void push(String value2) {
        if (value2 == null) {
            this.mv.visitInsn(1);
        } else {
            this.mv.visitLdcInsn(value2);
        }
    }

    public void push(Type value2) {
        if (value2 == null) {
            this.mv.visitInsn(1);
        } else {
            switch (value2.getSort()) {
                case 1: {
                    this.mv.visitFieldInsn(178, "java/lang/Boolean", "TYPE", CLASS_DESCRIPTOR);
                    break;
                }
                case 2: {
                    this.mv.visitFieldInsn(178, "java/lang/Character", "TYPE", CLASS_DESCRIPTOR);
                    break;
                }
                case 3: {
                    this.mv.visitFieldInsn(178, "java/lang/Byte", "TYPE", CLASS_DESCRIPTOR);
                    break;
                }
                case 4: {
                    this.mv.visitFieldInsn(178, "java/lang/Short", "TYPE", CLASS_DESCRIPTOR);
                    break;
                }
                case 5: {
                    this.mv.visitFieldInsn(178, "java/lang/Integer", "TYPE", CLASS_DESCRIPTOR);
                    break;
                }
                case 6: {
                    this.mv.visitFieldInsn(178, "java/lang/Float", "TYPE", CLASS_DESCRIPTOR);
                    break;
                }
                case 7: {
                    this.mv.visitFieldInsn(178, "java/lang/Long", "TYPE", CLASS_DESCRIPTOR);
                    break;
                }
                case 8: {
                    this.mv.visitFieldInsn(178, "java/lang/Double", "TYPE", CLASS_DESCRIPTOR);
                    break;
                }
                default: {
                    this.mv.visitLdcInsn(value2);
                }
            }
        }
    }

    public void push(Handle handle) {
        if (handle == null) {
            this.mv.visitInsn(1);
        } else {
            this.mv.visitLdcInsn(handle);
        }
    }

    private int getArgIndex(int arg2) {
        int index2 = (this.access & 8) == 0 ? 1 : 0;
        for (int i2 = 0; i2 < arg2; ++i2) {
            index2 += this.argumentTypes[i2].getSize();
        }
        return index2;
    }

    private void loadInsn(Type type2, int index2) {
        this.mv.visitVarInsn(type2.getOpcode(21), index2);
    }

    private void storeInsn(Type type2, int index2) {
        this.mv.visitVarInsn(type2.getOpcode(54), index2);
    }

    public void loadThis() {
        if ((this.access & 8) != 0) {
            throw new IllegalStateException("no 'this' pointer within static method");
        }
        this.mv.visitVarInsn(25, 0);
    }

    public void loadArg(int arg2) {
        this.loadInsn(this.argumentTypes[arg2], this.getArgIndex(arg2));
    }

    public void loadArgs(int arg2, int count2) {
        int index2 = this.getArgIndex(arg2);
        for (int i2 = 0; i2 < count2; ++i2) {
            Type argumentType = this.argumentTypes[arg2 + i2];
            this.loadInsn(argumentType, index2);
            index2 += argumentType.getSize();
        }
    }

    public void loadArgs() {
        this.loadArgs(0, this.argumentTypes.length);
    }

    public void loadArgArray() {
        this.push(this.argumentTypes.length);
        this.newArray(OBJECT_TYPE);
        for (int i2 = 0; i2 < this.argumentTypes.length; ++i2) {
            this.dup();
            this.push(i2);
            this.loadArg(i2);
            this.box(this.argumentTypes[i2]);
            this.arrayStore(OBJECT_TYPE);
        }
    }

    public void storeArg(int arg2) {
        this.storeInsn(this.argumentTypes[arg2], this.getArgIndex(arg2));
    }

    public Type getLocalType(int local2) {
        return this.localTypes.get(local2 - this.firstLocal);
    }

    protected void setLocalType(int local2, Type type2) {
        int index2 = local2 - this.firstLocal;
        while (this.localTypes.size() < index2 + 1) {
            this.localTypes.add(null);
        }
        this.localTypes.set(index2, type2);
    }

    public void loadLocal(int local2) {
        this.loadInsn(this.getLocalType(local2), local2);
    }

    public void loadLocal(int local2, Type type2) {
        this.setLocalType(local2, type2);
        this.loadInsn(type2, local2);
    }

    public void storeLocal(int local2) {
        this.storeInsn(this.getLocalType(local2), local2);
    }

    public void storeLocal(int local2, Type type2) {
        this.setLocalType(local2, type2);
        this.storeInsn(type2, local2);
    }

    public void arrayLoad(Type type2) {
        this.mv.visitInsn(type2.getOpcode(46));
    }

    public void arrayStore(Type type2) {
        this.mv.visitInsn(type2.getOpcode(79));
    }

    public void pop() {
        this.mv.visitInsn(87);
    }

    public void pop2() {
        this.mv.visitInsn(88);
    }

    public void dup() {
        this.mv.visitInsn(89);
    }

    public void dup2() {
        this.mv.visitInsn(92);
    }

    public void dupX1() {
        this.mv.visitInsn(90);
    }

    public void dupX2() {
        this.mv.visitInsn(91);
    }

    public void dup2X1() {
        this.mv.visitInsn(93);
    }

    public void dup2X2() {
        this.mv.visitInsn(94);
    }

    public void swap() {
        this.mv.visitInsn(95);
    }

    public void swap(Type prev, Type type2) {
        if (type2.getSize() == 1) {
            if (prev.getSize() == 1) {
                this.swap();
            } else {
                this.dupX2();
                this.pop();
            }
        } else if (prev.getSize() == 1) {
            this.dup2X1();
            this.pop2();
        } else {
            this.dup2X2();
            this.pop2();
        }
    }

    public void math(int op, Type type2) {
        this.mv.visitInsn(type2.getOpcode(op));
    }

    public void not() {
        this.mv.visitInsn(4);
        this.mv.visitInsn(130);
    }

    public void iinc(int local2, int amount) {
        this.mv.visitIincInsn(local2, amount);
    }

    public void cast(Type from, Type to) {
        if (from != to) {
            if (from.getSort() < 1 || from.getSort() > 8 || to.getSort() < 1 || to.getSort() > 8) {
                throw new IllegalArgumentException("Cannot cast from " + from + " to " + to);
            }
            if (from == Type.DOUBLE_TYPE) {
                if (to == Type.FLOAT_TYPE) {
                    this.mv.visitInsn(144);
                } else if (to == Type.LONG_TYPE) {
                    this.mv.visitInsn(143);
                } else {
                    this.mv.visitInsn(142);
                    this.cast(Type.INT_TYPE, to);
                }
            } else if (from == Type.FLOAT_TYPE) {
                if (to == Type.DOUBLE_TYPE) {
                    this.mv.visitInsn(141);
                } else if (to == Type.LONG_TYPE) {
                    this.mv.visitInsn(140);
                } else {
                    this.mv.visitInsn(139);
                    this.cast(Type.INT_TYPE, to);
                }
            } else if (from == Type.LONG_TYPE) {
                if (to == Type.DOUBLE_TYPE) {
                    this.mv.visitInsn(138);
                } else if (to == Type.FLOAT_TYPE) {
                    this.mv.visitInsn(137);
                } else {
                    this.mv.visitInsn(136);
                    this.cast(Type.INT_TYPE, to);
                }
            } else if (to == Type.BYTE_TYPE) {
                this.mv.visitInsn(145);
            } else if (to == Type.CHAR_TYPE) {
                this.mv.visitInsn(146);
            } else if (to == Type.DOUBLE_TYPE) {
                this.mv.visitInsn(135);
            } else if (to == Type.FLOAT_TYPE) {
                this.mv.visitInsn(134);
            } else if (to == Type.LONG_TYPE) {
                this.mv.visitInsn(133);
            } else if (to == Type.SHORT_TYPE) {
                this.mv.visitInsn(147);
            }
        }
    }

    private static Type getBoxedType(Type type2) {
        switch (type2.getSort()) {
            case 3: {
                return BYTE_TYPE;
            }
            case 1: {
                return BOOLEAN_TYPE;
            }
            case 4: {
                return SHORT_TYPE;
            }
            case 2: {
                return CHARACTER_TYPE;
            }
            case 5: {
                return INTEGER_TYPE;
            }
            case 6: {
                return FLOAT_TYPE;
            }
            case 7: {
                return LONG_TYPE;
            }
            case 8: {
                return DOUBLE_TYPE;
            }
        }
        return type2;
    }

    public void box(Type type2) {
        if (type2.getSort() == 10 || type2.getSort() == 9) {
            return;
        }
        if (type2 == Type.VOID_TYPE) {
            this.push((String)null);
        } else {
            Type boxedType = GeneratorAdapter.getBoxedType(type2);
            this.newInstance(boxedType);
            if (type2.getSize() == 2) {
                this.dupX2();
                this.dupX2();
                this.pop();
            } else {
                this.dupX1();
                this.swap();
            }
            this.invokeConstructor(boxedType, new Method("<init>", Type.VOID_TYPE, new Type[]{type2}));
        }
    }

    public void valueOf(Type type2) {
        if (type2.getSort() == 10 || type2.getSort() == 9) {
            return;
        }
        if (type2 == Type.VOID_TYPE) {
            this.push((String)null);
        } else {
            Type boxedType = GeneratorAdapter.getBoxedType(type2);
            this.invokeStatic(boxedType, new Method("valueOf", boxedType, new Type[]{type2}));
        }
    }

    public void unbox(Type type2) {
        Method unboxMethod;
        Type boxedType = NUMBER_TYPE;
        switch (type2.getSort()) {
            case 0: {
                return;
            }
            case 2: {
                boxedType = CHARACTER_TYPE;
                unboxMethod = CHAR_VALUE;
                break;
            }
            case 1: {
                boxedType = BOOLEAN_TYPE;
                unboxMethod = BOOLEAN_VALUE;
                break;
            }
            case 8: {
                unboxMethod = DOUBLE_VALUE;
                break;
            }
            case 6: {
                unboxMethod = FLOAT_VALUE;
                break;
            }
            case 7: {
                unboxMethod = LONG_VALUE;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                unboxMethod = INT_VALUE;
                break;
            }
            default: {
                unboxMethod = null;
            }
        }
        if (unboxMethod == null) {
            this.checkCast(type2);
        } else {
            this.checkCast(boxedType);
            this.invokeVirtual(boxedType, unboxMethod);
        }
    }

    public Label newLabel() {
        return new Label();
    }

    public void mark(Label label2) {
        this.mv.visitLabel(label2);
    }

    public Label mark() {
        Label label2 = new Label();
        this.mv.visitLabel(label2);
        return label2;
    }

    public void ifCmp(Type type2, int mode2, Label label2) {
        switch (type2.getSort()) {
            case 7: {
                this.mv.visitInsn(148);
                break;
            }
            case 8: {
                this.mv.visitInsn(mode2 == 156 || mode2 == 157 ? 151 : 152);
                break;
            }
            case 6: {
                this.mv.visitInsn(mode2 == 156 || mode2 == 157 ? 149 : 150);
                break;
            }
            case 9: 
            case 10: {
                if (mode2 == 153) {
                    this.mv.visitJumpInsn(165, label2);
                    return;
                }
                if (mode2 == 154) {
                    this.mv.visitJumpInsn(166, label2);
                    return;
                }
                throw new IllegalArgumentException("Bad comparison for type " + type2);
            }
            default: {
                int intOp = -1;
                switch (mode2) {
                    case 153: {
                        intOp = 159;
                        break;
                    }
                    case 154: {
                        intOp = 160;
                        break;
                    }
                    case 156: {
                        intOp = 162;
                        break;
                    }
                    case 155: {
                        intOp = 161;
                        break;
                    }
                    case 158: {
                        intOp = 164;
                        break;
                    }
                    case 157: {
                        intOp = 163;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Bad comparison mode " + mode2);
                    }
                }
                this.mv.visitJumpInsn(intOp, label2);
                return;
            }
        }
        this.mv.visitJumpInsn(mode2, label2);
    }

    public void ifICmp(int mode2, Label label2) {
        this.ifCmp(Type.INT_TYPE, mode2, label2);
    }

    public void ifZCmp(int mode2, Label label2) {
        this.mv.visitJumpInsn(mode2, label2);
    }

    public void ifNull(Label label2) {
        this.mv.visitJumpInsn(198, label2);
    }

    public void ifNonNull(Label label2) {
        this.mv.visitJumpInsn(199, label2);
    }

    public void goTo(Label label2) {
        this.mv.visitJumpInsn(167, label2);
    }

    public void ret(int local2) {
        this.mv.visitVarInsn(169, local2);
    }

    public void tableSwitch(int[] keys2, TableSwitchGenerator generator) {
        float density = keys2.length == 0 ? 0.0f : (float)keys2.length / (float)(keys2[keys2.length - 1] - keys2[0] + 1);
        this.tableSwitch(keys2, generator, density >= 0.5f);
    }

    public void tableSwitch(int[] keys2, TableSwitchGenerator generator, boolean useTable) {
        for (int i2 = 1; i2 < keys2.length; ++i2) {
            if (keys2[i2] >= keys2[i2 - 1]) continue;
            throw new IllegalArgumentException("keys must be sorted in ascending order");
        }
        Label defaultLabel = this.newLabel();
        Label endLabel = this.newLabel();
        if (keys2.length > 0) {
            int numKeys = keys2.length;
            if (useTable) {
                int i3;
                int min2 = keys2[0];
                int max2 = keys2[numKeys - 1];
                int range = max2 - min2 + 1;
                Object[] labels = new Label[range];
                Arrays.fill(labels, defaultLabel);
                for (i3 = 0; i3 < numKeys; ++i3) {
                    labels[keys2[i3] - min2] = this.newLabel();
                }
                this.mv.visitTableSwitchInsn(min2, max2, defaultLabel, (Label[])labels);
                for (i3 = 0; i3 < range; ++i3) {
                    Object label2 = labels[i3];
                    if (label2 == defaultLabel) continue;
                    this.mark((Label)label2);
                    generator.generateCase(i3 + min2, endLabel);
                }
            } else {
                int i4;
                Label[] labels = new Label[numKeys];
                for (i4 = 0; i4 < numKeys; ++i4) {
                    labels[i4] = this.newLabel();
                }
                this.mv.visitLookupSwitchInsn(defaultLabel, keys2, labels);
                for (i4 = 0; i4 < numKeys; ++i4) {
                    this.mark(labels[i4]);
                    generator.generateCase(keys2[i4], endLabel);
                }
            }
        }
        this.mark(defaultLabel);
        generator.generateDefault();
        this.mark(endLabel);
    }

    public void returnValue() {
        this.mv.visitInsn(this.returnType.getOpcode(172));
    }

    private void fieldInsn(int opcode, Type ownerType, String name2, Type fieldType) {
        this.mv.visitFieldInsn(opcode, ownerType.getInternalName(), name2, fieldType.getDescriptor());
    }

    public void getStatic(Type owner2, String name2, Type type2) {
        this.fieldInsn(178, owner2, name2, type2);
    }

    public void putStatic(Type owner2, String name2, Type type2) {
        this.fieldInsn(179, owner2, name2, type2);
    }

    public void getField(Type owner2, String name2, Type type2) {
        this.fieldInsn(180, owner2, name2, type2);
    }

    public void putField(Type owner2, String name2, Type type2) {
        this.fieldInsn(181, owner2, name2, type2);
    }

    private void invokeInsn(int opcode, Type type2, Method method2, boolean isInterface) {
        String owner2 = type2.getSort() == 9 ? type2.getDescriptor() : type2.getInternalName();
        this.mv.visitMethodInsn(opcode, owner2, method2.getName(), method2.getDescriptor(), isInterface);
    }

    public void invokeVirtual(Type owner2, Method method2) {
        this.invokeInsn(182, owner2, method2, false);
    }

    public void invokeConstructor(Type type2, Method method2) {
        this.invokeInsn(183, type2, method2, false);
    }

    public void invokeStatic(Type owner2, Method method2) {
        this.invokeInsn(184, owner2, method2, false);
    }

    public void invokeInterface(Type owner2, Method method2) {
        this.invokeInsn(185, owner2, method2, true);
    }

    public void invokeDynamic(String name2, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
        this.mv.visitInvokeDynamicInsn(name2, descriptor, bootstrapMethodHandle, bootstrapMethodArguments);
    }

    private void typeInsn(int opcode, Type type2) {
        this.mv.visitTypeInsn(opcode, type2.getInternalName());
    }

    public void newInstance(Type type2) {
        this.typeInsn(187, type2);
    }

    public void newArray(Type type2) {
        int arrayType;
        switch (type2.getSort()) {
            case 1: {
                arrayType = 4;
                break;
            }
            case 2: {
                arrayType = 5;
                break;
            }
            case 3: {
                arrayType = 8;
                break;
            }
            case 4: {
                arrayType = 9;
                break;
            }
            case 5: {
                arrayType = 10;
                break;
            }
            case 6: {
                arrayType = 6;
                break;
            }
            case 7: {
                arrayType = 11;
                break;
            }
            case 8: {
                arrayType = 7;
                break;
            }
            default: {
                this.typeInsn(189, type2);
                return;
            }
        }
        this.mv.visitIntInsn(188, arrayType);
    }

    public void arrayLength() {
        this.mv.visitInsn(190);
    }

    public void throwException() {
        this.mv.visitInsn(191);
    }

    public void throwException(Type type2, String message2) {
        this.newInstance(type2);
        this.dup();
        this.push(message2);
        this.invokeConstructor(type2, Method.getMethod("void <init> (String)"));
        this.throwException();
    }

    public void checkCast(Type type2) {
        if (!type2.equals(OBJECT_TYPE)) {
            this.typeInsn(192, type2);
        }
    }

    public void instanceOf(Type type2) {
        this.typeInsn(193, type2);
    }

    public void monitorEnter() {
        this.mv.visitInsn(194);
    }

    public void monitorExit() {
        this.mv.visitInsn(195);
    }

    public void endMethod() {
        if ((this.access & 0x400) == 0) {
            this.mv.visitMaxs(0, 0);
        }
        this.mv.visitEnd();
    }

    public void catchException(Label start2, Label end2, Type exception2) {
        Label catchLabel = new Label();
        if (exception2 == null) {
            this.mv.visitTryCatchBlock(start2, end2, catchLabel, null);
        } else {
            this.mv.visitTryCatchBlock(start2, end2, catchLabel, exception2.getInternalName());
        }
        this.mark(catchLabel);
    }
}

