/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.InlineClassesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/FunctionAndSignature;", "", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "(Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;)V", "getFunction", "()Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "jsName", "", "signature", "Lorg/jetbrains/kotlin/ir/backend/js/lower/FunctionAndSignature$Signature;", "equals", "", "other", "hashCode", "", "Signature", "backend.js"})
public final class FunctionAndSignature {
    private final String jsName;
    private final Signature signature;
    @NotNull
    private final IrSimpleFunction function;

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FunctionAndSignature)) {
            return false;
        }
        return Intrinsics.areEqual(this.signature, ((FunctionAndSignature)other).signature);
    }

    public int hashCode() {
        return this.signature.hashCode();
    }

    @NotNull
    public final IrSimpleFunction getFunction() {
        return this.function;
    }

    /*
     * WARNING - void declaration
     */
    public FunctionAndSignature(@NotNull IrSimpleFunction function2) {
        Signature signature;
        Intrinsics.checkParameterIsNotNull(function2, "function");
        this.function = function2;
        this.jsName = AnnotationUtilsKt.getJsName(this.function);
        FunctionAndSignature functionAndSignature = this;
        if (this.jsName != null) {
            signature = new Signature(this.jsName, null, null, null, 14, null);
        } else if (IrUtilsKt.isEffectivelyExternal(this.function)) {
            String string = this.function.getName().asString();
            Intrinsics.checkExpressionValueIsNotNull(string, "function.name.asString()");
            signature = new Signature(string, null, null, null, 14, null);
        } else {
            String string;
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            String string2 = this.function.getName().asString();
            Intrinsics.checkExpressionValueIsNotNull(string2, "function.name.asString()");
            Object object = this.function.getValueParameters();
            IrAnnotationContainer irAnnotationContainer = this.function.getExtensionReceiverParameter();
            String string3 = irAnnotationContainer != null && (irAnnotationContainer = irAnnotationContainer.getType()) != null ? IrTypeUtilsKt.asString((IrType)irAnnotationContainer) : null;
            String string4 = string2;
            FunctionAndSignature functionAndSignature2 = functionAndSignature;
            boolean $i$f$map = false;
            void var4_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                string = IrTypeUtilsKt.asString(it.getType());
                collection.add(string);
            }
            collection = (List)destination$iv$iv;
            object = this.function.getReturnType();
            boolean bl = false;
            boolean bl2 = false;
            Object $this$run = object;
            boolean bl3 = false;
            string = InlineClassesKt.isInlined((IrType)$this$run) ? IrTypeUtilsKt.asString((IrType)$this$run) : null;
            functionAndSignature = functionAndSignature2;
            String string5 = string;
            Collection<String> collection2 = collection;
            String string6 = string3;
            String string7 = string4;
            signature = new Signature(string7, string6, (List<String>)collection2, string5);
        }
        functionAndSignature.signature = signature;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0010\b\u0002\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0011\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0006H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J=\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\u0010\b\u0002\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0019\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/FunctionAndSignature$Signature;", "", "name", "", "extensionReceiverType", "valueParameters", "", "returnType", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;)V", "getExtensionReceiverType", "()Ljava/lang/String;", "getName", "getReturnType", "getValueParameters", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "backend.js"})
    private static final class Signature {
        @NotNull
        private final String name;
        @Nullable
        private final String extensionReceiverType;
        @NotNull
        private final List<String> valueParameters;
        @Nullable
        private final String returnType;

        @NotNull
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final String getExtensionReceiverType() {
            return this.extensionReceiverType;
        }

        @NotNull
        public final List<String> getValueParameters() {
            return this.valueParameters;
        }

        @Nullable
        public final String getReturnType() {
            return this.returnType;
        }

        public Signature(@NotNull String name, @Nullable String extensionReceiverType, @NotNull List<String> valueParameters2, @Nullable String returnType2) {
            Intrinsics.checkParameterIsNotNull(name, "name");
            Intrinsics.checkParameterIsNotNull(valueParameters2, "valueParameters");
            this.name = name;
            this.extensionReceiverType = extensionReceiverType;
            this.valueParameters = valueParameters2;
            this.returnType = returnType2;
        }

        public /* synthetic */ Signature(String string, String string2, List list2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker2) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            if ((n & 4) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            if ((n & 8) != 0) {
                string3 = null;
            }
            this(string, string2, list2, string3);
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @Nullable
        public final String component2() {
            return this.extensionReceiverType;
        }

        @NotNull
        public final List<String> component3() {
            return this.valueParameters;
        }

        @Nullable
        public final String component4() {
            return this.returnType;
        }

        @NotNull
        public final Signature copy(@NotNull String name, @Nullable String extensionReceiverType, @NotNull List<String> valueParameters2, @Nullable String returnType2) {
            Intrinsics.checkParameterIsNotNull(name, "name");
            Intrinsics.checkParameterIsNotNull(valueParameters2, "valueParameters");
            return new Signature(name, extensionReceiverType, valueParameters2, returnType2);
        }

        public static /* synthetic */ Signature copy$default(Signature signature, String string, String string2, List list2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = signature.name;
            }
            if ((n & 2) != 0) {
                string2 = signature.extensionReceiverType;
            }
            if ((n & 4) != 0) {
                list2 = signature.valueParameters;
            }
            if ((n & 8) != 0) {
                string3 = signature.returnType;
            }
            return signature.copy(string, string2, list2, string3);
        }

        @NotNull
        public String toString() {
            return "Signature(name=" + this.name + ", extensionReceiverType=" + this.extensionReceiverType + ", valueParameters=" + this.valueParameters + ", returnType=" + this.returnType + ")";
        }

        public int hashCode() {
            String string = this.name;
            String string2 = this.extensionReceiverType;
            List<String> list2 = this.valueParameters;
            String string3 = this.returnType;
            return (((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (list2 != null ? ((Object)list2).hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Signature)) break block3;
                    Signature signature = (Signature)object;
                    if (!Intrinsics.areEqual(this.name, signature.name) || !Intrinsics.areEqual(this.extensionReceiverType, signature.extensionReceiverType) || !Intrinsics.areEqual(this.valueParameters, signature.valueParameters) || !Intrinsics.areEqual(this.returnType, signature.returnType)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

