import { constant, constIdentity } from './function';
import { Reader } from './Reader';
import * as readerT from './ReaderT';
import * as taskEither from './TaskEither';
const readerTTaskEither = readerT.getReaderT2v(taskEither.taskEither);
export const URI = 'ReaderTaskEither';
/**
 * @since 1.6.0
 */
export class ReaderTaskEither {
    constructor(value) {
        this.value = value;
    }
    /** Runs the inner `TaskEither` */
    run(e) {
        return this.value(e).run();
    }
    map(f) {
        return new ReaderTaskEither(readerTTaskEither.map(this.value, f));
    }
    ap(fab) {
        return new ReaderTaskEither(readerTTaskEither.ap(fab.value, this.value));
    }
    /**
     * Flipped version of `ap`
     */
    ap_(fb) {
        return fb.ap(this);
    }
    /**
     * Combine two effectful actions, keeping only the result of the first
     */
    applyFirst(fb) {
        return fb.ap(this.map(constant));
    }
    /**
     * Combine two effectful actions, keeping only the result of the second
     */
    applySecond(fb) {
        return fb.ap(this.map(constIdentity));
    }
    chain(f) {
        return new ReaderTaskEither(readerTTaskEither.chain(this.value, a => f(a).value));
    }
    fold(left, right) {
        return new Reader(e => this.value(e).fold(left, right));
    }
    mapLeft(f) {
        return new ReaderTaskEither(e => this.value(e).mapLeft(f));
    }
    /**
     * Transforms the failure value of the `ReaderTaskEither` into a new `ReaderTaskEither`
     */
    orElse(f) {
        return new ReaderTaskEither(e => this.value(e).orElse(l => f(l).value(e)));
    }
    alt(fy) {
        return this.orElse(() => fy);
    }
    bimap(f, g) {
        return new ReaderTaskEither(e => this.value(e).bimap(f, g));
    }
    /**
     * @since 1.6.1
     */
    local(f) {
        return new ReaderTaskEither(e => this.value(f(e)));
    }
}
const map = (fa, f) => {
    return fa.map(f);
};
const of = (a) => {
    return new ReaderTaskEither(readerTTaskEither.of(a));
};
const ap = (fab, fa) => {
    return fa.ap(fab);
};
const chain = (fa, f) => {
    return fa.chain(f);
};
const alt = (fx, fy) => {
    return fx.alt(fy);
};
const bimap = (fa, f, g) => {
    return fa.bimap(f, g);
};
/**
 * @since 1.6.0
 */
export const ask = () => {
    return new ReaderTaskEither(e => taskEither.taskEither.of(e));
};
/**
 * @since 1.6.0
 */
export const asks = (f) => {
    return new ReaderTaskEither(e => taskEither.taskEither.of(f(e)));
};
/**
 * @since 1.6.0
 */
export const local = (f) => (fa) => {
    return fa.local(f);
};
/**
 * @since 1.6.0
 */
export const right = (fa) => {
    return new ReaderTaskEither(() => taskEither.right(fa));
};
/**
 * @since 1.6.0
 */
export const left = (fa) => {
    return new ReaderTaskEither(() => taskEither.left(fa));
};
/**
 * @since 1.6.0
 */
export const fromTaskEither = (fa) => {
    return new ReaderTaskEither(() => fa);
};
const readerTfromReader = readerT.fromReader(taskEither.taskEither);
/**
 * @since 1.6.0
 */
export const fromReader = (fa) => {
    return new ReaderTaskEither(readerTfromReader(fa));
};
/**
 * @since 1.6.0
 */
export const fromEither = (fa) => {
    return fromTaskEither(taskEither.fromEither(fa));
};
/**
 * @since 1.6.0
 */
export const fromIO = (fa) => {
    return fromTaskEither(taskEither.fromIO(fa));
};
/**
 * @since 1.6.0
 */
export const fromLeft = (l) => {
    return fromTaskEither(taskEither.fromLeft(l));
};
/**
 * @since 1.6.0
 */
export const fromIOEither = (fa) => {
    return fromTaskEither(taskEither.fromIOEither(fa));
};
export function fromPredicate(predicate, onFalse) {
    const f = taskEither.fromPredicate(predicate, onFalse);
    return a => fromTaskEither(f(a));
}
/**
 * @since 1.6.0
 */
export const tryCatch = (f, onrejected) => {
    return new ReaderTaskEither(e => taskEither.tryCatch(() => f(e), (reason) => onrejected(reason, e)));
};
const fromTask = right;
const throwError = fromLeft;
/**
 * @since 1.6.0
 */
export const readerTaskEither = {
    URI,
    map,
    of,
    ap,
    chain,
    alt,
    bimap,
    fromIO,
    fromTask,
    throwError,
    fromEither,
    fromOption: (o, e) => (o.isNone() ? throwError(e) : of(o.value))
};
/**
 * Like `readerTaskEither` but `ap` is sequential
 * @since 1.10.0
 */
export const readerTaskEitherSeq = Object.assign({}, readerTaskEither, { ap: (fab, fa) => fab.chain(f => fa.map(f)) });
