/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.instantiation;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.gradle.api.reflect.ObjectInstantiationException;
import org.gradle.internal.state.Managed;

public class ManagedTypeFactory
implements Managed.Factory {
    private final Constructor<?> constructor;

    public ManagedTypeFactory(Class<?> type) throws NoSuchMethodException {
        this.constructor = type.getConstructor(Object[].class);
    }

    @Override
    public <T> T fromState(Class<T> type, Object state) {
        if (!type.isAssignableFrom(this.constructor.getDeclaringClass())) {
            return null;
        }
        try {
            return type.cast(this.constructor.newInstance(state));
        }
        catch (InvocationTargetException e) {
            throw new ObjectInstantiationException(type, e.getCause());
        }
        catch (Exception e) {
            throw new ObjectInstantiationException(type, (Throwable)e);
        }
    }
}

