/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.impl;

import org.gradle.internal.file.FileType;
import org.gradle.internal.fingerprint.impl.AbstractFileSystemLocationFingerprint;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;

public class DefaultFileSystemLocationFingerprint
extends AbstractFileSystemLocationFingerprint {
    private final String normalizedPath;

    public DefaultFileSystemLocationFingerprint(String normalizedPath, FileType type, HashCode contentHash) {
        super(type, DefaultFileSystemLocationFingerprint.hashForType(type, contentHash));
        this.normalizedPath = normalizedPath;
    }

    public DefaultFileSystemLocationFingerprint(String normalizedPath, FileSystemLocationSnapshot snapshot) {
        this(normalizedPath, snapshot.getType(), snapshot.getHash());
    }

    private static HashCode hashForType(FileType fileType, HashCode hash) {
        switch (fileType) {
            case Directory: {
                return DIR_SIGNATURE;
            }
            case Missing: {
                return MISSING_FILE_SIGNATURE;
            }
            case RegularFile: {
                return hash;
            }
        }
        throw new IllegalStateException("Unknown file type: " + fileType);
    }

    @Override
    public String getNormalizedPath() {
        return this.normalizedPath;
    }
}

