/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.ListenerList;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

class FCLSupport {
    ListenerList<FileChangeListener> listeners;
    private static final RequestProcessor RP = new RequestProcessor("Async FileEvent dispatcher", 1, false, false);
    private static final Queue<DispatchEventWrapper> q = new ConcurrentLinkedQueue<DispatchEventWrapper>();
    private static final RequestProcessor.Task task = RP.create(new Runnable(){

        @Override
        public void run() {
            DispatchEventWrapper dw = (DispatchEventWrapper)q.poll();
            HashSet<Runnable> post = new HashSet<Runnable>();
            while (dw != null) {
                dw.dispatchEvent(false, post);
                dw = (DispatchEventWrapper)q.poll();
            }
            for (Runnable r : post) {
                r.run();
            }
        }
    });

    FCLSupport() {
    }

    final synchronized void addFileChangeListener(FileChangeListener fcl) {
        if (this.listeners == null) {
            this.listeners = new ListenerList();
        }
        this.listeners.add(fcl);
    }

    final synchronized void removeFileChangeListener(FileChangeListener fcl) {
        if (this.listeners != null) {
            this.listeners.remove(fcl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void dispatchEvent(FileEvent fe, Op operation, Collection<Runnable> postNotify) {
        List<FileChangeListener> fcls;
        FCLSupport fCLSupport = this;
        synchronized (fCLSupport) {
            if (this.listeners == null) {
                return;
            }
            fcls = this.listeners.getAllListeners();
        }
        for (FileChangeListener l : fcls) {
            FCLSupport.dispatchEvent(l, fe, operation, postNotify);
        }
    }

    static void dispatchEvent(FileChangeListener fcl, FileEvent fe, Op operation, Collection<Runnable> postNotify) {
        boolean async = fe.isAsynchronous();
        DispatchEventWrapperSingle dw = new DispatchEventWrapperSingle(fcl, fe, operation);
        dw.dispatchEvent(async, postNotify);
    }

    static void dispatchEvent(Collection<FileChangeListener> listeners, FileEvent fe, Op operation, Collection<Runnable> postNotify) {
        boolean async = fe.isAsynchronous();
        DispatchEventWrapperMulti dw = new DispatchEventWrapperMulti(listeners, fe, operation);
        dw.dispatchEvent(async, postNotify);
    }

    final synchronized boolean hasListeners() {
        return this.listeners != null && this.listeners.hasListeners();
    }

    private static abstract class DispatchEventWrapper {
        final FileEvent fe;
        final Op operation;

        DispatchEventWrapper(FileEvent fe, Op operation) {
            this.fe = fe;
            this.operation = operation;
        }

        void dispatchEvent(boolean async, Collection<Runnable> postNotify) {
            if (async) {
                q.offer(this);
                task.schedule(300);
            } else {
                this.dispatchAllEventsSync(postNotify);
            }
        }

        protected abstract void dispatchAllEventsSync(Collection<Runnable> var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected final void dispatchEventImpl(FileChangeListener fcl, FileEvent fe, Op operation, Collection<Runnable> postNotify) {
            Thread thread;
            String origThreadName;
            block26: {
                String threadName;
                boolean asserts = false;
                if (!$assertionsDisabled) {
                    asserts = true;
                    if (!true) {
                        throw new AssertionError();
                    }
                }
                origThreadName = null;
                thread = null;
                if (asserts && (threadName = (thread = Thread.currentThread()).getName()) != null && !threadName.contains(" :: ")) {
                    try {
                        origThreadName = threadName;
                        thread.setName(threadName + " :: " + (Object)((Object)operation) + " " + fe.getFile().getPath());
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                }
                if (postNotify != null) {
                    fe.setPostNotify(postNotify);
                }
                switch (operation) {
                    case DATA_CREATED: {
                        fcl.fileDataCreated(fe);
                        break;
                    }
                    case FOLDER_CREATED: {
                        fcl.fileFolderCreated(fe);
                        break;
                    }
                    case FILE_CHANGED: {
                        fcl.fileChanged(fe);
                        break;
                    }
                    case FILE_DELETED: {
                        fcl.fileDeleted(fe);
                        break;
                    }
                    case FILE_RENAMED: {
                        fcl.fileRenamed((FileRenameEvent)fe);
                        break;
                    }
                    case ATTR_CHANGED: {
                        fcl.fileAttributeChanged((FileAttributeEvent)fe);
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)operation);
                    }
                }
                if (postNotify == null) break block26;
                fe.setPostNotify(null);
            }
            if (thread == null || origThreadName == null) return;
            try {
                thread.setName(origThreadName);
                return;
            }
            catch (SecurityException threadName) {}
            return;
            catch (RuntimeException x) {
                try {
                    Exceptions.printStackTrace((Throwable)x);
                    if (postNotify != null) {
                        fe.setPostNotify(null);
                    }
                    if (thread == null || origThreadName == null) return;
                }
                catch (Throwable throwable) {
                    if (postNotify != null) {
                        fe.setPostNotify(null);
                    }
                    if (thread == null || origThreadName == null) throw throwable;
                    try {
                        thread.setName(origThreadName);
                        throw throwable;
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    thread.setName(origThreadName);
                    return;
                }
                catch (SecurityException securityException) {}
                return;
            }
        }
    }

    private static class DispatchEventWrapperMulti
    extends DispatchEventWrapper {
        private final Collection<FileChangeListener> listeners;

        public DispatchEventWrapperMulti(Collection<FileChangeListener> listeners, FileEvent fe, Op operation) {
            super(fe, operation);
            this.listeners = listeners;
        }

        @Override
        protected void dispatchAllEventsSync(Collection<Runnable> postNotify) {
            for (FileChangeListener fcl : this.listeners) {
                this.dispatchEventImpl(fcl, this.fe, this.operation, postNotify);
            }
        }
    }

    private static class DispatchEventWrapperSingle
    extends DispatchEventWrapper {
        private final FileChangeListener fcl;

        public DispatchEventWrapperSingle(FileChangeListener fcl, FileEvent fe, Op operation) {
            super(fe, operation);
            this.fcl = fcl;
        }

        @Override
        protected void dispatchAllEventsSync(Collection<Runnable> postNotify) {
            this.dispatchEventImpl(this.fcl, this.fe, this.operation, postNotify);
        }
    }

    static enum Op {
        DATA_CREATED,
        FOLDER_CREATED,
        FILE_CHANGED,
        FILE_DELETED,
        FILE_RENAMED,
        ATTR_CHANGED;

    }
}

