define(["appHeader","playbackManager","dom","inputmanager","datetime","itemHelper","mediaInfo","focusManager","imageLoader","scrollHelper","events","connectionManager","browser","globalize","apphost","layoutManager","userSettings","scrollStyles","emby-slider","paper-icon-button-light","css!./videoosd"],function(appHeader,playbackManager,dom,inputManager,datetime,itemHelper,mediaInfo,focusManager,imageLoader,scrollHelper,events,connectionManager,browser,globalize,appHost,layoutManager,userSettings){"use strict";function seriesImageUrl(item,options){return"Episode"!==item.Type?null:((options=options||{}).type=options.type||"Primary","Primary"===options.type&&item.SeriesPrimaryImageTag?(options.tag=item.SeriesPrimaryImageTag,connectionManager.getApiClient(item.ServerId).getScaledImageUrl(item.SeriesId,options)):"Thumb"===options.type&&item.ParentThumbImageTag?(options.tag=item.ParentThumbImageTag,connectionManager.getApiClient(item.ServerId).getScaledImageUrl(item.ParentThumbItemId,options)):null)}function imageUrl(item,options){return(options=options||{}).type=options.type||"Primary",item.ImageTags&&item.ImageTags[options.type]?(options.tag=item.ImageTags[options.type],connectionManager.getApiClient(item.ServerId).getScaledImageUrl(item.PrimaryImageItemId||item.Id,options)):"Primary"===options.type&&item.AlbumId&&item.AlbumPrimaryImageTag?(options.tag=item.AlbumPrimaryImageTag,connectionManager.getApiClient(item.ServerId).getScaledImageUrl(item.AlbumId,options)):null}return function(view,params){var currentPlayer,comingUpNextDisplayed,currentUpNextDialog,isEnabled,currentItem,currentItemThumbnails,currentItemThumbnailsPromise,recordingButtonManager,enableProgressByTimeOfDay,enableStopOnBack,enableBackOnStop,supportsBrightnessChange,currentVisibleMenu,statsOverlay,osdHideTimeout,lastPointerMoveData,self=this,currentPlayerSupportedCommands=[],currentRuntimeTicks=0,lastUpdateTime=0,programStartDateMs=0,programEndDateMs=0,playbackStartTimeTicks=0,nowPlayingVolumeSlider=view.querySelector(".osdVolumeSlider"),nowPlayingVolumeSliderContainer=view.querySelector(".osdVolumeSliderContainer"),nowPlayingPositionSlider=view.querySelector(".osdPositionSlider"),nowPlayingPositionText=view.querySelector(".osdPositionText"),nowPlayingDurationText=view.querySelector(".osdDurationText"),startTimeText=view.querySelector(".startTimeText"),endTimeText=view.querySelector(".endTimeText"),endsAtText=view.querySelector(".endsAtText"),btnRewind=view.querySelector(".btnRewind"),btnFastForward=view.querySelector(".btnFastForward"),transitionEndEventName=dom.whichTransitionEvent(),headerElement=document.querySelector(".skinHeader"),osdBottomElement=document.querySelector(".videoOsdBottom-maincontrols");function onVerticalSwipe(e,elem,data){var player=currentPlayer;if(player){var deltaY=data.currentDeltaY,windowSize=dom.getWindowSize();if(supportsBrightnessChange&&data.clientX<windowSize.innerWidth/2)return void function(deltaY,player,viewHeight){var delta=-deltaY/viewHeight*100,newValue=playbackManager.getBrightness(player)+delta;newValue=Math.min(newValue,100),newValue=Math.max(newValue,0),playbackManager.setBrightness(newValue,player)}(deltaY,player,windowSize.innerHeight);!function(deltaY,player,viewHeight){var delta=-deltaY/viewHeight*100,newValue=playbackManager.getVolume(player)+delta;newValue=Math.min(newValue,100),newValue=Math.max(newValue,0),playbackManager.setVolume(newValue,player)}(deltaY,player,windowSize.innerHeight)}}function updateRecordingButton(item){if(!item||"Program"!==item.Type)return recordingButtonManager&&(recordingButtonManager.destroy(),recordingButtonManager=null),void view.querySelector(".btnRecord").classList.add("hide");connectionManager.getApiClient(item.ServerId).getCurrentUser().then(function(user){user.Policy.EnableLiveTvManagement&&require(["recordingButton"],function(RecordingButton){recordingButtonManager?recordingButtonManager.refreshItem(item):(recordingButtonManager=new RecordingButton({item:item,button:view.querySelector(".btnRecord")}),view.querySelector(".btnRecord").classList.remove("hide"))})})}function updateDisplayItem(itemInfo){var item=itemInfo.originalItem;currentItem=item,currentItemThumbnails=currentItemThumbnailsPromise=null;var displayItem=itemInfo.displayItem||item;updateRecordingButton(displayItem),setPoster(displayItem,item);var titleElement,parentName=displayItem.SeriesName||displayItem.Album;(displayItem.EpisodeTitle||displayItem.IsSeries)&&(parentName=displayItem.Name),function(item,parentName){var url=function(item,apiClient,options){return(options=options||{}).type="Logo",item.ImageTags&&item.ImageTags.Logo?(options.tag=item.ImageTags.Logo,apiClient.getScaledImageUrl(item.Id,options)):item.ParentLogoImageTag?(options.tag=item.ParentLogoImageTag,apiClient.getScaledImageUrl(item.ParentLogoItemId,options)):null}(item,connectionManager.getApiClient(item.ServerId),{});if(url){appHeader.setTitle("");var pageTitle=document.querySelector(".pageTitle");pageTitle.style.backgroundImage="url('"+url+"')",pageTitle.classList.add("pageTitleWithLogo"),pageTitle.classList.remove("pageTitleWithDefaultLogo"),pageTitle.innerHTML=""}else appHeader.setTitle(parentName||"");var documentTitle=parentName||(item?item.Name:null);documentTitle&&(document.title=documentTitle)}(displayItem,parentName),titleElement=view.querySelector(".osdTitle");var displayName=itemHelper.getDisplayName(displayItem,{includeParentInfo:"Program"!==displayItem.Type,includeIndexNumber:"Program"!==displayItem.Type});displayName||displayItem.Type,(titleElement.innerHTML=displayName)?titleElement.classList.remove("hide"):titleElement.classList.add("hide");var mediaInfoHtml=mediaInfo.getPrimaryMediaInfoHtml(displayItem,{runtime:!1,subtitles:!1,tomatoes:!1,endsAt:!1,episodeTitle:!1,originalAirDate:"Program"!==displayItem.Type,episodeTitleIndexNumber:"Program"!==displayItem.Type,programIndicator:!1}),osdMediaInfo=view.querySelector(".osdMediaInfo");(osdMediaInfo.innerHTML=mediaInfoHtml)?osdMediaInfo.classList.remove("hide"):osdMediaInfo.classList.add("hide");var secondaryMediaInfo=view.querySelector(".osdSecondaryMediaInfo"),secondaryMediaInfoHtml=mediaInfo.getSecondaryMediaInfoHtml(displayItem,{startDate:!1,programTime:!1});(secondaryMediaInfo.innerHTML=secondaryMediaInfoHtml)?secondaryMediaInfo.classList.remove("hide"):secondaryMediaInfo.classList.add("hide"),displayName?view.querySelector(".osdMainTextContainer").classList.remove("hide"):view.querySelector(".osdMainTextContainer").classList.add("hide"),programEndDateMs=enableProgressByTimeOfDay?(setDisplayTime(startTimeText,displayItem.StartDate),setDisplayTime(endTimeText,displayItem.EndDate),startTimeText.classList.remove("hide"),endTimeText.classList.remove("hide"),programStartDateMs=displayItem.StartDate?datetime.parseISO8601Date(displayItem.StartDate).getTime():0,displayItem.EndDate?datetime.parseISO8601Date(displayItem.EndDate).getTime():0):(startTimeText.classList.add("hide"),endTimeText.classList.add("hide"),startTimeText.innerHTML="",endTimeText.innerHTML="",programStartDateMs=0)}function getDisplayTimeWithoutAmPm(date,showSeconds){return showSeconds?datetime.toLocaleTimeString(date,{hour:"numeric",minute:"2-digit",second:"2-digit"}).toLowerCase().replace("am","").replace("pm","").trim():datetime.getDisplayTime(date).toLowerCase().replace("am","").replace("pm","").trim()}function setDisplayTime(elem,date){var html;date&&(html=getDisplayTimeWithoutAmPm(date=datetime.parseISO8601Date(date))),elem.innerHTML=html||""}function updateNowPlayingInfo(player,state){var item=state.NowPlayingItem;if(currentItemThumbnails=currentItemThumbnailsPromise=null,!(currentItem=item))return setPoster(null),updateRecordingButton(null),appHeader.setTitle(""),nowPlayingVolumeSlider.disabled=!0,nowPlayingPositionSlider.disabled=!0,btnFastForward.disabled=!0,btnRewind.disabled=!0,view.querySelector(".btnSubtitles").classList.add("hide"),view.querySelector(".btnAudio").classList.add("hide"),view.querySelector(".osdTitle").innerHTML="",void(view.querySelector(".osdMediaInfo").innerHTML="");enableProgressByTimeOfDay=function(item){return!("TvChannel"!==item.Type||!item.CurrentProgram)}(item),function(item){if("TvChannel"!==item.Type)return Promise.resolve({originalItem:item});var apiClient=connectionManager.getApiClient(item.ServerId);return apiClient.getItem(apiClient.getCurrentUserId(),item.Id).then(function(refreshedItem){return{originalItem:refreshedItem,displayItem:refreshedItem.CurrentProgram}})}(item).then(updateDisplayItem),nowPlayingVolumeSlider.disabled=!1,nowPlayingPositionSlider.disabled=!1,btnFastForward.disabled=!1,btnRewind.disabled=!1,playbackManager.subtitleTracks(player).length?view.querySelector(".btnSubtitles").classList.remove("hide"):view.querySelector(".btnSubtitles").classList.add("hide"),1<playbackManager.audioTracks(player).length?view.querySelector(".btnAudio").classList.remove("hide"):view.querySelector(".btnAudio").classList.add("hide")}function setPoster(item,secondaryItem){var osdPoster=view.querySelector(".osdPoster");if(item){var imgUrl=seriesImageUrl(item,{type:"Primary"})||seriesImageUrl(item,{type:"Thumb"})||imageUrl(item,{type:"Primary"});if(!imgUrl&&secondaryItem&&(imgUrl=seriesImageUrl(secondaryItem,{type:"Primary"})||seriesImageUrl(secondaryItem,{type:"Thumb"})||imageUrl(secondaryItem,{type:"Primary"})),imgUrl)return void(osdPoster.innerHTML='<img src="'+imgUrl+'" />')}osdPoster.innerHTML=""}function showOsd(){!function(elem){elem.classList.remove("osdHeader-hidden")}(headerElement),function(){if(currentVisibleMenu)return;view.dispatchEvent(new CustomEvent("video-osd-show",{bubbles:!0}));var elem=osdBottomElement;currentVisibleMenu="osd",clearHideAnimationEventListeners(elem),elem.classList.remove("hide"),elem.offsetWidth,elem.classList.remove("videoOsdBottom-hidden"),layoutManager.mobile||setTimeout(function(){focusManager.focus(elem.querySelector(".btnPause"))},50)}(),stopOsdHideTimer(),osdHideTimeout=setTimeout(hideOsd,5e3)}function hideOsd(){!function(elem){elem.classList.add("osdHeader-hidden")}(headerElement),function(){if("osd"!==currentVisibleMenu)return;var elem=osdBottomElement;clearHideAnimationEventListeners(elem),elem.offsetWidth,elem.classList.add("videoOsdBottom-hidden"),dom.addEventListener(elem,transitionEndEventName,onHideAnimationComplete,{once:!0}),currentVisibleMenu=null,view.dispatchEvent(new CustomEvent("video-osd-hide",{bubbles:!0}))}()}function stopOsdHideTimer(){osdHideTimeout&&(clearTimeout(osdHideTimeout),osdHideTimeout=null)}function clearHideAnimationEventListeners(elem){dom.removeEventListener(elem,transitionEndEventName,onHideAnimationComplete,{once:!0})}function onHideAnimationComplete(e){var elem=e.currentTarget;elem.classList.add("hide"),dom.removeEventListener(elem,transitionEndEventName,onHideAnimationComplete,{once:!0})}function onPointerMove(e){if("mouse"===(e.pointerType||(layoutManager.mobile?"touch":"mouse"))){var eventX=e.screenX||0,eventY=e.screenY||0,obj=lastPointerMoveData;if(!obj)return void(lastPointerMoveData={x:eventX,y:eventY});if(Math.abs(eventX-obj.x)<10&&Math.abs(eventY-obj.y)<10)return;obj.x=eventX,obj.y=eventY,showOsd()}}function onInputCommand(e){switch(e.detail.command){case"left":"osd"===currentVisibleMenu?showOsd():currentVisibleMenu||(e.preventDefault(),playbackManager.rewind(currentPlayer));break;case"right":"osd"===currentVisibleMenu?showOsd():currentVisibleMenu||(e.preventDefault(),playbackManager.fastForward(currentPlayer));break;case"pageup":playbackManager.nextChapter(currentPlayer);break;case"pagedown":playbackManager.previousChapter(currentPlayer);break;case"up":case"down":case"select":case"menu":case"info":case"play":case"playpause":case"pause":case"fastforward":case"rewind":case"next":case"previous":showOsd();break;case"record":!function(){var btnRecord=view.querySelector(".btnRecord");btnRecord.classList.contains("hide")||btnRecord.click()}(),showOsd();break;case"togglestats":toggleStats();break;case"movies":case"music":case"tv":case"settings":case"nowplaying":case"search":case"favorites":case"livetv":case"recordedtv":case"guide":e.preventDefault()}}function updateFullscreenIcon(){playbackManager.isFullscreen(currentPlayer)?(view.querySelector(".btnFullscreen").setAttribute("title",globalize.translate("ExitFullscreen")),view.querySelector(".btnFullscreen i").innerHTML="&#xE5D1;"):(view.querySelector(".btnFullscreen").setAttribute("title",globalize.translate("Fullscreen")),view.querySelector(".btnFullscreen i").innerHTML="&#xE5D0;")}function onPlayerChange(){bindToPlayer(playbackManager.getCurrentPlayer())}function onStateChanged(event,state){state.NowPlayingItem&&(isEnabled=!0,function(event,player,state){var playState=state.PlayState||{};updatePlayPauseState(playState.IsPaused);var supportedCommands=playbackManager.getSupportedCommands(player);supportsBrightnessChange=-1!==(currentPlayerSupportedCommands=supportedCommands).indexOf("SetBrightness"),updatePlayerVolumeState(player,playState.IsMuted,playState.VolumeLevel),nowPlayingPositionSlider&&!nowPlayingPositionSlider.dragging&&(nowPlayingPositionSlider.disabled=!playState.CanSeek);btnFastForward.disabled=!playState.CanSeek,btnRewind.disabled=!playState.CanSeek;var nowPlayingItem=state.NowPlayingItem||{};playbackStartTimeTicks=playState.PlaybackStartTimeTicks,updateTimeDisplay(playState.PositionTicks,nowPlayingItem.RunTimeTicks,playState.PlaybackStartTimeTicks,playState.BufferedRanges||[]),updateNowPlayingInfo(player,state),state.MediaSource?view.querySelector(".btnVideoOsdSettings").classList.remove("hide"):view.querySelector(".btnVideoOsdSettings").classList.add("hide");var isProgressClear=state.MediaSource&&null==state.MediaSource.RunTimeTicks;nowPlayingPositionSlider.setIsClear(isProgressClear),-1===supportedCommands.indexOf("ToggleFullscreen")||player.isLocalPlayer&&layoutManager.tv&&playbackManager.isFullscreen(player)?view.querySelector(".btnFullscreen").classList.add("hide"):view.querySelector(".btnFullscreen").classList.remove("hide");-1===supportedCommands.indexOf("PictureInPicture")?view.querySelector(".btnPip").classList.add("hide"):view.querySelector(".btnPip").classList.remove("hide");updateFullscreenIcon()}(0,this,state),function(){var btnPreviousTrack=view.querySelector(".btnPreviousTrack"),btnNextTrack=view.querySelector(".btnNextTrack");btnPreviousTrack.classList.remove("hide"),btnNextTrack.classList.remove("hide"),btnNextTrack.disabled=!1,btnPreviousTrack.disabled=!1}(),enableBackOnStop=enableStopOnBack=!0)}function onPlayPauseStateChanged(e){if(isEnabled){updatePlayPauseState(this.paused())}}function onVolumeChanged(e){if(isEnabled){updatePlayerVolumeState(this,this.isMuted(),this.getVolume())}}function onPlaybackStart(e,state){console.log("nowplaying event: "+e.type);onStateChanged.call(this,e,state),setTimeout(resetUpNextDialog,300)}function resetUpNextDialog(){comingUpNextDisplayed=!1;currentUpNextDialog&&(currentUpNextDialog.destroy(),currentUpNextDialog=null)}function onPlaybackStopped(e,state){currentRuntimeTicks=null,resetUpNextDialog(),console.log("nowplaying event: "+e.type),"Video"!==state.NextMediaType&&(enableStopOnBack=!1,enableBackOnStop&&(enableBackOnStop=!1,Emby.Page.back()))}function onMediaStreamsChanged(e){var state=playbackManager.getPlayerState(this);onStateChanged.call(this,{type:"init"},state)}function bindToPlayer(player){if(player!==currentPlayer&&(releaseCurrentPlayer(),currentPlayer=player)){var state=playbackManager.getPlayerState(player);onStateChanged.call(player,{type:"init"},state),events.on(player,"playbackstart",onPlaybackStart),events.on(player,"playbackstop",onPlaybackStopped),events.on(player,"volumechange",onVolumeChanged),events.on(player,"pause",onPlayPauseStateChanged),events.on(player,"unpause",onPlayPauseStateChanged),events.on(player,"timeupdate",onTimeUpdate),events.on(player,"fullscreenchange",updateFullscreenIcon),events.on(player,"mediastreamschange",onMediaStreamsChanged),resetUpNextDialog()}}function releaseCurrentPlayer(){destroyStats(),resetUpNextDialog();var player=currentPlayer;player&&(events.off(player,"playbackstart",onPlaybackStart),events.off(player,"playbackstop",onPlaybackStopped),events.off(player,"volumechange",onVolumeChanged),events.off(player,"pause",onPlayPauseStateChanged),events.off(player,"unpause",onPlayPauseStateChanged),events.off(player,"timeupdate",onTimeUpdate),events.off(player,"fullscreenchange",updateFullscreenIcon),events.off(player,"mediastreamschange",onMediaStreamsChanged),currentPlayer=null)}function onTimeUpdate(e){if(isEnabled){var now=(new Date).getTime();if(!(now-lastUpdateTime<700)){lastUpdateTime=now;currentRuntimeTicks=playbackManager.duration(this);var currentTime=playbackManager.currentTime(this);updateTimeDisplay(currentTime,currentRuntimeTicks,playbackManager.playbackStartTime(this),playbackManager.getBufferedRanges(this));var item=currentItem;!function(player,item){if("TvChannel"!==item.Type)return;var program=item.CurrentProgram;if(!program||!program.EndDate)return;try{var endDate=datetime.parseISO8601Date(program.EndDate);if((new Date).getTime()>=endDate.getTime()){console.log("program info needs to be refreshed");var state=playbackManager.getPlayerState(player);onStateChanged.call(player,{type:"init"},state)}}catch(e){console.log("Error parsing date: "+program.EndDate)}}(this,item),function(player,currentItem,currentTimeTicks,runtimeTicks){if(runtimeTicks&&currentTimeTicks&&!comingUpNextDisplayed&&!currentVisibleMenu&&"Episode"===currentItem.Type&&userSettings.enableNextVideoInfoOverlay()){var timeRemainingTicks=runtimeTicks-currentTimeTicks;runtimeTicks-1e3*(3e10<=runtimeTicks?40:24e9<=runtimeTicks?35:30)*1e4<=currentTimeTicks&&6e9<=runtimeTicks&&2e8<=timeRemainingTicks&&function(player){require(["upNextDialog"],function(UpNextDialog){currentVisibleMenu||currentUpNextDialog||(currentVisibleMenu="upnext",comingUpNextDisplayed=!0,playbackManager.nextItem(player).then(function(nextItem){currentUpNextDialog=new UpNextDialog({parent:view.querySelector(".upNextContainer"),player:player,nextItem:nextItem}),events.on(currentUpNextDialog,"hide",onUpNextHidden)},onUpNextHidden))})}(player)}}(this,item,currentTime,currentRuntimeTicks)}}}function onUpNextHidden(){"upnext"===currentVisibleMenu&&(currentVisibleMenu=null)}function updatePlayPauseState(isPaused){view.querySelector(".btnPause i").innerHTML=isPaused?"&#xE037;":"&#xE034;"}function getDisplayPercentByTimeOfDay(programStartDateMs,programRuntimeMs,currentTimeMs){return(currentTimeMs-programStartDateMs)/programRuntimeMs*100}function updateTimeDisplay(positionTicks,runtimeTicks,playbackStartTimeTicks,bufferedRanges){if(enableProgressByTimeOfDay){if(nowPlayingPositionSlider&&!nowPlayingPositionSlider.dragging)if(programStartDateMs&&programEndDateMs){var currentTimeMs=(playbackStartTimeTicks+(positionTicks||0))/1e4,programRuntimeMs=programEndDateMs-programStartDateMs;if(nowPlayingPositionSlider.value=getDisplayPercentByTimeOfDay(programStartDateMs,programRuntimeMs,currentTimeMs),bufferedRanges.length){var rangeStart=getDisplayPercentByTimeOfDay(programStartDateMs,programRuntimeMs,(playbackStartTimeTicks+(bufferedRanges[0].start||0))/1e4),rangeEnd=getDisplayPercentByTimeOfDay(programStartDateMs,programRuntimeMs,(playbackStartTimeTicks+(bufferedRanges[0].end||0))/1e4);nowPlayingPositionSlider.setBufferedRanges([{start:rangeStart,end:rangeEnd}])}else nowPlayingPositionSlider.setBufferedRanges([])}else nowPlayingPositionSlider.value=0,nowPlayingPositionSlider.setBufferedRanges([]);nowPlayingPositionText.innerHTML="",nowPlayingDurationText.innerHTML=""}else{if(nowPlayingPositionSlider&&!nowPlayingPositionSlider.dragging){if(runtimeTicks){var pct=positionTicks/runtimeTicks;pct*=100,nowPlayingPositionSlider.value=pct}else nowPlayingPositionSlider.value=0;runtimeTicks&&null!=positionTicks&&currentRuntimeTicks&&!enableProgressByTimeOfDay&&currentItem.RunTimeTicks&&"Recording"!==currentItem.Type?endsAtText.innerHTML="&nbsp;&nbsp;-&nbsp;&nbsp;"+mediaInfo.getEndsAtFromPosition(runtimeTicks,positionTicks,!0):endsAtText.innerHTML=""}nowPlayingPositionSlider&&nowPlayingPositionSlider.setBufferedRanges(bufferedRanges,runtimeTicks,positionTicks),updateTimeText(nowPlayingPositionText,positionTicks),updateTimeText(nowPlayingDurationText,runtimeTicks,!0)}}function updatePlayerVolumeState(player,isMuted,volumeLevel){var supportedCommands=currentPlayerSupportedCommands,showMuteButton=!0,showVolumeSlider=!0;-1===supportedCommands.indexOf("Mute")&&(showMuteButton=!1),-1===supportedCommands.indexOf("SetVolume")&&(showVolumeSlider=!1),player.isLocalPlayer&&appHost.supports("physicalvolumecontrol")&&(showVolumeSlider=showMuteButton=!1),isMuted?(view.querySelector(".buttonMute").setAttribute("title",globalize.translate("Unmute")),view.querySelector(".buttonMute i").innerHTML="&#xE04F;"):(view.querySelector(".buttonMute").setAttribute("title",globalize.translate("Mute")),view.querySelector(".buttonMute i").innerHTML="&#xE050;"),showMuteButton?view.querySelector(".buttonMute").classList.remove("hide"):view.querySelector(".buttonMute").classList.add("hide"),nowPlayingVolumeSlider&&(showVolumeSlider?nowPlayingVolumeSliderContainer.classList.remove("hide"):nowPlayingVolumeSliderContainer.classList.add("hide"),nowPlayingVolumeSlider.dragging||(nowPlayingVolumeSlider.value=volumeLevel||0))}function updateTimeText(elem,ticks,divider){if(null!=ticks){var html=datetime.getDisplayRunningTime(ticks);divider&&(html="&nbsp;/&nbsp;"+html),elem.innerHTML=html}else elem.innerHTML=""}function onSettingsOption(selectedOption){"stats"===selectedOption&&toggleStats()}function toggleStats(){require(["playerStats"],function(PlayerStats){var player=currentPlayer;player&&(statsOverlay?statsOverlay.toggle():statsOverlay=new PlayerStats({player:player}))})}function destroyStats(){statsOverlay&&(statsOverlay.destroy(),statsOverlay=null)}function onWindowKeyDown(e){if(!currentVisibleMenu&&(32===e.keyCode||13===e.keyCode))return playbackManager.playPause(currentPlayer),void showOsd();switch(e.key){case"f":e.ctrlKey||playbackManager.toggleFullscreen(currentPlayer);break;case"m":playbackManager.toggleMute(currentPlayer);break;case"ArrowLeft":case"Left":case"NavigationLeft":case"GamepadDPadLeft":case"GamepadLeftThumbstickLeft":e.shiftKey&&playbackManager.rewind(currentPlayer);break;case"ArrowRight":case"Right":case"NavigationRight":case"GamepadDPadRight":case"GamepadLeftThumbstickRight":e.shiftKey&&playbackManager.fastForward(currentPlayer)}}view.addEventListener("viewbeforeshow",function(e){headerElement.classList.add("osdHeader"),Emby.Page.setTransparency("full")}),view.addEventListener("viewshow",function(e){events.on(playbackManager,"playerchange",onPlayerChange),bindToPlayer(playbackManager.getCurrentPlayer()),dom.addEventListener(document,window.PointerEvent?"pointermove":"mousemove",onPointerMove,{passive:!0}),document.body.classList.add("autoScrollY"),showOsd(),inputManager.on(window,onInputCommand),dom.addEventListener(window,"keydown",onWindowKeyDown,{passive:!0})}),view.addEventListener("viewbeforehide",function(){if(statsOverlay&&statsOverlay.enabled(!1),dom.removeEventListener(window,"keydown",onWindowKeyDown,{passive:!0}),stopOsdHideTimer(),headerElement.classList.remove("osdHeader"),headerElement.classList.remove("osdHeader-hidden"),dom.removeEventListener(document,window.PointerEvent?"pointermove":"mousemove",onPointerMove,{passive:!0}),document.body.classList.remove("autoScrollY"),inputManager.off(window,onInputCommand),events.off(playbackManager,"playerchange",onPlayerChange),enableStopOnBack){enableBackOnStop=enableStopOnBack=!1;var player=currentPlayer;player&&playbackManager.isPlayingVideo(player)&&playbackManager.stop(player)}releaseCurrentPlayer()}),view.querySelector(".btnFullscreen").addEventListener("click",function(){playbackManager.toggleFullscreen(currentPlayer)}),view.querySelector(".btnPip").addEventListener("click",function(){playbackManager.togglePictureInPicture(currentPlayer)}),view.querySelector(".btnVideoOsdSettings").addEventListener("click",function(e){var btn=this;require(["playerSettingsMenu"],function(playerSettingsMenu){var player=currentPlayer;player&&playerSettingsMenu.show({mediaType:"Video",player:player,positionTo:btn,stats:!0,onOption:onSettingsOption})})}),view.addEventListener("viewhide",function(){headerElement.classList.remove("hide")}),view.addEventListener("viewdestroy",function(){self.touchHelper&&(self.touchHelper.destroy(),self.touchHelper=null),recordingButtonManager&&(recordingButtonManager.destroy(),recordingButtonManager=null),destroyStats()});var lastPointerDown=0;function refreshThumbnailsIfNeeded(itemId,mediaSourceId,apiClient,maxThumbnailWidth){currentItemThumbnails||currentItemThumbnailsPromise||function(itemId,mediaSourceId,apiClient,maxThumbnailWidth){if(currentItemThumbnailsPromise)return;var promise=apiClient.getThumbnails(itemId,{MediaSourceId:mediaSourceId,Width:maxThumbnailWidth}).then(function(result){return currentItemThumbnails=result,Promise.resolve(result)},function(){currentItemThumbnailsPromise=null});currentItemThumbnailsPromise=promise}(itemId,mediaSourceId,apiClient,maxThumbnailWidth)}dom.addEventListener(view,window.PointerEvent?"pointerdown":"click",function(e){if(dom.parentWithClass(e.target,["videoOsdBottom","upNextContainer"]))showOsd();else{var pointerType=e.pointerType||(layoutManager.mobile?"touch":"mouse"),now=(new Date).getTime();switch(pointerType){case"touch":300<now-lastPointerDown&&(lastPointerDown=now,"osd"===currentVisibleMenu?hideOsd():currentVisibleMenu||showOsd());break;case"mouse":e.button||(playbackManager.playPause(currentPlayer),showOsd());break;default:playbackManager.playPause(currentPlayer),showOsd()}}},{passive:!0}),browser.touch&&dom.addEventListener(view,"dblclick",function(e){var clientX=e.clientX;null!=clientX&&(clientX<dom.getWindowSize().innerWidth/2?playbackManager.rewind(currentPlayer):playbackManager.fastForward(currentPlayer),e.preventDefault(),e.stopPropagation())},{}),view.querySelector(".buttonMute").addEventListener("click",function(){playbackManager.toggleMute(currentPlayer)}),nowPlayingVolumeSlider.addEventListener("change",function(){playbackManager.setVolume(this.value,currentPlayer)}),nowPlayingPositionSlider.addEventListener("change",function(){var player=currentPlayer;if(player){var newPercent=parseFloat(this.value);if(enableProgressByTimeOfDay){var seekAirTimeTicks=newPercent/100*(programEndDateMs-programStartDateMs)*1e4;seekAirTimeTicks+=1e4*programStartDateMs,seekAirTimeTicks-=playbackStartTimeTicks,playbackManager.seek(seekAirTimeTicks,player)}else playbackManager.seekPercent(newPercent,player)}}),nowPlayingPositionSlider.getBubbleHtml=function(value){if(showOsd(),enableProgressByTimeOfDay){if(programStartDateMs&&programEndDateMs){var ms=programEndDateMs-programStartDateMs;return ms/=100,ms*=value,ms+=programStartDateMs,'<h1 class="sliderBubbleText">'+getDisplayTimeWithoutAmPm(new Date(parseInt(ms)),!0)+"</h1>"}return"--:--"}if(!currentRuntimeTicks)return"--:--";var ticks=currentRuntimeTicks;ticks/=100,ticks*=value;var item=currentItem;if(item){var apiClient=connectionManager.getApiClient(item.ServerId);refreshThumbnailsIfNeeded(item.Id,"",apiClient,400);var thumbnails=currentItemThumbnails;if(thumbnails){var html=function(apiClient,itemId,mediaSourceId,thumbnailSet,chapters,positionTicks,maxThumbnailWidth){var thumbnail,i,length,chapter,thumbnails=thumbnailSet.Thumbnails;for(i=0,length=thumbnails.length;i<length;i++){var currentThumbnail=thumbnails[i];if(positionTicks>=currentThumbnail.PositionTicks)thumbnail=currentThumbnail;else if(thumbnail)break}if(!thumbnail)return null;for(i=0,length=chapters.length;i<length;i++){var currentChapter=chapters[i];if(positionTicks>=currentChapter.StartPositionTicks)chapter=currentChapter;else if(chapter)break}chapter=chapter||{Name:"&nbsp;"};var src=function(itemId,thumbnail,maxWidth,apiClient){return thumbnail.ImageTag?apiClient.getScaledImageUrl(itemId,{maxWidth:maxWidth,tag:thumbnail.ImageTag,type:"Thumbnail",PositionTicks:thumbnail.PositionTicks}):null}(itemId,thumbnail,maxThumbnailWidth,apiClient);if(src){var html='<div class="chapterThumbContainer">',className="chapterThumbImageContainer";return thumbnailSet.AspectRatio&&thumbnailSet.AspectRatio<1.4&&(className+=" chapterThumbImageContainer-fourthree"),html+='<div class="'+className+'" style="background-image:url(\''+src+"');\">",html+="</div>",html+='<div class="chapterThumbTextContainer">',html+='<div class="chapterThumbTextContainerInner">',html+='<div class="chapterThumbText">',html+=datetime.getDisplayRunningTime(positionTicks),html+="</div>",html+="</div>",html+="</div>",html+="</div>"}return null}(apiClient,item.Id,0,thumbnails,item.Chapters||{},ticks,400);if(html)return html}}return'<h1 class="sliderBubbleText">'+datetime.getDisplayRunningTime(ticks)+"</h1>"},view.querySelector(".btnPreviousTrack").addEventListener("click",function(){playbackManager.previousTrack(currentPlayer)}),view.querySelector(".btnPause").addEventListener("click",function(){playbackManager.playPause(currentPlayer)}),view.querySelector(".btnNextTrack").addEventListener("click",function(){playbackManager.nextTrack(currentPlayer)}),btnRewind.addEventListener("click",function(){playbackManager.rewind(currentPlayer)}),btnFastForward.addEventListener("click",function(){playbackManager.fastForward(currentPlayer)}),view.querySelector(".btnAudio").addEventListener("click",function(){var player=currentPlayer,audioTracks=playbackManager.audioTracks(player),currentIndex=playbackManager.getAudioStreamIndex(player),menuItems=audioTracks.map(function(stream){var opt={name:stream.DisplayTitle,id:stream.Index};return stream.Index===currentIndex&&(opt.selected=!0),opt}),positionTo=this;require(["actionsheet"],function(actionsheet){actionsheet.show({items:menuItems,title:globalize.translate("Audio"),positionTo:positionTo}).then(function(id){var index=parseInt(id);index!==currentIndex&&playbackManager.setAudioStreamIndex(index,player)})})}),view.querySelector(".btnSubtitles").addEventListener("click",function(){var player=currentPlayer,streams=playbackManager.subtitleTracks(player),currentIndex=playbackManager.getSubtitleStreamIndex(player);null==currentIndex&&(currentIndex=-1),streams.unshift({Index:-1,DisplayTitle:globalize.translate("Off")});var menuItems=streams.map(function(stream){var opt={name:stream.DisplayTitle,id:stream.Index};return stream.Index===currentIndex&&(opt.selected=!0),opt}),positionTo=this;require(["actionsheet"],function(actionsheet){actionsheet.show({title:globalize.translate("Subtitles"),items:menuItems,positionTo:positionTo}).then(function(id){var index=parseInt(id);index!==currentIndex&&playbackManager.setSubtitleStreamIndex(index,player)})})}),browser.touch&&require(["touchHelper"],function(TouchHelper){self.touchHelper=new TouchHelper(view,{swipeYThreshold:30,triggerOnMove:!0,preventDefaultOnMove:!0,ignoreTagNames:["BUTTON","INPUT","TEXTAREA"]}),events.on(self.touchHelper,"swipeup",onVerticalSwipe),events.on(self.touchHelper,"swipedown",onVerticalSwipe)})}});