/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.pipeline;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.xcontent.ParseFieldRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.AbstractPipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.BucketHelpers;
import org.elasticsearch.search.aggregations.pipeline.MovAvgModel;
import org.elasticsearch.search.aggregations.pipeline.MovAvgModelBuilder;
import org.elasticsearch.search.aggregations.pipeline.MovAvgPipelineAggregator;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.pipeline.SimpleModel;

public class MovAvgPipelineAggregationBuilder
extends AbstractPipelineAggregationBuilder<MovAvgPipelineAggregationBuilder> {
    public static final String NAME = "moving_avg";
    static final ParseField MODEL = new ParseField("model", new String[0]);
    private static final ParseField WINDOW = new ParseField("window", new String[0]);
    public static final ParseField SETTINGS = new ParseField("settings", new String[0]);
    private static final ParseField PREDICT = new ParseField("predict", new String[0]);
    private static final ParseField MINIMIZE = new ParseField("minimize", new String[0]);
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(LogManager.getLogger(MovAvgPipelineAggregationBuilder.class));
    private String format;
    private BucketHelpers.GapPolicy gapPolicy = BucketHelpers.GapPolicy.SKIP;
    private int window = 5;
    private MovAvgModel model = new SimpleModel();
    private int predict = 0;
    private Boolean minimize;

    public MovAvgPipelineAggregationBuilder(String name, String bucketsPath) {
        super(name, NAME, new String[]{bucketsPath});
    }

    public MovAvgPipelineAggregationBuilder(StreamInput in) throws IOException {
        super(in, NAME);
        this.format = in.readOptionalString();
        this.gapPolicy = BucketHelpers.GapPolicy.readFrom(in);
        this.window = in.readVInt();
        this.model = in.readNamedWriteable(MovAvgModel.class);
        this.predict = in.readVInt();
        this.minimize = in.readOptionalBoolean();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.format);
        this.gapPolicy.writeTo(out);
        out.writeVInt(this.window);
        out.writeNamedWriteable(this.model);
        out.writeVInt(this.predict);
        out.writeOptionalBoolean(this.minimize);
    }

    public MovAvgPipelineAggregationBuilder format(String format) {
        if (format == null) {
            throw new IllegalArgumentException("[format] must not be null: [" + this.name + "]");
        }
        this.format = format;
        return this;
    }

    public String format() {
        return this.format;
    }

    public MovAvgPipelineAggregationBuilder gapPolicy(BucketHelpers.GapPolicy gapPolicy) {
        if (gapPolicy == null) {
            throw new IllegalArgumentException("[gapPolicy] must not be null: [" + this.name + "]");
        }
        this.gapPolicy = gapPolicy;
        return this;
    }

    public BucketHelpers.GapPolicy gapPolicy() {
        return this.gapPolicy;
    }

    protected DocValueFormat formatter() {
        if (this.format != null) {
            return new DocValueFormat.Decimal(this.format);
        }
        return DocValueFormat.RAW;
    }

    public MovAvgPipelineAggregationBuilder window(int window) {
        if (window <= 0) {
            throw new IllegalArgumentException("[window] must be a positive integer: [" + this.name + "]");
        }
        if (this.model != null) {
            this.model.validate(window, this.name);
        }
        this.window = window;
        return this;
    }

    public int window() {
        return this.window;
    }

    public MovAvgPipelineAggregationBuilder modelBuilder(MovAvgModelBuilder model) {
        if (model == null) {
            throw new IllegalArgumentException("[model] must not be null: [" + this.name + "]");
        }
        this.model = model.build();
        return this;
    }

    public MovAvgPipelineAggregationBuilder model(MovAvgModel model) {
        if (model == null) {
            throw new IllegalArgumentException("[model] must not be null: [" + this.name + "]");
        }
        this.model = model;
        return this;
    }

    public MovAvgModel model() {
        return this.model;
    }

    public MovAvgPipelineAggregationBuilder predict(int predict) {
        if (predict <= 0) {
            throw new IllegalArgumentException("predict must be greater than 0. Found [" + predict + "] in [" + this.name + "]");
        }
        this.predict = predict;
        return this;
    }

    public int predict() {
        return this.predict;
    }

    public MovAvgPipelineAggregationBuilder minimize(boolean minimize) {
        this.minimize = minimize;
        return this;
    }

    public Boolean minimize() {
        return this.minimize;
    }

    @Override
    protected PipelineAggregator createInternal(Map<String, Object> metaData) {
        boolean minimize = this.minimize == null ? this.model.minimizeByDefault() : this.minimize.booleanValue();
        return new MovAvgPipelineAggregator(this.name, this.bucketsPaths, this.formatter(), this.gapPolicy, this.window, this.predict, this.model, minimize, metaData);
    }

    @Override
    public void doValidate(AggregatorFactory<?> parent, Collection<AggregationBuilder> aggFactories, Collection<PipelineAggregationBuilder> pipelineAggregatoractories) {
        if (this.minimize != null && this.minimize.booleanValue() && !this.model.canBeMinimized()) {
            throw new IllegalStateException("The [" + this.model + "] model cannot be minimized for aggregation [" + this.name + "]");
        }
        if (this.bucketsPaths.length != 1) {
            throw new IllegalStateException(PipelineAggregator.Parser.BUCKETS_PATH.getPreferredName() + " must contain a single entry for aggregation [" + this.name + "]");
        }
        this.model.validate(this.window, this.name);
        MovAvgPipelineAggregationBuilder.validateSequentiallyOrderedParentAggs(parent, NAME, this.name);
    }

    @Override
    protected XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.format != null) {
            builder.field(PipelineAggregator.Parser.FORMAT.getPreferredName(), this.format);
        }
        builder.field(PipelineAggregator.Parser.GAP_POLICY.getPreferredName(), this.gapPolicy.getName());
        this.model.toXContent(builder, params);
        builder.field(WINDOW.getPreferredName(), this.window);
        if (this.predict > 0) {
            builder.field(PREDICT.getPreferredName(), this.predict);
        }
        if (this.minimize != null) {
            builder.field(MINIMIZE.getPreferredName(), this.minimize);
        }
        return builder;
    }

    public static MovAvgPipelineAggregationBuilder parse(ParseFieldRegistry<MovAvgModel.AbstractModelParser> movingAverageMdelParserRegistry, String pipelineAggregatorName, XContentParser parser) throws IOException {
        XContentParser.Token token;
        String currentFieldName = null;
        String[] bucketsPaths = null;
        String format = null;
        BucketHelpers.GapPolicy gapPolicy = null;
        Integer window = null;
        Map settings = null;
        String model = null;
        Integer predict = null;
        Boolean minimize = null;
        DEPRECATION_LOGGER.deprecated("The moving_avg aggregation has been deprecated in favor of the moving_fn aggregation.", new Object[0]);
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.VALUE_NUMBER) {
                if (WINDOW.match(currentFieldName, parser.getDeprecationHandler())) {
                    window = parser.intValue();
                    if (window > 0) continue;
                    throw new ParsingException(parser.getTokenLocation(), "[" + currentFieldName + "] value must be a positive, non-zero integer.  Value supplied was [" + predict + "] in [" + pipelineAggregatorName + "].", new Object[0]);
                }
                if (PREDICT.match(currentFieldName, parser.getDeprecationHandler())) {
                    predict = parser.intValue();
                    if (predict > 0) continue;
                    throw new ParsingException(parser.getTokenLocation(), "[" + currentFieldName + "] value must be a positive integer.  Value supplied was [" + predict + "] in [" + pipelineAggregatorName + "].", new Object[0]);
                }
                throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + token + " in [" + pipelineAggregatorName + "]: [" + currentFieldName + "].", new Object[0]);
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                if (PipelineAggregator.Parser.FORMAT.match(currentFieldName, parser.getDeprecationHandler())) {
                    format = parser.text();
                    continue;
                }
                if (PipelineAggregator.Parser.BUCKETS_PATH.match(currentFieldName, parser.getDeprecationHandler())) {
                    bucketsPaths = new String[]{parser.text()};
                    continue;
                }
                if (PipelineAggregator.Parser.GAP_POLICY.match(currentFieldName, parser.getDeprecationHandler())) {
                    gapPolicy = BucketHelpers.GapPolicy.parse(parser.text(), parser.getTokenLocation());
                    continue;
                }
                if (MODEL.match(currentFieldName, parser.getDeprecationHandler())) {
                    model = parser.text();
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + token + " in [" + pipelineAggregatorName + "]: [" + currentFieldName + "].", new Object[0]);
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (PipelineAggregator.Parser.BUCKETS_PATH.match(currentFieldName, parser.getDeprecationHandler())) {
                    ArrayList<String> paths = new ArrayList<String>();
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        String path = parser.text();
                        paths.add(path);
                    }
                    bucketsPaths = paths.toArray(new String[paths.size()]);
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + token + " in [" + pipelineAggregatorName + "]: [" + currentFieldName + "].", new Object[0]);
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (SETTINGS.match(currentFieldName, parser.getDeprecationHandler())) {
                    settings = parser.map();
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + token + " in [" + pipelineAggregatorName + "]: [" + currentFieldName + "].", new Object[0]);
            }
            if (token == XContentParser.Token.VALUE_BOOLEAN) {
                if (MINIMIZE.match(currentFieldName, parser.getDeprecationHandler())) {
                    minimize = parser.booleanValue();
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + token + " in [" + pipelineAggregatorName + "]: [" + currentFieldName + "].", new Object[0]);
            }
            throw new ParsingException(parser.getTokenLocation(), "Unexpected token " + token + " in [" + pipelineAggregatorName + "].", new Object[0]);
        }
        if (bucketsPaths == null) {
            throw new ParsingException(parser.getTokenLocation(), "Missing required field [" + PipelineAggregator.Parser.BUCKETS_PATH.getPreferredName() + "] for movingAvg aggregation [" + pipelineAggregatorName + "]", new Object[0]);
        }
        MovAvgPipelineAggregationBuilder factory = new MovAvgPipelineAggregationBuilder(pipelineAggregatorName, (String)bucketsPaths[0]);
        if (format != null) {
            factory.format(format);
        }
        if (gapPolicy != null) {
            factory.gapPolicy(gapPolicy);
        }
        if (window != null) {
            factory.window(window);
        }
        if (predict != null) {
            factory.predict(predict);
        }
        if (model != null) {
            MovAvgModel movAvgModel;
            MovAvgModel.AbstractModelParser modelParser = movingAverageMdelParserRegistry.lookup(model, parser.getTokenLocation(), parser.getDeprecationHandler());
            try {
                movAvgModel = modelParser.parse(settings, pipelineAggregatorName, factory.window());
            }
            catch (ParseException exception) {
                throw new ParsingException(parser.getTokenLocation(), "Could not parse settings for model [" + model + "].", exception, new Object[0]);
            }
            factory.model(movAvgModel);
        }
        if (minimize != null) {
            factory.minimize(minimize);
        }
        return factory;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.format, this.gapPolicy, this.window, this.model, this.predict, this.minimize});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        MovAvgPipelineAggregationBuilder other = (MovAvgPipelineAggregationBuilder)obj;
        return Objects.equals(this.format, other.format) && Objects.equals((Object)this.gapPolicy, (Object)other.gapPolicy) && Objects.equals(this.window, other.window) && Objects.equals(this.model, other.model) && Objects.equals(this.predict, other.predict) && Objects.equals(this.minimize, other.minimize);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }
}

