/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.gitflow.op;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.egit.gitflow.GitFlowRepository;
import org.eclipse.egit.gitflow.WrongGitFlowStateException;
import org.eclipse.egit.gitflow.internal.CoreText;
import org.eclipse.egit.gitflow.op.GitFlowOperation;

public abstract class AbstractFeatureOperation
extends GitFlowOperation {
    protected String featureName;

    public AbstractFeatureOperation(GitFlowRepository repository, String featureName) {
        super(repository);
        this.featureName = featureName;
    }

    protected static String getFeatureName(GitFlowRepository repository) throws WrongGitFlowStateException, CoreException, IOException {
        String currentBranch = repository.getRepository().getBranch();
        if (currentBranch == null || !repository.isFeature()) {
            throw new WrongGitFlowStateException(CoreText.AbstractFeatureOperation_notOnAFeatureBranch);
        }
        return currentBranch.substring(repository.getConfig().getFeaturePrefix().length());
    }
}

