/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.wizards;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptModel;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.dltk.internal.core.ExternalScriptFolder;
import org.eclipse.dltk.internal.corext.util.Messages;
import org.eclipse.dltk.internal.ui.StandardModelElementContentProvider;
import org.eclipse.dltk.internal.ui.wizards.NewWizardMessages;
import org.eclipse.dltk.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.ModelElementLabelProvider;
import org.eclipse.dltk.ui.ModelElementSorter;
import org.eclipse.dltk.ui.dialogs.StatusInfo;
import org.eclipse.dltk.ui.viewsupport.IViewPartInputProvider;
import org.eclipse.dltk.ui.wizards.NewElementWizardPage;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.views.contentoutline.ContentOutline;

public abstract class NewContainerWizardPage
extends NewElementWizardPage {
    protected static final String CONTAINER = "NewContainerWizardPage.container";
    protected IStatus containerStatus;
    private StringButtonDialogField containerDialogField;
    private IScriptFolder currRoot;
    private IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();

    public NewContainerWizardPage(String name) {
        super(name);
        ContainerFieldAdapter adapter = new ContainerFieldAdapter();
        this.containerDialogField = new StringButtonDialogField(adapter);
        this.containerDialogField.setDialogFieldListener(adapter);
        this.containerDialogField.setLabelText(this.getContainerLabel());
        this.containerDialogField.setButtonLabel(NewWizardMessages.NewContainerWizardPage_container_button);
        this.containerStatus = new StatusInfo();
        this.currRoot = null;
    }

    protected String getContainerLabel() {
        return NewWizardMessages.NewContainerWizardPage_container_label;
    }

    protected void initContainerPage(IModelElement elem) {
        IScriptFolder initRoot = null;
        if (elem != null) {
            initRoot = (IScriptFolder)elem.getAncestor(4);
            if (initRoot instanceof ExternalScriptFolder) {
                initRoot = null;
            }
            try {
                if (initRoot == null) {
                    IScriptProject project;
                    IProjectFragment fragment = ScriptModelUtil.getProjectFragment((IModelElement)elem);
                    if (fragment != null && fragment.getKind() == 1 && !fragment.isExternal()) {
                        initRoot = fragment.getScriptFolder("");
                    }
                    if (initRoot == null && (project = elem.getScriptProject()) != null) {
                        initRoot = null;
                        if (project.exists()) {
                            IProjectFragment[] roots = project.getProjectFragments();
                            int i = 0;
                            while (i < roots.length) {
                                if (roots[i].getKind() == 1) {
                                    initRoot = roots[i].getScriptFolder("");
                                    break;
                                }
                                ++i;
                            }
                        }
                        if (initRoot == null) {
                            initRoot = project.getProjectFragment(project.getResource()).getScriptFolder("");
                        }
                    }
                }
            }
            catch (ModelException e) {
                DLTKUIPlugin.log(e);
            }
        }
        this.setScriptFolder(initRoot, true);
        this.handleFieldChanged(CONTAINER);
    }

    protected IModelElement getInitialScriptElement(IStructuredSelection selection) {
        Object selectedElement;
        IModelElement scriptElement = null;
        if (selection != null && !selection.isEmpty() && (selectedElement = selection.getFirstElement()) instanceof IAdaptable) {
            IResource resource;
            IAdaptable adaptable = (IAdaptable)selectedElement;
            scriptElement = (IModelElement)adaptable.getAdapter(IModelElement.class);
            if (scriptElement != null && scriptElement.isReadOnly()) {
                scriptElement = scriptElement.getScriptProject();
            }
            if (scriptElement == null && (resource = (IResource)adaptable.getAdapter(IResource.class)) != null && resource.getType() != 8) {
                while (scriptElement == null && resource.getType() != 4) {
                    resource = resource.getParent();
                    scriptElement = (IModelElement)resource.getAdapter(IModelElement.class);
                }
                if (scriptElement == null) {
                    scriptElement = DLTKCore.create((IResource)resource);
                }
            }
        }
        if (scriptElement == null) {
            Object provider;
            IWorkbenchPart part = DLTKUIPlugin.getActivePage().getActivePart();
            if (part instanceof ContentOutline) {
                part = DLTKUIPlugin.getActivePage().getActiveEditor();
            }
            if (part instanceof IViewPartInputProvider && (provider = ((IViewPartInputProvider)part).getViewPartInput()) instanceof IModelElement) {
                scriptElement = (IModelElement)provider;
            }
        }
        if (scriptElement == null || scriptElement.getElementType() == 1) {
            try {
                IScriptProject[] projects = DLTKCore.create((IWorkspaceRoot)this.getWorkspaceRoot()).getScriptProjects();
                if (projects.length == 1) {
                    scriptElement = projects[0];
                }
            }
            catch (ModelException e) {
                DLTKUIPlugin.log(e);
            }
        }
        return scriptElement;
    }

    protected int getMaxFieldWidth() {
        return this.convertWidthInCharsToPixels(40);
    }

    protected void createContainerControls(Composite parent, int nColumns) {
        this.containerDialogField.doFillIntoGrid(parent, nColumns);
        LayoutUtil.setWidthHint((Control)this.containerDialogField.getTextControl(null), this.getMaxFieldWidth());
    }

    protected void setFocusOnContainer() {
        this.containerDialogField.setFocus();
    }

    void containerChangeControlPressed(DialogField field) {
        IScriptFolder root = this.chooseContainer();
        if (root != null) {
            this.setScriptFolder(root, true);
        }
    }

    private void containerDialogFieldChanged(DialogField field) {
        if (field == this.containerDialogField) {
            this.containerStatus = this.containerChanged();
        }
        this.handleFieldChanged(CONTAINER);
    }

    protected abstract String getRequiredNature();

    protected IStatus containerChanged() {
        StatusInfo status = new StatusInfo();
        this.currRoot = null;
        String str = this.getScriptFolderText();
        if (str.length() == 0) {
            status.setError(NewWizardMessages.NewContainerWizardPage_error_EnterContainerName);
            return status;
        }
        Path path = new Path(str);
        IResource res = this.workspaceRoot.findMember((IPath)path);
        if (res != null) {
            int resType = res.getType();
            if (resType == 4 || resType == 2) {
                IProject proj = res.getProject();
                if (!proj.isOpen()) {
                    status.setError(Messages.format(NewWizardMessages.NewContainerWizardPage_error_ProjectClosed, proj.getFullPath().toString()));
                    return status;
                }
                IScriptProject jproject = DLTKCore.create((IProject)proj);
                if (resType == 4) {
                    this.currRoot = jproject.getProjectFragment(res).getScriptFolder("");
                } else {
                    IProjectFragment[] fragments;
                    block18: {
                        fragments = null;
                        try {
                            fragments = jproject.getProjectFragments();
                        }
                        catch (ModelException e) {
                            if (!DLTKCore.DEBUG) break block18;
                            e.printStackTrace();
                        }
                    }
                    if (fragments != null) {
                        IProjectFragment projectFragment = null;
                        IProjectFragment[] iProjectFragmentArray = fragments;
                        int n = fragments.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IProjectFragment fragment = iProjectFragmentArray[n2];
                            if (fragment.getPath().isPrefixOf((IPath)path)) {
                                projectFragment = fragment;
                                break;
                            }
                            ++n2;
                        }
                        if (projectFragment != null) {
                            IPath fragmentPath = projectFragment.getPath();
                            this.currRoot = projectFragment.getScriptFolder(path.removeFirstSegments(fragmentPath.segmentCount()));
                        }
                    }
                }
                if (res.exists()) {
                    try {
                        String nature = this.getRequiredNature();
                        if (nature != null && !proj.hasNature(nature)) {
                            if (resType == 4) {
                                status.setError(NewWizardMessages.NewContainerWizardPage_warning_NotAScriptProject);
                            } else {
                                status.setWarning(NewWizardMessages.NewContainerWizardPage_warning_NotInAScriptProject);
                            }
                            return status;
                        }
                    }
                    catch (CoreException e) {
                        status.setWarning(NewWizardMessages.NewContainerWizardPage_warning_NotAScriptProject);
                    }
                }
                return status;
            }
            status.setError(Messages.format(NewWizardMessages.NewContainerWizardPage_error_NotAFolder, str));
            return status;
        }
        status.setError(Messages.format(NewWizardMessages.NewContainerWizardPage_error_ContainerDoesNotExist, str));
        return status;
    }

    protected void handleFieldChanged(String fieldName) {
    }

    protected IWorkspaceRoot getWorkspaceRoot() {
        return this.workspaceRoot;
    }

    public IProjectFragment getProjectFragment() {
        if (this.currRoot == null) {
            return null;
        }
        IProjectFragment fragment = (IProjectFragment)this.currRoot.getAncestor(3);
        if (fragment != null) {
            return fragment;
        }
        IScriptProject project = this.currRoot.getScriptProject();
        try {
            if (project.exists()) {
                IProjectFragment[] roots = project.getProjectFragments();
                int i = 0;
                while (i < roots.length) {
                    if (roots[i].getKind() == 1) {
                        return roots[i];
                    }
                    ++i;
                }
            }
        }
        catch (ModelException modelException) {
            // empty catch block
        }
        return null;
    }

    public IScriptFolder getScriptFolder() {
        return this.currRoot;
    }

    public String getScriptFolderText() {
        return this.containerDialogField.getText();
    }

    public void setScriptFolder(IScriptFolder root, boolean canBeModified) {
        this.currRoot = root;
        String str = root == null ? "" : root.getPath().makeRelative().toString();
        this.containerDialogField.setText(str);
        this.containerDialogField.setEnabled(canBeModified);
    }

    protected IScriptFolder chooseContainer() {
        IProjectFragment initElement = this.getProjectFragment();
        ContainerViewerFilter filter = new ContainerViewerFilter();
        return this.doChooseContainer((IModelElement)initElement, filter, null);
    }

    protected IScriptFolder doChooseContainer(IModelElement initElement, ViewerFilter filter, ISelectionStatusValidator validator) {
        StandardModelElementContentProvider provider = new StandardModelElementContentProvider();
        ModelElementLabelProvider labelProvider = new ModelElementLabelProvider(ModelElementLabelProvider.SHOW_DEFAULT);
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)provider);
        dialog.setComparator((ViewerComparator)new ModelElementSorter());
        dialog.setTitle(NewWizardMessages.NewContainerWizardPage_ChooseSourceContainerDialog_title);
        dialog.setMessage(NewWizardMessages.NewContainerWizardPage_ChooseSourceContainerDialog_description);
        dialog.addFilter(filter);
        if (validator != null) {
            dialog.setValidator(validator);
        }
        dialog.setInput((Object)DLTKCore.create((IWorkspaceRoot)this.workspaceRoot));
        dialog.setInitialSelection((Object)initElement);
        dialog.setHelpAvailable(false);
        if (dialog.open() == 0) {
            Object element = dialog.getFirstResult();
            if (element instanceof IScriptProject) {
                IScriptProject jproject = (IScriptProject)element;
                return jproject.getProjectFragment(jproject.getResource()).getScriptFolder("");
            }
            if (element instanceof IScriptFolder) {
                return (IScriptFolder)element;
            }
            if (element instanceof IProjectFragment) {
                return ((IProjectFragment)element).getScriptFolder("");
            }
            return null;
        }
        return null;
    }

    private class ContainerFieldAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        private ContainerFieldAdapter() {
        }

        @Override
        public void changeControlPressed(DialogField field) {
            NewContainerWizardPage.this.containerChangeControlPressed(field);
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            NewContainerWizardPage.this.containerDialogFieldChanged(field);
        }
    }

    protected static class ContainerViewerFilter
    extends TypedViewerFilter {
        public ContainerViewerFilter() {
            this(new Class[]{IScriptModel.class, IScriptFolder.class, IScriptProject.class, IProjectFragment.class});
        }

        public ContainerViewerFilter(Class<?>[] acceptedTypes) {
            super(acceptedTypes);
        }

        @Override
        public boolean select(Viewer viewer, Object parent, Object element) {
            if (element instanceof IProjectFragment) {
                try {
                    IProjectFragment fragment = (IProjectFragment)element;
                    return fragment.getKind() == 1 && !fragment.isExternal();
                }
                catch (ModelException e) {
                    return false;
                }
            }
            return super.select(viewer, parent, element);
        }
    }
}

