/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.util.gradle;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import org.eclipse.buildship.core.internal.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.internal.workspace.CompositeModelQuery;
import org.eclipse.buildship.core.internal.workspace.DefaultModelProvider;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.ProjectConnection;

public class IdeFriendlyClassLoading {
    private static URLClassLoader classLoader;

    private IdeFriendlyClassLoading() {
    }

    public static <T> BuildAction<Collection<T>> loadCompositeModelQuery(Class<T> model) {
        try {
            if (Platform.inDevelopmentMode()) {
                Class<?> actionClass = IdeFriendlyClassLoading.loadClassWithIdeFriendlyClassLoader(CompositeModelQuery.class.getName());
                return (BuildAction)actionClass.getConstructor(Class.class).newInstance(model);
            }
            return new CompositeModelQuery<T>(model);
        }
        catch (Exception e) {
            throw new GradlePluginsRuntimeException(e);
        }
    }

    public static <T> T loadClass(Class<T> cls) {
        try {
            if (Platform.inDevelopmentMode()) {
                return (T)IdeFriendlyClassLoading.loadClassWithIdeFriendlyClassLoader(cls.getName()).newInstance();
            }
            return cls.newInstance();
        }
        catch (Exception e) {
            throw new GradlePluginsRuntimeException(e);
        }
    }

    public static void cleanup() {
        if (classLoader != null) {
            try {
                classLoader.close();
            }
            catch (IOException e) {
                throw new GradlePluginsRuntimeException(e);
            }
            classLoader = null;
        }
    }

    private static final Class<?> loadClassWithIdeFriendlyClassLoader(String classname) throws Exception {
        ClassLoader coreClassloader = DefaultModelProvider.class.getClassLoader();
        ClassLoader tapiClassloader = ProjectConnection.class.getClassLoader();
        URL actionRootUrl = FileLocator.resolve((URL)coreClassloader.getResource(""));
        if (classLoader == null) {
            classLoader = new URLClassLoader(new URL[]{actionRootUrl}, tapiClassloader);
        }
        return classLoader.loadClass(classname);
    }
}

