/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl;

import java.util.ArrayList;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Output;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.mime.MIMEContent;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.WSITag;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionFailException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionNotApplicableException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;

public class AP2903
extends AssertionProcess
implements WSITag {
    private final WSDLValidatorImpl validator;

    public AP2903(WSDLValidatorImpl impl) {
        super(impl);
        this.validator = impl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            boolean mimeContentsFound = false;
            Binding binding = (Binding)entryContext.getEntry().getEntryDetail();
            List ops = binding.getBindingOperations();
            int i = 0;
            while (i < ops.size()) {
                String part;
                BindingOperation bindingOperation = (BindingOperation)ops.get(i);
                BindingInput bindingInput = bindingOperation.getBindingInput();
                BindingOutput bindingOutput = bindingOperation.getBindingOutput();
                List inputMimeContents = this.getMimeContentElements(bindingInput == null ? null : bindingInput.getExtensibilityElements());
                List outputMimeContents = this.getMimeContentElements(bindingOutput == null ? null : bindingOutput.getExtensibilityElements());
                if (!inputMimeContents.isEmpty()) {
                    mimeContentsFound = true;
                    Input portTypeInput = bindingOperation.getOperation().getInput();
                    if (portTypeInput == null) {
                        throw new AssertionFailException("There is no the corresponging wsdl:input in the wsdl:portType operation for the wsdl:input of the \"" + bindingOperation.getName() + "\" binding operation.");
                    }
                    if (portTypeInput.getMessage() == null) {
                        throw new AssertionFailException("The wsdl:input of the \"" + bindingOperation.getOperation().getName() + "\" wsdl:portType " + "operation does not reference any wsdl:message.");
                    }
                    part = this.getInvalidMimeContentPart(inputMimeContents, portTypeInput.getMessage());
                    if (part != null) {
                        throw new AssertionFailException("part=\"" + part + "\", the input of the binding operation \"" + bindingOperation.getName() + "\"");
                    }
                }
                if (!outputMimeContents.isEmpty()) {
                    mimeContentsFound = true;
                    Output portTypeOutput = bindingOperation.getOperation().getOutput();
                    if (portTypeOutput == null) {
                        throw new AssertionFailException("There is no the corresponging wsdl:output in the wsdl:portType operation for the wsdl:output of the \"" + bindingOperation.getName() + "\" binding operation.");
                    }
                    if (portTypeOutput.getMessage() == null) {
                        throw new AssertionFailException("The wsdl:output of the \"" + bindingOperation.getOperation().getName() + "\" wsdl:portType " + "operation does not reference any wsdl:message.");
                    }
                    part = this.getInvalidMimeContentPart(outputMimeContents, portTypeOutput.getMessage());
                    if (part != null) {
                        throw new AssertionFailException("part=\"" + part + "\", the output of the binding operation \"" + bindingOperation.getName() + "\"");
                    }
                }
                ++i;
            }
            if (!mimeContentsFound) {
                throw new AssertionNotApplicableException();
            }
        }
        catch (AssertionNotApplicableException assertionNotApplicableException) {
            this.result = "notApplicable";
        }
        catch (AssertionFailException afe) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(afe.getMessage(), entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private List getMimeContentElements(List extElems) {
        ArrayList<ExtensibilityElement> mimeContentElements = new ArrayList<ExtensibilityElement>();
        if (extElems != null) {
            int i = 0;
            while (i < extElems.size()) {
                ExtensibilityElement extElem = (ExtensibilityElement)extElems.get(i);
                if (extElem.getElementType().equals(WSDL_MIME_MULTIPART)) {
                    List mimeParts = ((MIMEMultipartRelated)extElem).getMIMEParts();
                    int j = 0;
                    while (j < mimeParts.size()) {
                        List elems = this.getMimeContentElements(((MIMEPart)mimeParts.get(j)).getExtensibilityElements());
                        mimeContentElements.addAll(elems);
                        ++j;
                    }
                } else if (extElem.getElementType().equals(WSDL_MIME_CONTENT)) {
                    mimeContentElements.add(extElem);
                }
                ++i;
            }
        }
        return mimeContentElements;
    }

    private String getInvalidMimeContentPart(List mimeContents, Message message) {
        int i = 0;
        while (i < mimeContents.size()) {
            String part = ((MIMEContent)mimeContents.get(i)).getPart();
            if (!message.getParts().keySet().contains(part)) {
                return part;
            }
            ++i;
        }
        return null;
    }
}

