/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.contentmodel.internal.modelqueryimpl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.xml.core.internal.Logger;
import org.eclipse.wst.xml.core.internal.contentmodel.internal.modelqueryimpl.ModelQueryExtensionDescriptor;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.extension.ModelQueryExtension;

public class ModelQueryExtensionRegistry {
    protected static final String EXTENSION_POINT_ID = "modelQueryExtensions";
    protected static final String TAG_NAME = "modelQueryExtension";
    private List descriptors;

    public List getApplicableExtensions(String contentTypeId, String namespace) {
        ArrayList<ModelQueryExtension> list = new ArrayList<ModelQueryExtension>();
        if (contentTypeId != null) {
            this.ensureExtensionsLoaded();
            block2: for (ModelQueryExtensionDescriptor descriptor : this.descriptors) {
                String[] contentTypeIds = StringUtils.unpack((String)descriptor.getContentTypeId());
                int j = 0;
                while (j < contentTypeIds.length) {
                    if (contentTypeId.equals(contentTypeIds[j])) {
                        if (descriptor.getNamespace() != null && !descriptor.getNamespace().equals(namespace)) continue block2;
                        try {
                            ModelQueryExtension extension = descriptor.createModelQueryExtension();
                            list.add(extension);
                        }
                        catch (CoreException e) {
                            Logger.logException("problem creating model query extension", e);
                        }
                        continue block2;
                    }
                    ++j;
                }
            }
        }
        return list;
    }

    private synchronized void reloadExtensions() {
        this.descriptors = new ArrayList();
        String bundleid = "org.eclipse.wst.xml.core";
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(bundleid, EXTENSION_POINT_ID);
        int i = 0;
        while (i < elements.length) {
            ModelQueryExtensionDescriptor descriptor = new ModelQueryExtensionDescriptor(elements[i]);
            this.descriptors.add(descriptor);
            ++i;
        }
    }

    private void ensureExtensionsLoaded() {
        if (this.descriptors == null) {
            this.reloadExtensions();
        }
    }
}

