/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.http.core.internal;

import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.model.LaunchableAdapterDelegate;
import org.eclipse.wst.server.core.util.HttpLaunchable;
import org.eclipse.wst.server.core.util.WebResource;
import org.eclipse.wst.server.http.core.internal.HttpServer;
import org.eclipse.wst.server.http.core.internal.Trace;

public class HttpLaunchableAdapterDelegate
extends LaunchableAdapterDelegate {
    public Object getLaunchable(IServer server, IModuleArtifact moduleArtifact) throws CoreException {
        if (server == null || moduleArtifact == null) {
            return null;
        }
        HttpServer server2 = (HttpServer)((Object)server.loadAdapter(HttpServer.class, null));
        if (server2 == null) {
            return null;
        }
        try {
            URL url = server2.getModuleRootURL(moduleArtifact.getModule());
            if (moduleArtifact instanceof WebResource) {
                WebResource resource = (WebResource)moduleArtifact;
                String path = resource.getPath().toString();
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                url = new URL(String.valueOf(url.toExternalForm()) + "/" + path);
            }
            return new HttpLaunchable(url);
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error in launchable adapter", e);
            return null;
        }
    }
}

