/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.meson.core;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.internal.meson.core.MesonToolChainFile;
import org.eclipse.cdt.meson.core.Activator;
import org.eclipse.cdt.meson.core.IMesonToolChainFile;
import org.eclipse.cdt.meson.core.IMesonToolChainListener;
import org.eclipse.cdt.meson.core.IMesonToolChainManager;
import org.eclipse.cdt.meson.core.IMesonToolChainProvider;
import org.eclipse.cdt.meson.core.MesonToolChainEvent;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class MesonToolChainManager
implements IMesonToolChainManager {
    private Map<Path, IMesonToolChainFile> files;
    private static final String N = "n";
    private static final String PATH = "__path";
    private final List<IMesonToolChainListener> listeners = new LinkedList<IMesonToolChainListener>();

    private Preferences getPreferences() {
        return InstanceScope.INSTANCE.getNode(Activator.getPluginId()).node("mesonToolchains");
    }

    private void init() {
        if (this.files == null) {
            int n;
            this.files = new HashMap<Path, IMesonToolChainFile>();
            Preferences prefs = this.getPreferences();
            try {
                String[] stringArray = prefs.childrenNames();
                n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String childName = stringArray[n2];
                    Preferences tcNode = prefs.node(childName);
                    String pathStr = tcNode.get(PATH, "/");
                    Path path = Paths.get(pathStr, new String[0]);
                    if (Files.exists(path, new LinkOption[0]) && !this.files.containsKey(path)) {
                        MesonToolChainFile file = new MesonToolChainFile(childName, path);
                        String[] stringArray2 = tcNode.keys();
                        int n3 = stringArray2.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String key = stringArray2[n4];
                            String value = tcNode.get(key, "");
                            if (!value.isEmpty()) {
                                file.setProperty(key, value);
                            }
                            ++n4;
                        }
                        this.files.put(path, file);
                    } else {
                        tcNode.removeNode();
                        prefs.flush();
                    }
                    ++n2;
                }
            }
            catch (BackingStoreException e) {
                Activator.log(e);
            }
            IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(Activator.getPluginId(), "toolChainProvider");
            IConfigurationElement[] iConfigurationElementArray = point.getConfigurationElements();
            int n5 = iConfigurationElementArray.length;
            n = 0;
            while (n < n5) {
                IConfigurationElement element = iConfigurationElementArray[n];
                if (element.getName().equals("provider")) {
                    try {
                        IMesonToolChainProvider provider = (IMesonToolChainProvider)element.createExecutableExtension("class");
                        provider.init(this);
                    }
                    catch (ClassCastException | CoreException e) {
                        Activator.log(e);
                    }
                }
                ++n;
            }
        }
    }

    @Override
    public IMesonToolChainFile newToolChainFile(Path path) {
        return new MesonToolChainFile(null, path);
    }

    @Override
    public void addToolChainFile(IMesonToolChainFile file) {
        this.init();
        if (this.files.containsKey(file.getPath())) {
            this.removeToolChainFile(file);
        }
        this.files.put(file.getPath(), file);
        MesonToolChainFile realFile = (MesonToolChainFile)file;
        Preferences prefs = this.getPreferences();
        String n = realFile.n;
        if (n == null) {
            realFile.n = n = prefs.get(N, "0");
        }
        prefs.put(N, Integer.toString(Integer.parseInt(n) + 1));
        Preferences tcNode = prefs.node(n);
        tcNode.put(PATH, file.getPath().toString());
        for (Map.Entry<String, String> entry : realFile.properties.entrySet()) {
            tcNode.put(entry.getKey(), entry.getValue());
        }
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            Activator.log(e);
        }
        this.fireEvent(new MesonToolChainEvent(1, file));
    }

    @Override
    public void removeToolChainFile(IMesonToolChainFile file) {
        this.init();
        this.fireEvent(new MesonToolChainEvent(2, file));
        this.files.remove(file.getPath());
        String n = ((MesonToolChainFile)file).n;
        if (n != null) {
            Preferences prefs = this.getPreferences();
            Preferences tcNode = prefs.node(n);
            try {
                tcNode.removeNode();
                prefs.flush();
            }
            catch (BackingStoreException e) {
                Activator.log(e);
            }
        }
    }

    @Override
    public IMesonToolChainFile getToolChainFile(Path path) {
        this.init();
        return this.files.get(path);
    }

    @Override
    public Collection<IMesonToolChainFile> getToolChainFiles() {
        this.init();
        return Collections.unmodifiableCollection(this.files.values());
    }

    @Override
    public Collection<IMesonToolChainFile> getToolChainFilesMatching(Map<String, String> properties) {
        ArrayList<IMesonToolChainFile> matches = new ArrayList<IMesonToolChainFile>();
        for (IMesonToolChainFile file : this.getToolChainFiles()) {
            boolean match = true;
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                if (entry.getValue().equals(file.getProperty(entry.getKey()))) continue;
                match = false;
                break;
            }
            if (!match) continue;
            matches.add(file);
        }
        return matches;
    }

    @Override
    public IMesonToolChainFile getToolChainFileFor(IToolChain toolchain) {
        String id = toolchain.getId();
        for (IMesonToolChainFile file : this.getToolChainFiles()) {
            if (!id.equals(file.getProperty("cdt.toolChain.id"))) continue;
            return file;
        }
        return null;
    }

    @Override
    public void addListener(IMesonToolChainListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(IMesonToolChainListener listener) {
        this.listeners.remove(listener);
    }

    private void fireEvent(final MesonToolChainEvent event) {
        for (final IMesonToolChainListener listener : this.listeners) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() {
                    listener.handleMesonToolChainEvent(event);
                }

                public void handleException(Throwable exception) {
                    Activator.log(exception);
                }
            });
        }
    }
}

