/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.profiling.launch.provider;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.linuxtools.internal.profiling.launch.provider.launch.Messages;
import org.eclipse.linuxtools.internal.profiling.launch.provider.launch.ProviderFramework;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class AbstractProviderPreferencesPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage,
IExecutableExtension {
    private static final String PROVIDER_ATT_INFO = "information";
    private static final String PROVIDER_ATT_DESC = "description";
    private String type;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) {
        Hashtable parameters = (Hashtable)data;
        String profilingType = (String)parameters.get("type");
        if (profilingType == null) {
            profilingType = "";
        }
        this.setProfilingType(profilingType);
    }

    public AbstractProviderPreferencesPage() {
        super(1);
    }

    public void init(IWorkbench workbench) {
        ScopedPreferenceStore store = new ScopedPreferenceStore(ConfigurationScope.INSTANCE, "org.eclipse.linuxtools.profiling.launch");
        this.setPreferenceStore((IPreferenceStore)store);
    }

    public void initializeDefaultPreferences() {
        super.performDefaults();
        String providerId = ProviderFramework.getHighestProviderId(this.type);
        ConfigurationScope.INSTANCE.getNode("org.eclipse.linuxtools.profiling.launch").put("provider" + this.type, providerId);
    }

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.getHelpContextId());
        return super.createContents(parent);
    }

    protected void createFieldEditors() {
        Control[] providerOptions;
        String providerId = ProviderFramework.getHighestProviderId(this.type);
        if (providerId != null) {
            this.getPreferenceStore().setDefault("provider" + this.type, providerId);
        }
        HashMap<String, String> map = ProviderFramework.getProviderNamesForType(this.type);
        String[][] providerList = new String[map.size()][2];
        int i = 0;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String toolId = entry.getValue();
            String toolDescription = ProviderFramework.getToolInformationFromId(toolId, PROVIDER_ATT_DESC);
            String toolName = entry.getKey();
            if (toolDescription != null && !toolDescription.equals("")) {
                toolName = String.valueOf(toolName) + " " + "[" + toolDescription + "]";
            }
            providerList[i][0] = toolName;
            providerList[i][1] = toolId;
            ++i;
        }
        RadioGroupFieldEditor editor = new RadioGroupFieldEditor("provider" + this.type, Messages.ProviderPreferencesPage_1, 1, providerList, this.getFieldEditorParent(), true);
        editor.setPreferenceStore(this.getPreferenceStore());
        this.addField((FieldEditor)editor);
        Composite radioBoxControl = editor.getRadioBoxControl(this.getFieldEditorParent());
        Control[] controlArray = providerOptions = radioBoxControl.getChildren();
        int n = providerOptions.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            String curProviderId = (String)control.getData();
            String toolDescription = ProviderFramework.getToolInformationFromId(curProviderId, PROVIDER_ATT_INFO);
            if (toolDescription != null && !toolDescription.equals("")) {
                control.setToolTipText(toolDescription);
            }
            ++n2;
        }
    }

    private String getHelpContextId() {
        return "org.eclipse.linuxtools.profiling.launch.profiling_categories";
    }

    private void setProfilingType(String profilingType) {
        this.type = profilingType;
    }
}

