/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.actions.datasource;

import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimElement;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.IDataSourceContainerProvider;

public class DataSourceToolbarUtils {
    public static DBPDataSourceContainer getCurrentDataSource(IWorkbenchWindow workbenchWindow) {
        if (workbenchWindow == null || workbenchWindow.getActivePage() == null) {
            return null;
        }
        IEditorPart activeEditor = workbenchWindow.getActivePage().getActiveEditor();
        if (activeEditor == null) {
            return null;
        }
        if (activeEditor instanceof IDataSourceContainerProvider) {
            return ((IDataSourceContainerProvider)activeEditor).getDataSourceContainer();
        }
        return null;
    }

    public static void refreshSelectorToolbar(IWorkbenchWindow window) {
        if (window instanceof WorkbenchWindow) {
            MTrimBar topTrim = ((WorkbenchWindow)window).getTopTrim();
            for (MTrimElement element : topTrim.getChildren()) {
                if (!"dbeaver-connection-selector".equals(element.getElementId())) continue;
                if (element instanceof MElementContainer) {
                    MElementContainer container = (MElementContainer)element;
                    for (MUIElement tbItem : container.getChildren()) {
                        tbItem.setVisible(false);
                    }
                    for (MUIElement tbItem : container.getChildren()) {
                        tbItem.setVisible(true);
                    }
                }
                return;
            }
        }
        DataSourceToolbarUtils.updateCommandsUI();
    }

    public static void updateCommandsUI() {
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        if (commandService != null) {
            commandService.refreshElements("org.jkiss.dbeaver.ui.tools.select.connection", null);
            commandService.refreshElements("org.jkiss.dbeaver.ui.tools.select.schema", null);
            commandService.refreshElements("org.jkiss.dbeaver.ui.editors.sql.sync.connection", null);
        }
    }
}

