/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.net.ssh;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.ssh.SSHConstants;
import org.jkiss.dbeaver.model.net.ssh.SSHImplementation;
import org.jkiss.dbeaver.model.net.ssh.SSHUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public abstract class SSHImplementationAbstract
implements SSHImplementation {
    private static final Log log = Log.getLog(SSHImplementationAbstract.class);
    private transient int savedLocalPort = 0;
    protected transient DBWHandlerConfiguration savedConfiguration;
    protected transient DBPConnectionConfiguration savedConnectionInfo;

    @Override
    public DBPConnectionConfiguration initTunnel(DBRProgressMonitor monitor, DBPPlatform platform, DBWHandlerConfiguration configuration, DBPConnectionConfiguration connectionInfo) throws DBException, IOException {
        int dbPort;
        int connectTimeout;
        int sshPortNum;
        String dbPortString = connectionInfo.getHostPort();
        if (CommonUtils.isEmpty((String)dbPortString) && CommonUtils.isEmpty((String)(dbPortString = configuration.getDriver().getDefaultPort()))) {
            throw new DBException("Database port not specified and no default port number for driver '" + configuration.getDriver().getName() + "'");
        }
        String dbHost = connectionInfo.getHostName();
        Map properties = configuration.getProperties();
        String sshAuthType = (String)properties.get("authType");
        String sshHost = (String)properties.get("host");
        String sshPort = (String)properties.get("port");
        String sshLocalPort = (String)properties.get("localPort");
        String aliveInterval = (String)properties.get("aliveInterval");
        String connectTimeoutString = (String)properties.get("sshConnectTimeout");
        if (CommonUtils.isEmpty((String)sshHost)) {
            throw new DBException("SSH host not specified");
        }
        if (CommonUtils.isEmpty((String)sshPort)) {
            throw new DBException("SSH port not specified");
        }
        if (CommonUtils.isEmpty((String)configuration.getUserName())) {
            throw new DBException("SSH user not specified");
        }
        try {
            sshPortNum = Integer.parseInt(sshPort);
        }
        catch (NumberFormatException numberFormatException) {
            throw new DBException("Invalid SSH port: " + sshPort);
        }
        SSHConstants.AuthType authType = SSHConstants.AuthType.PASSWORD;
        if (sshAuthType != null) {
            authType = SSHConstants.AuthType.valueOf(sshAuthType);
        }
        File privKeyFile = null;
        String privKeyPath = (String)properties.get("keyPath");
        if (authType == SSHConstants.AuthType.PUBLIC_KEY) {
            if (CommonUtils.isEmpty((String)privKeyPath)) {
                throw new DBException("Private key path is empty");
            }
            privKeyFile = new File(privKeyPath);
            if (!privKeyFile.exists()) {
                throw new DBException("Private key file '" + privKeyFile.getAbsolutePath() + "' doesn't exist");
            }
        }
        try {
            connectTimeout = Integer.parseInt(connectTimeoutString);
        }
        catch (NumberFormatException numberFormatException) {
            connectTimeout = 10000;
        }
        monitor.subTask("Initiating tunnel at '" + sshHost + "'");
        try {
            dbPort = Integer.parseInt(dbPortString);
        }
        catch (NumberFormatException numberFormatException) {
            throw new DBException("Bad database port number: " + dbPortString);
        }
        int localPort = this.savedLocalPort;
        if (localPort == 0 && platform != null) {
            localPort = SSHUtils.findFreePort(platform);
        }
        if (!CommonUtils.isEmpty((String)sshLocalPort)) {
            try {
                int forceLocalPort = Integer.parseInt(sshLocalPort);
                if (forceLocalPort > 0) {
                    localPort = forceLocalPort;
                }
            }
            catch (NumberFormatException e) {
                log.warn((Object)"Bad local port specified", (Throwable)e);
            }
        }
        this.setupTunnel(monitor, configuration, dbHost, sshHost, aliveInterval, sshPortNum, privKeyFile, connectTimeout, dbPort, localPort);
        this.savedLocalPort = localPort;
        this.savedConfiguration = configuration;
        this.savedConnectionInfo = connectionInfo;
        connectionInfo = new DBPConnectionConfiguration(connectionInfo);
        String newPortValue = String.valueOf(localPort);
        connectionInfo.setHostName("127.0.0.1");
        connectionInfo.setHostPort(newPortValue);
        if (configuration.getDriver() != null) {
            String newURL = configuration.getDriver().getDataSourceProvider().getConnectionURL(configuration.getDriver(), connectionInfo);
            connectionInfo.setUrl(newURL);
        }
        return connectionInfo;
    }

    protected abstract void setupTunnel(DBRProgressMonitor var1, DBWHandlerConfiguration var2, String var3, String var4, String var5, int var6, File var7, int var8, int var9, int var10) throws DBException, IOException;
}

