/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model.fed;

import java.sql.ResultSet;
import java.util.Collection;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.db2.model.DB2DataSource;
import org.jkiss.dbeaver.ext.db2.model.DB2GlobalObject;
import org.jkiss.dbeaver.ext.db2.model.fed.DB2WrapperOption;
import org.jkiss.dbeaver.ext.db2.model.fed.DB2WrapperType;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectSimpleCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class DB2Wrapper
extends DB2GlobalObject
implements DBPRefreshableObject {
    private static final String C_OP = "SELECT * FROM SYSCAT.WRAPOPTIONS WHERE WRAPNAME = ? ORDER BY OPTION WITH UR";
    private final DBSObjectCache<DB2Wrapper, DB2WrapperOption> optionsCache;
    private String name;
    private DB2WrapperType type;
    private Integer version;
    private String library;
    private String remarks;

    public DB2Wrapper(DB2DataSource db2DataSource, ResultSet dbResult) {
        super(db2DataSource, true);
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"WRAPNAME");
        this.type = (DB2WrapperType)CommonUtils.valueOf(DB2WrapperType.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"WRAPTYPE"));
        this.version = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"WRAPVERSION");
        this.library = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"LIBRARY");
        this.remarks = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"REMARKS");
        this.optionsCache = new JDBCObjectSimpleCache(DB2WrapperOption.class, C_OP, new Object[]{this.name});
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.optionsCache.clearCache();
        return this;
    }

    @Association
    public Collection<DB2WrapperOption> getOptions(DBRProgressMonitor monitor) throws DBException {
        return this.optionsCache.getAllObjects(monitor, (DBSObject)this);
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, order=2)
    public DB2WrapperType getType() {
        return this.type;
    }

    @Property(viewable=true, order=3)
    public Integer getVersion() {
        return this.version;
    }

    @Property(viewable=true, order=4)
    public String getLibrary() {
        return this.library;
    }

    @Property(viewable=true, multiline=true, order=5)
    public String getRemarks() {
        return this.remarks;
    }
}

