/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;

public abstract class ObjectContainerSelectorPanel
extends Composite {
    private final Label containerIcon;
    private final Text containerName;

    protected ObjectContainerSelectorPanel(Composite parent, String containerTitle, String containerHint) {
        super(parent, 0);
        GridLayout layout = new GridLayout(4, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(768));
        UIUtils.createControlLabel(this, containerTitle);
        this.containerIcon = new Label((Composite)this, 0);
        this.containerIcon.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TYPE_UNKNOWN));
        this.containerName = new Text((Composite)this, 2056);
        this.containerName.setLayoutData((Object)new GridData(768));
        this.containerName.setText("");
        if (containerHint != null) {
            UIUtils.addEmptyTextHint(this.containerName, text -> containerHint);
        }
        Button browseButton = new Button((Composite)this, 8);
        browseButton.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TREE_FOLDER));
        browseButton.setText("...");
        final Runnable containerSelector = () -> {
            DBPProject activeProject = DBWorkbench.getPlatform().getWorkspace().getActiveProject();
            if (activeProject != null) {
                DBNModel navigatorModel = DBWorkbench.getPlatform().getNavigatorModel();
                DBNProject rootNode = navigatorModel.getRoot().getProjectNode(activeProject);
                DBNNode selectedNode = this.getSelectedNode();
                DBNNode node = DBWorkbench.getPlatformUI().selectObject((Object)this.getShell(), containerHint != null ? containerHint : containerTitle, (DBNNode)rootNode.getDatabases(), selectedNode, new Class[]{DBSObjectContainer.class}, null, new Class[]{DBSSchema.class});
                if (node instanceof DBNDatabaseNode) {
                    this.setSelectedNode((DBNDatabaseNode)node);
                }
            }
        };
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                containerSelector.run();
            }
        });
        this.containerName.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                containerSelector.run();
            }
        });
    }

    public void setContainerInfo(DBPImage image, String name) {
        this.containerIcon.setImage(DBeaverIcons.getImage(image));
        this.containerName.setText(name);
    }

    protected abstract void setSelectedNode(DBNDatabaseNode var1);

    @Nullable
    protected abstract DBNNode getSelectedNode();
}

