/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.connection;

import java.util.List;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.registry.DataSourceProviderDescriptor;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;
import org.jkiss.dbeaver.ui.dialogs.connection.NewConnectionWizard;
import org.jkiss.dbeaver.ui.dialogs.driver.DriverSelectViewer;
import org.jkiss.dbeaver.ui.dialogs.driver.DriverTreeViewer;

class ConnectionPageDriver
extends ActiveWizardPage
implements ISelectionChangedListener,
IDoubleClickListener {
    private NewConnectionWizard wizard;
    private DriverDescriptor selectedDriver;
    private DBPProject connectionProject;

    ConnectionPageDriver(NewConnectionWizard wizard) {
        super("newConnectionDrivers");
        this.wizard = wizard;
        this.setTitle(CoreMessages.dialog_new_connection_wizard_start_title);
        this.setDescription(CoreMessages.dialog_new_connection_wizard_start_description);
    }

    public void createControl(Composite parent) {
        Composite placeholder = UIUtils.createComposite((Composite)parent, (int)1);
        DriverSelectViewer driverSelectViewer = new DriverSelectViewer(placeholder, (Object)this, this.wizard.getAvailableProvides(), true);
        GridData gd = new GridData(1808);
        gd.heightHint = 200;
        driverSelectViewer.getControl().setLayoutData((Object)gd);
        this.setControl((Control)placeholder);
        final List projects = DBeaverCore.getInstance().getWorkspace().getProjects();
        if (projects.size() == 1) {
            this.connectionProject = (DBPProject)projects.get(0);
        } else if (projects.size() > 1) {
            Composite projectGroup = UIUtils.createComposite((Composite)placeholder, (int)2);
            projectGroup.setLayoutData((Object)new GridData(128));
            UIUtils.createControlLabel((Composite)projectGroup, (String)CoreMessages.dialog_connection_driver_project);
            final Combo projectCombo = new Combo(projectGroup, 12);
            projectCombo.setLayoutData((Object)new GridData(32));
            DBPProject activeProject = DBWorkbench.getPlatform().getWorkspace().getActiveProject();
            for (DBPProject project : projects) {
                projectCombo.add(project.getName());
            }
            if (activeProject == null) {
                projectCombo.select(0);
                this.connectionProject = (DBPProject)projects.get(0);
            } else {
                this.connectionProject = activeProject;
                projectCombo.setText(activeProject.getName());
            }
            projectCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ConnectionPageDriver.this.connectionProject = (DBPProject)projects.get(projectCombo.getSelectionIndex());
                }
            });
            projects.size();
        } else {
            this.setErrorMessage("You need to create a project first");
        }
        UIUtils.setHelp((Control)placeholder, (String)"con-wizard-driver");
    }

    public DriverDescriptor getSelectedDriver() {
        return this.selectedDriver;
    }

    public DBPProject getConnectionProject() {
        return this.connectionProject;
    }

    public boolean canFlipToNextPage() {
        return this.connectionProject != null && this.selectedDriver != null;
    }

    public boolean isPageComplete() {
        return this.canFlipToNextPage();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.selectedDriver = null;
        this.setMessage("");
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection) {
            Object selectedObject = ((IStructuredSelection)selection).getFirstElement();
            if (selectedObject instanceof DBPDriver) {
                this.selectedDriver = (DriverDescriptor)selectedObject;
                this.setMessage(this.selectedDriver.getDescription());
            } else if (selectedObject instanceof DataSourceProviderDescriptor) {
                this.setMessage(((DataSourceProviderDescriptor)selectedObject).getDescription());
            } else if (selectedObject instanceof DriverTreeViewer.DriverCategory) {
                this.setMessage(String.valueOf(((DriverTreeViewer.DriverCategory)selectedObject).getName()) + " drivers");
            }
        }
        this.getWizard().getContainer().updateButtons();
        this.getWizard().getContainer().updateMessage();
    }

    public void doubleClick(DoubleClickEvent event) {
        if (this.selectedDriver != null) {
            this.wizard.getContainer().showPage(this.wizard.getNextPage((IWizardPage)this));
        }
    }

    public void activatePage() {
    }

    public void deactivatePage() {
    }
}

