/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.io;

import com.android.repository.api.ProgressIndicator;
import com.android.repository.io.FileOp;
import com.android.repository.io.impl.FileOpImpl;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.util.regex.Pattern;

public final class FileOpUtils {
    public static FileOp create() {
        return new FileOpImpl();
    }

    public static void recursiveCopy(File src, File dest, FileOp fop) throws IOException {
        if (fop.exists(dest)) {
            throw new IOException(dest + " already exists!");
        }
        if (fop.isDirectory(src)) {
            File[] children;
            fop.mkdirs(dest);
            for (File child : children = fop.listFiles(src)) {
                File newDest = new File(dest, child.getName());
                FileOpUtils.recursiveCopy(child, newDest, fop);
            }
        } else if (fop.isFile(src)) {
            fop.copyFile(src, dest);
            if (!fop.isWindows() && fop.canExecute(src)) {
                fop.setExecutablePermission(dest);
            }
        }
    }

    public static void safeRecursiveOverwrite(File src, File dest, FileOp fop, ProgressIndicator progress) throws IOException {
        if (fop.exists(dest)) {
            File toDelete = FileOpUtils.getNewTempDir("FileOpUtilsToDelete", fop);
            if (toDelete == null) {
                fop.deleteFileOrFolder(dest);
            } else {
                FileOpUtils.recursiveCopy(dest, toDelete, fop);
            }
            try {
                fop.deleteFileOrFolder(dest);
                FileOpUtils.recursiveCopy(src, dest, fop);
                fop.deleteFileOrFolder(src);
            }
            catch (IOException e) {
                progress.logError("Old dir was moved away, but new one failed to be moved into place. Trying to move old one back.");
                if (fop.exists(dest)) {
                    fop.deleteFileOrFolder(dest);
                }
                if (toDelete == null) {
                    progress.logError("Failed to move old dir back into place! Component was lost.");
                } else {
                    FileOpUtils.recursiveCopy(toDelete, dest, fop);
                }
                throw new IOException("failed to move new dir into place", e);
            }
            if (toDelete != null) {
                fop.deleteFileOrFolder(toDelete);
            }
        } else {
            FileOpUtils.recursiveCopy(src, dest, fop);
            fop.deleteFileOrFolder(src);
        }
    }

    public static File getNewTempDir(String base, FileOp fileOp) {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        if (!fileOp.exists(tempDir)) {
            fileOp.mkdirs(tempDir);
        }
        for (int i = 1; i < 100; ++i) {
            File folder = new File(tempDir, String.format("%1$s%2$02d", base, i));
            if (fileOp.exists(folder)) continue;
            return folder;
        }
        return null;
    }

    public static File append(File base, String ... segments) {
        for (String segment : segments) {
            base = new File(base, segment);
        }
        return base;
    }

    public static File append(String base, String ... segments) {
        return FileOpUtils.append(new File(base), segments);
    }

    public static String makeRelative(File baseDir, File toBeRelative, FileOp fop) throws IOException {
        return FileOpUtils.makeRelativeImpl(baseDir.getCanonicalPath(), toBeRelative.getCanonicalPath(), fop.isWindows(), File.separator);
    }

    @VisibleForTesting
    static String makeRelativeImpl(String path1, String path2, boolean isWindows, String dirSeparator) throws IOException {
        int start;
        if (isWindows) {
            char drive2;
            String p1 = path1;
            String p2 = path2;
            char drive1 = p1.length() >= 2 && p1.charAt(1) == ':' ? p1.charAt(0) : (char)'\u0000';
            char c = drive2 = p2.length() >= 2 && p2.charAt(1) == ':' ? p2.charAt(0) : (char)'\u0000';
            if (drive1 != drive2) {
                throw new IOException("makeRelative: incompatible drive letters");
            }
        }
        String[] segments1 = path1.split(Pattern.quote(dirSeparator));
        String[] segments2 = path2.split(Pattern.quote(dirSeparator));
        int len1 = segments1.length;
        int len2 = segments2.length;
        int len = Math.min(len1, len2);
        for (start = 0; start < len && (!isWindows || segments1[start].equalsIgnoreCase(segments2[start])) && (isWindows || segments1[start].equals(segments2[start])); ++start) {
        }
        StringBuilder result = new StringBuilder();
        for (int i = start; i < len1; ++i) {
            result.append("..").append(dirSeparator);
        }
        while (start < len2) {
            result.append(segments2[start]);
            if (++start >= len2) continue;
            result.append(dirSeparator);
        }
        return result.toString();
    }

    private FileOpUtils() {
    }
}

