"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _helpers = require("../helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const CONTENT_TYPES = Object.keys(_helpers.reactionTypeToEmoji);
const EMOJI_COUNT = CONTENT_TYPES.length;
const EMOJI_PER_ROW = 4;
const EMOJI_ROWS = Math.ceil(EMOJI_COUNT / EMOJI_PER_ROW);

class ReactionPickerView extends _react["default"].Component {
  render() {
    const viewerReactedSet = new Set(this.props.viewerReacted);
    const emojiRows = [];

    for (let row = 0; row < EMOJI_ROWS; row++) {
      const emojiButtons = [];

      for (let column = 0; column < EMOJI_PER_ROW; column++) {
        const emojiIndex = row * EMOJI_PER_ROW + column;
        /* istanbul ignore if */

        if (emojiIndex >= CONTENT_TYPES.length) {
          break;
        }

        const content = CONTENT_TYPES[emojiIndex];
        const toggle = !viewerReactedSet.has(content) ? () => this.props.addReactionAndClose(content) : () => this.props.removeReactionAndClose(content);
        const className = (0, _classnames["default"])('github-ReactionPicker-reaction', 'btn', {
          selected: viewerReactedSet.has(content)
        });
        emojiButtons.push(_react["default"].createElement("button", {
          key: content,
          className: className,
          onClick: toggle
        }, _helpers.reactionTypeToEmoji[content]));
      }

      emojiRows.push(_react["default"].createElement("p", {
        key: row,
        className: "github-ReactionPicker-row inline-block-tight"
      }, emojiButtons));
    }

    return _react["default"].createElement("div", {
      className: "github-ReactionPicker"
    }, emojiRows);
  }

}

exports["default"] = ReactionPickerView;

_defineProperty(ReactionPickerView, "propTypes", {
  viewerReacted: _propTypes["default"].arrayOf(_propTypes["default"].oneOf(Object.keys(_helpers.reactionTypeToEmoji))),
  // Action methods
  addReactionAndClose: _propTypes["default"].func.isRequired,
  removeReactionAndClose: _propTypes["default"].func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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