/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.ui;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.panel.PanelBuilder;
import com.intellij.openapi.ui.panel.PanelGridBuilder;
import com.intellij.ui.components.JBBox;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UI;
import com.intellij.util.ui.dialog.DialogUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.authentication.ui.GithubAccountCombobox;
import org.jetbrains.plugins.github.ui.util.DialogValidationUtils;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B_\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0005\u0012*\u0010\n\u001a&\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00050\r0\u000b\u00a2\u0006\u0002\u0010\u000fJ\n\u0010!\u001a\u0004\u0018\u00010\"H\u0014J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00140$H\u0014J\u0006\u0010%\u001a\u00020\u0006J\u0006\u0010&\u001a\u00020\tJ\b\u0010'\u001a\u00020\tH\u0014J\b\u0010(\u001a\u00020\tH\u0014J\b\u0010)\u001a\u00020\u001fH\u0016J\u0006\u0010*\u001a\u00020\tJ\u0006\u0010+\u001a\u00020\tJ\u0006\u0010,\u001a\u00020\u000eJ\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u0006H\u0002J\u000e\u00100\u001a\u00020.2\u0006\u00101\u001a\u00020\tR\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R2\u0010\n\u001a&\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00050\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lorg/jetbrains/plugins/github/ui/GithubShareDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "accounts", "", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "defaultAccount", "existingRemotes", "", "accountInformationSupplier", "Lkotlin/Function2;", "Ljava/awt/Component;", "Lkotlin/Pair;", "", "(Lcom/intellij/openapi/project/Project;Ljava/util/Set;Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;Ljava/util/Set;Lkotlin/jvm/functions/Function2;)V", "GITHUB_REPO_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "accountInformationLoadingError", "Lcom/intellij/openapi/ui/ValidationInfo;", "accountSelector", "Lorg/jetbrains/plugins/github/authentication/ui/GithubAccountCombobox;", "descriptionTextArea", "Ljavax/swing/JTextArea;", "existingRemoteValidator", "Lorg/jetbrains/plugins/github/ui/util/DialogValidationUtils$RecordUniqueValidator;", "existingRepoValidator", "privateCheckBox", "Lcom/intellij/ui/components/JBCheckBox;", "remoteTextField", "Lcom/intellij/ui/components/JBTextField;", "repositoryTextField", "createCenterPanel", "Ljavax/swing/JComponent;", "doValidateAll", "", "getAccount", "getDescription", "getDimensionServiceKey", "getHelpId", "getPreferredFocusedComponent", "getRemoteName", "getRepositoryName", "isPrivate", "switchAccount", "", "account", "testSetRepositoryName", "name", "intellij.vcs.github"})
public final class GithubShareDialog
extends DialogWrapper {
    private final Pattern GITHUB_REPO_PATTERN;
    private final JBTextField repositoryTextField;
    private final JBCheckBox privateCheckBox;
    private final JBTextField remoteTextField;
    private final JTextArea descriptionTextArea;
    private final GithubAccountCombobox accountSelector;
    private final DialogValidationUtils.RecordUniqueValidator existingRepoValidator;
    private final DialogValidationUtils.RecordUniqueValidator existingRemoteValidator;
    private ValidationInfo accountInformationLoadingError;
    private final Function2<GithubAccount, Component, Pair<Boolean, Set<String>>> accountInformationSupplier;

    private final void switchAccount(GithubAccount account) {
        try {
            this.accountInformationLoadingError = null;
            Window window = this.getWindow();
            Intrinsics.checkExpressionValueIsNotNull((Object)window, (String)"window");
            Object object = this.accountInformationSupplier.invoke((Object)account, (Object)window);
            Pair it = (Pair)object;
            this.privateCheckBox.setEnabled(((Boolean)it.getFirst()).booleanValue());
            if (!((Boolean)it.getFirst()).booleanValue()) {
                this.privateCheckBox.setToolTipText("Your account doesn't support private repositories");
            } else {
                this.privateCheckBox.setToolTipText((String)null);
            }
            this.existingRepoValidator.setRecords((Set)it.getSecond());
        }
        catch (Exception e) {
            this.accountInformationLoadingError = e instanceof ProcessCanceledException ? new ValidationInfo("Cannot load information for " + account + ":\nProcess cancelled") : new ValidationInfo("Cannot load information for " + account + ":\n" + e);
            this.privateCheckBox.setEnabled(false);
            this.privateCheckBox.setToolTipText((String)null);
            this.existingRepoValidator.setRecords(SetsKt.emptySet());
            this.startTrackingValidation();
        }
    }

    @Nullable
    protected JComponent createCenterPanel() {
        PanelGridBuilder panelGridBuilder;
        JBScrollPane jBScrollPane;
        JBScrollPane $receiver = jBScrollPane = new JBScrollPane((Component)this.descriptionTextArea);
        $receiver.setMinimumSize((Dimension)new JBDimension(150, 50));
        $receiver.setPreferredSize((Dimension)new JBDimension(150, 50));
        JBScrollPane descriptionPane = jBScrollPane;
        JBBox repository = JBBox.createHorizontalBox();
        repository.add((Component)this.repositoryTextField);
        repository.add(JBBox.createRigidArea((Dimension)((Dimension)JBUI.size((int)10, (int)0))));
        repository.add((Component)this.privateCheckBox);
        repository.add(JBBox.createRigidArea((Dimension)((Dimension)JBUI.size((int)5, (int)0))));
        PanelGridBuilder $receiver2 = panelGridBuilder = UI.PanelFactory.grid().resize().add((PanelBuilder)UI.PanelFactory.panel((JComponent)((JComponent)repository)).withLabel("Repository name:")).add((PanelBuilder)UI.PanelFactory.panel((JComponent)((JComponent)this.remoteTextField)).withLabel("Remote:")).add((PanelBuilder)UI.PanelFactory.panel((JComponent)((JComponent)descriptionPane)).withLabel("Description:").anchorLabelOn(UI.Anchor.Top).resizeY(true));
        if (this.accountSelector.isEnabled()) {
            $receiver2.add((PanelBuilder)UI.PanelFactory.panel((JComponent)((JComponent)((Object)this.accountSelector))).withLabel("Share by:").resizeX(false));
        }
        return panelGridBuilder.createPanel();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected List<ValidationInfo> doValidateAll() {
        void $receiver$iv$iv;
        Function0 repositoryNamePatternMatchValidator2 = (Function0)new Function0<ValidationInfo>(this){
            final /* synthetic */ GithubShareDialog this$0;

            @Nullable
            public final ValidationInfo invoke() {
                return !GithubShareDialog.access$getGITHUB_REPO_PATTERN$p(this.this$0).matcher(GithubShareDialog.access$getRepositoryTextField$p(this.this$0).getText()).matches() ? new ValidationInfo("Invalid repository name. Name should consist of letters, numbers, dashes, dots and underscores", (JComponent)GithubShareDialog.access$getRepositoryTextField$p(this.this$0)) : null;
            }
            {
                this.this$0 = githubShareDialog;
                super(0);
            }
        };
        Iterable $receiver$iv = CollectionsKt.listOf((Object[])new Function0[]{(Function0)new Function0<ValidationInfo>(this){
            final /* synthetic */ GithubShareDialog this$0;

            @Nullable
            public final ValidationInfo invoke() {
                return GithubShareDialog.access$getAccountInformationLoadingError$p(this.this$0);
            }
            {
                this.this$0 = githubShareDialog;
                super(0);
            }
        }, DialogValidationUtils.INSTANCE.chain((Function0)new Function0<ValidationInfo>(this){
            final /* synthetic */ GithubShareDialog this$0;

            @Nullable
            public final ValidationInfo invoke() {
                return DialogValidationUtils.INSTANCE.notBlank((JTextField)GithubShareDialog.access$getRepositoryTextField$p(this.this$0), "No repository name selected");
            }
            {
                this.this$0 = githubShareDialog;
                super(0);
            }
        }, repositoryNamePatternMatchValidator2, this.existingRepoValidator), DialogValidationUtils.INSTANCE.chain((Function0)new Function0<ValidationInfo>(this){
            final /* synthetic */ GithubShareDialog this$0;

            @Nullable
            public final ValidationInfo invoke() {
                return DialogValidationUtils.INSTANCE.notBlank((JTextField)GithubShareDialog.access$getRemoteTextField$p(this.this$0), "No remote name selected");
            }
            {
                this.this$0 = githubShareDialog;
                super(0);
            }
        }, this.existingRemoteValidator)});
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            ValidationInfo validationInfo;
            Object element$iv$iv = element$iv$iv$iv;
            Function0 it = (Function0)element$iv$iv;
            if ((ValidationInfo)it.invoke() == null) continue;
            ValidationInfo it$iv$iv = validationInfo;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    protected String getHelpId() {
        return "github.share";
    }

    @NotNull
    protected String getDimensionServiceKey() {
        return "Github.ShareDialog";
    }

    @NotNull
    public JBTextField getPreferredFocusedComponent() {
        return this.repositoryTextField;
    }

    @NotNull
    public final String getRepositoryName() {
        String string = this.repositoryTextField.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"repositoryTextField.text");
        return string;
    }

    @NotNull
    public final String getRemoteName() {
        String string = this.remoteTextField.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"remoteTextField.text");
        return string;
    }

    public final boolean isPrivate() {
        return this.privateCheckBox.isSelected();
    }

    @NotNull
    public final String getDescription() {
        String string = this.descriptionTextArea.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"descriptionTextArea.text");
        return string;
    }

    @NotNull
    public final GithubAccount getAccount() {
        Object object = this.accountSelector.getSelectedItem();
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.plugins.github.authentication.accounts.GithubAccount");
        }
        return (GithubAccount)object;
    }

    public final void testSetRepositoryName(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.repositoryTextField.setText(name);
    }

    public GithubShareDialog(@NotNull Project project, @NotNull Set<? extends GithubAccount> accounts, @Nullable GithubAccount defaultAccount, @NotNull Set<String> existingRemotes, @NotNull Function2<? super GithubAccount, ? super Component, ? extends Pair<Boolean, ? extends Set<String>>> accountInformationSupplier) {
        DialogValidationUtils.RecordUniqueValidator recordUniqueValidator;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(accounts, (String)"accounts");
        Intrinsics.checkParameterIsNotNull(existingRemotes, (String)"existingRemotes");
        Intrinsics.checkParameterIsNotNull(accountInformationSupplier, (String)"accountInformationSupplier");
        super(project);
        this.accountInformationSupplier = accountInformationSupplier;
        this.GITHUB_REPO_PATTERN = Pattern.compile("[a-zA-Z0-9_.-]+");
        this.repositoryTextField = new JBTextField(project.getName());
        this.privateCheckBox = new JBCheckBox("Private", false);
        this.remoteTextField = new JBTextField(existingRemotes.isEmpty() ? "origin" : "github");
        this.descriptionTextArea = new JTextArea();
        this.accountSelector = new GithubAccountCombobox(accounts, defaultAccount, (Function1<? super GithubAccount, Unit>)((Function1)new Function1<GithubAccount, Unit>(this){
            final /* synthetic */ GithubShareDialog this$0;

            public final void invoke(@NotNull GithubAccount it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                GithubShareDialog.access$switchAccount(this.this$0, it);
            }
            {
                this.this$0 = githubShareDialog;
                super(1);
            }
        }));
        this.existingRepoValidator = new DialogValidationUtils.RecordUniqueValidator((JTextField)this.repositoryTextField, "Repository with selected name already exists");
        DialogValidationUtils.RecordUniqueValidator recordUniqueValidator2 = new DialogValidationUtils.RecordUniqueValidator((JTextField)this.remoteTextField, "Remote with selected name already exists");
        GithubShareDialog githubShareDialog = this;
        DialogValidationUtils.RecordUniqueValidator $receiver = recordUniqueValidator2;
        $receiver.setRecords(existingRemotes);
        githubShareDialog.existingRemoteValidator = recordUniqueValidator = recordUniqueValidator2;
        this.setTitle("Share Project On GitHub");
        this.setOKButtonText("Share");
        this.init();
        DialogUtils.invokeLaterAfterDialogShown((DialogWrapper)this, (Runnable)new Runnable(){

            @Override
            public final void run() {
                Object object = accountSelector.getSelectedItem();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.plugins.github.authentication.accounts.GithubAccount");
                }
                this.switchAccount((GithubAccount)object);
            }
        });
    }

    public static final /* synthetic */ Pattern access$getGITHUB_REPO_PATTERN$p(GithubShareDialog $this) {
        return $this.GITHUB_REPO_PATTERN;
    }

    @NotNull
    public static final /* synthetic */ JBTextField access$getRepositoryTextField$p(GithubShareDialog $this) {
        return $this.repositoryTextField;
    }

    @Nullable
    public static final /* synthetic */ ValidationInfo access$getAccountInformationLoadingError$p(GithubShareDialog $this) {
        return $this.accountInformationLoadingError;
    }

    public static final /* synthetic */ void access$setAccountInformationLoadingError$p(GithubShareDialog $this, @Nullable ValidationInfo validationInfo) {
        $this.accountInformationLoadingError = validationInfo;
    }

    @NotNull
    public static final /* synthetic */ JBTextField access$getRemoteTextField$p(GithubShareDialog $this) {
        return $this.remoteTextField;
    }
}

