/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.update;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import java.io.File;
import java.util.Collection;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.SvnWCRootCrawler;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.update.UpdateEventHandler;

public abstract class AbstractUpdateIntegrateCrawler
implements SvnWCRootCrawler {
    protected final SvnVcs myVcs;
    protected final UpdateEventHandler myHandler;
    protected final Collection<VcsException> myExceptions;
    protected final UpdatedFiles myPostUpdateFiles;
    protected final boolean myIsTotalUpdate;
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.update.AbstractUpdateIntegrateCrawler");

    protected AbstractUpdateIntegrateCrawler(boolean isTotalUpdate, UpdatedFiles postUpdateFiles, Collection<VcsException> exceptions, UpdateEventHandler handler, SvnVcs vcs) {
        this.myIsTotalUpdate = isTotalUpdate;
        this.myPostUpdateFiles = postUpdateFiles;
        this.myExceptions = exceptions;
        this.myHandler = handler;
        this.myVcs = vcs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleWorkingCopyRoot(File root, ProgressIndicator progress) {
        if (progress != null) {
            this.showProgressMessage(progress, root);
        }
        this.myHandler.startUpdate();
        try {
            long rev = this.doUpdate(root);
            if (rev < 0L && !this.isMerge()) {
                throw new SvnBindException(SvnBundle.message("exception.text.root.was.not.properly.updated", root));
            }
        }
        catch (VcsException e) {
            LOG.info((Throwable)e);
            this.myExceptions.add(e);
        }
        finally {
            this.myHandler.finishUpdate();
        }
    }

    protected abstract void showProgressMessage(ProgressIndicator var1, File var2);

    protected abstract long doUpdate(File var1) throws VcsException;

    protected abstract boolean isMerge();
}

