/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.renameProject;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.TitledHandler;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.platform.ModuleAttachProcessor;
import com.intellij.projectImport.ProjectAttachProcessor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.RenameHandler;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenameProjectHandler
implements RenameHandler,
TitledHandler {
    private static final Logger LOG = Logger.getInstance(RenameProjectHandler.class);

    public boolean isAvailableOnDataContext(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            RenameProjectHandler.$$$reportNull$$$0(0);
        }
        return RenameProjectHandler.isAvailable(dataContext);
    }

    static boolean isAvailable(DataContext dataContext) {
        Module module = (Module)LangDataKeys.MODULE_CONTEXT.getData(dataContext);
        return module != null;
    }

    public boolean isRenaming(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            RenameProjectHandler.$$$reportNull$$$0(1);
        }
        return this.isAvailableOnDataContext(dataContext);
    }

    public String getActionTitle() {
        return RefactoringBundle.message((String)"rename.project.handler.title");
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2, DataContext dataContext) {
        if (project == null) {
            RenameProjectHandler.$$$reportNull$$$0(2);
        }
        LOG.error("Project renaming should be never invoked from file");
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            RenameProjectHandler.$$$reportNull$$$0(3);
        }
        if (elements == null) {
            RenameProjectHandler.$$$reportNull$$$0(4);
        }
        LOG.assertTrue(project instanceof ProjectEx);
        Module module = (Module)LangDataKeys.MODULE_CONTEXT.getData(dataContext);
        LOG.assertTrue(module != null);
        Messages.showInputDialog((Project)project, (String)RefactoringBundle.message((String)"enter.new.project.name"), (String)RefactoringBundle.message((String)"rename.project"), (Icon)Messages.getQuestionIcon(), (String)module.getName(), (InputValidator)new MyInputValidator((ProjectEx)project, module));
    }

    public static boolean renameProject(@NotNull ProjectEx project, @Nullable Module module, String newName) {
        if (project == null) {
            RenameProjectHandler.$$$reportNull$$$0(5);
        }
        if (RenameProjectHandler.shouldRenameProject(project, module, newName)) {
            project.setProjectName(newName);
            project.save();
        }
        if (module != null && !newName.equals(module.getName())) {
            ModifiableModuleModel modifiableModel = ModuleManager.getInstance((Project)project).getModifiableModel();
            try {
                modifiableModel.renameModule(module, newName);
            }
            catch (ModuleWithNameAlreadyExists moduleWithNameAlreadyExists) {
                Messages.showErrorDialog((Project)project, (String)IdeBundle.message((String)"error.module.already.exists", (Object[])new Object[]{newName}), (String)IdeBundle.message((String)"title.rename.module", (Object[])new Object[0]));
                return false;
            }
            Ref success2 = Ref.create((Object)Boolean.TRUE);
            CommandProcessor.getInstance().executeCommand((Project)project, () -> ApplicationManager.getApplication().runWriteAction(() -> modifiableModel.commit()), IdeBundle.message((String)"command.renaming.module", (Object[])new Object[]{module.getName()}), null);
            return (Boolean)success2.get();
        }
        return true;
    }

    private static boolean shouldRenameProject(@NotNull Project project, @Nullable Module module, String inputString) {
        if (project == null) {
            RenameProjectHandler.$$$reportNull$$$0(6);
        }
        if (inputString.equals(project.getName())) {
            return false;
        }
        if (module == null) {
            return true;
        }
        if (ProjectAttachProcessor.canAttachToProject()) {
            return module == ModuleAttachProcessor.getPrimaryModule(project);
        }
        return module == ModuleAttachProcessor.findModuleInBaseDir(project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        objectArray2[1] = "com/intellij/platform/renameProject/RenameProjectHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableOnDataContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isRenaming";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "renameProject";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldRenameProject";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected static class MyInputValidator
    implements InputValidator {
        private final ProjectEx myProject;
        @Nullable
        private final Module myModule;

        public MyInputValidator(ProjectEx project, @Nullable Module module) {
            this.myProject = project;
            this.myModule = module;
        }

        public boolean checkInput(String inputString) {
            return inputString != null && inputString.length() > 0;
        }

        public boolean canClose(String inputString) {
            return RenameProjectHandler.renameProject(this.myProject, this.myModule, inputString);
        }
    }
}

