/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor;

import com.intellij.icons.AllIcons;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.newStructureView.StructureViewComponent;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.editor.PropertiesGroupingStructureViewModel;
import com.intellij.lang.properties.editor.ResourceBundleEditorKeepEmptyValueToggleAction;
import com.intellij.lang.properties.editor.ResourceBundleStructureViewModel;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.EmptyIcon;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class PropertiesGroupingStructureViewComponent
extends StructureViewComponent {
    protected PropertiesGroupingStructureViewComponent(Project project, FileEditor editor, PropertiesGroupingStructureViewModel structureViewModel) {
        super(editor, (StructureViewModel)structureViewModel, project, true);
        this.showToolbar();
    }

    protected void addGroupByActions(@NotNull DefaultActionGroup result) {
        if (result == null) {
            PropertiesGroupingStructureViewComponent.$$$reportNull$$$0(0);
        }
        super.addGroupByActions(result);
        result.add((AnAction)new ChangeGroupSeparatorAction());
        if (this.getTreeModel() instanceof ResourceBundleStructureViewModel) {
            result.add((AnAction)this.createSettingsActionGroup());
        }
    }

    private ActionGroup createSettingsActionGroup() {
        DefaultActionGroup actionGroup = new DefaultActionGroup(PropertiesBundle.message("resource.bundle.editor.settings.action.title", new Object[0]), true);
        Presentation presentation = actionGroup.getTemplatePresentation();
        presentation.setIcon(AllIcons.General.GearPlain);
        actionGroup.add((AnAction)new ResourceBundleEditorKeepEmptyValueToggleAction());
        actionGroup.add((AnAction)new ToggleAction(PropertiesBundle.message("show.only.incomplete.action.text", new Object[0]), null, AllIcons.General.Error){

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                return ((ResourceBundleStructureViewModel)PropertiesGroupingStructureViewComponent.this.getTreeModel()).isShowOnlyIncomplete();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                ((ResourceBundleStructureViewModel)PropertiesGroupingStructureViewComponent.this.getTreeModel()).setShowOnlyIncomplete(state);
                PropertiesGroupingStructureViewComponent.this.rebuild();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/lang/properties/editor/PropertiesGroupingStructureViewComponent$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setSelected";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return actionGroup;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/properties/editor/PropertiesGroupingStructureViewComponent", "addGroupByActions"));
    }

    private class ChangeGroupSeparatorAction
    extends DefaultActionGroup {
        private final Set<String> myPredefinedSeparators;

        ChangeGroupSeparatorAction() {
            super("Group by: ", true);
            this.myPredefinedSeparators = new LinkedHashSet<String>();
            this.myPredefinedSeparators.add(".");
            this.myPredefinedSeparators.add("_");
            this.myPredefinedSeparators.add("/");
            this.myPredefinedSeparators.add(this.getCurrentSeparator());
            this.refillActionGroup();
        }

        public final void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ChangeGroupSeparatorAction.$$$reportNull$$$0(0);
            }
            String separator = this.getCurrentSeparator();
            Presentation presentation = e.getPresentation();
            presentation.setText("Group by: " + separator, false);
            presentation.setIcon(EmptyIcon.ICON_16);
        }

        private String getCurrentSeparator() {
            return ((PropertiesGroupingStructureViewModel)PropertiesGroupingStructureViewComponent.this.getTreeModel()).getSeparator();
        }

        private void refillActionGroup() {
            this.removeAll();
            for (final String separator : this.myPredefinedSeparators) {
                if (separator.equals(this.getCurrentSeparator())) continue;
                AnAction action = new AnAction(){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        ((PropertiesGroupingStructureViewModel)PropertiesGroupingStructureViewComponent.this.getTreeModel()).setSeparator(separator);
                        PropertiesGroupingStructureViewComponent.this.setActionActive("GROUP_BY_PREFIXES", true);
                        ChangeGroupSeparatorAction.this.refillActionGroup();
                        PropertiesGroupingStructureViewComponent.this.rebuild();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/properties/editor/PropertiesGroupingStructureViewComponent$ChangeGroupSeparatorAction$1", "actionPerformed"));
                    }
                };
                action.getTemplatePresentation().setText(separator, false);
                this.add(action);
            }
            this.add(new SelectSeparatorAction());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/properties/editor/PropertiesGroupingStructureViewComponent$ChangeGroupSeparatorAction", "update"));
        }

        private final class SelectSeparatorAction
        extends AnAction {
            SelectSeparatorAction() {
                super(PropertiesBundle.message("select.separator.action.with.empty.separator.name", new Object[0]));
            }

            public final void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    SelectSeparatorAction.$$$reportNull$$$0(0);
                }
                String[] strings = ArrayUtil.toStringArray((Collection)ChangeGroupSeparatorAction.this.myPredefinedSeparators);
                String current = ChangeGroupSeparatorAction.this.getCurrentSeparator();
                String separator = Messages.showEditableChooseDialog((String)PropertiesBundle.message("select.property.separator.dialog.text", new Object[0]), (String)PropertiesBundle.message("select.property.separator.dialog.title", new Object[0]), (Icon)Messages.getQuestionIcon(), (String[])strings, (String)current, null);
                if (separator == null) {
                    return;
                }
                ChangeGroupSeparatorAction.this.myPredefinedSeparators.add(separator);
                ChangeGroupSeparatorAction.this.refillActionGroup();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/properties/editor/PropertiesGroupingStructureViewComponent$ChangeGroupSeparatorAction$SelectSeparatorAction", "actionPerformed"));
            }
        }
    }
}

