/*
 * Decompiled with CFR 0.152.
 */
package processing.app.ui;

import java.util.concurrent.LinkedBlockingQueue;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;

class BufferedStyledDocument
extends DefaultStyledDocument {
    LinkedBlockingQueue<DefaultStyledDocument.ElementSpec> elements;
    int maxLineLength;
    int maxLineCount;
    int maxCharCount;
    int currentLineLength = 0;
    boolean needLineBreak = false;
    final Object insertLock = new Object();

    public BufferedStyledDocument(int maxLineLength, int maxLineCount, int maxCharCount) {
        this.maxLineLength = maxLineLength;
        this.maxLineCount = maxLineCount;
        this.maxCharCount = maxCharCount;
        this.elements = new LinkedBlockingQueue();
    }

    public boolean hasAppendage() {
        return this.elements.size() > 0;
    }

    public void appendString(String str, AttributeSet a) {
        while (str.length() > 0) {
            if (this.needLineBreak || this.currentLineLength > this.maxLineLength) {
                this.elements.add(new DefaultStyledDocument.ElementSpec(a, 2));
                this.elements.add(new DefaultStyledDocument.ElementSpec(a, 1));
                this.currentLineLength = 0;
            }
            if (str.indexOf(10) == -1) {
                this.elements.add(new DefaultStyledDocument.ElementSpec(a, 3, str.toCharArray(), 0, str.length()));
                this.currentLineLength += str.length();
                this.needLineBreak = false;
                str = str.substring(str.length());
                continue;
            }
            this.elements.add(new DefaultStyledDocument.ElementSpec(a, 3, str.toCharArray(), 0, str.indexOf(10) + 1));
            this.needLineBreak = true;
            str = str.substring(str.indexOf(10) + 1);
        }
        if (this.elements.size() > 1000) {
            this.insertAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertAll() {
        DefaultStyledDocument.ElementSpec[] elementArray = this.elements.toArray(new DefaultStyledDocument.ElementSpec[0]);
        try {
            Object object = this.insertLock;
            synchronized (object) {
                this.checkLength();
                this.insert(this.getLength(), elementArray);
                this.checkLength();
            }
        }
        catch (BadLocationException badLocationException) {}
        this.elements.clear();
    }

    private void checkLength() throws BadLocationException {
        Element lineElement;
        Element element;
        int lineCount;
        int overage;
        int docLength = this.getLength();
        if (docLength > this.maxCharCount) {
            this.remove(0, docLength - this.maxCharCount);
        }
        if ((overage = (lineCount = (element = super.getDefaultRootElement()).getElementCount()) - this.maxLineCount) > 0 && (lineElement = element.getElement(overage)) != null) {
            int endOffset = lineElement.getEndOffset();
            super.remove(0, endOffset);
        }
    }
}

