/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jdt.internal.core.builder.ClasspathJar;
import org.eclipse.jdt.internal.core.builder.ClasspathLocation;
import org.eclipse.jdt.internal.core.search.matching.ClasspathSourceDirectory;
import org.eclipse.jdt.internal.core.util.Util;

public class JavaSearchNameEnvironment
implements INameEnvironment,
SuffixConstants {
    LinkedHashSet<ClasspathLocation> locationSet;
    HashMap workingCopies;

    public JavaSearchNameEnvironment(IJavaProject javaProject, org.eclipse.jdt.core.ICompilationUnit[] copies) {
        this.locationSet = this.computeClasspathLocations((JavaProject)javaProject);
        try {
            int length = copies == null ? 0 : copies.length;
            this.workingCopies = new HashMap(length);
            if (copies != null) {
                int i = 0;
                while (i < length) {
                    org.eclipse.jdt.core.ICompilationUnit workingCopy = copies[i];
                    IPackageDeclaration[] pkgs = workingCopy.getPackageDeclarations();
                    String pkg = pkgs.length > 0 ? pkgs[0].getElementName() : "";
                    String cuName = workingCopy.getElementName();
                    String mainTypeName = Util.getNameWithoutJavaLikeExtension(cuName);
                    String qualifiedMainTypeName = pkg.length() == 0 ? mainTypeName : String.valueOf(pkg.replace('.', '/')) + '/' + mainTypeName;
                    this.workingCopies.put(qualifiedMainTypeName, workingCopy);
                    ++i;
                }
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    @Override
    public void cleanup() {
        this.locationSet.clear();
    }

    void addProjectClassPath(JavaProject javaProject) {
        LinkedHashSet<ClasspathLocation> locations = this.computeClasspathLocations(javaProject);
        if (locations != null) {
            this.locationSet.addAll(locations);
        }
    }

    private LinkedHashSet<ClasspathLocation> computeClasspathLocations(JavaProject javaProject) {
        IPackageFragmentRoot[] roots = null;
        try {
            roots = javaProject.getAllPackageFragmentRoots();
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        LinkedHashSet<ClasspathLocation> locations = new LinkedHashSet<ClasspathLocation>();
        int length = roots.length;
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        int i = 0;
        while (i < length) {
            ClasspathLocation cp = this.mapToClassPathLocation(manager, (PackageFragmentRoot)roots[i]);
            if (cp != null) {
                locations.add(cp);
            }
            ++i;
        }
        return locations;
    }

    private ClasspathLocation mapToClassPathLocation(JavaModelManager manager, PackageFragmentRoot root) {
        ClasspathLocation cp = null;
        IPath path = root.getPath();
        try {
            if (root.isArchive()) {
                ClasspathEntry rawClasspathEntry = (ClasspathEntry)root.getRawClasspathEntry();
                cp = new ClasspathJar(manager.getZipFile(path), rawClasspathEntry.getAccessRuleSet(), ClasspathEntry.getExternalAnnotationPath(rawClasspathEntry, ((IJavaProject)root.getParent()).getProject(), true));
            } else {
                Object target = JavaModel.getTarget(path, true);
                if (target != null) {
                    cp = root.getKind() == 1 ? new ClasspathSourceDirectory((IContainer)target, root.fullExclusionPatternChars(), root.fullInclusionPatternChars()) : ClasspathLocation.forBinaryFolder((IContainer)target, false, ((ClasspathEntry)root.getRawClasspathEntry()).getAccessRuleSet());
                }
            }
        }
        catch (CoreException coreException) {}
        return cp;
    }

    private NameEnvironmentAnswer findClass(String qualifiedTypeName, char[] typeName) {
        String binaryFileName = null;
        String qBinaryFileName = null;
        String sourceFileName = null;
        String qSourceFileName = null;
        String qPackageName = null;
        NameEnvironmentAnswer suggestedAnswer = null;
        for (ClasspathLocation location : this.locationSet) {
            NameEnvironmentAnswer answer;
            if (location instanceof ClasspathSourceDirectory) {
                ICompilationUnit workingCopy;
                if (sourceFileName == null) {
                    sourceFileName = qSourceFileName = qualifiedTypeName;
                    qPackageName = "";
                    if (qualifiedTypeName.length() > typeName.length) {
                        int typeNameStart = qSourceFileName.length() - typeName.length;
                        qPackageName = qSourceFileName.substring(0, typeNameStart - 1);
                        sourceFileName = qSourceFileName.substring(typeNameStart);
                    }
                }
                answer = (workingCopy = (ICompilationUnit)this.workingCopies.get(qualifiedTypeName)) != null ? new NameEnvironmentAnswer(workingCopy, null) : location.findClass(sourceFileName, qPackageName, qSourceFileName);
            } else {
                if (binaryFileName == null) {
                    binaryFileName = qBinaryFileName = String.valueOf(qualifiedTypeName) + ".class";
                    qPackageName = "";
                    if (qualifiedTypeName.length() > typeName.length) {
                        int typeNameStart = qBinaryFileName.length() - typeName.length - 6;
                        qPackageName = qBinaryFileName.substring(0, typeNameStart - 1);
                        binaryFileName = qBinaryFileName.substring(typeNameStart);
                    }
                }
                answer = location.findClass(binaryFileName, qPackageName, qBinaryFileName);
            }
            if (answer == null) continue;
            if (!answer.ignoreIfBetter()) {
                if (!answer.isBetter(suggestedAnswer)) continue;
                return answer;
            }
            if (!answer.isBetter(suggestedAnswer)) continue;
            suggestedAnswer = answer;
        }
        if (suggestedAnswer != null) {
            return suggestedAnswer;
        }
        return null;
    }

    @Override
    public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName) {
        if (typeName != null) {
            return this.findClass(new String(CharOperation.concatWith(packageName, typeName, '/')), typeName);
        }
        return null;
    }

    @Override
    public NameEnvironmentAnswer findType(char[][] compoundName) {
        if (compoundName != null) {
            return this.findClass(new String(CharOperation.concatWith(compoundName, '/')), compoundName[compoundName.length - 1]);
        }
        return null;
    }

    @Override
    public boolean isPackage(char[][] compoundName, char[] packageName) {
        return this.isPackage(new String(CharOperation.concatWith(compoundName, packageName, '/')));
    }

    public boolean isPackage(String qualifiedPackageName) {
        Iterator iter = this.locationSet.iterator();
        while (iter.hasNext()) {
            if (!((ClasspathLocation)iter.next()).isPackage(qualifiedPackageName)) continue;
            return true;
        }
        return false;
    }
}

