/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.common;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class XMLUtils {
    private static final Logger LOG = LoggerFactory.getLogger(XMLUtils.class);
    public static final ErrorHandler ERROR_HANDLER = new ErrorHandler(){

        @Override
        public void warning(SAXParseException e) throws SAXException {
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            LOG.debug(e.getMessage());
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            throw e;
        }
    };

    private XMLUtils() {
    }

    public static String nullSafeGetStringAttribute(Node node, String attributeName) {
        Node namedItem;
        if (node != null && (namedItem = node.getAttributes().getNamedItem(attributeName)) != null) {
            return namedItem.getNodeValue();
        }
        return null;
    }

    public static boolean nullSafeGetBooleanAttribute(Node node, String attributeName) {
        return XMLUtils.nullSafeGetBooleanAttribute(node, attributeName, false);
    }

    public static boolean nullSafeGetBooleanAttribute(Node node, String attributeName, boolean defaultValue) {
        String value = XMLUtils.nullSafeGetStringAttribute(node, attributeName);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return Boolean.parseBoolean(value);
        }
        return defaultValue;
    }

    public static final DocumentBuilderFactory getDocumentBuilderFactory() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(true);
        factory.setFeature("http://xml.org/sax/features/validation", true);
        return factory;
    }
}

