/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.OverloadabilitySpecificityCallbacks;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilderImpl;
import org.jetbrains.kotlin.resolve.calls.results.FlatSignature;
import org.jetbrains.kotlin.resolve.calls.results.FlatSignatureKt;
import org.jetbrains.kotlin.resolve.calls.results.TypeSpecificityComparator;
import org.jetbrains.kotlin.resolve.descriptorUtil.AnnotationsForResolveKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J \u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J \u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0016H\u0002J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0013H\u0002J$\u0010\u001c\u001a\u00020\u001b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00130\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00130\u001eH\u0002J\f\u0010 \u001a\u00020\u001b*\u00020!H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/resolve/ShadowedExtensionChecker;", "", "typeSpecificityComparator", "Lorg/jetbrains/kotlin/resolve/calls/results/TypeSpecificityComparator;", "trace", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "(Lorg/jetbrains/kotlin/resolve/calls/results/TypeSpecificityComparator;Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;)V", "getTrace", "()Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "getTypeSpecificityComparator", "()Lorg/jetbrains/kotlin/resolve/calls/results/TypeSpecificityComparator;", "checkDeclaration", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "checkShadowedExtensionFunction", "extensionFunction", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "checkShadowedExtensionProperty", "extensionProperty", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "getInvokeOperatorShadowingExtensionFunction", "extension", "member", "isExtensionFunctionShadowedByMemberFunction", "", "isSignatureNotLessSpecific", "extensionSignature", "Lorg/jetbrains/kotlin/resolve/calls/results/FlatSignature;", "memberSignature", "isPublic", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorWithVisibility;", "frontend"})
public final class ShadowedExtensionChecker {
    @NotNull
    private final TypeSpecificityComparator typeSpecificityComparator;
    @NotNull
    private final DiagnosticSink trace;

    public final void checkDeclaration(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        if (declaration2.getName() == null) {
            return;
        }
        if (!(descriptor2 instanceof CallableMemberDescriptor)) {
            return;
        }
        if (AnnotationsForResolveKt.hasHidesMembersAnnotation((CallableDescriptor)descriptor2)) {
            return;
        }
        Annotated annotated = ((CallableMemberDescriptor)descriptor2).getExtensionReceiverParameter();
        if (annotated == null || (annotated = annotated.getType()) == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull(annotated, "descriptor.extensionRece\u2026Parameter?.type ?: return");
        Annotated extensionReceiverType = annotated;
        if (KotlinTypeKt.isError((KotlinType)extensionReceiverType)) {
            return;
        }
        if (((KotlinType)extensionReceiverType).isMarkedNullable()) {
            return;
        }
        DeclarationDescriptor declarationDescriptor = descriptor2;
        if (declarationDescriptor instanceof FunctionDescriptor) {
            this.checkShadowedExtensionFunction(declaration2, (FunctionDescriptor)descriptor2, this.trace);
        } else if (declarationDescriptor instanceof PropertyDescriptor) {
            this.checkShadowedExtensionProperty(declaration2, (PropertyDescriptor)descriptor2, this.trace);
        }
    }

    private final void checkShadowedExtensionFunction(KtDeclaration declaration2, FunctionDescriptor extensionFunction, DiagnosticSink trace) {
        Object object = extensionFunction.getExtensionReceiverParameter();
        if (object == null || (object = object.getType()) == null || (object = ((KotlinType)object).getMemberScope()) == null) {
            return;
        }
        Object memberScope2 = object;
        Name name = extensionFunction.getName();
        Intrinsics.checkExpressionValueIsNotNull(name, "extensionFunction.name");
        Collection<? extends SimpleFunctionDescriptor> contributedFunctions = memberScope2.getContributedFunctions(name, NoLookupLocation.WHEN_CHECK_DECLARATION_CONFLICTS);
        for (SimpleFunctionDescriptor simpleFunctionDescriptor : contributedFunctions) {
            if (!this.isPublic(simpleFunctionDescriptor) || !this.isExtensionFunctionShadowedByMemberFunction(extensionFunction, simpleFunctionDescriptor)) continue;
            trace.report(Errors.EXTENSION_SHADOWED_BY_MEMBER.on((KtDeclaration)((PsiElement)declaration2), simpleFunctionDescriptor));
            return;
        }
        Name name2 = extensionFunction.getName();
        Intrinsics.checkExpressionValueIsNotNull(name2, "extensionFunction.name");
        ClassifierDescriptor classifierDescriptor = memberScope2.getContributedClassifier(name2, NoLookupLocation.WHEN_CHECK_DECLARATION_CONFLICTS);
        if (classifierDescriptor instanceof ClassDescriptor && ((ClassDescriptor)classifierDescriptor).isInner() && this.isPublic((DeclarationDescriptorWithVisibility)((Object)classifierDescriptor))) {
            Iterator<ClassConstructorDescriptor> iterator2 = ((ClassDescriptor)classifierDescriptor).getConstructors().iterator();
            while (iterator2.hasNext()) {
                ClassConstructorDescriptor constructor2;
                ClassConstructorDescriptor classConstructorDescriptor = constructor2 = iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull(classConstructorDescriptor, "constructor");
                if (!this.isPublic(classConstructorDescriptor) || !this.isExtensionFunctionShadowedByMemberFunction(extensionFunction, constructor2)) continue;
                trace.report(Errors.EXTENSION_FUNCTION_SHADOWED_BY_INNER_CLASS_CONSTRUCTOR.on((KtDeclaration)((PsiElement)declaration2), constructor2));
                return;
            }
        }
        Name name3 = extensionFunction.getName();
        Intrinsics.checkExpressionValueIsNotNull(name3, "extensionFunction.name");
        Collection<? extends PropertyDescriptor> contributedVariables = memberScope2.getContributedVariables(name3, NoLookupLocation.WHEN_CHECK_DECLARATION_CONFLICTS);
        for (PropertyDescriptor propertyDescriptor2 : contributedVariables) {
            FunctionDescriptor invokeOperator;
            if (!this.isPublic(propertyDescriptor2) || (invokeOperator = this.getInvokeOperatorShadowingExtensionFunction(extensionFunction, propertyDescriptor2)) == null) continue;
            trace.report(Errors.EXTENSION_FUNCTION_SHADOWED_BY_MEMBER_PROPERTY_WITH_INVOKE.on((KtDeclaration)((PsiElement)declaration2), propertyDescriptor2, invokeOperator));
            return;
        }
    }

    private final boolean isPublic(@NotNull DeclarationDescriptorWithVisibility $this$isPublic) {
        return Intrinsics.areEqual($this$isPublic.getVisibility().normalize(), Visibilities.PUBLIC);
    }

    private final boolean isExtensionFunctionShadowedByMemberFunction(FunctionDescriptor extension, FunctionDescriptor member) {
        if (extension.getValueParameters().size() != member.getValueParameters().size()) {
            return false;
        }
        if (DescriptorUtilsKt.varargParameterPosition(extension) != DescriptorUtilsKt.varargParameterPosition(member)) {
            return false;
        }
        if (extension.isOperator() && !member.isOperator()) {
            return false;
        }
        if (extension.isInfix() && !member.isInfix()) {
            return false;
        }
        FlatSignature<CallableDescriptor> extensionSignature = FlatSignature.Companion.createForPossiblyShadowedExtension((CallableDescriptor)extension);
        FlatSignature<CallableDescriptor> memberSignature = FlatSignature.Companion.createFromCallableDescriptor((CallableDescriptor)member);
        return this.isSignatureNotLessSpecific(extensionSignature, memberSignature);
    }

    private final FunctionDescriptor getInvokeOperatorShadowingExtensionFunction(FunctionDescriptor extension, PropertyDescriptor member) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = member.getType().getMemberScope().getContributedFunctions(OperatorNameConventions.INVOKE, NoLookupLocation.WHEN_CHECK_DECLARATION_CONFLICTS);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                SimpleFunctionDescriptor it = (SimpleFunctionDescriptor)element$iv;
                boolean bl = false;
                if (!(this.isPublic(it) && it.isOperator() && this.isExtensionFunctionShadowedByMemberFunction(extension, it))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final boolean isSignatureNotLessSpecific(FlatSignature<? extends FunctionDescriptor> extensionSignature, FlatSignature<? extends FunctionDescriptor> memberSignature) {
        return FlatSignatureKt.isSignatureNotLessSpecific(ConstraintSystemBuilderImpl.Companion.forSpecificity(), extensionSignature, memberSignature, OverloadabilitySpecificityCallbacks.INSTANCE, this.typeSpecificityComparator);
    }

    private final void checkShadowedExtensionProperty(KtDeclaration declaration2, PropertyDescriptor extensionProperty, DiagnosticSink trace) {
        block3: {
            Object v2;
            block2: {
                Object object = extensionProperty.getExtensionReceiverParameter();
                if (object == null || (object = object.getType()) == null || (object = ((KotlinType)object).getMemberScope()) == null) {
                    return;
                }
                Object memberScope2 = object;
                Name name = extensionProperty.getName();
                Intrinsics.checkExpressionValueIsNotNull(name, "extensionProperty.name");
                Iterable $this$firstOrNull$iv = memberScope2.getContributedVariables(name, NoLookupLocation.WHEN_CHECK_DECLARATION_CONFLICTS);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PropertyDescriptor it = (PropertyDescriptor)element$iv;
                    boolean bl = false;
                    if (!(this.isPublic(it) && !DescriptorUtilsKt.isExtension(it))) continue;
                    v2 = element$iv;
                    break block2;
                }
                v2 = null;
            }
            PropertyDescriptor propertyDescriptor2 = v2;
            if (propertyDescriptor2 == null) break block3;
            PropertyDescriptor propertyDescriptor3 = propertyDescriptor2;
            boolean bl = false;
            boolean bl2 = false;
            PropertyDescriptor memberProperty = propertyDescriptor3;
            boolean bl3 = false;
            trace.report(Errors.EXTENSION_SHADOWED_BY_MEMBER.on((KtDeclaration)((PsiElement)declaration2), memberProperty));
        }
    }

    @NotNull
    public final TypeSpecificityComparator getTypeSpecificityComparator() {
        return this.typeSpecificityComparator;
    }

    @NotNull
    public final DiagnosticSink getTrace() {
        return this.trace;
    }

    public ShadowedExtensionChecker(@NotNull TypeSpecificityComparator typeSpecificityComparator, @NotNull DiagnosticSink trace) {
        Intrinsics.checkParameterIsNotNull(typeSpecificityComparator, "typeSpecificityComparator");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        this.typeSpecificityComparator = typeSpecificityComparator;
        this.trace = trace;
    }
}

