/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointAndAreaListener;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.LoadingOrder;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.impl.ExtensionComponentAdapter;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import com.intellij.openapi.extensions.impl.XmlExtensionAdapter;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.OpenTHashSet;
import com.intellij.util.containers.StringInterner;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.PicoContainer;

public abstract class ExtensionPointImpl<T>
implements ExtensionPoint<T> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.extensions.impl.ExtensionPointImpl");
    private static Set<ExtensionPointImpl<?>> POINTS_IN_READONLY_MODE;
    private final String myName;
    private final String myClassName;
    private volatile List<T> myExtensionsCache;
    @Nullable
    private volatile T[] myExtensionsCacheAsArray;
    protected final ExtensionsAreaImpl myOwner;
    private final PluginDescriptor myDescriptor;
    @NotNull
    protected List<ExtensionComponentAdapter> myAdapters;
    @NotNull
    private List<ExtensionComponentAdapter> myLoadedAdapters;
    @NotNull
    private ExtensionPointListener<T>[] myListeners;
    @Nullable
    protected Class<T> myExtensionClass;
    private static final StringInterner INTERNER;
    private boolean processingAdaptersNow;
    static Runnable CHECK_CANCELED;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ExtensionPointImpl(@NotNull String name, @NotNull String className2, @NotNull ExtensionsAreaImpl owner, @NotNull PluginDescriptor pluginDescriptor) {
        if (name == null) {
            ExtensionPointImpl.$$$reportNull$$$0(0);
        }
        if (className2 == null) {
            ExtensionPointImpl.$$$reportNull$$$0(1);
        }
        if (owner == null) {
            ExtensionPointImpl.$$$reportNull$$$0(2);
        }
        if (pluginDescriptor == null) {
            ExtensionPointImpl.$$$reportNull$$$0(3);
        }
        this.myAdapters = Collections.emptyList();
        this.myLoadedAdapters = Collections.emptyList();
        this.myListeners = ExtensionPointListener.EMPTY_ARRAY;
        StringInterner stringInterner = INTERNER;
        synchronized (stringInterner) {
            this.myName = INTERNER.intern(name);
        }
        this.myClassName = className2;
        this.myOwner = owner;
        this.myDescriptor = pluginDescriptor;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            ExtensionPointImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    public AreaInstance getArea() {
        return this.myOwner.getAreaInstance();
    }

    @NotNull
    public String getClassName() {
        String string = this.myClassName;
        if (string == null) {
            ExtensionPointImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    public void registerExtension(@NotNull T extension) {
        if (extension == null) {
            ExtensionPointImpl.$$$reportNull$$$0(6);
        }
        this.registerExtension(extension, LoadingOrder.ANY, null);
    }

    @Override
    public void registerExtension(@NotNull T extension, @NotNull Disposable parentDisposable) {
        if (extension == null) {
            ExtensionPointImpl.$$$reportNull$$$0(9);
        }
        if (parentDisposable == null) {
            ExtensionPointImpl.$$$reportNull$$$0(10);
        }
        this.registerExtension(extension, LoadingOrder.ANY, parentDisposable);
    }

    @NotNull
    final PluginDescriptor getDescriptor() {
        PluginDescriptor pluginDescriptor = this.myDescriptor;
        if (pluginDescriptor == null) {
            ExtensionPointImpl.$$$reportNull$$$0(11);
        }
        return pluginDescriptor;
    }

    public synchronized void registerExtension(final @NotNull T extension, @NotNull LoadingOrder order2, @Nullable Disposable parentDisposable) {
        if (extension == null) {
            ExtensionPointImpl.$$$reportNull$$$0(12);
        }
        if (order2 == null) {
            ExtensionPointImpl.$$$reportNull$$$0(13);
        }
        this.checkReadOnlyMode();
        for (ExtensionComponentAdapter adapter : this.myLoadedAdapters) {
            if (!(adapter instanceof ObjectComponentAdapter) || ((ObjectComponentAdapter)adapter).myComponentInstance != extension) continue;
            LOG.error("Extension was already added: " + extension);
            return;
        }
        final ObjectComponentAdapter adapter = new ObjectComponentAdapter(extension, order2);
        if (LoadingOrder.ANY == order2) {
            this.registerExtension(extension, adapter, this.findInsertionIndexForAnyOrder(), true);
        } else {
            this.registerExtensionAdapter(adapter);
            this.getExtensionList();
        }
        if (parentDisposable == null) {
            return;
        }
        Disposer.register(parentDisposable, new Disposable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dispose() {
                ExtensionPointImpl extensionPointImpl = ExtensionPointImpl.this;
                synchronized (extensionPointImpl) {
                    List<ExtensionComponentAdapter> list2 = ExtensionPointImpl.this.myLoadedAdapters;
                    int index2 = ContainerUtil.indexOfIdentity(list2, adapter);
                    if (index2 < 0) {
                        list2 = ExtensionPointImpl.this.myAdapters;
                        index2 = ContainerUtil.indexOfIdentity(list2, adapter);
                    }
                    if (index2 < 0) {
                        LOG.error("Extension to be removed not found: " + extension);
                    }
                    list2.remove(index2);
                    ExtensionPointImpl.this.clearCache();
                    ExtensionPointImpl.this.notifyListenersOnRemove(extension, adapter.getPluginDescriptor(), ExtensionPointImpl.this.myListeners);
                }
            }
        });
    }

    private synchronized int findInsertionIndexForAnyOrder() {
        ExtensionComponentAdapter lastAdapter;
        int index2;
        for (index2 = this.myLoadedAdapters.size(); index2 > 0 && (lastAdapter = this.myLoadedAdapters.get(index2 - 1)).getOrder() == LoadingOrder.LAST; --index2) {
        }
        return index2;
    }

    private synchronized void registerExtension(@NotNull T extension, @NotNull ExtensionComponentAdapter adapter, int index2, boolean runNotifications) {
        Class<T> extensionClass;
        if (extension == null) {
            ExtensionPointImpl.$$$reportNull$$$0(15);
        }
        if (adapter == null) {
            ExtensionPointImpl.$$$reportNull$$$0(16);
        }
        if (!(extensionClass = this.getExtensionClass()).isInstance(extension)) {
            throw new RuntimeException("Extension " + extension.getClass() + " does not implement " + extensionClass + ". It came from " + adapter);
        }
        if (this.myLoadedAdapters == Collections.emptyList()) {
            this.myLoadedAdapters = new ArrayList<ExtensionComponentAdapter>();
        }
        if (index2 == -1) {
            this.myLoadedAdapters.add(adapter);
        } else {
            this.myLoadedAdapters.add(index2, adapter);
        }
        if (runNotifications) {
            this.clearCache();
            if (!adapter.isNotificationSent()) {
                this.notifyListenersOnAdd(extension, adapter.getPluginDescriptor(), this.myListeners);
                adapter.setNotificationSent();
            }
        }
    }

    private void notifyListenersOnAdd(@NotNull T extension, @Nullable PluginDescriptor pluginDescriptor, @NotNull ExtensionPointListener<T>[] listeners) {
        if (extension == null) {
            ExtensionPointImpl.$$$reportNull$$$0(17);
        }
        if (listeners == null) {
            ExtensionPointImpl.$$$reportNull$$$0(18);
        }
        for (ExtensionPointListener<T> listener : listeners) {
            try {
                listener.extensionAdded(extension, pluginDescriptor);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<T> getExtensionList() {
        List<T> result2 = this.myExtensionsCache;
        if (result2 == null) {
            ExtensionPointImpl extensionPointImpl = this;
            synchronized (extensionPointImpl) {
                result2 = this.myExtensionsCache;
                if (result2 == null) {
                    T[] array = this.processAdapters();
                    this.myExtensionsCacheAsArray = array;
                    this.myExtensionsCache = result2 = array.length == 0 ? Collections.emptyList() : ContainerUtil.immutableList(array);
                }
            }
        }
        List<T> list2 = result2;
        if (list2 == null) {
            ExtensionPointImpl.$$$reportNull$$$0(19);
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public T[] getExtensions() {
        T[] array = this.myExtensionsCacheAsArray;
        if (array == null) {
            ExtensionPointImpl extensionPointImpl = this;
            synchronized (extensionPointImpl) {
                array = this.myExtensionsCacheAsArray;
                if (array == null) {
                    this.myExtensionsCacheAsArray = array = this.processAdapters();
                    this.myExtensionsCache = array.length == 0 ? Collections.emptyList() : ContainerUtil.immutableList(array);
                }
            }
        }
        Object[] objectArray = array.length == 0 ? array : (Object[])array.clone();
        if (objectArray == null) {
            ExtensionPointImpl.$$$reportNull$$$0(20);
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasAnyExtensions() {
        List<T> cache2 = this.myExtensionsCache;
        if (cache2 != null) {
            return !cache2.isEmpty();
        }
        ExtensionPointImpl extensionPointImpl = this;
        synchronized (extensionPointImpl) {
            return this.myAdapters.size() + this.myLoadedAdapters.size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private synchronized T[] processAdapters() {
        Object[] objectArray;
        block15: {
            if (this.processingAdaptersNow) {
                throw new IllegalStateException("Recursive processAdapters() detected. You must have called 'getExtensions()' from within your extension constructor - don't. Either pass extension via constructor parameter or call getExtensions() later.");
            }
            this.checkReadOnlyMode();
            int totalSize = this.myAdapters.size() + this.myLoadedAdapters.size();
            Class<T> extensionClass = this.getExtensionClass();
            Object[] result2 = (Object[])Array.newInstance(extensionClass, totalSize);
            if (totalSize == 0) {
                if (result2 == null) {
                    ExtensionPointImpl.$$$reportNull$$$0(22);
                }
                return result2;
            }
            CHECK_CANCELED.run();
            this.processingAdaptersNow = true;
            LoadingOrder.Orderable[] adapters = this.myAdapters.toArray(new ExtensionComponentAdapter[totalSize]);
            ArrayUtil.copy(this.myLoadedAdapters, adapters, this.myAdapters.size());
            LoadingOrder.sort(adapters);
            Set<ExtensionComponentAdapter> loaded = ContainerUtil.newHashOrEmptySet(this.myLoadedAdapters);
            OpenTHashSet duplicates = new OpenTHashSet(adapters.length);
            this.myLoadedAdapters = Collections.emptyList();
            this.myAdapters = Collections.emptyList();
            int extensionIndex = 0;
            for (int i = 0; i < adapters.length; ++i) {
                LoadingOrder.Orderable adapter = adapters[i];
                try {
                    Object extension = ((ExtensionComponentAdapter)adapter).createInstance(this.myOwner.getPicoContainer());
                    if (!duplicates.add(extension)) {
                        Object duplicate = duplicates.get(extension);
                        LOG.error("Duplicate extension found: " + extension + ";  Prev extension:  " + duplicate + ";\n Adapter:         " + adapter + ";\n Extension class: " + this.getExtensionClass() + ";\n result:" + Arrays.asList(result2));
                        continue;
                    }
                    this.registerExtension(extension, (ExtensionComponentAdapter)adapter, -1, !loaded.contains(adapter));
                    result2[extensionIndex++] = extension;
                    continue;
                }
                catch (ExtensionNotApplicableException ignore) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug(adapter + " not loaded because it reported that not applicable");
                    continue;
                }
                catch (ProcessCanceledException e) {
                    this.addBackNotLoadedAdapters((ExtensionComponentAdapter[])adapters, i);
                    throw e;
                }
                catch (Throwable e) {
                    try {
                        LOG.error(e);
                        continue;
                    }
                    catch (Throwable testError) {
                        this.addBackNotLoadedAdapters((ExtensionComponentAdapter[])adapters, i);
                        throw testError;
                    }
                }
            }
            if (extensionIndex != result2.length) {
                result2 = Arrays.copyOf(result2, extensionIndex);
            }
            objectArray = result2;
            if (objectArray != null) break block15;
            ExtensionPointImpl.$$$reportNull$$$0(23);
        }
        return objectArray;
        finally {
            this.processingAdaptersNow = false;
        }
    }

    private synchronized void addBackNotLoadedAdapters(@NotNull ExtensionComponentAdapter[] allAdapters, int failedIndex) {
        if (allAdapters == null) {
            ExtensionPointImpl.$$$reportNull$$$0(24);
        }
        ArrayList<ExtensionComponentAdapter> adapters = new ArrayList<ExtensionComponentAdapter>(allAdapters.length - failedIndex);
        for (int i = failedIndex; i < allAdapters.length; ++i) {
            adapters.add(allAdapters[i]);
        }
        this.myAdapters = adapters;
    }

    private void notifyListenersOnRemove(@NotNull T extensionObject, @Nullable PluginDescriptor pluginDescriptor, @NotNull ExtensionPointListener<T>[] listeners) {
        if (extensionObject == null) {
            ExtensionPointImpl.$$$reportNull$$$0(32);
        }
        if (listeners == null) {
            ExtensionPointImpl.$$$reportNull$$$0(33);
        }
        for (ExtensionPointListener<T> listener : listeners) {
            try {
                listener.extensionRemoved(extensionObject, pluginDescriptor);
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
    }

    @Override
    public synchronized void addExtensionPointListener(@NotNull ExtensionPointListener<T> listener, boolean invokeForLoadedExtensions, @Nullable Disposable parentDisposable) {
        if (listener == null) {
            ExtensionPointImpl.$$$reportNull$$$0(34);
        }
        if (invokeForLoadedExtensions) {
            this.addExtensionPointListener(listener);
        } else {
            this.addListener(listener);
        }
        if (parentDisposable != null) {
            Disposer.register(parentDisposable, () -> this.removeExtensionPointListener(listener));
        }
    }

    private synchronized boolean addListener(@NotNull ExtensionPointListener<T> listener) {
        if (listener == null) {
            ExtensionPointImpl.$$$reportNull$$$0(35);
        }
        if (ArrayUtil.indexOf(this.myListeners, listener) != -1) {
            return false;
        }
        this.myListeners = ArrayUtil.append(this.myListeners, listener, n -> n == 0 ? ExtensionPointListener.EMPTY_ARRAY : new ExtensionPointListener[n]);
        return true;
    }

    private synchronized boolean removeListener(@NotNull ExtensionPointListener<T> listener) {
        if (listener == null) {
            ExtensionPointImpl.$$$reportNull$$$0(36);
        }
        if (ArrayUtil.indexOf(this.myListeners, listener) == -1) {
            return false;
        }
        this.myListeners = ArrayUtil.remove(this.myListeners, listener, n -> n == 0 ? ExtensionPointListener.EMPTY_ARRAY : new ExtensionPointListener[n]);
        return true;
    }

    public synchronized void addExtensionPointListener(@NotNull ExtensionPointListener<T> listener) {
        if (listener == null) {
            ExtensionPointImpl.$$$reportNull$$$0(37);
        }
        this.getExtensionList();
        if (this.addListener(listener)) {
            this.notifyListenersAboutLoadedExtensions(this.myLoadedAdapters, listener, false);
        }
    }

    @Override
    public void removeExtensionPointListener(@NotNull ExtensionPointListener<T> listener) {
        if (listener == null) {
            ExtensionPointImpl.$$$reportNull$$$0(38);
        }
        this.removeListener(listener);
    }

    private synchronized void notifyListenersAboutLoadedExtensions(@NotNull List<ExtensionComponentAdapter> loadedAdapters, @Nullable ExtensionPointListener<T> onlyListener, boolean isRemoved) {
        ExtensionPointListener<T>[] listeners;
        if (loadedAdapters == null) {
            ExtensionPointImpl.$$$reportNull$$$0(39);
        }
        if ((listeners = this.myListeners).length == 0) {
            return;
        }
        T[] extensions = this.myExtensionsCacheAsArray;
        int size = loadedAdapters.size();
        for (int i = 0; i < size; ++i) {
            Object extension;
            ExtensionComponentAdapter adapter = loadedAdapters.get(i);
            if (adapter instanceof ObjectComponentAdapter) {
                extension = ((ObjectComponentAdapter)adapter).myComponentInstance;
            } else {
                if (extensions == null) continue;
                extension = extensions[i];
            }
            if (isRemoved) {
                if (onlyListener == null) {
                    this.notifyListenersOnRemove(extension, adapter.getPluginDescriptor(), listeners);
                    continue;
                }
                onlyListener.extensionRemoved(extension, adapter.getPluginDescriptor());
                continue;
            }
            if (onlyListener == null) {
                this.notifyListenersOnAdd(extension, adapter.getPluginDescriptor(), listeners);
                continue;
            }
            onlyListener.extensionAdded(extension, adapter.getPluginDescriptor());
        }
    }

    @NotNull
    public Class<T> getExtensionClass() {
        Class<Object> extensionClass = this.myExtensionClass;
        if (extensionClass == null) {
            try {
                ClassLoader pluginClassLoader = this.myDescriptor.getPluginClassLoader();
                Class<?> extClass = pluginClassLoader == null ? Class.forName(this.myClassName) : Class.forName(this.myClassName, true, pluginClassLoader);
                this.myExtensionClass = extensionClass = extClass;
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        Class<T> clazz2 = extensionClass;
        if (clazz2 == null) {
            ExtensionPointImpl.$$$reportNull$$$0(40);
        }
        return clazz2;
    }

    public String toString() {
        return this.getName();
    }

    synchronized void registerExtensionAdapter(@NotNull ExtensionComponentAdapter adapter) {
        if (adapter == null) {
            ExtensionPointImpl.$$$reportNull$$$0(41);
        }
        if (this.myAdapters == Collections.emptyList()) {
            this.myAdapters = new ArrayList<ExtensionComponentAdapter>();
        }
        this.myAdapters.add(adapter);
        this.clearCache();
    }

    private synchronized void clearCache() {
        this.myExtensionsCache = null;
        this.myExtensionsCacheAsArray = null;
        this.checkReadOnlyMode();
    }

    private void checkReadOnlyMode() {
        if (this.isInReadOnlyMode()) {
            throw new IllegalStateException(this + " in a read-only mode and cannot be modified");
        }
    }

    @NotNull
    protected abstract ExtensionComponentAdapter createAdapter(@NotNull Element var1, @NotNull PluginDescriptor var2);

    @NotNull
    ExtensionComponentAdapter createAndRegisterAdapter(@NotNull Element extensionElement, @NotNull PluginDescriptor pluginDescriptor) {
        if (extensionElement == null) {
            ExtensionPointImpl.$$$reportNull$$$0(43);
        }
        if (pluginDescriptor == null) {
            ExtensionPointImpl.$$$reportNull$$$0(44);
        }
        ExtensionComponentAdapter adapter = this.createAdapter(extensionElement, pluginDescriptor);
        this.registerExtensionAdapter(adapter);
        ExtensionComponentAdapter extensionComponentAdapter = adapter;
        if (extensionComponentAdapter == null) {
            ExtensionPointImpl.$$$reportNull$$$0(45);
        }
        return extensionComponentAdapter;
    }

    @NotNull
    protected static ExtensionComponentAdapter doCreateAdapter(@NotNull String implementationClassName, @NotNull Element extensionElement, boolean isNeedToDeserialize, @NotNull PluginDescriptor pluginDescriptor, boolean isConstructorInjectionSupported) {
        Element effectiveElement;
        if (implementationClassName == null) {
            ExtensionPointImpl.$$$reportNull$$$0(46);
        }
        if (extensionElement == null) {
            ExtensionPointImpl.$$$reportNull$$$0(47);
        }
        if (pluginDescriptor == null) {
            ExtensionPointImpl.$$$reportNull$$$0(48);
        }
        String orderId = extensionElement.getAttributeValue("id");
        LoadingOrder order2 = LoadingOrder.readOrder(extensionElement.getAttributeValue("order"));
        Element element = effectiveElement = isNeedToDeserialize ? extensionElement : null;
        if (isConstructorInjectionSupported) {
            XmlExtensionAdapter.ConstructorInjectionAdapter constructorInjectionAdapter = new XmlExtensionAdapter.ConstructorInjectionAdapter(implementationClassName, pluginDescriptor, orderId, order2, effectiveElement);
            if (constructorInjectionAdapter == null) {
                ExtensionPointImpl.$$$reportNull$$$0(49);
            }
            return constructorInjectionAdapter;
        }
        XmlExtensionAdapter xmlExtensionAdapter = new XmlExtensionAdapter(implementationClassName, pluginDescriptor, orderId, order2, effectiveElement);
        if (xmlExtensionAdapter == null) {
            ExtensionPointImpl.$$$reportNull$$$0(50);
        }
        return xmlExtensionAdapter;
    }

    final synchronized void notifyAreaReplaced(@NotNull ExtensionsArea oldArea) {
        if (oldArea == null) {
            ExtensionPointImpl.$$$reportNull$$$0(51);
        }
        for (ExtensionPointListener<T> listener : this.myListeners) {
            if (!(listener instanceof ExtensionPointAndAreaListener)) continue;
            ((ExtensionPointAndAreaListener)listener).areaReplaced(oldArea);
        }
    }

    public synchronized boolean isInReadOnlyMode() {
        return POINTS_IN_READONLY_MODE != null && POINTS_IN_READONLY_MODE.contains(this);
    }

    static {
        INTERNER = new StringInterner();
        CHECK_CANCELED = EmptyRunnable.getInstance();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 40: 
            case 45: 
            case 49: 
            case 50: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 40: 
            case 45: 
            case 49: 
            case 50: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 3: 
            case 44: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 40: 
            case 45: 
            case 49: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/extensions/impl/ExtensionPointImpl";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 15: 
            case 17: 
            case 25: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "order";
                break;
            }
            case 10: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensions";
                break;
            }
            case 16: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "adapter";
                break;
            }
            case 18: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listeners";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allAdapters";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionClass";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionClassFilter";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionObject";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loadedAdapters";
                break;
            }
            case 43: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionElement";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implementationClassName";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldArea";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/extensions/impl/ExtensionPointImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptor";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionList";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensions";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "extensions";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "processAdapters";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionClass";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "createAndRegisterAdapter";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateAdapter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 40: 
            case 45: 
            case 49: 
            case 50: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "registerExtension";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensions";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "notifyListenersOnAdd";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addBackNotLoadedAdapters";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "hasExtension";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "maskAll";
                break;
            }
            case 28: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "unregisterExtensions";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "unregisterExtension";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "notifyListenersOnRemove";
                break;
            }
            case 34: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "addExtensionPointListener";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "removeExtensionPointListener";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "notifyListenersAboutLoadedExtensions";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensionAdapter";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "unregisterExtensionAdapter";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "createAndRegisterAdapter";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "doCreateAdapter";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "notifyAreaReplaced";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 40: 
            case 45: 
            case 49: 
            case 50: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ObjectComponentAdapter<T>
    extends ExtensionComponentAdapter {
        private final T myComponentInstance;

        private ObjectComponentAdapter(@NotNull T extension, @NotNull LoadingOrder loadingOrder) {
            if (extension == null) {
                ObjectComponentAdapter.$$$reportNull$$$0(0);
            }
            if (loadingOrder == null) {
                ObjectComponentAdapter.$$$reportNull$$$0(1);
            }
            super(extension.getClass().getName(), null, null, loadingOrder);
            this.myComponentInstance = extension;
        }

        @NotNull
        public T createInstance(@Nullable PicoContainer container) {
            T t = this.myComponentInstance;
            if (t == null) {
                ObjectComponentAdapter.$$$reportNull$$$0(2);
            }
            return t;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extension";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "loadingOrder";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/extensions/impl/ExtensionPointImpl$ObjectComponentAdapter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/extensions/impl/ExtensionPointImpl$ObjectComponentAdapter";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createInstance";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

