"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardGridContainer = void 0;

var _reactRedux = require("react-redux");

var _actions = require("../actions");

var _selectors = require("../selectors");

var _dashboard_grid = require("./dashboard_grid");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var mapStateToProps = function mapStateToProps(_ref) {
  var dashboard = _ref.dashboard;
  return {
    panels: (0, _selectors.getPanels)(dashboard),
    dashboardViewMode: (0, _selectors.getViewMode)(dashboard),
    useMargins: (0, _selectors.getUseMargins)(dashboard)
  };
};

var mapDispatchToProps = function mapDispatchToProps(dispatch) {
  return {
    onPanelsUpdated: function onPanelsUpdated(updatedPanels) {
      return dispatch((0, _actions.updatePanels)(updatedPanels));
    }
  };
};

var DashboardGridContainer = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(_dashboard_grid.DashboardGrid);
exports.DashboardGridContainer = DashboardGridContainer;