"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "ExpressionRenderer", {
  enumerable: true,
  get: function get() {
    return _expressions.ExpressionRenderer;
  }
});
Object.defineProperty(exports, "ExpressionRendererProps", {
  enumerable: true,
  get: function get() {
    return _expressions.ExpressionRendererProps;
  }
});
Object.defineProperty(exports, "ExpressionRunner", {
  enumerable: true,
  get: function get() {
    return _expressions.ExpressionRunner;
  }
});
Object.defineProperty(exports, "Query", {
  enumerable: true,
  get: function get() {
    return _query.Query;
  }
});
Object.defineProperty(exports, "IndexPattern", {
  enumerable: true,
  get: function get() {
    return _index_patterns.IndexPattern;
  }
});
Object.defineProperty(exports, "StaticIndexPattern", {
  enumerable: true,
  get: function get() {
    return _index_patterns.StaticIndexPattern;
  }
});
Object.defineProperty(exports, "StaticIndexPatternField", {
  enumerable: true,
  get: function get() {
    return _index_patterns.StaticIndexPatternField;
  }
});
Object.defineProperty(exports, "Field", {
  enumerable: true,
  get: function get() {
    return _index_patterns.Field;
  }
});
Object.defineProperty(exports, "FilterManager", {
  enumerable: true,
  get: function get() {
    return _filter_manager.FilterManager;
  }
});
Object.defineProperty(exports, "FilterStateManager", {
  enumerable: true,
  get: function get() {
    return _filter_manager.FilterStateManager;
  }
});
Object.defineProperty(exports, "uniqFilters", {
  enumerable: true,
  get: function get() {
    return _filter_manager.uniqFilters;
  }
});
Object.defineProperty(exports, "dateHistogramInterval", {
  enumerable: true,
  get: function get() {
    return _date_histogram_interval.dateHistogramInterval;
  }
});
Object.defineProperty(exports, "isValidEsInterval", {
  enumerable: true,
  get: function get() {
    return _parse_es_interval.isValidEsInterval;
  }
});
Object.defineProperty(exports, "InvalidEsCalendarIntervalError", {
  enumerable: true,
  get: function get() {
    return _parse_es_interval.InvalidEsCalendarIntervalError;
  }
});
Object.defineProperty(exports, "InvalidEsIntervalFormatError", {
  enumerable: true,
  get: function get() {
    return _parse_es_interval.InvalidEsIntervalFormatError;
  }
});
Object.defineProperty(exports, "parseEsInterval", {
  enumerable: true,
  get: function get() {
    return _parse_es_interval.parseEsInterval;
  }
});
Object.defineProperty(exports, "ParsedInterval", {
  enumerable: true,
  get: function get() {
    return _parse_es_interval.ParsedInterval;
  }
});
exports.DataPlugin = void 0;

var _registries = require("plugins/interpreter/registries");

var _expressions = require("./expressions");

var _search = require("./search");

var _query = require("./query");

var _filter = require("./filter");

var _index_patterns = require("./index_patterns");

var _filter_manager = require("./filter/filter_manager");

var _date_histogram_interval = require("../common/date_histogram_interval");

var _parse_es_interval = require("../common/parse_es_interval");

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var DataPlugin =
/*#__PURE__*/
function () {
  // Exposed services, sorted alphabetically
  function DataPlugin() {
    _classCallCheck(this, DataPlugin);

    _defineProperty(this, "expressions", void 0);

    _defineProperty(this, "filter", void 0);

    _defineProperty(this, "indexPatterns", void 0);

    _defineProperty(this, "search", void 0);

    _defineProperty(this, "query", void 0);

    this.indexPatterns = new _index_patterns.IndexPatternsService();
    this.filter = new _filter.FilterService();
    this.query = new _query.QueryService();
    this.search = new _search.SearchService();
    this.expressions = new _expressions.ExpressionsService();
  }

  _createClass(DataPlugin, [{
    key: "setup",
    value: function setup() {
      // TODO: this is imported here to avoid circular imports.
      // eslint-disable-next-line @typescript-eslint/no-var-requires
      var _require = require('plugins/interpreter/interpreter'),
          getInterpreter = _require.getInterpreter;

      var indexPatternsService = this.indexPatterns.setup();
      return {
        expressions: this.expressions.setup({
          interpreter: {
            getInterpreter: getInterpreter,
            renderersRegistry: _registries.renderersRegistry
          }
        }),
        indexPatterns: indexPatternsService,
        filter: this.filter.setup({
          indexPatterns: indexPatternsService.indexPatterns
        }),
        search: this.search.setup(),
        query: this.query.setup()
      };
    }
  }, {
    key: "stop",
    value: function stop() {
      this.expressions.stop();
      this.indexPatterns.stop();
      this.filter.stop();
      this.search.stop();
      this.query.stop();
    }
  }]);

  return DataPlugin;
}();
/** @public */


exports.DataPlugin = DataPlugin;