"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
var __values = (this && this.__values) || function (o) {
    var m = typeof Symbol === "function" && o[Symbol.iterator], i = 0;
    if (m) return m.call(o);
    return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
};
Object.defineProperty(exports, "__esModule", { value: true });
var axis_utils_1 = require("../lib/axes/axis_utils");
var x_domain_1 = require("../lib/series/domains/x_domain");
var y_domain_1 = require("../lib/series/domains/y_domain");
var rendering_1 = require("../lib/series/rendering");
var scales_1 = require("../lib/series/scales");
var series_1 = require("../lib/series/series");
var specs_1 = require("../lib/series/specs");
var commons_1 = require("../lib/utils/commons");
var MAX_ANIMATABLE_BARS = 300;
var MAX_ANIMATABLE_LINES_AREA_POINTS = 600;
function updateDeselectedDataSeries(series, value) {
    var seriesIndex = series_1.findDataSeriesByColorValues(series, value);
    var updatedSeries = series ? __spread(series) : [];
    if (seriesIndex > -1) {
        updatedSeries.splice(seriesIndex, 1);
    }
    else {
        updatedSeries.push(value);
    }
    return updatedSeries;
}
exports.updateDeselectedDataSeries = updateDeselectedDataSeries;
function getUpdatedCustomSeriesColors(seriesSpecs) {
    var updatedCustomSeriesColors = new Map();
    seriesSpecs.forEach(function (spec) {
        if (spec.customSeriesColors) {
            spec.customSeriesColors.forEach(function (color, seriesColorValues) {
                var colorValues = seriesColorValues.colorValues, specId = seriesColorValues.specId;
                var seriesLabel = series_1.getColorValuesAsString(colorValues, specId);
                updatedCustomSeriesColors.set(seriesLabel, color);
            });
        }
    });
    return updatedCustomSeriesColors;
}
exports.getUpdatedCustomSeriesColors = getUpdatedCustomSeriesColors;
/**
 *
 * @param seriesSpecs
 * @param selectedDataSeries is optional; if not supplied,
 * then all series will be factored into computations. Otherwise, selectedDataSeries
 * is used to restrict the computation for just the selected series
 * @returns `SeriesDomainsAndData`
 */
function computeSeriesDomains(seriesSpecs, domainsByGroupId, customXDomain, deselectedDataSeries) {
    var _a = series_1.getSplittedSeries(seriesSpecs, deselectedDataSeries), splittedSeries = _a.splittedSeries, xValues = _a.xValues, seriesColors = _a.seriesColors;
    // tslint:disable-next-line:no-console
    // console.log({ splittedSeries, xValues, seriesColors });
    var splittedDataSeries = __spread(splittedSeries.values());
    var specsArray = __spread(seriesSpecs.values());
    var xDomain = x_domain_1.mergeXDomain(specsArray, xValues, customXDomain);
    var yDomain = y_domain_1.mergeYDomain(splittedSeries, specsArray, domainsByGroupId);
    var formattedDataSeries = series_1.getFormattedDataseries(specsArray, splittedSeries);
    // tslint:disable-next-line:no-console
    // console.log({ formattedDataSeries, xDomain, yDomain });
    return {
        xDomain: xDomain,
        yDomain: yDomain,
        splittedDataSeries: splittedDataSeries,
        formattedDataSeries: formattedDataSeries,
        seriesColors: seriesColors,
    };
}
exports.computeSeriesDomains = computeSeriesDomains;
function computeSeriesGeometries(seriesSpecs, xDomain, yDomain, formattedDataSeries, seriesColorMap, chartTheme, chartDims, chartRotation, axesSpecs, enableHistogramMode) {
    var chartColors = chartTheme.colors;
    var barsPadding = enableHistogramMode ? chartTheme.scales.histogramPadding : chartTheme.scales.barsPadding;
    var width = [0, 180].includes(chartRotation) ? chartDims.width : chartDims.height;
    var height = [0, 180].includes(chartRotation) ? chartDims.height : chartDims.width;
    // const { width, height } = chartDims;
    var stacked = formattedDataSeries.stacked, nonStacked = formattedDataSeries.nonStacked;
    // compute how many series are clustered
    var _a = scales_1.countBarsInCluster(stacked, nonStacked), stackedBarsInCluster = _a.stackedBarsInCluster, totalBarsInCluster = _a.totalBarsInCluster;
    // compute scales
    var xScale = scales_1.computeXScale(xDomain, totalBarsInCluster, 0, width, barsPadding);
    var yScales = scales_1.computeYScales(yDomain, height, 0);
    // compute colors
    // compute geometries
    var points = [];
    var areas = [];
    var bars = [];
    var lines = [];
    var stackedGeometriesIndex = new Map();
    var nonStackedGeometriesIndex = new Map();
    var orderIndex = 0;
    var geometriesCounts = {
        points: 0,
        bars: 0,
        areas: 0,
        areasPoints: 0,
        lines: 0,
        linePoints: 0,
    };
    formattedDataSeries.stacked.forEach(function (dataSeriesGroup) {
        var groupId = dataSeriesGroup.groupId, dataSeries = dataSeriesGroup.dataSeries, counts = dataSeriesGroup.counts;
        var yScale = yScales.get(groupId);
        if (!yScale) {
            return;
        }
        var geometries = renderGeometries(orderIndex, totalBarsInCluster, true, dataSeries, xScale, yScale, seriesSpecs, seriesColorMap, chartColors.defaultVizColor, axesSpecs, chartTheme, enableHistogramMode);
        orderIndex = counts.barSeries > 0 ? orderIndex + 1 : orderIndex;
        areas.push.apply(areas, __spread(geometries.areas));
        lines.push.apply(lines, __spread(geometries.lines));
        bars.push.apply(bars, __spread(geometries.bars));
        points.push.apply(points, __spread(geometries.points));
        stackedGeometriesIndex = mergeGeometriesIndexes(stackedGeometriesIndex, geometries.geometriesIndex);
        // update counts
        geometriesCounts.points += geometries.geometriesCounts.points;
        geometriesCounts.bars += geometries.geometriesCounts.bars;
        geometriesCounts.areas += geometries.geometriesCounts.areas;
        geometriesCounts.areasPoints += geometries.geometriesCounts.areasPoints;
        geometriesCounts.lines += geometries.geometriesCounts.lines;
        geometriesCounts.linePoints += geometries.geometriesCounts.linePoints;
    });
    formattedDataSeries.nonStacked.map(function (dataSeriesGroup) {
        var groupId = dataSeriesGroup.groupId, dataSeries = dataSeriesGroup.dataSeries;
        var yScale = yScales.get(groupId);
        if (!yScale) {
            return;
        }
        var geometries = renderGeometries(stackedBarsInCluster, totalBarsInCluster, false, dataSeries, xScale, yScale, seriesSpecs, seriesColorMap, chartColors.defaultVizColor, axesSpecs, chartTheme, enableHistogramMode);
        areas.push.apply(areas, __spread(geometries.areas));
        lines.push.apply(lines, __spread(geometries.lines));
        bars.push.apply(bars, __spread(geometries.bars));
        points.push.apply(points, __spread(geometries.points));
        nonStackedGeometriesIndex = mergeGeometriesIndexes(nonStackedGeometriesIndex, geometries.geometriesIndex);
        // update counts
        geometriesCounts.points += geometries.geometriesCounts.points;
        geometriesCounts.bars += geometries.geometriesCounts.bars;
        geometriesCounts.areas += geometries.geometriesCounts.areas;
        geometriesCounts.areasPoints += geometries.geometriesCounts.areasPoints;
        geometriesCounts.lines += geometries.geometriesCounts.lines;
        geometriesCounts.linePoints += geometries.geometriesCounts.linePoints;
    });
    var geometriesIndex = mergeGeometriesIndexes(stackedGeometriesIndex, nonStackedGeometriesIndex);
    return {
        scales: {
            xScale: xScale,
            yScales: yScales,
        },
        geometries: {
            points: points,
            areas: areas,
            bars: bars,
            lines: lines,
        },
        geometriesIndex: geometriesIndex,
        geometriesCounts: geometriesCounts,
    };
}
exports.computeSeriesGeometries = computeSeriesGeometries;
function setBarSeriesAccessors(isHistogramMode, seriesSpecs) {
    var e_1, _a;
    if (!isHistogramMode) {
        return;
    }
    try {
        for (var seriesSpecs_1 = __values(seriesSpecs), seriesSpecs_1_1 = seriesSpecs_1.next(); !seriesSpecs_1_1.done; seriesSpecs_1_1 = seriesSpecs_1.next()) {
            var _b = __read(seriesSpecs_1_1.value, 2), spec = _b[1];
            if (specs_1.isBarSeriesSpec(spec)) {
                var stackAccessors = spec.stackAccessors ? __spread(spec.stackAccessors) : spec.yAccessors;
                if (spec.splitSeriesAccessors) {
                    stackAccessors = __spread(stackAccessors, spec.splitSeriesAccessors);
                }
                spec.stackAccessors = stackAccessors;
            }
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (seriesSpecs_1_1 && !seriesSpecs_1_1.done && (_a = seriesSpecs_1.return)) _a.call(seriesSpecs_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
    return;
}
exports.setBarSeriesAccessors = setBarSeriesAccessors;
function isHistogramModeEnabled(seriesSpecs) {
    var e_2, _a;
    try {
        for (var seriesSpecs_2 = __values(seriesSpecs), seriesSpecs_2_1 = seriesSpecs_2.next(); !seriesSpecs_2_1.done; seriesSpecs_2_1 = seriesSpecs_2.next()) {
            var _b = __read(seriesSpecs_2_1.value, 2), spec = _b[1];
            if (specs_1.isBarSeriesSpec(spec) && spec.enableHistogramMode) {
                return true;
            }
        }
    }
    catch (e_2_1) { e_2 = { error: e_2_1 }; }
    finally {
        try {
            if (seriesSpecs_2_1 && !seriesSpecs_2_1.done && (_a = seriesSpecs_2.return)) _a.call(seriesSpecs_2);
        }
        finally { if (e_2) throw e_2.error; }
    }
    return false;
}
exports.isHistogramModeEnabled = isHistogramModeEnabled;
function computeXScaleOffset(xScale, enableHistogramMode, histogramModeAlignment) {
    if (histogramModeAlignment === void 0) { histogramModeAlignment = specs_1.HistogramModeAlignments.Start; }
    if (!enableHistogramMode) {
        return 0;
    }
    var bandwidth = xScale.bandwidth, barsPadding = xScale.barsPadding;
    var band = bandwidth / (1 - barsPadding);
    var halfPadding = (band - bandwidth) / 2;
    var startAlignmentOffset = bandwidth / 2 + halfPadding;
    switch (histogramModeAlignment) {
        case specs_1.HistogramModeAlignments.Center:
            return 0;
        case specs_1.HistogramModeAlignments.End:
            return -startAlignmentOffset;
        default:
            return startAlignmentOffset;
    }
}
exports.computeXScaleOffset = computeXScaleOffset;
function renderGeometries(indexOffset, clusteredCount, isStacked, dataSeries, xScale, yScale, seriesSpecs, seriesColorsMap, defaultColor, axesSpecs, chartTheme, enableHistogramMode) {
    var len = dataSeries.length;
    var i;
    var points = [];
    var bars = [];
    var areas = [];
    var lines = [];
    var pointGeometriesIndex = new Map();
    var barGeometriesIndex = new Map();
    var lineGeometriesIndex = new Map();
    var areaGeometriesIndex = new Map();
    var geometriesCounts = {
        points: 0,
        bars: 0,
        areas: 0,
        areasPoints: 0,
        lines: 0,
        linePoints: 0,
    };
    for (i = 0; i < len; i++) {
        var ds = dataSeries[i];
        var spec = getSpecById(seriesSpecs, ds.specId);
        if (spec === undefined) {
            continue;
        }
        var color = seriesColorsMap.get(ds.seriesColorKey) || defaultColor;
        if (specs_1.isBarSeriesSpec(spec)) {
            var shift = isStacked ? indexOffset : indexOffset + i;
            // TODO: we can handle style merging here and not pass that off to the component
            // then barSeriesStyle should not be an optional parameter and we can simplify
            // the props building in the geometries component
            var barSeriesStyle = spec.barSeriesStyle
                ? __assign({}, chartTheme.barSeriesStyle, spec.barSeriesStyle) : chartTheme.barSeriesStyle;
            var yAxis = getAxesSpecForSpecId(axesSpecs, spec.groupId).yAxis;
            var valueFormatter = yAxis && yAxis.tickFormat ? yAxis.tickFormat : commons_1.identity;
            var displayValueSettings = spec.displayValueSettings
                ? __assign({ valueFormatter: valueFormatter }, spec.displayValueSettings) : undefined;
            var renderedBars = rendering_1.renderBars(shift, ds.data, xScale, yScale, color, ds.specId, ds.key, displayValueSettings, barSeriesStyle);
            barGeometriesIndex = mergeGeometriesIndexes(barGeometriesIndex, renderedBars.indexedGeometries);
            bars.push.apply(bars, __spread(renderedBars.barGeometries));
            geometriesCounts.bars += renderedBars.barGeometries.length;
        }
        else if (specs_1.isLineSeriesSpec(spec)) {
            var lineShift = clusteredCount > 0 ? clusteredCount : 1;
            var lineSeriesStyle = spec.lineSeriesStyle;
            var xScaleOffset = computeXScaleOffset(xScale, enableHistogramMode, spec.histogramModeAlignment);
            var renderedLines = rendering_1.renderLine(
            // move the point on half of the bandwidth if we have mixed bars/lines
            (xScale.bandwidth * lineShift) / 2, ds.data, xScale, yScale, color, spec.curve || 9 /* LINEAR */, ds.specId, Boolean(spec.y0Accessors), ds.key, xScaleOffset, lineSeriesStyle);
            lineGeometriesIndex = mergeGeometriesIndexes(lineGeometriesIndex, renderedLines.indexedGeometries);
            lines.push(renderedLines.lineGeometry);
            geometriesCounts.linePoints += renderedLines.lineGeometry.points.length;
            geometriesCounts.lines += 1;
        }
        else if (specs_1.isAreaSeriesSpec(spec)) {
            var areaShift = clusteredCount > 0 ? clusteredCount : 1;
            var areaSeriesStyle = spec.areaSeriesStyle;
            var xScaleOffset = computeXScaleOffset(xScale, enableHistogramMode, spec.histogramModeAlignment);
            var renderedAreas = rendering_1.renderArea(
            // move the point on half of the bandwidth if we have mixed bars/lines
            (xScale.bandwidth * areaShift) / 2, ds.data, xScale, yScale, color, spec.curve || 9 /* LINEAR */, ds.specId, Boolean(spec.y0Accessors), ds.key, xScaleOffset, areaSeriesStyle);
            areaGeometriesIndex = mergeGeometriesIndexes(areaGeometriesIndex, renderedAreas.indexedGeometries);
            areas.push(renderedAreas.areaGeometry);
            geometriesCounts.areasPoints += renderedAreas.areaGeometry.points.length;
            geometriesCounts.areas += 1;
        }
    }
    var geometriesIndex = mergeGeometriesIndexes(pointGeometriesIndex, lineGeometriesIndex, areaGeometriesIndex, barGeometriesIndex);
    return {
        points: points,
        bars: bars,
        areas: areas,
        lines: lines,
        geometriesIndex: geometriesIndex,
        geometriesCounts: geometriesCounts,
    };
}
exports.renderGeometries = renderGeometries;
function getSpecById(seriesSpecs, specId) {
    return seriesSpecs.get(specId);
}
exports.getSpecById = getSpecById;
function getAxesSpecForSpecId(axesSpecs, groupId) {
    var e_3, _a;
    var xAxis;
    var yAxis;
    try {
        for (var _b = __values(axesSpecs.values()), _c = _b.next(); !_c.done; _c = _b.next()) {
            var axisSpec = _c.value;
            if (axisSpec.groupId !== groupId) {
                continue;
            }
            if (axis_utils_1.isVertical(axisSpec.position)) {
                yAxis = axisSpec;
            }
            else {
                xAxis = axisSpec;
            }
        }
    }
    catch (e_3_1) { e_3 = { error: e_3_1 }; }
    finally {
        try {
            if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
        }
        finally { if (e_3) throw e_3.error; }
    }
    return {
        xAxis: xAxis,
        yAxis: yAxis,
    };
}
exports.getAxesSpecForSpecId = getAxesSpecForSpecId;
function computeChartTransform(chartDimensions, chartRotation) {
    if (chartRotation === 90) {
        return {
            x: chartDimensions.width,
            y: 0,
            rotate: 90,
        };
    }
    else if (chartRotation === -90) {
        return {
            x: 0,
            y: chartDimensions.height,
            rotate: -90,
        };
    }
    else if (chartRotation === 180) {
        return {
            x: chartDimensions.width,
            y: chartDimensions.height,
            rotate: 180,
        };
    }
    else {
        return {
            x: 0,
            y: 0,
            rotate: 0,
        };
    }
}
exports.computeChartTransform = computeChartTransform;
function computeBrushExtent(chartDimensions, chartRotation, chartTransform) {
    var minX = [0, 180].includes(chartRotation)
        ? chartDimensions.left + chartTransform.x
        : chartDimensions.top + chartTransform.y;
    var minY = [0, 180].includes(chartRotation)
        ? chartDimensions.top + chartTransform.y
        : chartDimensions.left + chartTransform.x;
    var maxX = minX + chartDimensions.width;
    var maxY = minY + chartDimensions.height;
    return {
        minX: minX,
        minY: minY,
        maxX: maxX,
        maxY: maxY,
    };
}
exports.computeBrushExtent = computeBrushExtent;
/**
 * Merge multiple geometry indexes maps together.
 * @param iterables a set of maps to be merged
 * @returns a new Map where each element with the same key are concatenated on a single
 * IndexedGemoetry array for that key
 */
function mergeGeometriesIndexes() {
    var e_4, _a, e_5, _b;
    var iterables = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        iterables[_i] = arguments[_i];
    }
    var geometriesIndex = new Map();
    try {
        for (var iterables_1 = __values(iterables), iterables_1_1 = iterables_1.next(); !iterables_1_1.done; iterables_1_1 = iterables_1.next()) {
            var iterable = iterables_1_1.value;
            try {
                for (var iterable_1 = __values(iterable), iterable_1_1 = iterable_1.next(); !iterable_1_1.done; iterable_1_1 = iterable_1.next()) {
                    var item = iterable_1_1.value;
                    rendering_1.mutableIndexedGeometryMapUpsert(geometriesIndex, item[0], item[1]);
                }
            }
            catch (e_5_1) { e_5 = { error: e_5_1 }; }
            finally {
                try {
                    if (iterable_1_1 && !iterable_1_1.done && (_b = iterable_1.return)) _b.call(iterable_1);
                }
                finally { if (e_5) throw e_5.error; }
            }
        }
    }
    catch (e_4_1) { e_4 = { error: e_4_1 }; }
    finally {
        try {
            if (iterables_1_1 && !iterables_1_1.done && (_a = iterables_1.return)) _a.call(iterables_1);
        }
        finally { if (e_4) throw e_4.error; }
    }
    return geometriesIndex;
}
exports.mergeGeometriesIndexes = mergeGeometriesIndexes;
function isHorizontalRotation(chartRotation) {
    return chartRotation === 0 || chartRotation === 180;
}
exports.isHorizontalRotation = isHorizontalRotation;
function isVerticalRotation(chartRotation) {
    return chartRotation === -90 || chartRotation === 90;
}
exports.isVerticalRotation = isVerticalRotation;
/**
 * Check if a specs map contains only line or area specs
 * @param specs Map<SpecId, BasicSeriesSpec>
 */
function isLineAreaOnlyChart(specs) {
    return !__spread(specs.values()).some(function (spec) {
        return spec.seriesType === 'bar';
    });
}
exports.isLineAreaOnlyChart = isLineAreaOnlyChart;
function isChartAnimatable(geometriesCounts, animationEnabled) {
    if (!animationEnabled) {
        return false;
    }
    var bars = geometriesCounts.bars, linePoints = geometriesCounts.linePoints, areasPoints = geometriesCounts.areasPoints;
    var isBarsAnimatable = bars <= MAX_ANIMATABLE_BARS;
    var isLinesAndAreasAnimatable = linePoints + areasPoints <= MAX_ANIMATABLE_LINES_AREA_POINTS;
    return isBarsAnimatable && isLinesAndAreasAnimatable;
}
exports.isChartAnimatable = isChartAnimatable;
//# sourceMappingURL=utils.js.map