/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.ChangesetCache;
import org.openstreetmap.josm.data.osm.ChangesetCacheEvent;
import org.openstreetmap.josm.data.osm.ChangesetCacheListener;
import org.openstreetmap.josm.gui.util.GuiHelper;

public class OpenChangesetComboBoxModel
extends DefaultComboBoxModel<Changeset>
implements ChangesetCacheListener {
    private final transient List<Changeset> changesets = new ArrayList<Changeset>();
    private transient Changeset selectedChangeset;

    protected Changeset getChangesetById(long id) {
        for (Changeset cs : this.changesets) {
            if ((long)cs.getId() != id) continue;
            return cs;
        }
        return null;
    }

    public void refresh() {
        this.changesets.clear();
        this.changesets.addAll(ChangesetCache.getInstance().getOpenChangesetsForCurrentUser());
        this.fireContentsChanged(this, 0, this.getSize());
        int idx = this.changesets.indexOf(this.selectedChangeset);
        if (idx < 0) {
            this.selectFirstChangeset();
        } else {
            this.setSelectedItem(this.changesets.get(idx));
        }
    }

    public void selectFirstChangeset() {
        if (this.changesets == null || this.changesets.isEmpty()) {
            this.setSelectedItem(null);
        } else {
            this.setSelectedItem(this.changesets.get(0));
        }
    }

    @Override
    public void changesetCacheUpdated(ChangesetCacheEvent event) {
        GuiHelper.runInEDT(this::refresh);
    }

    @Override
    public Changeset getElementAt(int index) {
        return this.changesets.get(index);
    }

    @Override
    public int getIndexOf(Object anObject) {
        return this.changesets.indexOf(anObject);
    }

    @Override
    public int getSize() {
        return this.changesets.size();
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedChangeset;
    }

    @Override
    public void setSelectedItem(Object anObject) {
        if (anObject == null) {
            this.selectedChangeset = null;
            super.setSelectedItem(null);
            return;
        }
        if (!(anObject instanceof Changeset)) {
            return;
        }
        Changeset cs = (Changeset)anObject;
        if (cs.getId() == 0 || !cs.isOpen()) {
            return;
        }
        Changeset candidate = this.getChangesetById(cs.getId());
        if (candidate == null) {
            return;
        }
        this.selectedChangeset = candidate;
        super.setSelectedItem(this.selectedChangeset);
    }
}

