#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: tls
version: 1.4.1
id: tls-1.4.1-19glv3cmc0cJ8jILL90nTj
key: tls-1.4.1-19glv3cmc0cJ8jILL90nTj
license: BSD-3-Clause
copyright: Vincent Hanquez <vincent@snarc.org>
maintainer: Vincent Hanquez <vincent@snarc.org>
author: Vincent Hanquez <vincent@snarc.org>
stability: experimental
homepage: http://github.com/vincenthz/hs-tls
synopsis: TLS/SSL protocol native implementation (Server and Client)
description:
    Native Haskell TLS and SSL protocol implementation for server and client.
    .
    This provides a high-level implementation of a sensitive security protocol,
    eliminating a common set of security issues through the use of the advanced
    type system, high level constructions and common Haskell features.
    .
    Currently implement the SSL3.0, TLS1.0, TLS1.1 and TLS1.2 protocol,
    and support RSA and Ephemeral (Elliptic curve and regular) Diffie Hellman key exchanges,
    and many extensions.
    .
    Some debug tools linked with tls, are available through the
    <http://hackage.haskell.org/package/tls-debug/>.
category: Network
abi: 9d3032238778c8c9d1d51236ce3730ca
exposed: True
exposed-modules:
    Network.TLS Network.TLS.Cipher Network.TLS.Compression
    Network.TLS.Extra Network.TLS.Extra.Cipher Network.TLS.Extra.FFDHE
    Network.TLS.Internal
hidden-modules: Network.TLS.Cap Network.TLS.Struct Network.TLS.Core
                Network.TLS.Context Network.TLS.Context.Internal
                Network.TLS.Credentials Network.TLS.Backend Network.TLS.Crypto
                Network.TLS.Crypto.DH Network.TLS.Crypto.IES
                Network.TLS.Crypto.Types Network.TLS.ErrT Network.TLS.Extension
                Network.TLS.Handshake Network.TLS.Handshake.Common
                Network.TLS.Handshake.Certificate Network.TLS.Handshake.Key
                Network.TLS.Handshake.Client Network.TLS.Handshake.Server
                Network.TLS.Handshake.Process Network.TLS.Handshake.Signature
                Network.TLS.Handshake.State Network.TLS.Hooks Network.TLS.IO
                Network.TLS.Imports Network.TLS.MAC Network.TLS.Measurement
                Network.TLS.Packet Network.TLS.Parameters Network.TLS.Record
                Network.TLS.Record.Types Network.TLS.Record.Engage
                Network.TLS.Record.Disengage Network.TLS.Record.State
                Network.TLS.RNG Network.TLS.State Network.TLS.Session
                Network.TLS.Sending Network.TLS.Receiving Network.TLS.Util
                Network.TLS.Util.ASN1 Network.TLS.Util.Serialization
                Network.TLS.Types Network.TLS.Wire Network.TLS.X509
import-dirs: /usr/lib/ghc-8.6.5/site-local/tls-1.4.1
library-dirs: /usr/lib/ghc-8.6.5/site-local/tls-1.4.1
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/x86_64-linux-ghc-8.6.5/tls-1.4.1
hs-libraries: HStls-1.4.1-19glv3cmc0cJ8jILL90nTj
depends:
    asn1-encoding-0.9.5-GnbcxVcyGEJ8Q4QPyFmhzh
    asn1-types-0.3.3-4Uk1PObX3MW4QyDGQKlaYD
    async-2.2.2-5KbUJa8fnnu9oaTmXcEjsG base-4.12.0.0
    bytestring-0.10.8.2 cereal-0.5.8.1-7AyRb7vLva5K85rZXh3kQh
    cryptonite-0.26-CDY1m3syfqq9pANhaEyZh6
    data-default-class-0.1.2.0-1aigY0ifYUs4kfvMygEld7
    memory-0.14.18-2FfCNwP2nzn4wBPtrz4oOB mtl-2.2.2
    network-2.8.0.0-HTKosw7lwpaCVnkz1nc19d transformers-0.5.6.2
    x509-1.7.5-EPkuEwnfnbiCAKFsQobtlj
    x509-store-1.6.7-Yv2PK4siWe3seRZsbCOXO
    x509-validation-1.6.11-88uuBzYFxddIvpMLXzmuzb
haddock-interfaces: /usr/share/doc/haskell-tls/html/tls.haddock
haddock-html: /usr/share/doc/haskell-tls/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

