/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import com.google.common.collect.ImmutableSortedMap;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.gradle.api.UncheckedIOException;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.internal.CacheableEntity;
import org.gradle.caching.internal.command.BuildCacheCommandFactory;
import org.gradle.caching.internal.controller.BuildCacheController;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.internal.Try;
import org.gradle.internal.execution.CurrentSnapshotResult;
import org.gradle.internal.execution.ExecutionOutcome;
import org.gradle.internal.execution.IncrementalChangesContext;
import org.gradle.internal.execution.Step;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.caching.CachingState;
import org.gradle.internal.execution.history.AfterPreviousExecutionState;
import org.gradle.internal.execution.history.BeforeExecutionState;
import org.gradle.internal.execution.history.changes.ExecutionStateChanges;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheStep
implements Step<IncrementalChangesContext, CurrentSnapshotResult> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheStep.class);
    private static final String FAILED_LOAD_REBUILD_REASON = "Outputs removed due to failed load from cache";
    private final BuildCacheController buildCache;
    private final BuildCacheCommandFactory commandFactory;
    private final Step<? super IncrementalChangesContext, ? extends CurrentSnapshotResult> delegate;

    public CacheStep(BuildCacheController buildCache, BuildCacheCommandFactory commandFactory, Step<? super IncrementalChangesContext, ? extends CurrentSnapshotResult> delegate) {
        this.buildCache = buildCache;
        this.commandFactory = commandFactory;
        this.delegate = delegate;
    }

    @Override
    public CurrentSnapshotResult execute(IncrementalChangesContext context) {
        CachingState cachingState = context.getCachingState();
        return cachingState.getDisabledReasons().isEmpty() ? this.executeWithCache(context, cachingState.getKey().get()) : this.executeWithoutCache(context);
    }

    private CurrentSnapshotResult executeWithCache(final IncrementalChangesContext context, BuildCacheKey cacheKey) {
        final UnitOfWork work = context.getWork();
        return (CurrentSnapshotResult)Try.ofFailable(() -> work.isAllowedToLoadFromCache() ? this.buildCache.load(this.commandFactory.createLoad(cacheKey, (CacheableEntity)work)) : Optional.empty()).map(successfulLoad -> successfulLoad.map(cacheHit -> {
            CacheStep.cleanLocalState(work);
            final OriginMetadata originMetadata = cacheHit.getOriginMetadata();
            final ImmutableSortedMap finalOutputs = cacheHit.getResultingSnapshots();
            return new CurrentSnapshotResult(){

                @Override
                public Try<ExecutionOutcome> getOutcome() {
                    return Try.successful((Object)((Object)ExecutionOutcome.FROM_CACHE));
                }

                @Override
                public OriginMetadata getOriginMetadata() {
                    return originMetadata;
                }

                @Override
                public boolean isReused() {
                    return true;
                }

                @Override
                public ImmutableSortedMap<String, CurrentFileCollectionFingerprint> getFinalOutputs() {
                    return finalOutputs;
                }
            };
        }).orElseGet(() -> this.executeAndStoreInCache(cacheKey, context))).orElseMapFailure(loadFailure -> {
            LOGGER.warn("Failed to load cache entry for {}, cleaning outputs and falling back to (non-incremental) execution", (Object)work.getDisplayName(), loadFailure);
            CacheStep.cleanLocalState(work);
            CacheStep.cleanOutputsAfterLoadFailure(work);
            final Optional<ExecutionStateChanges> rebuildChanges = context.getChanges().map(changes -> changes.withEnforcedRebuild(FAILED_LOAD_REBUILD_REASON));
            return this.executeAndStoreInCache(cacheKey, new IncrementalChangesContext(){

                @Override
                public Optional<ExecutionStateChanges> getChanges() {
                    return rebuildChanges;
                }

                @Override
                public CachingState getCachingState() {
                    return context.getCachingState();
                }

                @Override
                public Optional<String> getRebuildReason() {
                    return Optional.of(CacheStep.FAILED_LOAD_REBUILD_REASON);
                }

                @Override
                public Optional<AfterPreviousExecutionState> getAfterPreviousExecutionState() {
                    return context.getAfterPreviousExecutionState();
                }

                @Override
                public Optional<BeforeExecutionState> getBeforeExecutionState() {
                    return context.getBeforeExecutionState();
                }

                @Override
                public UnitOfWork getWork() {
                    return work;
                }
            });
        });
    }

    private static void cleanLocalState(UnitOfWork work) {
        work.visitLocalState(localStateFile -> {
            try {
                CacheStep.remove(localStateFile);
            }
            catch (IOException ex) {
                throw new UncheckedIOException(String.format("Failed to clean up local state files for %s: %s", work.getDisplayName(), localStateFile), (Throwable)ex);
            }
        });
    }

    private static void cleanOutputsAfterLoadFailure(UnitOfWork work) {
        work.visitOutputProperties((name, type, roots) -> {
            for (File root : roots) {
                try {
                    CacheStep.remove(root);
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(String.format("Failed to clean up files for tree '%s' of %s: %s", name, work.getDisplayName(), root), (Throwable)ex);
                }
            }
        });
    }

    private static void remove(File root) throws IOException {
        if (root.exists()) {
            if (root.isDirectory()) {
                FileUtils.cleanDirectory((File)root);
            } else {
                FileUtils.forceDelete((File)root);
            }
        }
    }

    private CurrentSnapshotResult executeAndStoreInCache(BuildCacheKey cacheKey, IncrementalChangesContext context) {
        CurrentSnapshotResult executionResult = this.executeWithoutCache(context);
        executionResult.getOutcome().ifSuccessfulOrElse(outcome -> this.store(context.getWork(), cacheKey, executionResult), failure -> LOGGER.debug("Not storing result of {} in cache because the execution failed", (Object)context.getWork().getDisplayName()));
        return executionResult;
    }

    private void store(UnitOfWork work, BuildCacheKey cacheKey, CurrentSnapshotResult result) {
        try {
            this.buildCache.store(this.commandFactory.createStore(cacheKey, (CacheableEntity)work, result.getFinalOutputs(), result.getOriginMetadata().getExecutionTime()));
        }
        catch (Exception e) {
            LOGGER.warn("Failed to store cache entry {}", (Object)cacheKey.getDisplayName(), (Object)e);
        }
    }

    private CurrentSnapshotResult executeWithoutCache(IncrementalChangesContext context) {
        return this.delegate.execute(context);
    }
}

