/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.mysqla.io;

import com.mysql.cj.api.MysqlConnection;
import com.mysql.cj.api.ProfilerEventHandler;
import com.mysql.cj.api.authentication.AuthenticationProvider;
import com.mysql.cj.api.conf.PropertySet;
import com.mysql.cj.api.conf.ReadableProperty;
import com.mysql.cj.api.conf.RuntimeProperty;
import com.mysql.cj.api.io.PacketReceivedTimeHolder;
import com.mysql.cj.api.io.PacketSentTimeHolder;
import com.mysql.cj.api.io.Protocol;
import com.mysql.cj.api.io.SocketConnection;
import com.mysql.cj.api.jdbc.JdbcConnection;
import com.mysql.cj.api.jdbc.Statement;
import com.mysql.cj.api.jdbc.interceptors.StatementInterceptor;
import com.mysql.cj.api.log.Log;
import com.mysql.cj.api.mysqla.io.NativeProtocol;
import com.mysql.cj.api.mysqla.io.PacketHeader;
import com.mysql.cj.api.mysqla.io.PacketPayload;
import com.mysql.cj.api.mysqla.io.PacketReader;
import com.mysql.cj.api.mysqla.io.PacketSender;
import com.mysql.cj.api.mysqla.io.ProtocolEntityFactory;
import com.mysql.cj.api.mysqla.io.ProtocolEntityReader;
import com.mysql.cj.api.mysqla.result.ColumnDefinition;
import com.mysql.cj.api.mysqla.result.ProtocolEntity;
import com.mysql.cj.api.mysqla.result.Resultset;
import com.mysql.cj.api.mysqla.result.ResultsetRow;
import com.mysql.cj.api.mysqla.result.ResultsetRows;
import com.mysql.cj.core.Constants;
import com.mysql.cj.core.Messages;
import com.mysql.cj.core.MysqlType;
import com.mysql.cj.core.ServerVersion;
import com.mysql.cj.core.exceptions.CJConnectionFeatureNotAvailableException;
import com.mysql.cj.core.exceptions.CJException;
import com.mysql.cj.core.exceptions.CJPacketTooBigException;
import com.mysql.cj.core.exceptions.CJTimeoutException;
import com.mysql.cj.core.exceptions.ClosedOnExpiredPasswordException;
import com.mysql.cj.core.exceptions.DataTruncationException;
import com.mysql.cj.core.exceptions.ExceptionFactory;
import com.mysql.cj.core.exceptions.FeatureNotAvailableException;
import com.mysql.cj.core.exceptions.OperationCancelledException;
import com.mysql.cj.core.exceptions.PasswordExpiredException;
import com.mysql.cj.core.exceptions.UnableToConnectException;
import com.mysql.cj.core.exceptions.WrongArgumentException;
import com.mysql.cj.core.io.AbstractProtocol;
import com.mysql.cj.core.io.ExportControlled;
import com.mysql.cj.core.profiler.ProfilerEventImpl;
import com.mysql.cj.core.util.LazyString;
import com.mysql.cj.core.util.LogUtils;
import com.mysql.cj.core.util.StringUtils;
import com.mysql.cj.core.util.TestUtils;
import com.mysql.cj.core.util.Util;
import com.mysql.cj.jdbc.PreparedStatement;
import com.mysql.cj.jdbc.StatementImpl;
import com.mysql.cj.jdbc.exceptions.SQLError;
import com.mysql.cj.jdbc.util.ResultSetUtil;
import com.mysql.cj.jdbc.util.TimeUtil;
import com.mysql.cj.mysqla.authentication.MysqlaAuthenticationProvider;
import com.mysql.cj.mysqla.io.BinaryResultsetReader;
import com.mysql.cj.mysqla.io.Buffer;
import com.mysql.cj.mysqla.io.ColumnDefinitionReader;
import com.mysql.cj.mysqla.io.CompressedInputStream;
import com.mysql.cj.mysqla.io.CompressedPacketSender;
import com.mysql.cj.mysqla.io.DebugBufferingPacketReader;
import com.mysql.cj.mysqla.io.DebugBufferingPacketSender;
import com.mysql.cj.mysqla.io.MultiPacketReader;
import com.mysql.cj.mysqla.io.MysqlaCapabilities;
import com.mysql.cj.mysqla.io.MysqlaServerSession;
import com.mysql.cj.mysqla.io.ResultsetRowReader;
import com.mysql.cj.mysqla.io.SimplePacketReader;
import com.mysql.cj.mysqla.io.SimplePacketSender;
import com.mysql.cj.mysqla.io.TextResultsetReader;
import com.mysql.cj.mysqla.io.TimeTrackingPacketReader;
import com.mysql.cj.mysqla.io.TimeTrackingPacketSender;
import com.mysql.cj.mysqla.io.TracingPacketReader;
import com.mysql.cj.mysqla.io.TracingPacketSender;
import com.mysql.cj.mysqla.result.OkPacket;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class MysqlaProtocol
extends AbstractProtocol
implements NativeProtocol,
RuntimeProperty.RuntimePropertyListener {
    protected static final int INITIAL_PACKET_SIZE = 1024;
    protected static final int COMP_HEADER_LENGTH = 3;
    protected static final int MAX_QUERY_SIZE_TO_EXPLAIN = 0x100000;
    private static final String EXPLAINABLE_STATEMENT = "SELECT";
    private static final String[] EXPLAINABLE_STATEMENT_EXTENSION = new String[]{"INSERT", "UPDATE", "REPLACE", "DELETE"};
    protected PacketSender packetSender;
    protected PacketReader packetReader;
    protected MysqlaServerSession serverSession;
    protected CompressedPacketSender compressedPacketSender;
    private PacketPayload sendPacket = null;
    protected PacketPayload sharedSendPacket = null;
    protected PacketPayload reusablePacket = null;
    private SoftReference<PacketPayload> loadFileBufRef;
    protected byte packetSequence = 0;
    protected boolean useCompression = false;
    private ReadableProperty<Integer> maxAllowedPacket;
    private boolean needToGrabQueryFromPacket;
    private boolean autoGenerateTestcaseScript;
    private boolean logSlowQueries = false;
    private boolean useAutoSlowLog;
    private boolean profileSQL = false;
    private boolean useNanosForElapsedTime;
    private long slowQueryThreshold;
    private String queryTimingUnits;
    private int commandCount = 0;
    protected boolean hadWarnings = false;
    private int warningCount = 0;
    private boolean queryBadIndexUsed = false;
    private boolean queryNoIndexUsed = false;
    private boolean serverQueryWasSlow = false;
    protected Map<Class<? extends ProtocolEntity>, ProtocolEntityReader<? extends ProtocolEntity>> PROTOCOL_ENTITY_CLASS_TO_TEXT_READER;
    protected Map<Class<? extends ProtocolEntity>, ProtocolEntityReader<? extends ProtocolEntity>> PROTOCOL_ENTITY_CLASS_TO_BINARY_READER;
    protected boolean platformDbCharsetMatches = true;
    private int statementExecutionDepth = 0;
    private List<StatementInterceptor> statementInterceptors;
    private ReadableProperty<Boolean> maintainTimeStats;
    private ReadableProperty<Integer> maxQuerySizeToLog;
    private InputStream localInfileInputStream;
    private static String jvmPlatformCharset = null;
    private ResultsetRows streamingData = null;

    public static MysqlaProtocol getInstance(MysqlConnection conn, SocketConnection socketConnection, PropertySet propertySet, Log log) {
        MysqlaProtocol protocol = new MysqlaProtocol(log);
        protocol.init(conn, propertySet.getIntegerReadableProperty("socketTimeout").getValue(), socketConnection, propertySet);
        return protocol;
    }

    public MysqlaProtocol(Log logger) {
        this.log = logger;
    }

    @Override
    public void init(MysqlConnection conn, int socketTimeout, SocketConnection phConnection, PropertySet propSet) {
        this.connection = conn;
        this.propertySet = propSet;
        this.socketConnection = phConnection;
        this.exceptionInterceptor = this.socketConnection.getExceptionInterceptor();
        this.maintainTimeStats = this.propertySet.getBooleanReadableProperty("maintainTimeStats");
        this.maxQuerySizeToLog = this.propertySet.getIntegerReadableProperty("maxQuerySizeToLog");
        this.useAutoSlowLog = this.propertySet.getBooleanReadableProperty("autoSlowLog").getValue();
        this.logSlowQueries = this.propertySet.getBooleanReadableProperty("logSlowQueries").getValue();
        this.maxAllowedPacket = this.propertySet.getIntegerReadableProperty("maxAllowedPacket");
        this.profileSQL = this.propertySet.getBooleanReadableProperty("profileSQL").getValue();
        this.autoGenerateTestcaseScript = this.propertySet.getBooleanReadableProperty("autoGenerateTestcaseScript").getValue();
        this.reusablePacket = new Buffer(1024);
        this.sendPacket = new Buffer(1024);
        this.packetSender = new SimplePacketSender(this.socketConnection.getMysqlOutput());
        this.packetReader = new SimplePacketReader(this.socketConnection, this.maxAllowedPacket);
        boolean bl = this.needToGrabQueryFromPacket = this.profileSQL || this.logSlowQueries || this.autoGenerateTestcaseScript;
        if (this.propertySet.getBooleanReadableProperty("useNanosForElapsedTime").getValue().booleanValue() && TimeUtil.nanoTimeAvailable()) {
            this.useNanosForElapsedTime = true;
            this.queryTimingUnits = Messages.getString("Nanoseconds");
        } else {
            this.queryTimingUnits = Messages.getString("Milliseconds");
        }
        if (this.propertySet.getBooleanReadableProperty("logSlowQueries").getValue().booleanValue()) {
            this.calculateSlowQueryThreshold();
        }
        this.authProvider = new MysqlaAuthenticationProvider(this.log);
        this.authProvider.init(this, this.getPropertySet(), this.socketConnection.getExceptionInterceptor());
        HashMap<Class<Resultset>, ProtocolEntityReader<ColumnDefinition>> protocolEntityClassToTextReader = new HashMap<Class<Resultset>, ProtocolEntityReader<ColumnDefinition>>();
        protocolEntityClassToTextReader.put(ColumnDefinition.class, new ColumnDefinitionReader(this));
        protocolEntityClassToTextReader.put(ResultsetRow.class, new ResultsetRowReader(this));
        protocolEntityClassToTextReader.put(Resultset.class, new TextResultsetReader(this));
        this.PROTOCOL_ENTITY_CLASS_TO_TEXT_READER = Collections.unmodifiableMap(protocolEntityClassToTextReader);
        HashMap<Class, ProtocolEntityReader<ColumnDefinition>> protocolEntityClassToBinaryReader = new HashMap<Class, ProtocolEntityReader<ColumnDefinition>>();
        protocolEntityClassToBinaryReader.put(ColumnDefinition.class, new ColumnDefinitionReader(this));
        protocolEntityClassToBinaryReader.put(Resultset.class, new BinaryResultsetReader(this));
        this.PROTOCOL_ENTITY_CLASS_TO_BINARY_READER = Collections.unmodifiableMap(protocolEntityClassToBinaryReader);
    }

    public PacketSender getPacketSender() {
        return this.packetSender;
    }

    @Override
    public PacketReader getPacketReader() {
        return this.packetReader;
    }

    @Override
    public void negotiateSSLConnection(int packLength) {
        if (!ExportControlled.enabled()) {
            throw new CJConnectionFeatureNotAvailableException(this.getPropertySet(), this.serverSession, this.getPacketSentTimeHolder().getLastPacketSentTime(), null);
        }
        long clientParam = this.serverSession.getClientParam();
        this.serverSession.setClientParam(clientParam |= 0x800L);
        Buffer packet = new Buffer(packLength);
        packet.writeInteger(NativeProtocol.IntegerDataType.INT4, clientParam);
        packet.writeInteger(NativeProtocol.IntegerDataType.INT4, 0xFFFFFFL);
        packet.writeInteger(NativeProtocol.IntegerDataType.INT1, AuthenticationProvider.getCharsetForHandshake(this.authProvider.getEncodingForHandshake(), this.serverSession.getCapabilities().getServerVersion()));
        packet.writeBytes(NativeProtocol.StringLengthDataType.STRING_FIXED, new byte[23]);
        this.send(packet, packet.getPosition());
        try {
            ExportControlled.transformSocketToSSLSocket(this.socketConnection, this.serverSession.getServerVersion());
        }
        catch (FeatureNotAvailableException nae) {
            throw new CJConnectionFeatureNotAvailableException(this.getPropertySet(), this.serverSession, this.getPacketSentTimeHolder().getLastPacketSentTime(), nae);
        }
        catch (IOException ioEx) {
            throw ExceptionFactory.createCommunicationsException(this.getConnection().getPropertySet(), this.serverSession, this.getPacketSentTimeHolder().getLastPacketSentTime(), this.getPacketReceivedTimeHolder().getLastPacketReceivedTime(), ioEx, this.getExceptionInterceptor());
        }
        this.packetSender = new SimplePacketSender(this.socketConnection.getMysqlOutput());
        this.packetReader = new SimplePacketReader(this.socketConnection, this.maxAllowedPacket);
    }

    @Override
    public void rejectConnection(String message) {
        try {
            ((JdbcConnection)this.connection).close();
        }
        catch (SQLException e) {
            throw ExceptionFactory.createException(e.getMessage(), e, this.getExceptionInterceptor());
        }
        this.socketConnection.forceClose();
        throw ExceptionFactory.createException(UnableToConnectException.class, message, this.getExceptionInterceptor());
    }

    @Override
    public void rejectProtocol(PacketPayload buf) {
        try {
            this.socketConnection.getMysqlSocket().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        int errno = 2000;
        errno = (int)buf.readInteger(NativeProtocol.IntegerDataType.INT2);
        String serverErrorMessage = "";
        try {
            serverErrorMessage = buf.readString(NativeProtocol.StringSelfDataType.STRING_TERM, "ASCII");
        }
        catch (Exception exception) {
            // empty catch block
        }
        StringBuilder errorBuf = new StringBuilder(Messages.getString("Protocol.0"));
        errorBuf.append(serverErrorMessage);
        errorBuf.append("\"");
        String xOpen = SQLError.mysqlToSqlState(errno);
        throw ExceptionFactory.createException(SQLError.get(xOpen) + ", " + errorBuf.toString(), xOpen, errno, false, null, this.getExceptionInterceptor());
    }

    @Override
    public void beforeHandshake() {
        this.packetReader.resetPacketSequence();
        this.serverSession = new MysqlaServerSession(this.propertySet);
        MysqlaCapabilities capabilities = this.readServerCapabilities();
        this.serverSession.setCapabilities(capabilities);
    }

    @Override
    public void afterHandshake() {
        this.checkTransactionState();
        PropertySet pset = this.getPropertySet();
        if ((this.serverSession.getCapabilities().getCapabilityFlags() & 0x20) != 0 && pset.getBooleanReadableProperty("useCompression").getValue().booleanValue() && !(this.socketConnection.getMysqlInput().getUnderlyingStream() instanceof CompressedInputStream)) {
            this.useCompression = true;
            this.socketConnection.setMysqlInput(new CompressedInputStream(this.socketConnection.getMysqlInput(), pset.getBooleanReadableProperty("traceProtocol"), this.log));
            this.compressedPacketSender = new CompressedPacketSender(this.socketConnection.getMysqlOutput());
            this.packetSender = this.compressedPacketSender;
        }
        this.applyPacketDecorators(this.packetSender, this.packetReader);
        try {
            this.socketConnection.setMysqlSocket(this.socketConnection.getSocketFactory().afterHandshake());
        }
        catch (IOException ioEx) {
            throw ExceptionFactory.createCommunicationsException(this.getPropertySet(), this.serverSession, this.getPacketSentTimeHolder().getLastPacketSentTime(), this.getPacketReceivedTimeHolder().getLastPacketReceivedTime(), ioEx, this.getExceptionInterceptor());
        }
        this.maintainTimeStats.addListener(this);
        pset.getBooleanReadableProperty("traceProtocol").addListener(this);
        pset.getBooleanReadableProperty("enablePacketDebug").addListener(this);
    }

    @Override
    public void handlePropertyChange(RuntimeProperty<?> prop) {
        switch (prop.getPropertyDefinition().getName()) {
            case "maintainTimeStats": 
            case "traceProtocol": 
            case "enablePacketDebug": {
                this.applyPacketDecorators(this.packetSender.undecorateAll(), this.packetReader.undecorateAll());
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyPacketDecorators(PacketSender sender, PacketReader reader) {
        TimeTrackingPacketSender ttSender = null;
        TimeTrackingPacketReader ttReader = null;
        LinkedList<StringBuilder> debugRingBuffer = null;
        if (this.maintainTimeStats.getValue().booleanValue()) {
            ttSender = new TimeTrackingPacketSender(sender);
            sender = ttSender;
            ttReader = new TimeTrackingPacketReader(reader);
            reader = ttReader;
        }
        if (this.propertySet.getBooleanReadableProperty("traceProtocol").getValue().booleanValue()) {
            sender = new TracingPacketSender(sender, this.log, this.socketConnection.getHost(), this.getServerSession().getCapabilities().getThreadId());
            reader = new TracingPacketReader(reader, this.log);
        }
        if (this.getPropertySet().getBooleanReadableProperty("enablePacketDebug").getValue().booleanValue()) {
            debugRingBuffer = new LinkedList<StringBuilder>();
            sender = new DebugBufferingPacketSender(sender, debugRingBuffer, this.propertySet.getIntegerReadableProperty("packetDebugBufferSize"));
            reader = new DebugBufferingPacketReader(reader, debugRingBuffer, this.propertySet.getIntegerReadableProperty("packetDebugBufferSize"));
        }
        reader = new MultiPacketReader(reader);
        Object object = this.packetReader;
        synchronized (object) {
            this.packetReader = reader;
            this.packetDebugRingBuffer = debugRingBuffer;
            this.setPacketSentTimeHolder(ttSender != null ? ttSender : new PacketSentTimeHolder(){

                @Override
                public long getLastPacketSentTime() {
                    return 0L;
                }
            });
        }
        object = this.packetSender;
        synchronized (object) {
            this.packetSender = sender;
            this.setPacketReceivedTimeHolder(ttReader != null ? ttReader : new PacketReceivedTimeHolder(){

                @Override
                public long getLastPacketReceivedTime() {
                    return 0L;
                }
            });
        }
    }

    @Override
    public MysqlaCapabilities readServerCapabilities() {
        PacketPayload buf = this.readPacket(null);
        MysqlaCapabilities serverCapabilities = new MysqlaCapabilities();
        serverCapabilities.setInitialHandshakePacket(buf);
        if (serverCapabilities.getProtocolVersion() == -1) {
            this.rejectProtocol(buf);
        }
        return serverCapabilities;
    }

    @Override
    public MysqlaServerSession getServerSession() {
        return this.serverSession;
    }

    @Override
    public void changeDatabase(String database) {
        if (database == null || database.length() == 0) {
            return;
        }
        try {
            this.sendCommand(2, database, null, false, null, 0);
        }
        catch (CJException ex) {
            if (this.getPropertySet().getBooleanReadableProperty("createDatabaseIfNotExist").getValue().booleanValue()) {
                this.sendCommand(3, "CREATE DATABASE IF NOT EXISTS " + database, null, false, null, 0);
                this.sendCommand(2, database, null, false, null, 0);
            }
            throw ExceptionFactory.createCommunicationsException(this.getPropertySet(), this.serverSession, this.getPacketSentTimeHolder().getLastPacketSentTime(), this.getPacketReceivedTimeHolder().getLastPacketReceivedTime(), ex, this.getExceptionInterceptor());
        }
    }

    @Override
    public final PacketPayload readPacket(PacketPayload reuse) {
        try {
            PacketHeader header = this.packetReader.readHeader();
            PacketPayload buf = this.packetReader.readPayload(Optional.ofNullable(reuse), header.getPacketLength());
            this.packetSequence = header.getPacketSequence();
            return buf;
        }
        catch (IOException ioEx) {
            throw ExceptionFactory.createCommunicationsException(this.propertySet, this.serverSession, this.getPacketSentTimeHolder().getLastPacketSentTime(), this.getPacketReceivedTimeHolder().getLastPacketReceivedTime(), ioEx, this.getExceptionInterceptor());
        }
        catch (OutOfMemoryError oom) {
            try {
                ((JdbcConnection)this.connection).realClose(false, false, true, oom);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw oom;
        }
    }

    @Override
    public final void send(PacketPayload packet, int packetLen) {
        try {
            if (this.maxAllowedPacket.getValue() > 0 && packetLen > this.maxAllowedPacket.getValue()) {
                throw new CJPacketTooBigException(packetLen, this.maxAllowedPacket.getValue().intValue());
            }
            this.packetSequence = (byte)(this.packetSequence + 1);
            this.packetSender.send(packet.getByteBuffer(), packetLen, this.packetSequence);
            if (packet == this.sharedSendPacket) {
                this.reclaimLargeSharedSendPacket();
            }
        }
        catch (IOException ioEx) {
            throw ExceptionFactory.createCommunicationsException(this.getPropertySet(), this.serverSession, this.getPacketSentTimeHolder().getLastPacketSentTime(), this.getPacketReceivedTimeHolder().getLastPacketReceivedTime(), ioEx, this.getExceptionInterceptor());
        }
    }

    @Override
    public final PacketPayload sendCommand(int command, String extraData, PacketPayload queryPacket, boolean skipCheck, String extraDataCharEncoding, int timeoutMillis) {
        ++this.commandCount;
        this.packetReader.resetPacketSequence();
        int oldTimeout = 0;
        if (timeoutMillis != 0) {
            try {
                oldTimeout = this.socketConnection.getMysqlSocket().getSoTimeout();
                this.socketConnection.getMysqlSocket().setSoTimeout(timeoutMillis);
            }
            catch (SocketException e) {
                throw ExceptionFactory.createCommunicationsException(this.propertySet, this.serverSession, this.getPacketSentTimeHolder().getLastPacketSentTime(), this.getPacketReceivedTimeHolder().getLastPacketReceivedTime(), e, this.getExceptionInterceptor());
            }
        }
        try {
            int bytesLeft;
            this.checkForOutstandingStreamingData();
            this.serverSession.setStatusFlags(0, true);
            this.hadWarnings = false;
            this.setWarningCount(0);
            this.queryNoIndexUsed = false;
            this.queryBadIndexUsed = false;
            this.serverQueryWasSlow = false;
            if (this.useCompression && (bytesLeft = this.socketConnection.getMysqlInput().available()) > 0) {
                this.socketConnection.getMysqlInput().skip(bytesLeft);
            }
            try {
                this.clearInputStream();
                if (queryPacket == null) {
                    int packLength = 4 + (extraData != null ? extraData.length() : 0) + 2;
                    if (this.sendPacket == null) {
                        this.sendPacket = new Buffer(packLength);
                    }
                    this.packetSequence = (byte)-1;
                    this.sendPacket.setPosition(0);
                    this.sendPacket.writeInteger(NativeProtocol.IntegerDataType.INT1, command);
                    if (command == 2 || command == 5 || command == 6 || command == 3 || command == 22) {
                        this.sendPacket.writeBytes(NativeProtocol.StringLengthDataType.STRING_FIXED, StringUtils.getBytes(extraData, extraDataCharEncoding));
                    } else if (command == 12) {
                        long id = Long.parseLong(extraData);
                        this.sendPacket.writeInteger(NativeProtocol.IntegerDataType.INT4, id);
                    }
                    this.send(this.sendPacket, this.sendPacket.getPosition());
                } else {
                    this.packetSequence = (byte)-1;
                    this.send(queryPacket, queryPacket.getPosition());
                }
            }
            catch (CJException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw ExceptionFactory.createCommunicationsException(this.propertySet, this.serverSession, this.getPacketSentTimeHolder().getLastPacketSentTime(), this.getPacketReceivedTimeHolder().getLastPacketReceivedTime(), ex, this.getExceptionInterceptor());
            }
            PacketPayload returnPacket = null;
            if (!skipCheck) {
                if (command == 23 || command == 26) {
                    this.packetReader.resetPacketSequence();
                }
                returnPacket = this.checkErrorPacket(command);
            }
            PacketPayload packetPayload = returnPacket;
            return packetPayload;
        }
        catch (IOException ioEx) {
            this.serverSession.preserveOldTransactionState();
            throw ExceptionFactory.createCommunicationsException(this.propertySet, this.serverSession, this.getPacketSentTimeHolder().getLastPacketSentTime(), this.getPacketReceivedTimeHolder().getLastPacketReceivedTime(), ioEx, this.getExceptionInterceptor());
        }
        catch (CJException e) {
            this.serverSession.preserveOldTransactionState();
            throw e;
        }
        finally {
            if (timeoutMillis != 0) {
                try {
                    this.socketConnection.getMysqlSocket().setSoTimeout(oldTimeout);
                }
                catch (SocketException e) {
                    throw ExceptionFactory.createCommunicationsException(this.propertySet, this.serverSession, this.getPacketSentTimeHolder().getLastPacketSentTime(), this.getPacketReceivedTimeHolder().getLastPacketReceivedTime(), e, this.getExceptionInterceptor());
                }
            }
        }
    }

    public void checkTransactionState() {
        int transState = this.serverSession.getTransactionState();
        try {
            if (transState == 3) {
                ((JdbcConnection)this.connection).transactionCompleted();
            } else if (transState == 2) {
                ((JdbcConnection)this.connection).transactionBegun();
            }
        }
        catch (SQLException e) {
            throw ExceptionFactory.createException(e.getMessage(), e, this.getExceptionInterceptor());
        }
    }

    @Override
    public PacketPayload checkErrorPacket() {
        return this.checkErrorPacket(-1);
    }

    private PacketPayload checkErrorPacket(int command) {
        PacketPayload resultPacket = null;
        this.serverSession.setStatusFlags(0);
        try {
            resultPacket = this.readPacket(this.reusablePacket);
        }
        catch (CJException ex) {
            throw ex;
        }
        catch (Exception fallThru) {
            throw ExceptionFactory.createCommunicationsException(this.propertySet, this.serverSession, this.getPacketSentTimeHolder().getLastPacketSentTime(), this.getPacketReceivedTimeHolder().getLastPacketReceivedTime(), fallThru, this.getExceptionInterceptor());
        }
        this.checkErrorPacket(resultPacket);
        return resultPacket;
    }

    public void checkErrorPacket(PacketPayload resultPacket) {
        resultPacket.setPosition(0);
        byte statusCode = (byte)resultPacket.readInteger(NativeProtocol.IntegerDataType.INT1);
        if (statusCode == -1) {
            int errno = 2000;
            errno = (int)resultPacket.readInteger(NativeProtocol.IntegerDataType.INT2);
            String xOpen = null;
            String serverErrorMessage = resultPacket.readString(NativeProtocol.StringSelfDataType.STRING_TERM, this.serverSession.getErrorMessageEncoding());
            if (serverErrorMessage.charAt(0) == '#') {
                if (serverErrorMessage.length() > 6) {
                    xOpen = serverErrorMessage.substring(1, 6);
                    serverErrorMessage = serverErrorMessage.substring(6);
                    if (xOpen.equals("HY000")) {
                        xOpen = SQLError.mysqlToSqlState(errno);
                    }
                } else {
                    xOpen = SQLError.mysqlToSqlState(errno);
                }
            } else {
                xOpen = SQLError.mysqlToSqlState(errno);
            }
            this.clearInputStream();
            StringBuilder errorBuf = new StringBuilder();
            String xOpenErrorMessage = SQLError.get(xOpen);
            boolean useOnlyServerErrorMessages = this.propertySet.getBooleanReadableProperty("useOnlyServerErrorMessages").getValue();
            if (!useOnlyServerErrorMessages && xOpenErrorMessage != null) {
                errorBuf.append(xOpenErrorMessage);
                errorBuf.append(Messages.getString("Protocol.0"));
            }
            errorBuf.append(serverErrorMessage);
            if (!useOnlyServerErrorMessages && xOpenErrorMessage != null) {
                errorBuf.append("\"");
            }
            ResultSetUtil.appendDeadlockStatusInformation(this.connection, xOpen, errorBuf);
            if (xOpen != null) {
                if (xOpen.startsWith("22")) {
                    throw new DataTruncationException(errorBuf.toString(), 0, true, false, 0, 0, errno);
                }
                if (errno == 1820) {
                    throw ExceptionFactory.createException(PasswordExpiredException.class, errorBuf.toString(), this.getExceptionInterceptor());
                }
                if (errno == 1862) {
                    throw ExceptionFactory.createException(ClosedOnExpiredPasswordException.class, errorBuf.toString(), this.getExceptionInterceptor());
                }
            }
            throw ExceptionFactory.createException(errorBuf.toString(), xOpen, errno, false, null, this.getExceptionInterceptor());
        }
    }

    private void reclaimLargeSharedSendPacket() {
        if (this.sharedSendPacket != null && this.sharedSendPacket.getCapacity() > 0x100000) {
            this.sharedSendPacket = new Buffer(1024);
        }
    }

    public void clearInputStream() {
        try {
            int len;
            while ((len = this.socketConnection.getMysqlInput().available()) > 0 && this.socketConnection.getMysqlInput().skip(len) > 0L) {
            }
        }
        catch (IOException ioEx) {
            throw ExceptionFactory.createCommunicationsException(this.propertySet, this.serverSession, this.getPacketSentTimeHolder().getLastPacketSentTime(), this.getPacketReceivedTimeHolder().getLastPacketReceivedTime(), ioEx, this.getExceptionInterceptor());
        }
    }

    public void reclaimLargeReusablePacket() {
        if (this.reusablePacket != null && this.reusablePacket.getCapacity() > 0x100000) {
            this.reusablePacket = new Buffer(1024);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T extends Resultset> T sqlQueryDirect(StatementImpl callingStatement, String query, String characterEncoding, PacketPayload queryPacket, int maxRows, boolean streamResults, String catalog, ColumnDefinition cachedMetadata, Protocol.GetProfilerEventHandlerInstanceFunction getProfilerEventHandlerInstanceFunction, ProtocolEntityFactory<T> resultSetFactory) throws IOException {
        ++this.statementExecutionDepth;
        try {
            T interceptedResults;
            T interceptedResults2;
            if (this.statementInterceptors != null && (interceptedResults2 = this.invokeStatementInterceptorsPre(query, callingStatement, false)) != null) {
                T t = interceptedResults2;
                return t;
            }
            long queryStartTime = 0L;
            long queryEndTime = 0L;
            String statementComment = ((JdbcConnection)this.connection).getStatementComment();
            if (this.propertySet.getBooleanReadableProperty("includeThreadNamesAsStatementComment").getValue().booleanValue()) {
                statementComment = (statementComment != null ? statementComment + ", " : "") + "java thread: " + Thread.currentThread().getName();
            }
            if (query != null) {
                int packLength = 1 + query.length() * 3 + 2;
                byte[] commentAsBytes = null;
                if (statementComment != null) {
                    commentAsBytes = StringUtils.getBytes(statementComment, characterEncoding);
                    packLength += commentAsBytes.length;
                    packLength += 6;
                }
                if (this.sendPacket == null) {
                    this.sendPacket = new Buffer(packLength);
                }
                this.sendPacket.setPosition(0);
                this.sendPacket.writeInteger(NativeProtocol.IntegerDataType.INT1, 3L);
                if (commentAsBytes != null) {
                    this.sendPacket.writeBytes(NativeProtocol.StringLengthDataType.STRING_FIXED, Constants.SLASH_STAR_SPACE_AS_BYTES);
                    this.sendPacket.writeBytes(NativeProtocol.StringLengthDataType.STRING_FIXED, commentAsBytes);
                    this.sendPacket.writeBytes(NativeProtocol.StringLengthDataType.STRING_FIXED, Constants.SPACE_STAR_SLASH_SPACE_AS_BYTES);
                }
                if (!this.platformDbCharsetMatches && StringUtils.startsWithIgnoreCaseAndWs(query, "LOAD DATA")) {
                    this.sendPacket.writeBytes(NativeProtocol.StringLengthDataType.STRING_FIXED, StringUtils.getBytes(query));
                } else {
                    this.sendPacket.writeBytes(NativeProtocol.StringLengthDataType.STRING_FIXED, StringUtils.getBytes(query, characterEncoding));
                }
                queryPacket = this.sendPacket;
            }
            byte[] queryBuf = null;
            int oldPacketPosition = 0;
            if (this.needToGrabQueryFromPacket) {
                queryBuf = queryPacket.getByteBuffer();
                oldPacketPosition = queryPacket.getPosition();
                queryStartTime = this.getCurrentTimeNanosOrMillis();
            }
            if (this.autoGenerateTestcaseScript) {
                String testcaseQuery = null;
                testcaseQuery = query != null ? (statementComment != null ? "/* " + statementComment + " */ " + query : query) : StringUtils.toString(queryBuf, 1, oldPacketPosition - 1);
                StringBuilder debugBuf = new StringBuilder(testcaseQuery.length() + 32);
                ((JdbcConnection)this.connection).generateConnectionCommentBlock(debugBuf);
                debugBuf.append(testcaseQuery);
                debugBuf.append(';');
                TestUtils.dumpTestcaseQuery(debugBuf.toString());
            }
            PacketPayload resultPacket = this.sendCommand(3, null, queryPacket, false, null, 0);
            long fetchBeginTime = 0L;
            long fetchEndTime = 0L;
            String profileQueryToLog = null;
            boolean queryWasSlow = false;
            if (this.profileSQL || this.logSlowQueries) {
                queryEndTime = this.getCurrentTimeNanosOrMillis();
                boolean shouldExtractQuery = false;
                if (this.profileSQL) {
                    shouldExtractQuery = true;
                } else if (this.logSlowQueries) {
                    long queryTime = queryEndTime - queryStartTime;
                    boolean logSlow = false;
                    if (!this.useAutoSlowLog) {
                        logSlow = queryTime > (long)this.propertySet.getIntegerReadableProperty("slowQueryThresholdMillis").getValue().intValue();
                    } else {
                        logSlow = ((JdbcConnection)this.connection).isAbonormallyLongQuery(queryTime);
                        ((JdbcConnection)this.connection).reportQueryTime(queryTime);
                    }
                    if (logSlow) {
                        shouldExtractQuery = true;
                        queryWasSlow = true;
                    }
                }
                if (shouldExtractQuery) {
                    boolean truncated = false;
                    int extractPosition = oldPacketPosition;
                    if (oldPacketPosition > this.maxQuerySizeToLog.getValue()) {
                        extractPosition = this.maxQuerySizeToLog.getValue() + 1;
                        truncated = true;
                    }
                    profileQueryToLog = StringUtils.toString(queryBuf, 1, extractPosition - 1);
                    if (truncated) {
                        profileQueryToLog = profileQueryToLog + Messages.getString("Protocol.2");
                    }
                }
                fetchBeginTime = queryEndTime;
            }
            T rs = this.readAllResults(maxRows, streamResults, resultPacket, false, cachedMetadata, resultSetFactory);
            if (queryWasSlow && !this.serverQueryWasSlow) {
                StringBuilder mesgBuf = new StringBuilder(48 + profileQueryToLog.length());
                mesgBuf.append(Messages.getString("Protocol.SlowQuery", new Object[]{String.valueOf(this.useAutoSlowLog ? " 95% of all queries " : Long.valueOf(this.slowQueryThreshold)), this.queryTimingUnits, queryEndTime - queryStartTime}));
                mesgBuf.append(profileQueryToLog);
                ProfilerEventHandler eventSink = getProfilerEventHandlerInstanceFunction.apply();
                eventSink.consumeEvent(new ProfilerEventImpl(6, "", catalog, this.connection.getId(), callingStatement != null ? callingStatement.getId() : 999, rs.getResultId(), System.currentTimeMillis(), (int)(queryEndTime - queryStartTime), this.queryTimingUnits, null, LogUtils.findCallingClassAndMethod(new Throwable()), mesgBuf.toString()));
                if (this.propertySet.getBooleanReadableProperty("explainSlowQueries").getValue().booleanValue()) {
                    if (oldPacketPosition < 0x100000) {
                        queryPacket.setPosition(1);
                        this.explainSlowQuery(queryPacket.readBytes(NativeProtocol.StringLengthDataType.STRING_FIXED, oldPacketPosition - 1), profileQueryToLog);
                    } else {
                        this.log.logWarn(Messages.getString("Protocol.3", new Object[]{0x100000}));
                    }
                }
            }
            if (this.logSlowQueries) {
                ProfilerEventHandler eventSink = getProfilerEventHandlerInstanceFunction.apply();
                if (this.queryBadIndexUsed && this.profileSQL) {
                    eventSink.consumeEvent(new ProfilerEventImpl(6, "", catalog, this.connection.getId(), callingStatement != null ? callingStatement.getId() : 999, rs.getResultId(), System.currentTimeMillis(), queryEndTime - queryStartTime, this.queryTimingUnits, null, LogUtils.findCallingClassAndMethod(new Throwable()), Messages.getString("Protocol.4") + profileQueryToLog));
                }
                if (this.queryNoIndexUsed && this.profileSQL) {
                    eventSink.consumeEvent(new ProfilerEventImpl(6, "", catalog, this.connection.getId(), callingStatement != null ? callingStatement.getId() : 999, rs.getResultId(), System.currentTimeMillis(), queryEndTime - queryStartTime, this.queryTimingUnits, null, LogUtils.findCallingClassAndMethod(new Throwable()), Messages.getString("Protocol.5") + profileQueryToLog));
                }
                if (this.serverQueryWasSlow && this.profileSQL) {
                    eventSink.consumeEvent(new ProfilerEventImpl(6, "", catalog, this.connection.getId(), callingStatement != null ? callingStatement.getId() : 999, rs.getResultId(), System.currentTimeMillis(), queryEndTime - queryStartTime, this.queryTimingUnits, null, LogUtils.findCallingClassAndMethod(new Throwable()), Messages.getString("Protocol.ServerSlowQuery") + profileQueryToLog));
                }
            }
            if (this.profileSQL) {
                fetchEndTime = this.getCurrentTimeNanosOrMillis();
                ProfilerEventHandler eventSink = getProfilerEventHandlerInstanceFunction.apply();
                eventSink.consumeEvent(new ProfilerEventImpl(3, "", catalog, this.connection.getId(), callingStatement != null ? callingStatement.getId() : 999, rs.getResultId(), System.currentTimeMillis(), queryEndTime - queryStartTime, this.queryTimingUnits, null, LogUtils.findCallingClassAndMethod(new Throwable()), profileQueryToLog));
                eventSink.consumeEvent(new ProfilerEventImpl(5, "", catalog, this.connection.getId(), callingStatement != null ? callingStatement.getId() : 999, rs.getResultId(), System.currentTimeMillis(), fetchEndTime - fetchBeginTime, this.queryTimingUnits, null, LogUtils.findCallingClassAndMethod(new Throwable()), null));
            }
            if (this.hadWarnings) {
                this.scanForAndThrowDataTruncation();
            }
            if (this.statementInterceptors != null && (interceptedResults = this.invokeStatementInterceptorsPost(query, callingStatement, rs, false, (Exception)null)) != null) {
                rs = interceptedResults;
            }
            T t = rs;
            return t;
        }
        catch (CJException | SQLException sqlEx) {
            if (this.statementInterceptors != null) {
                this.invokeStatementInterceptorsPost(query, callingStatement, null, false, sqlEx);
            }
            if (callingStatement != null) {
                Object object = callingStatement.cancelTimeoutMutex;
                synchronized (object) {
                    if (callingStatement.wasCancelled) {
                        CJException cause = null;
                        cause = callingStatement.wasCancelledByTimeout ? new CJTimeoutException() : new OperationCancelledException();
                        try {
                            callingStatement.resetCancelledState();
                        }
                        catch (SQLException e) {
                            throw ExceptionFactory.createException(e.getMessage(), e);
                        }
                        throw cause;
                    }
                }
            }
            if (sqlEx instanceof CJException) {
                throw (CJException)sqlEx;
            }
            throw ExceptionFactory.createException(sqlEx.getMessage(), sqlEx);
        }
        finally {
            --this.statementExecutionDepth;
        }
    }

    public <T extends Resultset> T invokeStatementInterceptorsPre(String sql, Statement interceptedStatement, boolean forceExecute) {
        T previousResultSet = null;
        int s = this.statementInterceptors.size();
        for (int i = 0; i < s; ++i) {
            boolean shouldExecute;
            StatementInterceptor interceptor = this.statementInterceptors.get(i);
            boolean executeTopLevelOnly = interceptor.executeTopLevelOnly();
            boolean bl = shouldExecute = executeTopLevelOnly && (this.statementExecutionDepth == 1 || forceExecute) || !executeTopLevelOnly;
            if (!shouldExecute) continue;
            String sqlToInterceptor = sql;
            try {
                Object interceptedResultSet = interceptor.preProcess(sqlToInterceptor, interceptedStatement);
                if (interceptedResultSet == null) continue;
                previousResultSet = interceptedResultSet;
                continue;
            }
            catch (SQLException ex) {
                throw ExceptionFactory.createException(ex.getMessage(), ex);
            }
        }
        return previousResultSet;
    }

    public <T extends Resultset> T invokeStatementInterceptorsPost(String sql, Statement interceptedStatement, T originalResultSet, boolean forceExecute, Exception statementException) {
        int s = this.statementInterceptors.size();
        for (int i = 0; i < s; ++i) {
            boolean shouldExecute;
            StatementInterceptor interceptor = this.statementInterceptors.get(i);
            boolean executeTopLevelOnly = interceptor.executeTopLevelOnly();
            boolean bl = shouldExecute = executeTopLevelOnly && (this.statementExecutionDepth == 1 || forceExecute) || !executeTopLevelOnly;
            if (!shouldExecute) continue;
            String sqlToInterceptor = sql;
            try {
                T interceptedResultSet = interceptor.postProcess(sqlToInterceptor, interceptedStatement, originalResultSet, this.getWarningCount(), this.queryNoIndexUsed, this.queryBadIndexUsed, statementException);
                if (interceptedResultSet == null) continue;
                originalResultSet = interceptedResultSet;
                continue;
            }
            catch (SQLException ex) {
                throw ExceptionFactory.createException(ex.getMessage(), ex);
            }
        }
        return originalResultSet;
    }

    public long getCurrentTimeNanosOrMillis() {
        if (this.useNanosForElapsedTime) {
            return TimeUtil.getCurrentTimeNanosOrMillis();
        }
        return System.currentTimeMillis();
    }

    public boolean hadWarnings() {
        return this.hadWarnings;
    }

    public void setHadWarnings(boolean hadWarnings) {
        this.hadWarnings = hadWarnings;
    }

    public void explainSlowQuery(byte[] querySQL, String truncatedQuery) {
        if (StringUtils.startsWithIgnoreCaseAndWs(truncatedQuery, EXPLAINABLE_STATEMENT) || this.versionMeetsMinimum(5, 6, 3) && StringUtils.startsWithIgnoreCaseAndWs(truncatedQuery, EXPLAINABLE_STATEMENT_EXTENSION) != -1) {
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                stmt = (PreparedStatement)((JdbcConnection)this.connection).clientPrepareStatement("EXPLAIN ?");
                stmt.setBytesNoEscapeNoQuotes(1, querySQL);
                rs = stmt.executeQuery();
                StringBuilder explainResults = new StringBuilder(Messages.getString("Protocol.6"));
                explainResults.append(truncatedQuery);
                explainResults.append(Messages.getString("Protocol.7"));
                ResultSetUtil.appendResultSetSlashGStyle(explainResults, rs);
                this.log.logWarn(explainResults.toString());
            }
            catch (CJException | SQLException ex) {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException ex2) {
                    throw ExceptionFactory.createException(ex2.getMessage(), ex2);
                }
            }
            catch (Exception ex) {
                throw ExceptionFactory.createException(ex.getMessage(), ex, this.getExceptionInterceptor());
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException ex) {
                    throw ExceptionFactory.createException(ex.getMessage(), ex);
                }
            }
        }
    }

    public final void skipPacket() {
        try {
            int packetLength = this.packetReader.readHeader().getPacketLength();
            this.socketConnection.getMysqlInput().skipFully(packetLength);
        }
        catch (IOException ioEx) {
            throw ExceptionFactory.createCommunicationsException(this.propertySet, this.serverSession, this.getPacketSentTimeHolder().getLastPacketSentTime(), this.getPacketReceivedTimeHolder().getLastPacketReceivedTime(), ioEx, this.getExceptionInterceptor());
        }
        catch (OutOfMemoryError oom) {
            try {
                ((JdbcConnection)this.connection).realClose(false, false, true, oom);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw oom;
        }
    }

    public final void quit() {
        try {
            try {
                if (!this.socketConnection.getMysqlSocket().isClosed()) {
                    try {
                        this.socketConnection.getMysqlSocket().shutdownInput();
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {}
                }
            }
            catch (IOException ioEx) {
                this.log.logWarn("Caught while disconnecting...", ioEx);
            }
            Buffer packet = new Buffer(6);
            this.packetSequence = (byte)-1;
            packet.writeInteger(NativeProtocol.IntegerDataType.INT1, 1L);
            this.send(packet, packet.getPosition());
        }
        finally {
            this.socketConnection.forceClose();
            this.localInfileInputStream = null;
        }
    }

    public PacketPayload getSharedSendPacket() {
        if (this.sharedSendPacket == null) {
            this.sharedSendPacket = new Buffer(1024);
        }
        this.sharedSendPacket.setPosition(0);
        return this.sharedSendPacket;
    }

    private void calculateSlowQueryThreshold() {
        this.slowQueryThreshold = this.propertySet.getIntegerReadableProperty("slowQueryThresholdMillis").getValue().intValue();
        if (this.propertySet.getBooleanReadableProperty("useNanosForElapsedTime").getValue().booleanValue()) {
            long nanosThreshold = this.propertySet.getLongReadableProperty("slowQueryThresholdNanos").getValue();
            this.slowQueryThreshold = nanosThreshold != 0L ? nanosThreshold : (this.slowQueryThreshold *= 1000000L);
        }
    }

    @Override
    public void changeUser(String user, String password, String database) {
        this.packetSequence = (byte)-1;
        this.authProvider.changeUser(this.serverSession, user, password, database);
    }

    public void checkForCharsetMismatch() {
        String characterEncoding = this.propertySet.getStringReadableProperty("characterEncoding").getValue();
        if (characterEncoding != null) {
            String encodingToCheck = jvmPlatformCharset;
            if (encodingToCheck == null) {
                encodingToCheck = Constants.PLATFORM_ENCODING;
            }
            this.platformDbCharsetMatches = encodingToCheck == null ? false : encodingToCheck.equals(characterEncoding);
        }
    }

    public void setServerSlowQueryFlags() {
        MysqlaServerSession state = this.serverSession;
        this.queryBadIndexUsed = state.noGoodIndexUsed();
        this.queryNoIndexUsed = state.noIndexUsed();
        this.serverQueryWasSlow = state.queryWasSlow();
    }

    protected boolean useNanosForElapsedTime() {
        return this.useNanosForElapsedTime;
    }

    public long getSlowQueryThreshold() {
        return this.slowQueryThreshold;
    }

    public String getQueryTimingUnits() {
        return this.queryTimingUnits;
    }

    public int getCommandCount() {
        return this.commandCount;
    }

    public void setStatementInterceptors(List<StatementInterceptor> statementInterceptors) {
        this.statementInterceptors = statementInterceptors.isEmpty() ? null : statementInterceptors;
    }

    public List<StatementInterceptor> getStatementInterceptors() {
        return this.statementInterceptors;
    }

    public void setSocketTimeout(int milliseconds) {
        try {
            this.socketConnection.getMysqlSocket().setSoTimeout(milliseconds);
        }
        catch (SocketException e) {
            throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("Protocol.8"), e, this.getExceptionInterceptor());
        }
    }

    public void releaseResources() {
        if (this.compressedPacketSender != null) {
            this.compressedPacketSender.stop();
        }
    }

    @Override
    public void connect(String user, String password, String database) {
        this.beforeHandshake();
        this.authProvider.connect(this.serverSession, user, password, database);
    }

    @Override
    public JdbcConnection getConnection() {
        return (JdbcConnection)this.connection;
    }

    public void setConnection(JdbcConnection connection) {
        this.connection = connection;
    }

    protected boolean isDataAvailable() {
        try {
            return this.socketConnection.getMysqlInput().available() > 0;
        }
        catch (IOException ioEx) {
            throw ExceptionFactory.createCommunicationsException(this.propertySet, this.serverSession, this.getPacketSentTimeHolder().getLastPacketSentTime(), this.getPacketReceivedTimeHolder().getLastPacketReceivedTime(), ioEx, this.getExceptionInterceptor());
        }
    }

    public PacketPayload getReusablePacket() {
        return this.reusablePacket;
    }

    public int getWarningCount() {
        return this.warningCount;
    }

    public void setWarningCount(int warningCount) {
        this.warningCount = warningCount;
    }

    public void dumpPacketRingBuffer() {
        LinkedList localPacketDebugRingBuffer = this.packetDebugRingBuffer;
        if (localPacketDebugRingBuffer != null) {
            StringBuilder dumpBuffer = new StringBuilder();
            dumpBuffer.append("Last " + localPacketDebugRingBuffer.size() + " packets received from server, from oldest->newest:\n");
            dumpBuffer.append("\n");
            Iterator ringBufIter = localPacketDebugRingBuffer.iterator();
            while (ringBufIter.hasNext()) {
                dumpBuffer.append((CharSequence)ringBufIter.next());
                dumpBuffer.append("\n");
            }
            this.log.logTrace(dumpBuffer.toString());
        }
    }

    public boolean doesPlatformDbCharsetMatches() {
        return this.platformDbCharsetMatches;
    }

    @Override
    public String getPasswordCharacterEncoding() {
        String encoding = this.propertySet.getStringReadableProperty("passwordCharacterEncoding").getStringValue();
        if (encoding != null) {
            return encoding;
        }
        encoding = this.propertySet.getStringReadableProperty("characterEncoding").getValue();
        if (encoding != null) {
            return encoding;
        }
        return "UTF-8";
    }

    @Override
    public boolean versionMeetsMinimum(int major, int minor, int subminor) {
        return this.serverSession.getServerVersion().meetsMinimum(new ServerVersion(major, minor, subminor));
    }

    public static MysqlType findMysqlType(PropertySet propertySet, int mysqlTypeId, short colFlag, long length, LazyString tableName, LazyString originalTableName, int collationIndex, String encoding) {
        boolean isImplicitTemporaryTable;
        boolean isUnsigned = (colFlag & 0x20) > 0;
        boolean isFromFunction = originalTableName.length() == 0;
        boolean isBinary = (colFlag & 0x80) > 0;
        boolean bl = isImplicitTemporaryTable = tableName.length() > 0 && tableName.toString().startsWith("#sql_");
        boolean isOpaqueBinary = isBinary && collationIndex == 63 && (mysqlTypeId == 254 || mysqlTypeId == 253 || mysqlTypeId == 15) ? !isImplicitTemporaryTable : "binary".equalsIgnoreCase(encoding);
        switch (mysqlTypeId) {
            case 0: 
            case 246: {
                return isUnsigned ? MysqlType.DECIMAL_UNSIGNED : MysqlType.DECIMAL;
            }
            case 1: {
                if (length == 1L) {
                    if (propertySet.getBooleanReadableProperty("transformedBitIsBoolean").getValue().booleanValue()) {
                        return MysqlType.BOOLEAN;
                    }
                    if (propertySet.getBooleanReadableProperty("tinyInt1isBit").getValue().booleanValue()) {
                        return MysqlType.BIT;
                    }
                }
                return isUnsigned ? MysqlType.TINYINT_UNSIGNED : MysqlType.TINYINT;
            }
            case 2: {
                return isUnsigned ? MysqlType.SMALLINT_UNSIGNED : MysqlType.SMALLINT;
            }
            case 3: {
                return isUnsigned ? MysqlType.INT_UNSIGNED : MysqlType.INT;
            }
            case 4: {
                return isUnsigned ? MysqlType.FLOAT_UNSIGNED : MysqlType.FLOAT;
            }
            case 5: {
                return isUnsigned ? MysqlType.DOUBLE_UNSIGNED : MysqlType.DOUBLE;
            }
            case 6: {
                return MysqlType.NULL;
            }
            case 7: {
                return MysqlType.TIMESTAMP;
            }
            case 8: {
                return isUnsigned ? MysqlType.BIGINT_UNSIGNED : MysqlType.BIGINT;
            }
            case 9: {
                return isUnsigned ? MysqlType.MEDIUMINT_UNSIGNED : MysqlType.MEDIUMINT;
            }
            case 10: {
                return MysqlType.DATE;
            }
            case 11: {
                return MysqlType.TIME;
            }
            case 12: {
                return MysqlType.DATETIME;
            }
            case 13: {
                return MysqlType.YEAR;
            }
            case 15: 
            case 253: {
                if (!(!isOpaqueBinary || isFromFunction && propertySet.getBooleanReadableProperty("functionsNeverReturnBlobs").getValue().booleanValue())) {
                    return MysqlType.VARBINARY;
                }
                return MysqlType.VARCHAR;
            }
            case 16: {
                return MysqlType.BIT;
            }
            case 245: {
                return MysqlType.JSON;
            }
            case 247: {
                return MysqlType.ENUM;
            }
            case 248: {
                return MysqlType.SET;
            }
            case 249: {
                if (!isBinary || collationIndex != 63 || propertySet.getBooleanReadableProperty("blobsAreStrings").getValue().booleanValue() || isFromFunction && propertySet.getBooleanReadableProperty("functionsNeverReturnBlobs").getValue().booleanValue()) {
                    return MysqlType.TINYTEXT;
                }
                return MysqlType.TINYBLOB;
            }
            case 250: {
                if (!isBinary || collationIndex != 63 || propertySet.getBooleanReadableProperty("blobsAreStrings").getValue().booleanValue() || isFromFunction && propertySet.getBooleanReadableProperty("functionsNeverReturnBlobs").getValue().booleanValue()) {
                    return MysqlType.MEDIUMTEXT;
                }
                return MysqlType.MEDIUMBLOB;
            }
            case 251: {
                if (!isBinary || collationIndex != 63 || propertySet.getBooleanReadableProperty("blobsAreStrings").getValue().booleanValue() || isFromFunction && propertySet.getBooleanReadableProperty("functionsNeverReturnBlobs").getValue().booleanValue()) {
                    return MysqlType.LONGTEXT;
                }
                return MysqlType.LONGBLOB;
            }
            case 252: {
                int newMysqlTypeId = mysqlTypeId;
                if (length <= MysqlType.TINYBLOB.getPrecision()) {
                    newMysqlTypeId = 249;
                } else {
                    if (length <= MysqlType.BLOB.getPrecision()) {
                        if (!isBinary || collationIndex != 63 || propertySet.getBooleanReadableProperty("blobsAreStrings").getValue().booleanValue() || isFromFunction && propertySet.getBooleanReadableProperty("functionsNeverReturnBlobs").getValue().booleanValue()) {
                            newMysqlTypeId = 15;
                            return MysqlType.TEXT;
                        }
                        return MysqlType.BLOB;
                    }
                    newMysqlTypeId = length <= MysqlType.MEDIUMBLOB.getPrecision() ? 250 : 251;
                }
                return MysqlaProtocol.findMysqlType(propertySet, newMysqlTypeId, colFlag, length, tableName, originalTableName, collationIndex, encoding);
            }
            case 254: {
                if (isOpaqueBinary && !propertySet.getBooleanReadableProperty("blobsAreStrings").getValue().booleanValue()) {
                    return MysqlType.BINARY;
                }
                return MysqlType.CHAR;
            }
            case 255: {
                return MysqlType.GEOMETRY;
            }
        }
        return MysqlType.UNKNOWN;
    }

    @Override
    public <T extends ProtocolEntity> T read(Class<T> requiredClass, ProtocolEntityFactory<T> protocolEntityFactory) throws IOException {
        ProtocolEntityReader<? extends ProtocolEntity> sr = this.PROTOCOL_ENTITY_CLASS_TO_TEXT_READER.get(requiredClass);
        if (sr == null) {
            throw ExceptionFactory.createException(FeatureNotAvailableException.class, "ProtocolEntityReader isn't available for class " + requiredClass);
        }
        return (T)sr.read(protocolEntityFactory);
    }

    @Override
    public <T extends ProtocolEntity> T read(Class<Resultset> requiredClass, int maxRows, boolean streamResults, PacketPayload resultPacket, boolean isBinaryEncoded, ColumnDefinition metadata, ProtocolEntityFactory<T> protocolEntityFactory) throws IOException {
        ProtocolEntityReader<? extends ProtocolEntity> sr;
        ProtocolEntityReader<? extends ProtocolEntity> protocolEntityReader = sr = isBinaryEncoded ? this.PROTOCOL_ENTITY_CLASS_TO_BINARY_READER.get(requiredClass) : this.PROTOCOL_ENTITY_CLASS_TO_TEXT_READER.get(requiredClass);
        if (sr == null) {
            throw ExceptionFactory.createException(FeatureNotAvailableException.class, "ProtocolEntityReader isn't available for class " + requiredClass);
        }
        return (T)sr.read(maxRows, streamResults, resultPacket, metadata, protocolEntityFactory);
    }

    public <T extends ProtocolEntity> T readNextResultset(T currentProtocolEntity, int maxRows, boolean streamResults, boolean isBinaryEncoded, ProtocolEntityFactory<T> resultSetFactory) throws IOException {
        T result = null;
        if (Resultset.class.isAssignableFrom(currentProtocolEntity.getClass()) && this.serverSession.useMultiResults() && this.serverSession.hasMoreResults()) {
            T currentResultSet = currentProtocolEntity;
            do {
                PacketPayload fieldPacket = this.checkErrorPacket();
                fieldPacket.setPosition(0);
                T newResultSet = this.read(Resultset.class, maxRows, streamResults, fieldPacket, isBinaryEncoded, null, resultSetFactory);
                ((Resultset)currentResultSet).setNextResultset((Resultset)newResultSet);
                currentResultSet = newResultSet;
                if (result != null) continue;
                result = currentResultSet;
            } while (streamResults && this.serverSession.hasMoreResults() && !((Resultset)currentResultSet).hasRows());
        }
        return result;
    }

    public <T extends Resultset> T readAllResults(int maxRows, boolean streamResults, PacketPayload resultPacket, boolean isBinaryEncoded, ColumnDefinition metadata, ProtocolEntityFactory<T> resultSetFactory) throws IOException {
        resultPacket.setPosition(0);
        Resultset topLevelResultSet = (Resultset)this.read(Resultset.class, maxRows, streamResults, resultPacket, isBinaryEncoded, metadata, resultSetFactory);
        if (this.serverSession.hasMoreResults()) {
            Resultset currentResultSet = topLevelResultSet;
            if (streamResults) {
                currentResultSet = this.readNextResultset(currentResultSet, maxRows, true, isBinaryEncoded, resultSetFactory);
            } else {
                while (this.serverSession.hasMoreResults()) {
                    currentResultSet = this.readNextResultset(currentResultSet, maxRows, false, isBinaryEncoded, resultSetFactory);
                }
                this.clearInputStream();
            }
        }
        this.reclaimLargeReusablePacket();
        return (T)topLevelResultSet;
    }

    public final <T> T readServerStatusForResultSets(PacketPayload rowPacket, boolean saveOldStatus) {
        OkPacket result = null;
        if (rowPacket.isEOFPacket()) {
            rowPacket.readInteger(NativeProtocol.IntegerDataType.INT1);
            this.warningCount = (int)rowPacket.readInteger(NativeProtocol.IntegerDataType.INT2);
            if (this.warningCount > 0) {
                this.hadWarnings = true;
            }
            this.serverSession.setStatusFlags((int)rowPacket.readInteger(NativeProtocol.IntegerDataType.INT2), saveOldStatus);
            this.checkTransactionState();
        } else {
            OkPacket ok;
            result = ok = OkPacket.parse(rowPacket, ((JdbcConnection)this.connection).isReadInfoMsgEnabled(), this.serverSession.getErrorMessageEncoding());
            this.serverSession.setStatusFlags(ok.getStatusFlags(), saveOldStatus);
            this.checkTransactionState();
            this.warningCount = ok.getWarningCount();
            if (this.warningCount > 0) {
                this.hadWarnings = true;
            }
        }
        this.setServerSlowQueryFlags();
        return (T)result;
    }

    @Override
    public InputStream getLocalInfileInputStream() {
        return this.localInfileInputStream;
    }

    @Override
    public void setLocalInfileInputStream(InputStream stream) {
        this.localInfileInputStream = stream;
    }

    public final PacketPayload sendFileToServer(String fileName) {
        PacketPayload filePacket = this.loadFileBufRef == null ? null : this.loadFileBufRef.get();
        int bigPacketLength = Math.min(this.maxAllowedPacket.getValue() - 12, this.alignPacketSize(this.maxAllowedPacket.getValue() - 16, 4096) - 12);
        int oneMeg = 0x100000;
        int smallerPacketSizeAligned = Math.min(oneMeg - 12, this.alignPacketSize(oneMeg - 16, 4096) - 12);
        int packetLength = Math.min(smallerPacketSizeAligned, bigPacketLength);
        if (filePacket == null) {
            try {
                filePacket = new Buffer(packetLength);
                this.loadFileBufRef = new SoftReference<PacketPayload>(filePacket);
            }
            catch (OutOfMemoryError oom) {
                throw ExceptionFactory.createException(Messages.getString("MysqlIO.111", new Object[]{packetLength}), "HY001", 0, false, oom, this.exceptionInterceptor);
            }
        }
        filePacket.setPosition(0);
        byte[] fileBuf = new byte[packetLength];
        BufferedInputStream fileIn = null;
        try {
            if (!this.propertySet.getBooleanReadableProperty("allowLoadLocalInfile").getValue().booleanValue()) {
                throw ExceptionFactory.createException(Messages.getString("MysqlIO.LoadDataLocalNotAllowed"), this.exceptionInterceptor);
            }
            InputStream hookedStream = null;
            hookedStream = this.getLocalInfileInputStream();
            if (hookedStream != null) {
                fileIn = new BufferedInputStream(hookedStream);
            } else if (!this.propertySet.getBooleanReadableProperty("allowUrlInLocalInfile").getValue().booleanValue()) {
                fileIn = new BufferedInputStream(new FileInputStream(fileName));
            } else if (fileName.indexOf(58) != -1) {
                try {
                    URL urlFromFileName = new URL(fileName);
                    fileIn = new BufferedInputStream(urlFromFileName.openStream());
                }
                catch (MalformedURLException badUrlEx) {
                    fileIn = new BufferedInputStream(new FileInputStream(fileName));
                }
            } else {
                fileIn = new BufferedInputStream(new FileInputStream(fileName));
            }
            int bytesRead = 0;
            while ((bytesRead = fileIn.read(fileBuf)) != -1) {
                filePacket.setPosition(0);
                filePacket.writeBytes(NativeProtocol.StringLengthDataType.STRING_FIXED, fileBuf, 0, bytesRead);
                this.send(filePacket, filePacket.getPosition());
            }
        }
        catch (IOException ioEx) {
            StringBuilder messageBuf = new StringBuilder(Messages.getString("MysqlIO.60"));
            boolean isParanoid = this.propertySet.getBooleanReadableProperty("paranoid").getValue();
            if (fileName != null && !isParanoid) {
                messageBuf.append("'");
                messageBuf.append(fileName);
                messageBuf.append("'");
            }
            messageBuf.append(Messages.getString("MysqlIO.63"));
            if (!isParanoid) {
                messageBuf.append(Messages.getString("MysqlIO.64"));
                messageBuf.append(Util.stackTraceToString(ioEx));
            }
            throw ExceptionFactory.createException(messageBuf.toString(), ioEx, this.exceptionInterceptor);
        }
        finally {
            if (fileIn != null) {
                try {
                    fileIn.close();
                }
                catch (Exception ex) {
                    throw ExceptionFactory.createException(Messages.getString("MysqlIO.65"), ex, this.exceptionInterceptor);
                }
                fileIn = null;
            } else {
                filePacket.setPosition(0);
                this.send(filePacket, filePacket.getPosition());
                this.checkErrorPacket();
            }
        }
        filePacket.setPosition(0);
        this.send(filePacket, filePacket.getPosition());
        return this.checkErrorPacket();
    }

    private int alignPacketSize(int a, int l) {
        return a + l - 1 & ~(l - 1);
    }

    public ResultsetRows getStreamingData() {
        return this.streamingData;
    }

    public void setStreamingData(ResultsetRows streamingData) {
        this.streamingData = streamingData;
    }

    public void checkForOutstandingStreamingData() {
        try {
            if (this.streamingData != null) {
                boolean shouldClobber = this.propertySet.getBooleanReadableProperty("clobberStreamingResults").getValue();
                if (!shouldClobber) {
                    throw SQLError.createSQLException(Messages.getString("MysqlIO.39") + this.streamingData + Messages.getString("MysqlIO.40") + Messages.getString("MysqlIO.41") + Messages.getString("MysqlIO.42"), this.exceptionInterceptor);
                }
                this.streamingData.getOwner().closeOwner(false);
                this.clearInputStream();
            }
        }
        catch (SQLException ex) {
            throw ExceptionFactory.createException(ex.getMessage(), ex);
        }
    }

    public void closeStreamer(ResultsetRows streamer) {
        if (this.streamingData == null) {
            throw ExceptionFactory.createException(Messages.getString("MysqlIO.17") + streamer + Messages.getString("MysqlIO.18"), this.exceptionInterceptor);
        }
        if (streamer != this.streamingData) {
            throw ExceptionFactory.createException(Messages.getString("MysqlIO.19") + streamer + Messages.getString("MysqlIO.20") + Messages.getString("MysqlIO.21") + Messages.getString("MysqlIO.22"), this.exceptionInterceptor);
        }
        this.streamingData = null;
    }

    public void scanForAndThrowDataTruncation() throws SQLException {
        if (this.streamingData == null && this.propertySet.getBooleanReadableProperty("jdbcCompliantTruncation").getValue().booleanValue() && this.getWarningCount() > 0) {
            ResultSetUtil.convertShowWarningsToSQLWarnings(this.connection, this.getWarningCount(), true);
        }
    }

    static {
        OutputStreamWriter outWriter = null;
        try {
            outWriter = new OutputStreamWriter(new ByteArrayOutputStream());
            jvmPlatformCharset = outWriter.getEncoding();
        }
        finally {
            try {
                if (outWriter != null) {
                    outWriter.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

