/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.BufferedChecksumIndexInput;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.util.IOUtils;

public abstract class Directory
implements Closeable {
    public abstract String[] listAll() throws IOException;

    public abstract void deleteFile(String var1) throws IOException;

    public abstract long fileLength(String var1) throws IOException;

    public abstract IndexOutput createOutput(String var1, IOContext var2) throws IOException;

    public abstract IndexOutput createTempOutput(String var1, String var2, IOContext var3) throws IOException;

    public abstract void sync(Collection<String> var1) throws IOException;

    public abstract void syncMetaData() throws IOException;

    public abstract void rename(String var1, String var2) throws IOException;

    public abstract IndexInput openInput(String var1, IOContext var2) throws IOException;

    public ChecksumIndexInput openChecksumInput(String name, IOContext context) throws IOException {
        return new BufferedChecksumIndexInput(this.openInput(name, context));
    }

    public abstract Lock obtainLock(String var1) throws IOException;

    @Override
    public abstract void close() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void copyFrom(Directory from, String src, String dest, IOContext context) throws IOException {
        boolean success = false;
        try {
            try (IndexInput is = from.openInput(src, context);
                 IndexOutput os = this.createOutput(dest, context);){
                os.copyBytes(is, is.length());
                success = true;
            }
            if (success) return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.deleteFilesIgnoringExceptions(this, dest);
            throw throwable;
        }
        IOUtils.deleteFilesIgnoringExceptions(this, dest);
    }

    public String toString() {
        return this.getClass().getSimpleName() + '@' + Integer.toHexString(this.hashCode());
    }

    protected void ensureOpen() throws AlreadyClosedException {
    }

    public abstract Set<String> getPendingDeletions() throws IOException;
}

