/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search.dependencies;

import java.util.HashMap;
import java.util.Set;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;

public class DependencyCalculator {
    boolean fIncludeOptional;
    protected HashMap<String, IPluginModelBase> fDependencies;

    public DependencyCalculator(boolean includeOptional) {
        this.fIncludeOptional = includeOptional;
    }

    public void findDependencies(Object[] includedBundles) {
        if (this.fDependencies == null) {
            this.fDependencies = new HashMap();
        }
        Object[] objectArray = includedBundles;
        int n = includedBundles.length;
        int n2 = 0;
        while (n2 < n) {
            Object bundle = objectArray[n2];
            this.findObjectDependencies(bundle);
            ++n2;
        }
    }

    public void findDependency(Object bundle) {
        if (this.fDependencies == null) {
            this.fDependencies = new HashMap();
        }
        this.findObjectDependencies(bundle);
    }

    private void findObjectDependencies(Object obj) {
        IPluginModelBase base;
        BundleDescription desc;
        if (obj instanceof IPluginModelBase && (desc = (base = (IPluginModelBase)obj).getBundleDescription()) != null) {
            obj = desc;
        }
        if (obj instanceof BundleDescription) {
            this.findDependencies((BundleDescription)obj);
        }
    }

    public Set<String> getBundleIDs() {
        Set<String> temp = this.fDependencies.keySet();
        this.fDependencies = null;
        return temp;
    }

    protected void findDependencies(BundleDescription desc) {
        if (desc == null) {
            return;
        }
        String id = desc.getSymbolicName();
        if (this.fDependencies.containsKey(id)) {
            return;
        }
        IPluginModelBase model = PluginRegistry.findModel((BundleDescription)desc);
        if (model == null) {
            return;
        }
        this.fDependencies.put(id, model);
        this.addRequiredBundles(desc.getRequiredBundles());
        this.addImportedPackages(desc.getImportPackages());
        HostSpecification host = desc.getHost();
        if (host != null) {
            BaseDescription bd = host.getSupplier();
            if (bd != null && bd instanceof BundleDescription) {
                this.findDependencies((BundleDescription)bd);
            }
        } else {
            this.addFragments(desc);
        }
    }

    protected void addRequiredBundles(BundleSpecification[] requiredBundles) {
        BundleSpecification[] bundleSpecificationArray = requiredBundles;
        int n = requiredBundles.length;
        int n2 = 0;
        while (n2 < n) {
            BaseDescription bd;
            BundleSpecification bundle = bundleSpecificationArray[n2];
            if ((!bundle.isOptional() || this.fIncludeOptional) && (bd = bundle.getSupplier()) != null && bd instanceof BundleDescription) {
                this.findDependencies((BundleDescription)bd);
            }
            ++n2;
        }
    }

    protected void addImportedPackages(ImportPackageSpecification[] packages) {
        ImportPackageSpecification[] importPackageSpecificationArray = packages;
        int n = packages.length;
        int n2 = 0;
        while (n2 < n) {
            BundleDescription exporter;
            BaseDescription bd;
            ImportPackageSpecification pkg = importPackageSpecificationArray[n2];
            if ((this.fIncludeOptional || !"optional".equals(pkg.getDirective("resolution"))) && (bd = pkg.getSupplier()) != null && bd instanceof ExportPackageDescription && (exporter = ((ExportPackageDescription)bd).getExporter()) != null) {
                this.findDependencies(exporter);
            }
            ++n2;
        }
    }

    protected void addFragments(BundleDescription desc) {
        BundleDescription[] fragments;
        BundleDescription[] bundleDescriptionArray = fragments = desc.getFragments();
        int n = fragments.length;
        int n2 = 0;
        while (n2 < n) {
            BundleDescription fragment = bundleDescriptionArray[n2];
            if (fragment.isResolved()) {
                this.findDependencies(fragment);
            }
            ++n2;
        }
    }

    public boolean containsPluginId(String id) {
        return this.fDependencies.containsKey(id);
    }
}

