/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.snippets.internal.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wst.common.snippets.internal.util.TableViewerImpl;

public class AccessibleTableViewer
extends StructuredViewer {
    protected Table fTable;
    protected TableEditor fTableEditor;
    protected TableViewerImpl fTableViewerImpl;

    public AccessibleTableViewer(Composite parent) {
        this(parent, 2818);
    }

    public AccessibleTableViewer(Composite parent, int style) {
        this(new Table(parent, style));
    }

    public AccessibleTableViewer(Table table) {
        this.fTable = table;
        this.addKeyListener();
        this.hookControl((Control)table);
        this.fTableEditor = new TableEditor(table);
        this.initTableViewerImpl();
    }

    public void add(Object element) {
        this.add(new Object[]{element});
    }

    public void add(Object[] elements) {
        Object[] filtered = this.filter(elements);
        int i = 0;
        while (i < filtered.length) {
            Object element = filtered[i];
            int index = this.indexForElement(element);
            this.updateItem((Widget)new TableItem(this.getTable(), 0, index), element);
            ++i;
        }
    }

    private void addKeyListener() {
        if (this.fTable != null && !this.fTable.isDisposed()) {
            this.fTable.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    TableItem[] selectedItems;
                    if ((e.character == '\r' || e.character == ' ') && (selectedItems = AccessibleTableViewer.this.fTable.getSelection()) != null && selectedItems.length == 1) {
                        AccessibleTableViewer.this.fTableViewerImpl.setTableItem((Item)selectedItems[0]);
                        AccessibleTableViewer.this.fTableViewerImpl.activateFirstCellEditor();
                    }
                }
            });
        }
    }

    public void cancelEditing() {
        this.fTableViewerImpl.cancelEditing();
    }

    protected Widget doFindInputItem(Object element) {
        if (element.equals(this.getRoot())) {
            return this.getTable();
        }
        return null;
    }

    protected Widget doFindItem(Object element) {
        TableItem[] children = this.fTable.getItems();
        int i = 0;
        while (i < children.length) {
            TableItem item = children[i];
            Object data = item.getData();
            if (data != null && data.equals(element)) {
                return item;
            }
            ++i;
        }
        return null;
    }

    protected void doUpdateItem(Widget widget, Object element, boolean fullMap) {
        if (widget instanceof TableItem) {
            TableItem item = (TableItem)widget;
            if (fullMap) {
                this.associate(element, (Item)item);
            } else {
                item.setData(element);
                this.mapElement(element, (Widget)item);
            }
            IBaseLabelProvider prov = this.getLabelProvider();
            ITableLabelProvider tprov = null;
            ILabelProvider lprov = null;
            if (prov instanceof ITableLabelProvider) {
                tprov = (ITableLabelProvider)prov;
            } else {
                lprov = (ILabelProvider)prov;
            }
            int columnCount = this.fTable.getColumnCount();
            int column = 0;
            while (column < columnCount || column == 0) {
                TableItem ti = item;
                String text = "";
                Image image = null;
                if (tprov != null) {
                    text = tprov.getColumnText(element, column);
                    image = tprov.getColumnImage(element, column);
                } else if (column == 0) {
                    text = lprov.getText(element);
                    image = lprov.getImage(element);
                }
                ti.setText(column, text);
                if (ti.getImage(column) != image) {
                    ti.setImage(column, image);
                }
                ++column;
            }
        }
    }

    public void editElement(Object element, int column) {
        this.fTableViewerImpl.editElement(element, column);
    }

    public void finishEditing() {
        this.fTableViewerImpl.applyEditorValue();
    }

    public CellEditor[] getCellEditors() {
        return this.fTableViewerImpl.getCellEditors();
    }

    public ICellModifier getCellModifier() {
        return this.fTableViewerImpl.getCellModifier();
    }

    public Object[] getColumnProperties() {
        return this.fTableViewerImpl.getColumnProperties();
    }

    public Control getControl() {
        return this.fTable;
    }

    public Object getElementAt(int index) {
        TableItem i;
        if (index >= 0 && index < this.fTable.getItemCount() && (i = this.fTable.getItem(index)) != null) {
            return i.getData();
        }
        return null;
    }

    public IBaseLabelProvider getLabelProvider() {
        return super.getLabelProvider();
    }

    protected List getSelectionFromWidget() {
        TableItem[] items = this.fTable.getSelection();
        ArrayList<Object> list = new ArrayList<Object>(items.length);
        int i = 0;
        while (i < items.length) {
            TableItem item = items[i];
            Object e = item.getData();
            if (e != null) {
                list.add(e);
            }
            ++i;
        }
        return list;
    }

    public Table getTable() {
        return this.fTable;
    }

    protected void hookControl(Control control) {
        super.hookControl(control);
        Table tableControl = (Table)control;
        tableControl.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                AccessibleTableViewer.this.handleDoubleSelect(e);
            }

            public void widgetSelected(SelectionEvent e) {
                AccessibleTableViewer.this.handleSelect(e);
            }
        });
        tableControl.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                AccessibleTableViewer.this.fTableViewerImpl.handleMouseDoubleClick(e);
            }

            public void mouseDown(MouseEvent e) {
                AccessibleTableViewer.this.fTableViewerImpl.handleMouseDown(e);
            }
        });
    }

    protected int indexForElement(Object element) {
        ViewerSorter sorter = this.getSorter();
        if (sorter == null) {
            return this.fTable.getItemCount();
        }
        int count = this.fTable.getItemCount();
        int min = 0;
        int max = count - 1;
        while (min <= max) {
            int mid = (min + max) / 2;
            Object data = this.fTable.getItem(mid).getData();
            int compare = sorter.compare((Viewer)this, data, element);
            if (compare == 0) {
                while (compare == 0) {
                    if (++mid >= count) break;
                    data = this.fTable.getItem(mid).getData();
                    compare = sorter.compare((Viewer)this, data, element);
                }
                return mid;
            }
            if (compare < 0) {
                min = mid + 1;
                continue;
            }
            max = mid - 1;
        }
        return min;
    }

    protected void initTableViewerImpl() {
        this.fTableViewerImpl = new TableViewerImpl(this.fTable){

            @Override
            Rectangle getBounds(Item item, int columnNumber) {
                return ((TableItem)item).getBounds(columnNumber);
            }

            @Override
            int getColumnCount() {
                return AccessibleTableViewer.this.getTable().getColumnCount();
            }

            @Override
            Item[] getSelection() {
                return AccessibleTableViewer.this.getTable().getSelection();
            }

            @Override
            void setEditor(Control w, Item item, int columnNumber) {
                AccessibleTableViewer.this.fTableEditor.setEditor(w, (TableItem)item, columnNumber);
            }

            @Override
            void setLayoutData(CellEditor.LayoutData layoutData) {
                AccessibleTableViewer.this.fTableEditor.grabHorizontal = layoutData.grabHorizontal;
                AccessibleTableViewer.this.fTableEditor.horizontalAlignment = layoutData.horizontalAlignment;
                AccessibleTableViewer.this.fTableEditor.minimumWidth = layoutData.minimumWidth;
            }

            @Override
            void setSelection(StructuredSelection selection, boolean b) {
                AccessibleTableViewer.this.setSelection((ISelection)selection, b);
            }

            @Override
            void showSelection() {
                AccessibleTableViewer.this.getTable().showSelection();
            }
        };
    }

    protected void inputChanged(Object input, Object oldInput) {
        this.getControl().setRedraw(false);
        try {
            this.refresh();
        }
        finally {
            this.getControl().setRedraw(true);
        }
    }

    public void insert(Object element, int position) {
        this.fTableViewerImpl.applyEditorValue();
        if (this.getSorter() != null || this.hasFilters()) {
            this.add(element);
            return;
        }
        if (position == -1) {
            position = this.fTable.getItemCount();
        }
        this.updateItem((Widget)new TableItem(this.fTable, 0, position), element);
    }

    protected void internalRefresh(Object element) {
        this.internalRefresh(element, true);
    }

    protected void internalRefresh(Object element, boolean updateLabels) {
        this.fTableViewerImpl.applyEditorValue();
        if (element == null || element.equals(this.getRoot())) {
            Object[] children = this.getSortedChildren(this.getRoot());
            TableItem[] items = this.fTable.getItems();
            int min = Math.min(children.length, items.length);
            int i = 0;
            while (i < min) {
                if (children[i] != null && items[i] != null) {
                    if (children[i].equals(items[i].getData())) {
                        if (updateLabels) {
                            this.updateItem((Widget)items[i], children[i]);
                        }
                    } else {
                        this.disassociate((Item)items[i]);
                    }
                }
                ++i;
            }
            if (min < items.length) {
                i = items.length;
                while (--i >= min) {
                    this.disassociate((Item)items[i]);
                }
                this.fTable.remove(min, items.length - 1);
            }
            if (this.fTable.getItemCount() == 0) {
                this.fTable.removeAll();
            }
            i = 0;
            while (i < min) {
                if (items[i].getData() == null) {
                    this.updateItem((Widget)items[i], children[i]);
                }
                ++i;
            }
            i = min;
            while (i < children.length) {
                this.updateItem((Widget)new TableItem(this.fTable, 0, i), children[i]);
                ++i;
            }
        } else {
            Widget w = this.findItem(element);
            if (w != null) {
                this.updateItem(w, element);
            }
        }
    }

    private void internalRemove(Object[] elements) {
        Object input = this.getInput();
        int i = 0;
        while (i < elements.length) {
            if (elements[i].equals(input)) {
                this.setInput(null);
                return;
            }
            ++i;
        }
        int[] indices = new int[elements.length];
        int count = 0;
        int i2 = 0;
        while (i2 < elements.length) {
            Widget w = this.findItem(elements[i2]);
            if (w instanceof TableItem) {
                TableItem item = (TableItem)w;
                this.disassociate((Item)item);
                indices[count++] = this.fTable.indexOf(item);
            }
            ++i2;
        }
        if (count < indices.length) {
            int[] nArray = indices;
            indices = new int[count];
            System.arraycopy(nArray, 0, indices, 0, count);
        }
        this.fTable.remove(indices);
        if (this.fTable.getItemCount() == 0) {
            this.fTable.removeAll();
        }
    }

    public boolean isCellEditorActive() {
        return this.fTableViewerImpl.isCellEditorActive();
    }

    public void remove(Object element) {
        this.remove(new Object[]{element});
    }

    public void remove(final Object[] elements) {
        this.preservingSelection(new Runnable(){

            @Override
            public void run() {
                AccessibleTableViewer.this.internalRemove(elements);
            }
        });
    }

    public void reveal(Object element) {
        Widget w = this.findItem(element);
        if (w instanceof TableItem) {
            this.getTable().showItem((TableItem)w);
        }
    }

    public void setCellEditors(CellEditor[] editors) {
        this.fTableViewerImpl.setCellEditors(editors);
    }

    public void setCellModifier(ICellModifier modifier) {
        this.fTableViewerImpl.setCellModifier(modifier);
    }

    public void setColumnProperties(String[] columnProperties) {
        this.fTableViewerImpl.setColumnProperties(columnProperties);
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        Assert.isTrue((labelProvider instanceof ITableLabelProvider || labelProvider instanceof ILabelProvider ? 1 : 0) != 0);
        super.setLabelProvider(labelProvider);
    }

    protected void setSelectionToWidget(List list, boolean reveal) {
        if (list == null) {
            this.fTable.deselectAll();
            return;
        }
        int size = list.size();
        TableItem[] items = new TableItem[size];
        TableItem firstItem = null;
        int count = 0;
        int i = 0;
        while (i < size) {
            Object o = list.get(i);
            Widget w = this.findItem(o);
            if (w instanceof TableItem) {
                TableItem item = (TableItem)w;
                items[count++] = item;
                if (firstItem == null) {
                    firstItem = item;
                }
            }
            ++i;
        }
        if (count < size) {
            TableItem[] tableItemArray = items;
            items = new TableItem[count];
            System.arraycopy(tableItemArray, 0, items, 0, count);
        }
        this.fTable.setSelection(items);
        if (reveal && firstItem != null) {
            this.fTable.showItem(firstItem);
        }
    }

    public void setSingleClickCellSelect(boolean b) {
        this.fTableViewerImpl.setSingleClickCellSelect(b);
    }
}

