/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.common.core.log.TraceCompassLogUtils;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.TmfFilterAppliedSignal;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.TimeQueryRegexFilter;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.xy.ISeriesModel;
import org.eclipse.tracecompass.tmf.core.model.xy.ITmfXYDataProvider;
import org.eclipse.tracecompass.tmf.core.model.xy.ITmfXyModel;
import org.eclipse.tracecompass.tmf.core.presentation.IXYPresentationProvider;
import org.eclipse.tracecompass.tmf.core.presentation.IYAppearance;
import org.eclipse.tracecompass.tmf.core.presentation.RGBAColor;
import org.eclipse.tracecompass.tmf.core.presentation.XYPresentationProvider;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.colors.RGBAUtil;
import org.eclipse.tracecompass.tmf.ui.signal.TmfTimeViewAlignmentInfo;
import org.eclipse.tracecompass.tmf.ui.signal.TmfTimeViewAlignmentSignal;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfChartTimeStampFormat;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfXYChartViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts.TmfCommonXLineChartTooltipProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts.TmfXYChartSettings;
import org.swtchart.IBarSeries;
import org.swtchart.ILineSeries;
import org.swtchart.ISeries;
import org.swtchart.ISeriesSet;
import org.swtchart.LineStyle;
import org.swtchart.Range;

public abstract class TmfCommonXAxisChartViewer
extends TmfXYChartViewer {
    private static final String DIRTY_UNDERFLOW_ERROR = "Dirty underflow error";
    private static final Map<String, ILineSeries.PlotSymbolType> SYMBOL_MAP;
    private static final ColorRegistry COLOR_REGISTRY;
    private static final double DEFAULT_MAXY = Double.MIN_VALUE;
    private static final double DEFAULT_MINY = Double.MAX_VALUE;
    private static final long BUILD_UPDATE_TIMEOUT = 500L;
    private static final @NonNull Logger LOGGER;
    private static final int DEFAULT_SERIES_WIDTH = 1;
    private static final String DIMMED_SERIES_SUFFIX = ".dimmed";
    private final double fResolution;
    private final AtomicInteger fDirty = new AtomicInteger();
    private final Map<ITmfTrace, IXYPresentationProvider> fXYPresentationProvider;
    private UpdateThread fUpdateThread;
    private int fOverrideNbPoints = 0;
    private Collection<@NonNull String> fGlobalFilter = Collections.emptyList();

    static {
        COLOR_REGISTRY = new ColorRegistry();
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        builder.put((Object)"NONE", (Object)ILineSeries.PlotSymbolType.NONE);
        builder.put((Object)"CIRCLE", (Object)ILineSeries.PlotSymbolType.CIRCLE);
        builder.put((Object)"CROSS", (Object)ILineSeries.PlotSymbolType.CROSS);
        builder.put((Object)"DIAMOND", (Object)ILineSeries.PlotSymbolType.DIAMOND);
        builder.put((Object)"INVERTED_TRIANGLE", (Object)ILineSeries.PlotSymbolType.INVERTED_TRIANGLE);
        builder.put((Object)"TRIANGLE", (Object)ILineSeries.PlotSymbolType.TRIANGLE);
        builder.put((Object)"PLUS", (Object)ILineSeries.PlotSymbolType.PLUS);
        builder.put((Object)"SQUARE", (Object)ILineSeries.PlotSymbolType.SQUARE);
        SYMBOL_MAP = builder.build();
        LOGGER = TraceCompassLog.getLogger(TmfCommonXAxisChartViewer.class);
    }

    public TmfCommonXAxisChartViewer(Composite parent, TmfXYChartSettings settings) {
        super(parent, settings.getTitle(), settings.getXLabel(), settings.getYLabel());
        this.getSwtChart().getTitle().setVisible(false);
        this.getSwtChart().getLegend().setPosition(1024);
        this.getSwtChart().getAxisSet().getXAxes()[0].getTitle().setVisible(false);
        this.fResolution = settings.getResolution();
        this.setTooltipProvider(new TmfCommonXLineChartTooltipProvider(this));
        this.fXYPresentationProvider = new HashMap<ITmfTrace, IXYPresentationProvider>();
    }

    @Override
    public void loadTrace(ITmfTrace trace) {
        super.loadTrace(trace);
        this.fXYPresentationProvider.putIfAbsent(trace, (IXYPresentationProvider)new XYPresentationProvider());
    }

    @Override
    public boolean isDirty() {
        return super.isDirty() || this.fDirty.get() != 0;
    }

    public synchronized void setNbPoints(int nbPoints) {
        if (nbPoints < 0) {
            throw new IllegalArgumentException("Number of points cannot be negative");
        }
        this.fOverrideNbPoints = nbPoints;
        this.updateContent();
    }

    protected ITmfXYDataProvider initializeDataProvider(@NonNull ITmfTrace trace) {
        throw new UnsupportedOperationException("This needs to be implemented concrete classes");
    }

    protected IXYPresentationProvider getPresentationProvider() {
        return Objects.requireNonNull(this.fXYPresentationProvider.get(this.getTrace()));
    }

    @Deprecated
    protected @NonNull TimeQueryFilter createQueryFilter(long start, long end, int nb) {
        return new TimeQueryRegexFilter(this.getWindowStartTime(), this.getWindowEndTime(), nb, this.getRegexes());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @NonNull Map<String, Object> createQueryParameters(long start, long end, int nb) {
        @NonNull @NonNull Map parameters = FetchParametersUtils.timeQueryToMap((TimeQueryFilter)new TimeQueryFilter(start, end, nb));
        Multimap<@NonNull Integer, @NonNull String> regexesMap = this.getRegexes();
        if (!regexesMap.isEmpty()) {
            parameters.put("regex_map_filters", regexesMap.asMap());
        }
        return parameters;
    }

    public @NonNull IYAppearance getSeriesAppearance(@NonNull String seriesName) {
        return this.getPresentationProvider().getAppearance(seriesName, "line", 1);
    }

    protected synchronized void cancelUpdate() {
        if (this.fUpdateThread != null) {
            this.fUpdateThread.cancel();
        }
    }

    @Override
    protected void updateContent() {
        ITmfTrace trace = this.getTrace();
        if (trace == null) {
            return;
        }
        this.cancelUpdate();
        Throwable throwable = null;
        Object var3_4 = null;
        try (TraceCompassLogUtils.FlowScopeLog parentScope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "CommonXLineChart:ContentUpdateRequested", new Object[0]).setCategory(this.getViewerId()).build();){
            this.fDirty.incrementAndGet();
            TmfCommonXAxisChartViewer.getDisplay().asyncExec(() -> {
                if (!trace.equals(this.getTrace())) {
                    return;
                }
                Throwable throwable = null;
                Object var4_5 = null;
                try (TraceCompassLogUtils.FlowScopeLog scope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "CommonXLineChart:CreatingUpdateThread", new Object[0]).setParentScope(parentScope).build();){
                    this.newUpdateThread(trace, scope);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected void clearContent() {
        this.getSwtChart().getAxisSet().getXAxis(0).getTick().setFormat(null);
        super.clearContent();
    }

    private @NonNull String getViewerId() {
        return this.getClass().getName();
    }

    private synchronized void newUpdateThread(@NonNull ITmfTrace trace, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull TraceCompassLogUtils.FlowScopeLog fScope) {
        if (this.getSwtChart().isDisposed()) {
            return;
        }
        int numRequests = this.fOverrideNbPoints != 0 ? this.fOverrideNbPoints : (int)Math.min(this.getWindowEndTime() - this.getWindowStartTime() + 1L, (long)((double)this.getSwtChart().getPlotArea().getBounds().width * this.fResolution));
        this.fUpdateThread = new UpdateThread(trace, numRequests, fScope);
        this.fUpdateThread.start();
    }

    @Override
    @TmfSignalHandler
    public void traceClosed(@Nullable TmfTraceClosedSignal signal) {
        this.cancelUpdate();
        super.traceClosed(signal);
        if (signal != null) {
            this.fXYPresentationProvider.remove(signal.getTrace());
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @TmfSignalHandler
    public void regexFilterApplied(TmfFilterAppliedSignal signal) {
        @NonNull Collection regex = signal.getFilter().getRegexes();
        this.setGlobalRegexFilter(regex);
        this.updateContent();
    }

    private void setGlobalRegexFilter(Collection<@NonNull String> regex) {
        this.fGlobalFilter = regex;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @NonNull Multimap<@NonNull Integer, @NonNull String> getRegexes() {
        @NonNull @NonNull HashMultimap regexes = HashMultimap.create();
        if (this.fGlobalFilter != null && !this.fGlobalFilter.isEmpty()) {
            regexes.putAll((Object)1, (Iterable)NonNullUtils.checkNotNull(this.fGlobalFilter));
        }
        return regexes;
    }

    private class UpdateThread
    extends Thread {
        private final ITmfTrace fTrace;
        private final IProgressMonitor fMonitor;
        private final int fNumRequests;
        private final // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull TraceCompassLogUtils.FlowScopeLog fScope;

        public UpdateThread(ITmfTrace trace, @NonNull int numRequests, TraceCompassLogUtils.FlowScopeLog log) {
            super("Line chart update");
            this.fTrace = trace;
            this.fNumRequests = numRequests;
            this.fMonitor = new NullProgressMonitor();
            this.fScope = log;
        }

        @Override
        public void run() {
            Throwable throwable = null;
            Object var2_3 = null;
            try (TraceCompassLogUtils.FlowScopeLog scope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "CommonXLineChart:UpdateThread", new Object[]{"numRequests=", this.fNumRequests}).setParentScope(this.fScope).build();){
                ITmfXYDataProvider dataProvider = null;
                Throwable throwable2 = null;
                Object var6_10 = null;
                try (TraceCompassLogUtils.FlowScopeLog scopeDp = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "CommonXLineChart:InitializeDataProvider", new Object[0]).setParentScope(this.fScope).build();){
                    dataProvider = TmfCommonXAxisChartViewer.this.initializeDataProvider(this.fTrace);
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
                if (dataProvider == null) {
                    TraceCompassLogUtils.traceInstant((Logger)LOGGER, (Level)Level.WARNING, (String)"Data provider for this viewer is not available", (Object[])new Object[0]);
                    return;
                }
                try {
                    int numRequests = this.fNumRequests;
                    if (numRequests == 0) {
                        return;
                    }
                    Map<String, Object> parameters = TmfCommonXAxisChartViewer.this.createQueryParameters(TmfCommonXAxisChartViewer.this.getWindowStartTime(), TmfCommonXAxisChartViewer.this.getWindowEndTime(), numRequests);
                    this.updateData(dataProvider, parameters, this.fMonitor);
                }
                finally {
                    if (TmfCommonXAxisChartViewer.this.fDirty.decrementAndGet() < 0) {
                        Activator.getDefault().logError(TmfCommonXAxisChartViewer.DIRTY_UNDERFLOW_ERROR, new Throwable());
                    }
                }
                this.updateThreadFinished(this);
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }

        public void cancel() {
            TraceCompassLogUtils.traceInstant((Logger)LOGGER, (Level)Level.FINE, (String)"CommonXLineChart:UpdateThreadCanceled", (Object[])new Object[0]);
            this.fMonitor.setCanceled(true);
        }

        private void updateData(@NonNull ITmfXYDataProvider dataProvider, @NonNull Map<String, Object> parameters, IProgressMonitor monitor) {
            boolean isComplete = false;
            do {
                ITmfResponse.Status status;
                TmfModelResponse response;
                ITmfXyModel model;
                if ((model = (ITmfXyModel)(response = dataProvider.fetchXY(parameters, monitor)).getModel()) != null) {
                    this.updateDisplay(model, monitor);
                }
                if ((status = response.getStatus()) == ITmfResponse.Status.COMPLETED) {
                    isComplete = true;
                    continue;
                }
                if (status == ITmfResponse.Status.FAILED || status == ITmfResponse.Status.CANCELLED) {
                    TraceCompassLogUtils.traceInstant((Logger)LOGGER, (Level)Level.WARNING, (String)response.getStatusMessage(), (Object[])new Object[0]);
                    isComplete = true;
                    continue;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    TraceCompassLogUtils.traceInstant((Logger)LOGGER, (Level)Level.INFO, (String)e.getMessage(), (Object[])new Object[0]);
                }
            } while (!isComplete);
        }

        private void updateDisplay(ITmfXyModel model, IProgressMonitor monitor) {
            Throwable throwable = null;
            Object var4_5 = null;
            try (TraceCompassLogUtils.FlowScopeLog scope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "TmfCommonXAxisChart:UpdateDisplayRequested", new Object[0]).setCategory(TmfCommonXAxisChartViewer.this.getViewerId()).build();){
                ITmfXyModel seriesValues = model;
                TmfCommonXAxisChartViewer.this.fDirty.incrementAndGet();
                Display.getDefault().asyncExec(() -> this.lambda$0(scope, monitor, seriesValues));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        private double[] extractXValuesToDisplay(long[] xValuesRequested) {
            double[] xValuesToDisplay = new double[xValuesRequested.length];
            long offset = TmfCommonXAxisChartViewer.this.getTimeOffset();
            int i = 0;
            while (i < xValuesRequested.length) {
                xValuesToDisplay[i] = xValuesRequested[i] - offset;
                ++i;
            }
            return xValuesToDisplay;
        }

        private @NonNull ISeries createSWTSeriesFromModel(ISeriesModel yModel) {
            ISeriesSet seriesSet = TmfCommonXAxisChartViewer.this.getSwtChart().getSeriesSet();
            String seriesName = yModel.getName();
            IYAppearance appearance = TmfCommonXAxisChartViewer.this.getSeriesAppearance(seriesName);
            String type = appearance.getType();
            RGBAColor rgb = appearance.getColor();
            COLOR_REGISTRY.put(rgb.toString(), RGBAUtil.fromRGBAColor((RGBAColor)rgb).rgb);
            Color color = COLOR_REGISTRY.get(rgb.toString());
            String symbolType = appearance.getSymbolStyle();
            if (type.equals("bar")) {
                IBarSeries barSeries = (IBarSeries)seriesSet.createSeries(ISeries.SeriesType.BAR, seriesName);
                barSeries.enableStack(true);
                barSeries.setBarColor(color);
                barSeries.setBarPadding(0);
                barSeries.setVisible(true);
                return barSeries;
            }
            ILineSeries lineSeries = (ILineSeries)seriesSet.createSeries(ISeries.SeriesType.LINE, seriesName);
            lineSeries.enableArea("area".equals(type));
            lineSeries.setLineStyle(LineStyle.valueOf((String)appearance.getStyle()));
            lineSeries.setSymbolType(SYMBOL_MAP.getOrDefault(symbolType, ILineSeries.PlotSymbolType.NONE));
            lineSeries.setLineColor(color);
            lineSeries.setSymbolColor(color);
            lineSeries.setVisible(true);
            lineSeries.setLineWidth(appearance.getWidth());
            return lineSeries;
        }

        private @NonNull ISeries createDimmedSeriesFromModel(ISeriesModel yModel) {
            ISeriesSet seriesSet = TmfCommonXAxisChartViewer.this.getSwtChart().getSeriesSet();
            String seriesName = String.valueOf(yModel.getName()) + TmfCommonXAxisChartViewer.DIMMED_SERIES_SUFFIX;
            IYAppearance appearance = TmfCommonXAxisChartViewer.this.getSeriesAppearance(yModel.getName());
            String type = appearance.getType();
            float[] rgb = appearance.getColor().getHSBA();
            COLOR_REGISTRY.put(rgb.toString(), new RGBA((float)rgb[0], (float)(rgb[1] * 0.5f), (float)(rgb[2] * 0.5f), (float)rgb[3]).rgb);
            Color color = COLOR_REGISTRY.get(rgb.toString());
            String symbolType = appearance.getSymbolStyle();
            if (type.equals("bar")) {
                IBarSeries barSeries = (IBarSeries)seriesSet.createSeries(ISeries.SeriesType.BAR, seriesName);
                barSeries.enableStack(true);
                barSeries.setBarColor(color);
                barSeries.setBarPadding(0);
                barSeries.setVisible(true);
                return barSeries;
            }
            ILineSeries lineSeries = (ILineSeries)seriesSet.createSeries(ISeries.SeriesType.LINE, seriesName);
            lineSeries.enableArea("area".equals(type));
            lineSeries.setLineStyle(LineStyle.valueOf((String)appearance.getStyle()));
            lineSeries.setSymbolType(SYMBOL_MAP.getOrDefault(symbolType, ILineSeries.PlotSymbolType.NONE));
            lineSeries.setLineColor(color);
            lineSeries.setSymbolColor(color);
            lineSeries.setVisible(true);
            lineSeries.setLineWidth(appearance.getWidth());
            return lineSeries;
        }

        private synchronized void updateThreadFinished(UpdateThread thread) {
            if (thread == TmfCommonXAxisChartViewer.this.fUpdateThread) {
                TmfCommonXAxisChartViewer.this.fUpdateThread = null;
            }
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private /* synthetic */ void lambda$0(TraceCompassLogUtils.FlowScopeLog var1_1, IProgressMonitor var2_2, ITmfXyModel var3_3) {
            tmfChartTimeStampFormat = new TmfChartTimeStampFormat(TmfCommonXAxisChartViewer.this.getTimeOffset());
            var5_5 = null;
            var6_7 = null;
            try {
                block38: {
                    block39: {
                        block41: {
                            block40: {
                                block36: {
                                    block37: {
                                        block34: {
                                            block35: {
                                                block32: {
                                                    block33: {
                                                        log = new TraceCompassLogUtils.FlowScopeLogBuilder(TmfCommonXAxisChartViewer.access$0(), Level.FINE, "TmfCommonXAxisChart:UpdateDisplay", new Object[0]).setParentScope(var1_1).build();
                                                        if (this.fTrace.equals(TmfCommonXAxisChartViewer.this.getTrace())) break block32;
                                                        if (log == null) break block33;
                                                        log.close();
                                                    }
                                                    if (TmfCommonXAxisChartViewer.access$1(TmfCommonXAxisChartViewer.this).decrementAndGet() >= 0) return;
                                                    Activator.getDefault().logError("Dirty underflow error", new Throwable());
                                                    return;
                                                }
                                                if (!TmfCommonXAxisChartViewer.this.getSwtChart().isDisposed()) break block34;
                                                if (log == null) break block35;
                                                log.close();
                                            }
                                            if (TmfCommonXAxisChartViewer.access$1(TmfCommonXAxisChartViewer.this).decrementAndGet() >= 0) return;
                                            Activator.getDefault().logError("Dirty underflow error", new Throwable());
                                            return;
                                        }
                                        if (var2_2 == null || !var2_2.isCanceled()) break block36;
                                        if (log == null) break block37;
                                        log.close();
                                    }
                                    if (TmfCommonXAxisChartViewer.access$1(TmfCommonXAxisChartViewer.this).decrementAndGet() >= 0) return;
                                    Activator.getDefault().logError("Dirty underflow error", new Throwable());
                                    return;
                                }
                                maxy = 4.9E-324;
                                miny = 1.7976931348623157E308;
                                delta = TmfCommonXAxisChartViewer.this.getWindowEndTime() - TmfCommonXAxisChartViewer.this.getWindowStartTime();
                                if (delta <= 0L) break block40;
                                var15_13 = var3_3.getData().values().iterator();
                                if (true) ** GOTO lbl110
                            }
                            TmfCommonXAxisChartViewer.this.clearContent();
                            delta = 1L;
                            break block41;
                            do {
                                entry = (ISeriesModel)var15_13.next();
                                extractXValuesToDisplay = this.extractXValuesToDisplay(entry.getXAxis());
                                dimmedX = new ArrayList<Double>(extractXValuesToDisplay.length);
                                dimmedY = new ArrayList<Double>(extractXValuesToDisplay.length);
                                brightX = new ArrayList<Double>(extractXValuesToDisplay.length);
                                brightY = new ArrayList<Double>(extractXValuesToDisplay.length);
                                propertiesArray = entry.getProperties();
                                data = entry.getData();
                                i = 0;
                                while (i < extractXValuesToDisplay.length) {
                                    value = data[i];
                                    maxy = Math.max(maxy, value);
                                    miny = Math.min(miny, value);
                                    v0 = properties = i < propertiesArray.length ? propertiesArray[i] : 0;
                                    if ((properties & 4) == 0) {
                                        if ((properties & 1) == 0) {
                                            brightX.add(extractXValuesToDisplay[i]);
                                            brightY.add(value);
                                        } else {
                                            dimmedX.add(extractXValuesToDisplay[i]);
                                            dimmedY.add(value);
                                        }
                                    }
                                    ++i;
                                }
                                brightXArray = new double[brightX.size()];
                                brightYArray = new double[brightY.size()];
                                i = 0;
                                while (i < brightX.size()) {
                                    brightXArray[i] = (Double)brightX.get(i);
                                    brightYArray[i] = (Double)brightY.get(i);
                                    ++i;
                                }
                                dimmedXArray = new double[dimmedX.size()];
                                dimmedYArray = new double[dimmedY.size()];
                                i = 0;
                                while (i < dimmedX.size()) {
                                    dimmedXArray[i] = (Double)dimmedX.get(i);
                                    dimmedYArray[i] = (Double)dimmedY.get(i);
                                    ++i;
                                }
                                seriesSet = TmfCommonXAxisChartViewer.this.getSwtChart().getSeriesSet();
                                series = seriesSet.getSeries(entry.getName());
                                dimmedSeries = seriesSet.getSeries(String.valueOf(entry.getName()) + ".dimmed");
                                if (brightX.isEmpty()) {
                                    if (series != null) {
                                        seriesSet.deleteSeries(entry.getName());
                                    }
                                } else {
                                    if (series == null) {
                                        series = this.createSWTSeriesFromModel(entry);
                                    }
                                    series.setXSeries(brightXArray);
                                    series.setYSeries(brightYArray);
                                }
                                if (dimmedX.isEmpty()) {
                                    if (dimmedSeries == null) continue;
                                    seriesSet.deleteSeries(String.valueOf(entry.getName()) + ".dimmed");
                                    continue;
                                }
                                if (dimmedSeries == null) {
                                    dimmedSeries = this.createDimmedSeriesFromModel(entry);
                                }
                                dimmedSeries.setXSeries(dimmedXArray);
                                dimmedSeries.setYSeries(dimmedYArray);
lbl110:
                                // 4 sources

                            } while (var15_13.hasNext());
                            maxy = maxy == 4.9E-324 ? 1.0 : maxy;
                        }
                        xTick = TmfCommonXAxisChartViewer.this.getSwtChart().getAxisSet().getXAxis(0).getTick();
                        xTick.setFormat((Format)tmfChartTimeStampFormat);
                        start = 1.0;
                        TmfCommonXAxisChartViewer.this.getSwtChart().getAxisSet().getXAxis(0).setRange(new Range(1.0, 1.0 + (double)delta));
                        TmfCommonXAxisChartViewer.this.getSwtChart().getAxisSet().getYAxis(0).adjustRange();
                        TmfCommonXAxisChartViewer.this.getSwtChart().redraw();
                        if (TmfCommonXAxisChartViewer.this.isSendTimeAlignSignals() == false) return;
                        parent = TmfCommonXAxisChartViewer.this.getParent();
                        if (parent != null && parent.getParent() != null) break block38;
                        if (log == null) break block39;
                        {
                            catch (Throwable var5_6) {
                                throw var5_6;
                            }
                        }
                        log.close();
                    }
                    if (TmfCommonXAxisChartViewer.access$1(TmfCommonXAxisChartViewer.this).decrementAndGet() >= 0) return;
                    Activator.getDefault().logError("Dirty underflow error", new Throwable());
                    return;
                }
                viewPos = parent.getParent().toDisplay(0, 0);
                axisPos = TmfCommonXAxisChartViewer.this.getSwtChart().toDisplay((int)0, (int)0).x + TmfCommonXAxisChartViewer.this.getPointAreaOffset();
                timeAxisOffset = axisPos - viewPos.x;
                timeAlignmentInfo = new TmfTimeViewAlignmentInfo(TmfCommonXAxisChartViewer.this.getControl().getShell(), viewPos, timeAxisOffset);
                TmfSignalManager.dispatchSignal((TmfSignal)new TmfTimeViewAlignmentSignal(TmfCommonXAxisChartViewer.this, timeAlignmentInfo, true));
                return;
            }
            catch (Throwable var6_8) {
                if (var5_5 == null) {
                    var5_5 = var6_8;
                    throw var5_5;
                }
                if (var5_5 == var6_8) throw var5_5;
                var5_5.addSuppressed(var6_8);
                throw var5_5;
            }
            {
                finally {
                    if (log != null) {
                        log.close();
                    }
                }
            }
        }
    }
}

