/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.virtual;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeTransformerDescriptor;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.virtual.DBVColorOverride;
import org.jkiss.dbeaver.model.virtual.DBVContainer;
import org.jkiss.dbeaver.model.virtual.DBVEntity;
import org.jkiss.dbeaver.model.virtual.DBVEntityAttribute;
import org.jkiss.dbeaver.model.virtual.DBVEntityConstraint;
import org.jkiss.dbeaver.model.virtual.DBVEntityConstraintColumn;
import org.jkiss.dbeaver.model.virtual.DBVEntityForeignKey;
import org.jkiss.dbeaver.model.virtual.DBVEntityForeignKeyColumn;
import org.jkiss.dbeaver.model.virtual.DBVModelSerializer;
import org.jkiss.dbeaver.model.virtual.DBVTransformSettings;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.xml.SAXListener;
import org.jkiss.utils.xml.SAXReader;
import org.jkiss.utils.xml.XMLBuilder;
import org.jkiss.utils.xml.XMLException;
import org.xml.sax.Attributes;

@Deprecated
class DBVModelSerializerLegacy
implements DBVModelSerializer {
    private static final Log log = Log.getLog(DBVModelSerializerLegacy.class);

    DBVModelSerializerLegacy() {
    }

    static void serializeContainer(XMLBuilder xml, DBVContainer object) throws IOException {
        if (!object.hasValuableData()) {
            return;
        }
        xml.startElement("container");
        xml.addAttribute("name", object.getName());
        for (DBVContainer container : object.getContainers()) {
            DBVModelSerializerLegacy.serializeContainer(xml, container);
        }
        for (DBVEntity entity : object.getEntities()) {
            if (!entity.hasValuableData()) continue;
            DBVModelSerializerLegacy.serializeEntity(xml, entity);
        }
        xml.endElement();
    }

    private static void serializeEntity(XMLBuilder xml, DBVEntity entity) throws IOException {
        xml.startElement("entity");
        xml.addAttribute("name", entity.getName());
        if (!CommonUtils.isEmpty((String)entity.getDescriptionColumnNames())) {
            xml.addAttribute("description", entity.getDescriptionColumnNames());
        }
        if (!CommonUtils.isEmpty(entity.properties)) {
            for (Map.Entry<String, String> prop : entity.properties.entrySet()) {
                xml.startElement("property");
                xml.addAttribute("name", prop.getKey());
                xml.addAttribute("value", prop.getValue());
                xml.endElement();
            }
        }
        for (DBVEntityAttribute attr : CommonUtils.safeCollection(entity.entityAttributes)) {
            if (!attr.hasValuableData()) continue;
            Throwable throwable = null;
            Iterator iterator = null;
            try (XMLBuilder.Element e3 = xml.startElement("attribute");){
                xml.addAttribute("name", attr.getName());
                DBVTransformSettings transformSettings = attr.getTransformSettings();
                if (transformSettings != null && transformSettings.hasValuableData()) {
                    Throwable throwable2 = null;
                    Iterator<Map.Entry<String, String>> iterator2 = null;
                    try (XMLBuilder.Element e4 = xml.startElement("transform");){
                        XMLBuilder.Element e5;
                        Throwable throwable3;
                        Object object;
                        if (!CommonUtils.isEmpty((String)transformSettings.getCustomTransformer())) {
                            xml.addAttribute("custom", transformSettings.getCustomTransformer());
                        }
                        for (String id : CommonUtils.safeCollection(transformSettings.getIncludedTransformers())) {
                            object = null;
                            throwable3 = null;
                            try {
                                e5 = xml.startElement("include");
                                try {
                                    xml.addAttribute("id", id);
                                }
                                finally {
                                    if (e5 != null) {
                                        e5.close();
                                    }
                                }
                            }
                            catch (Throwable throwable4) {
                                if (object == null) {
                                    object = throwable4;
                                } else if (object != throwable4) {
                                    ((Throwable)object).addSuppressed(throwable4);
                                }
                                throw object;
                            }
                        }
                        for (String id : CommonUtils.safeCollection(transformSettings.getExcludedTransformers())) {
                            object = null;
                            throwable3 = null;
                            try {
                                e5 = xml.startElement("exclude");
                                try {
                                    xml.addAttribute("id", id);
                                }
                                finally {
                                    if (e5 != null) {
                                        e5.close();
                                    }
                                }
                            }
                            catch (Throwable throwable5) {
                                if (object == null) {
                                    object = throwable5;
                                } else if (object != throwable5) {
                                    ((Throwable)object).addSuppressed(throwable5);
                                }
                                throw object;
                            }
                        }
                        Map<String, String> transformOptions = transformSettings.getTransformOptions();
                        if (transformOptions != null) {
                            for (Map.Entry entry : transformOptions.entrySet()) {
                                throwable3 = null;
                                Object var15_29 = null;
                                try (XMLBuilder.Element e52 = xml.startElement("property");){
                                    if (entry.getValue() == null) continue;
                                    xml.addAttribute("name", (String)entry.getKey());
                                    xml.addAttribute("value", (String)entry.getValue());
                                }
                                catch (Throwable throwable6) {
                                    if (throwable3 == null) {
                                        throwable3 = throwable6;
                                    } else if (throwable3 != throwable6) {
                                        throwable3.addSuppressed(throwable6);
                                    }
                                    throw throwable3;
                                }
                            }
                        }
                    }
                    catch (Throwable throwable7) {
                        if (throwable2 == null) {
                            throwable2 = throwable7;
                        } else if (throwable2 != throwable7) {
                            throwable2.addSuppressed(throwable7);
                        }
                        throw throwable2;
                    }
                }
                if (CommonUtils.isEmpty(attr.properties)) continue;
                for (Map.Entry<String, String> prop : attr.properties.entrySet()) {
                    xml.startElement("property");
                    xml.addAttribute("name", prop.getKey());
                    xml.addAttribute("value", prop.getValue());
                    xml.endElement();
                }
            }
            catch (Throwable throwable8) {
                if (throwable == null) {
                    throwable = throwable8;
                } else if (throwable != throwable8) {
                    throwable.addSuppressed(throwable8);
                }
                throw throwable;
            }
        }
        for (DBVEntityConstraint c : CommonUtils.safeCollection(entity.entityConstraints)) {
            if (!c.hasAttributes()) continue;
            xml.startElement("constraint");
            xml.addAttribute("name", c.getName());
            xml.addAttribute("type", c.getConstraintType().getName());
            for (DBVEntityConstraintColumn cc : CommonUtils.safeCollection(c.getAttributeReferences(null))) {
                xml.startElement("attribute");
                xml.addAttribute("name", cc.getAttributeName());
                xml.endElement();
            }
            xml.endElement();
        }
        for (DBVEntityForeignKey fk : CommonUtils.safeCollection(entity.entityForeignKeys)) {
            xml.startElement("association");
            DBSEntity refEntity = fk.getAssociatedEntity();
            xml.addAttribute("entity", DBUtils.getObjectFullId(refEntity));
            DBSEntityConstraint refConstraint = fk.getReferencedConstraint();
            if (refConstraint != null) {
                xml.addAttribute("constraint", refConstraint.getName());
            }
            for (DBVEntityForeignKeyColumn cc : CommonUtils.safeCollection(fk.getAttributes())) {
                xml.startElement("attribute");
                xml.addAttribute("name", cc.getAttributeName());
                xml.endElement();
            }
            xml.endElement();
        }
        if (!CommonUtils.isEmpty(entity.colorOverrides)) {
            xml.startElement("colors");
            for (DBVColorOverride color : entity.colorOverrides) {
                xml.startElement("color");
                xml.addAttribute("name", color.getAttributeName());
                xml.addAttribute("operator", color.getOperator().name());
                if (color.isRange()) {
                    xml.addAttribute("range", true);
                }
                if (color.isSingleColumn()) {
                    xml.addAttribute("singleColumn", true);
                }
                if (color.getColorForeground() != null) {
                    xml.addAttribute("foreground", color.getColorForeground());
                }
                if (color.getColorForeground2() != null) {
                    xml.addAttribute("foreground2", color.getColorForeground2());
                }
                if (color.getColorBackground() != null) {
                    xml.addAttribute("background", color.getColorBackground());
                }
                if (color.getColorBackground2() != null) {
                    xml.addAttribute("background2", color.getColorBackground2());
                }
                if (!ArrayUtils.isEmpty((Object[])color.getAttributeValues())) {
                    Object[] objectArray = color.getAttributeValues();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object value = objectArray[n2];
                        if (value != null) {
                            xml.startElement("value");
                            xml.addText((CharSequence)GeneralUtils.serializeObject(value));
                            xml.endElement();
                        }
                        ++n2;
                    }
                }
                xml.endElement();
            }
            xml.endElement();
        }
        xml.endElement();
    }

    static class ModelParser
    implements SAXListener {
        private DBVContainer rootContainer;
        private DBVContainer curContainer = null;
        private DBVEntity curEntity = null;
        private DBVEntityAttribute curAttribute = null;
        private DBVTransformSettings curTransformSettings = null;
        private DBVEntityConstraint curConstraint;
        private DBVColorOverride curColor;
        private boolean colorValue = false;

        public ModelParser(DBVContainer rootContainer) {
            this.rootContainer = rootContainer;
        }

        public void saxStartElement(SAXReader reader, String namespaceURI, String localName, Attributes atts) throws XMLException {
            switch (localName) {
                case "container": {
                    if (this.curContainer == null) {
                        this.curContainer = this.rootContainer;
                        break;
                    }
                    DBVContainer container = new DBVContainer(this.curContainer, atts.getValue("name"));
                    this.curContainer.addContainer(container);
                    this.curContainer = container;
                    break;
                }
                case "entity": {
                    this.curEntity = new DBVEntity(this.curContainer, atts.getValue("name"), atts.getValue("description"));
                    this.curContainer.addEntity(this.curEntity);
                    break;
                }
                case "property": {
                    if (this.curTransformSettings != null) {
                        this.curTransformSettings.setTransformOption(atts.getValue("name"), atts.getValue("value"));
                        break;
                    }
                    if (this.curAttribute != null) {
                        this.curAttribute.setProperty(atts.getValue("name"), atts.getValue("value"));
                        break;
                    }
                    if (this.curEntity == null) break;
                    this.curEntity.setProperty(atts.getValue("name"), atts.getValue("value"));
                    break;
                }
                case "constraint": {
                    if (this.curEntity == null) break;
                    this.curConstraint = new DBVEntityConstraint(this.curEntity, DBSEntityConstraintType.VIRTUAL_KEY, atts.getValue("name"));
                    this.curEntity.addConstraint(this.curConstraint);
                    break;
                }
                case "attribute": {
                    if (this.curConstraint != null) {
                        this.curConstraint.addAttribute(atts.getValue("name"));
                        break;
                    }
                    if (this.curAttribute != null) {
                        DBVEntityAttribute childAttribute = new DBVEntityAttribute(this.curEntity, this.curAttribute, atts.getValue("name"));
                        this.curAttribute.addChild(childAttribute);
                        this.curAttribute = childAttribute;
                        break;
                    }
                    if (this.curEntity == null) break;
                    this.curAttribute = new DBVEntityAttribute(this.curEntity, null, atts.getValue("name"));
                    this.curEntity.addVirtualAttribute(this.curAttribute);
                    break;
                }
                case "transform": {
                    this.curTransformSettings = new DBVTransformSettings();
                    this.curTransformSettings.setCustomTransformer(atts.getValue("custom"));
                    if (this.curAttribute != null) {
                        this.curAttribute.setTransformSettings(this.curTransformSettings);
                        break;
                    }
                    if (this.curEntity == null) break;
                    this.curEntity.setTransformSettings(this.curTransformSettings);
                    break;
                }
                case "exclude": 
                case "include": {
                    String transformerId = atts.getValue("id");
                    if (this.curTransformSettings == null || CommonUtils.isEmpty((String)transformerId)) break;
                    DBDAttributeTransformerDescriptor transformer = DBWorkbench.getPlatform().getValueHandlerRegistry().getTransformer(transformerId);
                    if (transformer == null) {
                        log.warn("Transformer '" + transformerId + "' not found");
                        break;
                    }
                    this.curTransformSettings.enableTransformer(transformer, "include".equals(localName));
                    break;
                }
                case "color": {
                    if (this.curEntity == null) break;
                    try {
                        this.curColor = new DBVColorOverride(atts.getValue("name"), DBCLogicalOperator.valueOf(atts.getValue("operator")), null, atts.getValue("foreground"), atts.getValue("background"));
                        this.curColor.setRange(CommonUtils.getBoolean((String)atts.getValue("range"), (boolean)false));
                        this.curColor.setSingleColumn(CommonUtils.getBoolean((String)atts.getValue("singleColumn"), (boolean)false));
                        this.curColor.setColorForeground2(atts.getValue("foreground2"));
                        this.curColor.setColorBackground2(atts.getValue("background2"));
                        this.curEntity.addColorOverride(this.curColor);
                    }
                    catch (Throwable e) {
                        log.warn("Error reading color settings", e);
                    }
                    break;
                }
                case "value": {
                    if (this.curColor == null) break;
                    this.colorValue = true;
                }
            }
        }

        public void saxText(SAXReader reader, String data) {
            if (this.colorValue) {
                this.curColor.addAttributeValue(GeneralUtils.deserializeObject(data));
            }
        }

        public void saxEndElement(SAXReader reader, String namespaceURI, String localName) {
            switch (localName) {
                case "container": {
                    this.curContainer = this.curContainer.getParentObject();
                    break;
                }
                case "entity": {
                    this.curEntity = null;
                    break;
                }
                case "constraint": {
                    this.curConstraint = null;
                    break;
                }
                case "attribute": {
                    if (this.curAttribute == null) break;
                    this.curAttribute = this.curAttribute.getParent();
                    break;
                }
                case "transform": {
                    this.curTransformSettings = null;
                }
                case "color": {
                    this.curColor = null;
                    break;
                }
                case "value": {
                    if (this.curColor == null) break;
                    this.colorValue = false;
                }
            }
        }
    }
}

